/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.util;

import com.novell.naudit.util.Constants;
import com.novell.naudit.util.SLSException;
import com.novell.naudit.util.Util;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class SLSConnection
implements Constants {
    private SSLSocket sslSocket = null;
    private Socket socket = null;
    private DataOutputStream sslout;
    private DataInputStream sslin;
    private DataOutputStream out;
    private DataInputStream in;
    private DataOutputStream tempout;
    private DataInputStream tempin;
    SSLSocketFactory factory;
    String host;
    int port;
    private boolean sslAlways = false;

    public SLSConnection(X509Certificate[] x509CertificateArray, PrivateKey privateKey, String string, int n) throws SLSException {
        try {
            System.setProperty("javax.net.ssl.trustStoreType", "JKS");
            String string2 = "novell";
            this.host = string;
            this.port = n;
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(null, string2.toCharArray());
            keyStore.setKeyEntry("sls", privateKey, string2.toCharArray(), x509CertificateArray);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
            keyManagerFactory.init(keyStore, string2.toCharArray());
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }

                public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }
            }};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
            this.factory = sSLContext.getSocketFactory();
        }
        catch (Exception exception) {
            SLSException sLSException = new SLSException(exception.getMessage());
            sLSException.setErrorCode(9);
            throw sLSException;
        }
    }

    public void openConnection() throws Exception {
        this.socket = new Socket(this.host, this.port);
        this.sslSocket = (SSLSocket)this.factory.createSocket(this.socket, this.host, this.port, false);
        this.socket.setKeepAlive(true);
        this.socket.setSoTimeout(180000);
        this.openStreams();
    }

    public void authenticate() throws SLSException, Exception {
        try {
            this.openConnection();
        }
        catch (Exception exception) {
            SLSException sLSException = new SLSException(exception.getMessage());
            sLSException.setErrorCode(6);
            throw sLSException;
        }
        byte by = this.in.readByte();
        if (by < 1) {
            SLSException sLSException = new SLSException("Wrong server version");
            sLSException.setErrorCode(4);
            throw sLSException;
        }
        byte by2 = this.in.readByte();
        byte[] byArray = new byte[by2];
        this.in.readFully(byArray);
        this.out.writeByte(84);
        this.out.flush();
        byte by3 = this.in.readByte();
        if ((by3 & 1) == 0) {
            SLSException sLSException = new SLSException("Can't start SSL Session with SLS");
            sLSException.setErrorCode(19);
            throw sLSException;
        }
        byte by4 = this.sslin.readByte();
        if ((by4 & 1) == 0) {
            SLSException sLSException = new SLSException("Authentication failed");
            sLSException.setErrorCode(5);
            throw sLSException;
        }
        if ((by4 & 4) != 0) {
            this.sslAlways = true;
        }
        if (!this.sslAlways) {
            this.sslout.writeInt(Util.getLEInt(78));
            this.sslout.writeInt(0);
            this.sslout.flush();
            byte by5 = this.in.readByte();
            if ((by5 & 1) == 0) {
                SLSException sLSException = new SLSException("Can't stop TLS session with server.");
                sLSException.setErrorCode(18);
                throw sLSException;
            }
        } else {
            this.enableSSLAlways();
        }
        this.out.writeInt(Util.getLEInt(87));
        this.out.writeInt(0);
        this.out.flush();
    }

    public void sendEventData(byte[] byArray, int n) throws Exception {
        this.out.writeInt(Util.getLEInt(69));
        this.out.writeInt(Util.getLEInt(n));
        this.out.write(byArray);
        this.out.flush();
    }

    public void sendData(byte[] byArray) throws Exception {
        this.out.write(byArray);
    }

    public void sendData(byte[] byArray, int n, int n2) throws Exception {
        this.out.write(byArray, n, n2);
    }

    public void sendData(int n) throws Exception {
        this.out.writeInt(n);
    }

    public void flushData() throws Exception {
        this.out.flush();
    }

    public byte getByte() throws Exception {
        return this.in.readByte();
    }

    public int getInt() throws Exception {
        return Util.getBEInt(this.in.readInt());
    }

    public void enableSSLAlways() {
        this.tempin = this.in;
        this.tempout = this.out;
        this.in = this.sslin;
        this.out = this.sslout;
    }

    public void disableSSLAlways() {
        this.tempin = this.in;
        this.tempout = this.out;
        this.in = this.tempin;
        this.out = this.tempout;
    }

    public void openStreams() throws IOException {
        this.out = new DataOutputStream(this.socket.getOutputStream());
        this.in = new DataInputStream(this.socket.getInputStream());
        this.sslin = new DataInputStream(this.sslSocket.getInputStream());
        this.sslout = new DataOutputStream(this.sslSocket.getOutputStream());
    }

    public void closeStreams() throws IOException {
        if (this.sslout != null) {
            this.sslout.close();
            this.sslout = null;
        }
        if (this.sslin != null) {
            this.sslin.close();
            this.sslin = null;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    public void closeSSL() throws Exception {
        if (this.sslout != null) {
            this.sslout.close();
            this.sslout = null;
        }
        if (this.sslin != null) {
            this.sslin.close();
            this.sslin = null;
        }
        if (this.sslSocket != null) {
            if (!this.sslSocket.isClosed()) {
                this.sslSocket.close();
            }
            this.sslSocket = null;
        }
    }

    public boolean closeConnection() {
        try {
            this.closeStreams();
            if (this.socket != null) {
                if (!this.socket.isClosed()) {
                    this.socket.close();
                }
                this.socket = null;
            }
            if (this.sslSocket != null) {
                if (!this.sslSocket.isClosed()) {
                    this.sslSocket.close();
                }
                this.sslSocket = null;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Socket getSocket() {
        return this.socket;
    }
}

