/*
 * Decompiled with CFR 0.152.
 */
package com.novell.naudit.util;

import com.novell.naudit.util.SLSConnection;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Util {
    private static String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----";
    private static String END_CERTIFICATE = "-----END CERTIFICATE-----";
    private static String BEGIN_PRIVATE_KEY = "-----BEGIN RSA PRIVATE KEY-----";
    private static String END_PRIVATE_KEY = "-----END RSA PRIVATE KEY-----";
    public static String NEW_LINE = "\r\n";
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String byteToHex(byte by) {
        int n = by & 0xFF;
        int n2 = n & 0xF;
        int n3 = n >>> 4 & 0xF;
        char[] cArray = new char[]{hexChars[n3], hexChars[n2]};
        return String.valueOf(cArray);
    }

    public static void printByteArray(byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < 16) {
                if (n2 + n3 >= n) {
                    System.out.print("   ");
                } else {
                    System.out.print(Util.byteToHex(byArray[n2 + n3]) + " ");
                }
                ++n3;
            }
            System.out.print("\t");
            int n4 = 0;
            while (n4 < 16 && n2 + n4 < n) {
                byte by = byArray[n2 + n4];
                if (by >= 33 && by <= 187) {
                    System.out.print((char)by);
                } else {
                    System.out.print(".");
                }
                ++n4;
            }
            System.out.println();
            n2 += 16;
        }
    }

    public static void printByteArray(byte[] byArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < 16) {
                if (n2 + n3 >= n) {
                    System.out.print("   ");
                } else {
                    System.out.print(Util.byteToHex(byArray[n2 + n3]) + " ");
                }
                ++n3;
            }
            System.out.print("\t");
            int n4 = 0;
            while (n4 < 16 && n2 + n4 < n) {
                byte by = byArray[n2 + n4];
                if (by >= 33 && by <= 187) {
                    System.out.print((char)by);
                } else {
                    System.out.print(".");
                }
                ++n4;
            }
            System.out.println();
            n2 += 16;
        }
    }

    public static int getLEInt(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getInt(0);
    }

    public static int getNativeInt(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer.getInt(0);
    }

    public static long getLELong(long l) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        byteBuffer.putLong(l);
        byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return byteBuffer.getLong(0);
    }

    public static byte[] getLEBytes(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer = byteBuffer.putInt(n);
        byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte[] byArray = new byte[4];
        byteBuffer = (ByteBuffer)byteBuffer.position(0);
        byteBuffer.get(byArray);
        return byArray;
    }

    public static int getBEInt(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer = byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.putInt(n);
        byteBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer.getInt(0);
    }

    public static int getBEIntFromNative(int n) throws Exception {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer = byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.putInt(n);
        byteBuffer = byteBuffer.order(ByteOrder.BIG_ENDIAN);
        return byteBuffer.getInt(0);
    }

    public static int getByteOffset(byte by, byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (byArray[n3] == by) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static String parseString(int n, int n2, byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = byArray.length;
        if (n2 != -1) {
            n3 = n + n2;
        }
        int n4 = n;
        while (n4 < n3) {
            char c = (char)byArray[n4];
            if (c == '\u0000') break;
            stringBuffer.append(c);
            ++n4;
        }
        return stringBuffer.toString();
    }

    public static String parseCertificate(String string) {
        int n = string.indexOf(BEGIN_CERTIFICATE);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(END_CERTIFICATE);
        if (n2 == -1) {
            return null;
        }
        return string.substring(n, n2 + END_CERTIFICATE.length());
    }

    public static String parsePrivateKey(String string) {
        int n = string.indexOf(BEGIN_PRIVATE_KEY);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(END_PRIVATE_KEY);
        if (n2 == -1) {
            return null;
        }
        return string.substring(n, n2 + END_PRIVATE_KEY.length());
    }

    public static String pemEncodeCertificate(String string) throws Exception {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BEGIN_CERTIFICATE + NEW_LINE);
        StringBuffer stringBuffer2 = new StringBuffer(bASE64Encoder.encode(string.getBytes("UTF-8")));
        int n = 64;
        while (stringBuffer2.length() < n) {
            stringBuffer2.insert(n, NEW_LINE);
            n += 64 + NEW_LINE.length();
        }
        stringBuffer.append(NEW_LINE + END_CERTIFICATE + NEW_LINE);
        return stringBuffer.toString();
    }

    public static String pemEncodePrivateKey(String string) throws Exception {
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(BEGIN_PRIVATE_KEY + NEW_LINE);
        StringBuffer stringBuffer2 = new StringBuffer(bASE64Encoder.encode(string.getBytes("UTF-8")));
        int n = 64;
        while (stringBuffer2.length() < n) {
            stringBuffer2.insert(n, NEW_LINE);
            n += 64 + NEW_LINE.length();
        }
        stringBuffer.append(NEW_LINE + END_PRIVATE_KEY + NEW_LINE);
        return stringBuffer.toString();
    }

    public static byte[] getPrivateKeyDer(String string) throws IOException {
        int n = string.indexOf(BEGIN_PRIVATE_KEY);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(END_PRIVATE_KEY);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n + BEGIN_PRIVATE_KEY.length(), n2);
        string2 = Util.removeNewLine(string2);
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(string2);
    }

    public static byte[] getCertificateDer(String string) throws IOException {
        int n = string.indexOf(BEGIN_CERTIFICATE);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(END_CERTIFICATE);
        if (n2 == -1) {
            return null;
        }
        String string2 = string.substring(n + BEGIN_CERTIFICATE.length(), n2);
        string2 = Util.removeNewLine(string2);
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        return bASE64Decoder.decodeBuffer(string2);
    }

    public static String removeNewLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '\n' && string.charAt(n) != '\r') {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static void makePath(String string) throws Exception {
        File file = new File(string);
        file.mkdirs();
    }

    public static int getLocalIPAddress(SLSConnection sLSConnection) {
        if (sLSConnection != null) {
            try {
                Socket socket = sLSConnection.getSocket();
                InetAddress inetAddress = socket.getLocalAddress();
                return inetAddress.hashCode();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.hashCode();
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

