/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.events.edir.eventdata;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.events.edir.EventResponseData;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class BinderyObjectEventData
implements EventResponseData {
    private final String entryDN;
    private final int type;
    private final int emuObjFlags;
    private final int security;
    private final String name;

    public BinderyObjectEventData(ASN1Object aSN1Object) throws IOException {
        byte[] byArray = ((ASN1OctetString)aSN1Object).byteValue();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        LBERDecoder lBERDecoder = new LBERDecoder();
        int[] nArray = new int[1];
        this.entryDN = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
        this.type = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.emuObjFlags = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.security = ((ASN1Integer)lBERDecoder.decode(byteArrayInputStream, nArray)).intValue();
        this.name = ((ASN1OctetString)lBERDecoder.decode(byteArrayInputStream, nArray)).stringValue();
    }

    public int getEmuObjFlags() {
        return this.emuObjFlags;
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public String getName() {
        return this.name;
    }

    public int getSecurity() {
        return this.security;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[BinderyObjectEvent[EntryDn=" + this.getEntryDN() + "]");
        stringBuffer.append("[Type=" + this.getType() + "]");
        stringBuffer.append("[EnumOldFlags=" + this.getEmuObjFlags() + "]");
        stringBuffer.append("[Secuirty=" + this.getSecurity() + "]");
        stringBuffer.append("[Name=" + this.getName() + "]]");
        return stringBuffer.toString();
    }
}

