/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.InternalWSConnectionHandle;
import com.novell.WebServiceSDK.WSConnectionHandle;
import com.novell.WebServiceSDK.WSDebug;
import com.novell.WebServiceSDK.WSException;
import com.novell.WebServiceSDK.WSSSLSocketProvider;
import com.novell.WebServiceSDK.WSSocketProvider;
import com.novell.WebServiceSDK.WebService;
import java.io.IOException;

class WSConnectionManager {
    String m_Server;
    int m_Port;
    WSSocketProvider m_SocketProvider;
    InternalWSConnectionHandle m_cListHead;
    InternalWSConnectionHandle m_cListTail;

    public WSConnectionManager(boolean bl) throws WSException {
        if (bl) {
            try {
                this.m_SocketProvider = new WSSSLSocketProvider();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                throw new WSException(WebService.m_ResBundle.getString("unableToInitializeJSSE"));
            }
        } else {
            this.m_SocketProvider = new WSSocketProvider();
        }
        WSDebug.trace(3, "ConMgr WSConnectionManager()");
        this.m_cListHead = new InternalWSConnectionHandle();
        this.m_cListTail = new InternalWSConnectionHandle();
        this.m_cListHead.setNext(this.m_cListTail);
        this.m_cListTail.setPrev(this.m_cListHead);
        this.m_cListHead.use();
        this.m_cListTail.use();
    }

    public void setConnection(String string, String string2) throws WSException {
        WSDebug.trace(3, "ConMgr setConnection(" + string + "," + string2 + ")");
        this.m_Server = string;
        try {
            this.m_Port = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new WSException(WebService.m_ResBundle.getString("invalidPortNumber"));
        }
    }

    public WSConnectionHandle getConnectionHandle() throws WSException {
        WSDebug.trace(3, "ConMgr getConnectionHandle()");
        InternalWSConnectionHandle internalWSConnectionHandle = this.getUnusedConnectionHandle();
        if (internalWSConnectionHandle == null) {
            internalWSConnectionHandle = new InternalWSConnectionHandle(this.m_Server, this.m_Port, this, this.m_SocketProvider);
            internalWSConnectionHandle.use();
            this.addConnectionHandle(internalWSConnectionHandle);
        }
        return internalWSConnectionHandle;
    }

    public synchronized void closeAllConnections() {
        WSDebug.trace(3, "ConMgr closeAllConnections()");
        InternalWSConnectionHandle internalWSConnectionHandle = this.m_cListHead.getNext();
        while (internalWSConnectionHandle != this.m_cListTail) {
            InternalWSConnectionHandle internalWSConnectionHandle2 = internalWSConnectionHandle;
            internalWSConnectionHandle = internalWSConnectionHandle.getNext();
            try {
                internalWSConnectionHandle2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.removeConnectionHandle(internalWSConnectionHandle2);
        }
    }

    public void removeClosedConnectionHandle(WSConnectionHandle wSConnectionHandle) {
        InternalWSConnectionHandle internalWSConnectionHandle = (InternalWSConnectionHandle)wSConnectionHandle;
        WSDebug.trace(3, "ConMgr removeClosedConnectionHandle()");
        try {
            internalWSConnectionHandle.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.removeConnectionHandle(internalWSConnectionHandle);
    }

    private synchronized InternalWSConnectionHandle getUnusedConnectionHandle() {
        InternalWSConnectionHandle internalWSConnectionHandle;
        WSDebug.trace(3, "ConMgr getUnusedConnectionHandle()");
        for (internalWSConnectionHandle = this.m_cListHead.getNext(); internalWSConnectionHandle != null && !internalWSConnectionHandle.use(); internalWSConnectionHandle = internalWSConnectionHandle.getNext()) {
        }
        return internalWSConnectionHandle;
    }

    private synchronized void addConnectionHandle(InternalWSConnectionHandle internalWSConnectionHandle) {
        WSDebug.trace(3, "ConMgr addConnectionHandle()");
        this.m_cListTail.getPrev().setNext(internalWSConnectionHandle);
        internalWSConnectionHandle.setPrev(this.m_cListTail.getPrev());
        internalWSConnectionHandle.setNext(this.m_cListTail);
        this.m_cListTail.setPrev(internalWSConnectionHandle);
    }

    private synchronized void removeConnectionHandle(InternalWSConnectionHandle internalWSConnectionHandle) {
        WSDebug.trace(3, "ConMgr removeConnectionHandle()");
        if (internalWSConnectionHandle.getPrev() != null && internalWSConnectionHandle.getNext() != null) {
            internalWSConnectionHandle.getPrev().setNext(internalWSConnectionHandle.getNext());
            internalWSConnectionHandle.getNext().setPrev(internalWSConnectionHandle.getPrev());
            internalWSConnectionHandle.setPrev(null);
            internalWSConnectionHandle.setNext(null);
        }
    }
}

