/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.WSDebug;

class WSHttp {
    private String m_httpResponse = null;
    private String m_post = null;
    private String m_contentType = null;
    private String m_connection = null;
    private String m_acceptLanguage = null;
    private String m_userAgent = null;
    private String m_cookie = null;
    private String m_contentLength = null;
    private String m_soapAction = null;
    private String m_authorization = null;
    private String m_transferEncoding = null;
    private String m_acceptCharset = null;

    public WSHttp() {
        this.m_acceptCharset = System.getProperty("file.encoding");
        if (this.m_acceptCharset.endsWith("-LINUX")) {
            this.m_acceptCharset = this.m_acceptCharset.substring(0, this.m_acceptCharset.length() - 6);
        }
        if (this.m_acceptCharset.endsWith("-open")) {
            this.m_acceptCharset = this.m_acceptCharset.substring(0, this.m_acceptCharset.length() - 5);
        }
    }

    public WSHttp(WSHttp wSHttp) {
        this.m_post = wSHttp.getPost();
        this.m_contentType = wSHttp.getContentType();
        this.m_connection = wSHttp.getConnection();
        this.m_acceptLanguage = wSHttp.getAcceptLanguage();
        this.m_userAgent = wSHttp.getUserAgent();
        this.m_cookie = wSHttp.getCookie();
        this.m_contentLength = wSHttp.getContentLength();
        this.m_authorization = wSHttp.getAuthorization();
        this.m_acceptCharset = System.getProperty("file.encoding");
        if (this.m_acceptCharset.endsWith("-LINUX")) {
            this.m_acceptCharset = this.m_acceptCharset.substring(0, this.m_acceptCharset.length() - 6);
        }
        if (this.m_acceptCharset.endsWith("-open")) {
            this.m_acceptCharset = this.m_acceptCharset.substring(0, this.m_acceptCharset.length() - 5);
        }
    }

    public void setPost(String string) {
        this.m_post = string;
    }

    public void setHttpResponse(String string) {
        this.m_httpResponse = string;
    }

    public void setContentType(String string) {
        this.m_contentType = string;
    }

    public void setConnection(String string) {
        this.m_connection = string;
    }

    public void setAcceptLanguage(String string) {
        this.m_acceptLanguage = string;
    }

    public void setUserAgent(String string) {
        this.m_userAgent = string;
    }

    public synchronized void setCookie(String string) {
        this.m_cookie = string;
    }

    public void setContentLength(String string) {
        this.m_contentLength = string;
    }

    public void setContentLength(int n) {
        this.m_contentLength = "" + n;
    }

    public void setSoapAction(String string) {
        this.m_soapAction = string;
    }

    public void setAuthorization(String string) {
        this.m_authorization = string;
    }

    public void setTransferEncoding(String string) {
        this.m_transferEncoding = string;
    }

    public String getHttpResponse() {
        return this.m_httpResponse;
    }

    public String getTransferEncoding() {
        return this.m_transferEncoding;
    }

    public String getAuthorization() {
        return this.m_authorization;
    }

    public String getPost() {
        return this.m_post;
    }

    public String getContentType() {
        return this.m_contentType;
    }

    public String getConnection() {
        return this.m_connection;
    }

    public String getAcceptLanguage() {
        return this.m_acceptLanguage;
    }

    public String getUserAgent() {
        return this.m_userAgent;
    }

    public synchronized String getCookie() {
        return this.m_cookie;
    }

    public String getContentLength() {
        return this.m_contentLength;
    }

    public void add(String string) {
        if (string.toLowerCase().startsWith("http/1.0")) {
            this.setHttpResponse(string.substring(8).trim());
        } else if (string.toLowerCase().startsWith("http/1.1")) {
            this.setHttpResponse(string.substring(8).trim());
        } else if (string.toLowerCase().startsWith("post")) {
            this.setPost(string.substring(4).trim());
        } else if (string.toLowerCase().startsWith("content-type:")) {
            this.setContentType(string.substring(13).trim());
        } else if (string.toLowerCase().startsWith("connection:")) {
            this.setConnection(string.substring(11).trim());
        } else if (string.toLowerCase().startsWith("accept-language:")) {
            this.setAcceptLanguage(string.substring(16).trim());
        } else if (string.toLowerCase().startsWith("user-agent:")) {
            this.setUserAgent(string.substring(11).trim());
        } else if (string.toLowerCase().startsWith("cookie:")) {
            this.setCookie(string.substring(7).trim());
        } else if (string.toLowerCase().startsWith("setcookie2:")) {
            this.setCookie(string.substring(11).trim());
        } else if (string.toLowerCase().startsWith("set-cookie:")) {
            this.setCookie(string.substring(11).trim());
        } else if (string.toLowerCase().startsWith("content-length:")) {
            this.setContentLength(string.substring(15).trim());
        } else if (string.toLowerCase().startsWith("soapaction:")) {
            this.setSoapAction(string.substring(11).trim());
        } else if (string.toLowerCase().startsWith("transfer-encoding:")) {
            this.setSoapAction(string.substring(18).trim());
        } else {
            WSDebug.trace(6, "HttpHeader: can not add " + string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("POST " + this.m_post + "\n");
        stringBuffer.append("Content-Type: " + this.m_contentType + "\n");
        stringBuffer.append("Connection: " + this.m_connection + "\n");
        if (this.m_acceptLanguage != null) {
            stringBuffer.append("Accept-Language: " + this.m_acceptLanguage + "\n");
        }
        stringBuffer.append("Accept-Charset: " + this.m_acceptCharset + "\n");
        stringBuffer.append("User-Agent: " + this.m_userAgent + "\n");
        if (this.m_cookie != null) {
            stringBuffer.append("Cookie: " + this.m_cookie + "\n");
        }
        stringBuffer.append("Content-Length: " + this.m_contentLength + "\n");
        if (this.m_soapAction != null) {
            stringBuffer.append("SOAPAction: \"/" + this.m_soapAction + "\"\n");
        }
        if (this.m_authorization != null) {
            stringBuffer.append("Authorization: " + this.m_authorization + "\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

