/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.Utils;
import com.novell.WebServiceSDK.WSHttp;
import com.novell.WebServiceSDK.WSSoap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class WSMessage {
    protected WSHttp m_HttpObject;
    protected WSSoap m_SoapObject;

    public int getResultCode() {
        int n;
        Element element = this.getParamsElement();
        NodeList nodeList = element.getElementsByTagName("EBX:XError");
        if (nodeList == null) {
            return 0;
        }
        if (nodeList.getLength() == 0) {
            return 0;
        }
        Element element2 = (Element)nodeList.item(0);
        String string = element2.getAttribute("EBX:ErrorCode");
        if (string == null || string.equals("")) {
            return 0;
        }
        int n2 = 10;
        try {
            n = (int)Long.parseLong(string, n2);
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println(numberFormatException);
            n = -1;
        }
        return n;
    }

    public Document getSoapDocument() {
        return this.m_SoapObject.getDocument();
    }

    public boolean isQuestion() {
        Element element = this.getParamsElement();
        String string = element.getAttribute("type");
        return string != null && string.equals("Question");
    }

    public Element getParamsElement() {
        Element element = this.m_SoapObject.getParameterElement();
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getElementsByTagName("params");
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public String getEvent() {
        Element element = this.m_SoapObject.getActionElement();
        if (element == null) {
            return null;
        }
        Text text = (Text)element.getFirstChild();
        return text.getNodeValue();
    }

    public String getErrorMessage() {
        String string;
        if (this.getResultCode() == 0) {
            return null;
        }
        Element element = this.getParamsElement();
        NodeList nodeList = element.getElementsByTagName("EBX:XError");
        if (nodeList == null) {
            return null;
        }
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element element2 = (Element)nodeList.item(0);
        if ((nodeList = element2.getElementsByTagName("EBX:ErrorDescription")).getLength() == 0) {
            return "" + this.getResultCode();
        }
        element2 = (Element)nodeList.item(0);
        String string2 = element2.getAttribute("dt");
        Text text = (Text)element2.getFirstChild();
        if (text == null) {
            return "" + this.getResultCode();
        }
        if (string2 != null && string2.equals("Binary")) {
            try {
                string = new String(Utils.decode(text.getNodeValue()));
            }
            catch (Throwable throwable) {
                return "" + this.getResultCode();
            }
        } else {
            string = text.getNodeValue();
        }
        return string;
    }

    static long copyData(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        long l = 0L;
        byte[] byArray = new byte[100];
        while ((n = inputStream.read(byArray, 0, 100)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    public String toString() {
        return this.m_SoapObject.toString();
    }
}

