/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.Utils;
import com.novell.WebServiceSDK.WSException;
import com.novell.WebServiceSDK.WebService;
import java.io.ByteArrayInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class WSSoap {
    private Document m_Document = null;
    private String m_DocumentString = null;
    private Element m_ActionElm;
    private Element m_ParametersElm;

    public WSSoap() {
        this.initializeSoapDom();
    }

    public WSSoap(WSSoap wSSoap) {
        this.initializeSoapDom();
    }

    public WSSoap(String string, String string2) throws WSException {
        this.initializeSoapDom();
        this.setEvent(string);
        this.setParams(string2);
    }

    public WSSoap(String string, Node node) throws WSException {
        this.initializeSoapDom();
        this.setEvent(string);
        this.setParams(node);
    }

    public WSSoap(Document document) throws WSException {
        this.m_Document = document;
        this.parseElements();
    }

    public WSSoap(String string) throws WSException {
        this.m_Document = null;
        this.m_DocumentString = string;
    }

    public Document getDocument() {
        try {
            if (this.m_Document == null) {
                this.parseDocument();
            }
        }
        catch (WSException wSException) {
            return null;
        }
        return this.m_Document;
    }

    public Element getActionElement() {
        try {
            if (this.m_Document == null) {
                this.parseDocument();
            }
        }
        catch (WSException wSException) {
            return null;
        }
        return this.m_ActionElm;
    }

    public Element getParameterElement() {
        try {
            if (this.m_Document == null) {
                this.parseDocument();
            }
        }
        catch (WSException wSException) {
            return null;
        }
        return this.m_ParametersElm;
    }

    public String toString() {
        if (this.m_DocumentString == null) {
            try {
                return "<?xml version=\"1.0\"?>" + Utils.docToString(this.m_Document);
            }
            catch (Throwable throwable) {
                return "<?xml version=\"1.0\"?>";
            }
        }
        return this.m_DocumentString;
    }

    public void setEvent(String string) {
        this.clearEvent();
        Text text = this.m_Document.createTextNode(string);
        this.m_ActionElm.appendChild(text);
    }

    public void setParams(String string) throws WSException {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            document = documentBuilder.parse(byteArrayInputStream);
        }
        catch (Throwable throwable) {
            throw new WSException(WebService.m_ResBundle.getString("parseError") + "\n" + throwable.getMessage());
        }
        this.setParams(document);
    }

    public void setParams(Node node) {
        this.clearParameters();
        if (node instanceof Document) {
            Document document = (Document)node;
            this.graftSubtree(this.m_ParametersElm, document.getDocumentElement());
        } else {
            this.graftSubtree(this.m_ParametersElm, node);
        }
    }

    private void clearEvent() {
        NodeList nodeList = this.m_ActionElm.getChildNodes();
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.m_ActionElm.removeChild(nodeList.item(i));
            }
        }
    }

    private void clearParameters() {
        NodeList nodeList = this.m_ParametersElm.getChildNodes();
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.m_ParametersElm.removeChild(nodeList.item(i));
            }
        }
    }

    private void parseDocument() throws WSException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.m_DocumentString.getBytes());
            this.m_Document = documentBuilder.parse(byteArrayInputStream);
        }
        catch (Throwable throwable) {
            throw new WSException(WebService.m_ResBundle.getString("parseError") + "\n" + throwable.getMessage());
        }
        this.parseElements();
    }

    private void parseElements() throws WSException {
        Element element = this.m_Document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("SOAP-ENV:Body");
        if (nodeList.getLength() == 0) {
            throw new WSException(WebService.m_ResBundle.getString("tagMissing") + " <SOAP-ENV:Body>");
        }
        element = (Element)nodeList.item(0);
        if ((nodeList = element.getElementsByTagName("dispatch")).getLength() == 0) {
            throw new WSException(WebService.m_ResBundle.getString("tagMissing") + " <dispatch>");
        }
        element = (Element)nodeList.item(0);
        if ((nodeList = element.getElementsByTagName("Action")).getLength() == 0) {
            throw new WSException(WebService.m_ResBundle.getString("tagMissing") + " <Action>");
        }
        this.m_ActionElm = (Element)nodeList.item(0);
        nodeList = element.getElementsByTagName("Parameters");
        if (nodeList.getLength() == 0) {
            throw new WSException(WebService.m_ResBundle.getString("tagMissing") + " <Parameters>");
        }
        this.m_ParametersElm = (Element)nodeList.item(0);
    }

    private void initializeSoapDom() {
        this.m_Document = Utils.newDocument();
        Element element = this.m_Document.createElement("SOAP-ENV:Envelope");
        element.setAttribute("xmlns:SOAP-ENV", "http://schemas.xmlsoap.org/soap/envelope/");
        Element element2 = this.m_Document.createElement("SOAP-ENV:Header");
        element.appendChild(element2);
        Element element3 = this.m_Document.createElement("SOAP-ENV:Body");
        element.appendChild(element3);
        Element element4 = this.m_Document.createElement("dispatch");
        element3.appendChild(element4);
        this.m_ActionElm = this.m_Document.createElement("Action");
        element4.appendChild(this.m_ActionElm);
        element2 = this.m_Document.createElement("Object");
        element4.appendChild(element2);
        this.m_ParametersElm = this.m_Document.createElement("Parameters");
        element4.appendChild(this.m_ParametersElm);
        this.m_Document.appendChild(element);
    }

    private Node cloneSubtree(Document document, Node node) {
        try {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    Element element2 = document.createElement(element.getNodeName());
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                        Attr attr = (Attr)namedNodeMap.item(i);
                        element2.setAttribute(attr.getName(), attr.getValue());
                    }
                    NodeList nodeList = element.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        element2.appendChild(this.cloneSubtree(document, nodeList.item(i)));
                    }
                    return element2;
                }
                case 2: {
                    Attr attr = document.createAttribute(((Attr)node).getName());
                    attr.setValue(((Attr)node).getValue());
                    return attr;
                }
                case 3: {
                    return document.createTextNode(((Text)node).getData());
                }
                case 4: {
                    return document.createCDATASection(((CDATASection)node).getData());
                }
                case 5: {
                    return document.createEntityReference(node.getNodeName());
                }
                case 7: {
                    return document.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                }
                case 8: {
                    return document.createComment(node.getNodeValue());
                }
                case 11: {
                    DocumentFragment documentFragment = document.createDocumentFragment();
                    NodeList nodeList = node.getChildNodes();
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        documentFragment.appendChild(this.cloneSubtree(document, nodeList.item(i)));
                    }
                    return documentFragment;
                }
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    private void graftSubtree(Node node, Node node2) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        node.appendChild(this.cloneSubtree(document, node2));
    }
}

