/*
 * Decompiled with CFR 0.152.
 */
package com.novell.WebServiceSDK;

import com.novell.WebServiceSDK.InternalWSPublisher;
import com.novell.WebServiceSDK.InternalWSSubscriber;
import com.novell.WebServiceSDK.WSConnectionManager;
import com.novell.WebServiceSDK.WSDebug;
import com.novell.WebServiceSDK.WSException;
import com.novell.WebServiceSDK.WSHttp;
import com.novell.WebServiceSDK.WSLanguage;
import com.novell.WebServiceSDK.WSMessage;
import com.novell.WebServiceSDK.WSPublisher;
import com.novell.WebServiceSDK.WSSoap;
import com.novell.WebServiceSDK.WSSubscriber;
import com.novell.WebServiceSDK.WebServiceLogin;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.ResourceBundle;
import org.w3c.dom.Node;

public class WebService {
    public static ResourceBundle m_ResBundle = ResourceBundle.getBundle("com.novell.WebServiceSDK.msg.WebServiceSDK");
    public static ResourceBundle m_HTTPBundle = ResourceBundle.getBundle("com.novell.WebServiceSDK.msg.HTTPMessages");
    private WSConnectionManager m_ConnMgr;
    private WSHttp m_HttpObject;
    private WSSoap m_SoapObject;
    private String m_LoginType;
    private String m_CredentialOne;
    private String m_CredentialTwo;
    private long m_publisherTimeout = -1L;
    private Locale m_Locale;

    public WebService() {
        WSDebug.trace(4, "WS WebService()");
        this.m_ConnMgr = null;
        this.m_SoapObject = new WSSoap();
        this.m_HttpObject = new WSHttp();
        this.m_HttpObject.setPost("/SOAP HTTP/1.0");
        this.m_HttpObject.setContentType("text/xml");
        this.m_HttpObject.setConnection("Keep-Alive");
        this.m_HttpObject.setUserAgent("eMBoxSDK");
        this.setLanguage(null);
        this.m_Locale = Locale.getDefault();
    }

    public void setLanguage(WSLanguage[] wSLanguageArray) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        WSDebug.trace(4, "WS setLanguage()");
        if (wSLanguageArray != null) {
            m_ResBundle = ResourceBundle.getBundle("com.novell.WebServiceSDK.msg.WebServiceSDK", new Locale(wSLanguageArray[0].getLanguage(), wSLanguageArray[0].getCountry()));
            m_HTTPBundle = ResourceBundle.getBundle("com.novell.WebServiceSDK.msg.HTTPMessages", new Locale(wSLanguageArray[0].getLanguage(), wSLanguageArray[0].getCountry()));
            for (int i = 0; i < wSLanguageArray.length; ++i) {
                if (wSLanguageArray[i] == null) continue;
                bl = true;
                if (i != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(wSLanguageArray[i].getLanguage());
                if (wSLanguageArray[i].getCountry() != null) {
                    stringBuffer.append("-" + wSLanguageArray[i].getCountry());
                }
                stringBuffer.append(";q=" + wSLanguageArray[i].getQuality());
            }
        }
        Locale locale = Locale.getDefault();
        if (bl) {
            stringBuffer.append(", ");
        }
        stringBuffer.append(locale.getLanguage() + "-" + locale.getCountry() + ";" + "q=0.2");
        stringBuffer.append(", en;q=0.1");
        this.m_HttpObject.setAcceptLanguage(stringBuffer.toString());
    }

    public WSMessage connect(String string, String string2) throws WSException {
        return this.connect(string, string2, false);
    }

    public WSMessage connect(String string, String string2, boolean bl) throws WSException {
        this.m_ConnMgr = new WSConnectionManager(bl);
        WSPublisher wSPublisher = this.createPublisher();
        wSPublisher.setEvent("novell.embox.connmgr.serverinfo");
        WSDebug.trace(4, "WS connect(" + string + "," + string2 + "," + bl + ")");
        this.m_ConnMgr.closeAllConnections();
        this.m_ConnMgr.setConnection(string, string2);
        return wSPublisher.publish();
    }

    public void disconnect() {
        WSDebug.trace(4, "WS disconnect()");
        if (this.m_ConnMgr != null) {
            this.m_ConnMgr.closeAllConnections();
            this.m_ConnMgr = null;
        }
    }

    public void login(WebServiceLogin webServiceLogin) throws WSException {
        if (this.m_ConnMgr == null) {
            throw new WSException(m_ResBundle.getString("notConnected"));
        }
        this.m_LoginType = new String(webServiceLogin.getType());
        this.m_CredentialOne = new String(webServiceLogin.getCredentialOne());
        this.m_CredentialTwo = new String(webServiceLogin.getCredentialTwo());
        try {
            WSDebug.trace(4, "WS login C1=" + this.m_CredentialOne + " Type=" + this.m_LoginType);
            this.m_HttpObject.setAuthorization(webServiceLogin.getHttpAuth());
            WSPublisher wSPublisher = this.createPublisher();
            wSPublisher.setEvent("novell.embox.connmgr.login");
            wSPublisher.setParams("<params xmlns:CM=\"connmgr.dtd\"><CM:Type>" + this.m_LoginType + "</CM:Type><CM:Param1>" + new String(this.m_CredentialOne.getBytes("UTF-8")) + "</CM:Param1></params>");
            WSMessage wSMessage = wSPublisher.publish();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_CredentialOne = null;
            this.m_CredentialTwo = null;
            this.m_HttpObject.setAuthorization(null);
            throw new WSException();
        }
        catch (WSException wSException) {
            this.m_CredentialOne = null;
            this.m_CredentialTwo = null;
            this.m_HttpObject.setAuthorization(null);
            throw wSException;
        }
    }

    public void logout(WebServiceLogin webServiceLogin) throws WSException {
        if (this.m_ConnMgr == null) {
            throw new WSException(m_ResBundle.getString("notConnected"));
        }
        WSDebug.trace(4, "WS logout Type=" + webServiceLogin.getType());
        WSPublisher wSPublisher = this.createPublisher();
        wSPublisher.setEvent("novell.embox.connmgr.logout");
        wSPublisher.setParams("<params xmlns:CM=\"connmgr.dtd\"><CM:Type>" + webServiceLogin.getType() + "</CM:Type></params>");
        WSMessage wSMessage = wSPublisher.publish();
        this.m_CredentialOne = null;
        this.m_CredentialTwo = null;
        this.m_HttpObject.setAuthorization(null);
        this.m_HttpObject.setCookie(null);
        this.m_ConnMgr.closeAllConnections();
    }

    public WSSubscriber createSubscriber() throws WSException {
        InternalWSSubscriber internalWSSubscriber = new InternalWSSubscriber();
        if (this.m_ConnMgr == null) {
            throw new WSException(m_ResBundle.getString("notConnected"));
        }
        WSDebug.trace(4, "WS createSubscriber()");
        internalWSSubscriber.setConnectionManager(this.m_ConnMgr);
        internalWSSubscriber.setHttpObject(this.m_HttpObject);
        internalWSSubscriber.setSoapObject(this.m_SoapObject);
        internalWSSubscriber.setWebService(this);
        return internalWSSubscriber;
    }

    public void setPublisherTimeout(long l) {
        this.m_publisherTimeout = l;
    }

    public WSPublisher createPublisher() throws WSException {
        InternalWSPublisher internalWSPublisher = new InternalWSPublisher();
        if (this.m_ConnMgr == null) {
            throw new WSException(m_ResBundle.getString("notConnected"));
        }
        WSDebug.trace(4, "WS createPublisher()");
        internalWSPublisher.setConnectionManager(this.m_ConnMgr);
        internalWSPublisher.setHttpObject(this.m_HttpObject);
        internalWSPublisher.setSoapObject(this.m_SoapObject);
        if (this.m_publisherTimeout != -1L) {
            internalWSPublisher.setTimeout(this.m_publisherTimeout);
        }
        return internalWSPublisher;
    }

    public WSPublisher createPublisher(String string, String string2) throws WSException {
        InternalWSPublisher internalWSPublisher = (InternalWSPublisher)this.createPublisher();
        internalWSPublisher.setEvent(string);
        if (string2 != null) {
            internalWSPublisher.setParams(string2);
        }
        return internalWSPublisher;
    }

    public WSPublisher createPublisher(String string, Node node) throws WSException {
        InternalWSPublisher internalWSPublisher = (InternalWSPublisher)this.createPublisher();
        internalWSPublisher.setEvent(string);
        internalWSPublisher.setParams(node);
        return internalWSPublisher;
    }
}

