/*=============================================================================
  $Id: ChangePassword.java,v 1.1.1.1 2001/05/09 12:46:34 rommel Exp $

  Copyright (c) 1997 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.
==============================================================================*/
package com.novell.admin.common.security;

import java.awt.*;
import java.awt.event.*;
import java.lang.*;
import java.util.*;
import java.io.*;

import javax.swing.*;

import com.novell.admin.ns.*;
import com.novell.admin.common.ui.*;
import com.novell.admin.common.exceptions.*;

import com.novell.application.console.widgets.*;
import com.novell.application.console.snapin.*;
import com.novell.utility.nmsgbox.*;

/**
 * Authentication Dialog
 */
public class ChangePassword
{

   private Shell shell;
   private ObjectEntry oe;
   private JFrame parentFrame;

   private SimpleSPIException nsSpiException = new SimpleSPIException("com.novell.admin.ns.NSResourceBundle");

   public ChangePassword(Shell theShell, AuthenticationNamespace ns, ObjectEntry obj)
       throws SPIException
   {
      parentFrame = theShell.getShellFrame();
      shell = theShell;
      oe = obj;
      NChangePasswordDlg dlg = new NChangePasswordDlg( shell );
      
      int rval = dlg.launch();
      switch ( rval )
      {
         case NLoginDlg.ID_LOGIN:
         {
            shell.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));

            String oldPassword = dlg.getOldPassword();
            String newPassword = dlg.getNewPassword();

            try
            {
               ns.changePassword(obj, oldPassword, newPassword);
               shell.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
            }
            catch (SPIException e)
            {
               shell.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
               NSPIExceptionMsgBox nbox = new NSPIExceptionMsgBox( shell, e );
               nbox.setVisible( true );
            }
            break;
         }

         case NLoginDlg.ID_CANCEL:
         {
            throw nsSpiException.newException( com.novell.admin.ns.ns.SET_PASSWORD_CANCELLED );
         }
      }
   }

}
