/*
   $RCSfile: Constants.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:12 $

   $ProjectName: V:/PROJECT/houston/shell.pj $
   $ProjectRevision: 1.171 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-2000 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
   CIVIL LIABILITY.
*/
package com.novell.application.console.shell;

import java.util.*;
import java.awt.*;

public final class Constants
{
   // NOTE: Any static variables in this class cannot be instantiated using Resources.getXXX since the resource
   //       bundle has not been loaded until the DefaultSnapinLister is instantiated and Console.snapinBundleLoader
   //       is set.

   // IMPORTANT: For NonGuiShell to work properly, the fonts must not be initialized on construction of class, this is
   //            why the getFont method is used to get fonts.
   private static Hashtable fonts = new Hashtable();
   private static boolean fontsInited = false;

   public static Font getFont(String key)
   {
      if(!fontsInited)
      {
         fonts.put("DefaultSimpleStatusBarFontKey", new Font("Dialog", Font.PLAIN, 11));
         fonts.put("ConsoleONEFontKey", new Font("Dialog", Font.PLAIN, 12));
         fontsInited = true;
      }

      return (Font) fonts.get(key);
   }

   public static final String ShellNamespaceUniqueIDKey               ="ShellRoot";
   public static final String MyWorldPlaceholderID                    ="RootPlaceholder";

   public static final String PreferencesWindowHeightKey              ="window.height";
   public static final String PreferencesWindowWidthKey               ="window.width";
   public static final String PreferencesWindowTopKey                 ="window.top";
   public static final String PreferencesWindowLeftKey                ="window.left";
   public static final String PreferencesSplitterPercentKey           ="splitter.percent";
   public static final String PreferencesObjectRootedListKey          ="object.rooted.list";
   public static final String PreferencesLookAndFeelKey               ="look.and.feel";
   public static final String PreferencesDescriptionBarKey            ="description.bar.state";
   public static final String PreferencesOpenNDSKey                   ="open.NDS.state";

   public static final String WindowsLookAndFeelKey                   ="com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
   public static final String MotifLookAndFeelKey                     ="com.sum.java.swing.plaf.motif.MotifLookAndFeel";
   public static final String MetalLookAndFeelKey                     ="com.sum.java.swing.plaf.metal.MetalLookAndFeel";

   public static final String NDSNamespaceUniqueID                    ="NDS";
   public static final String NDSPlaceholderID                        ="NovellTheNetwork";

   // It is vitally important that this separator be a character that is not
   // contained in the any namespace or oe name, or preferences is will be busted.
   public static final String PreferencesNamespaceSeparatorKey        ="^";
   public static final String PreferencesNoContextStringKey           ="<no context>";

   public static final String DummyObjectEntryNameKey                 ="null";
   public static final String DummyObjectTypeNameKey                  ="null";

   // Must be a globally unique name.
   public static final String TopObjectEntryID                        ="@My World!";

   public static final String ConsoleOneAppDirKey                     ="consoleone.app.dir";
   public static final String SnapinLibPathKey                        ="consoleone.lib.path";
   public static final String SnapinPathKey                           ="consoleone.snapin.path";
   public static final String UpdateMaster                            ="consoleone.update.master.location";

   public static final String ActionsMenuKey                         = "Actions";


   //*********************************************************************
   // Used in displayURL
   //*********************************************************************
    // Used to identify the windows platform.
    public static final String WIN_ID                                = "Windows";
    // The default system browser under windows.
    public static final String WIN_PATH                              = "rundll32";
    // The flag to display a url.
    public static final String WIN_FLAG                              = "url.dll,FileProtocolHandler";
    // The default browser under unix.
    public static final String UNIX_PATH                             = "netscape";
    // The flag to display a url.
    public static final String UNIX_FLAG                             = "-remote openURL";

   //*********************************************************************
   // Scope Keys
   //*********************************************************************
   public static final String PreferenceScopeKey                      ="PS";
   public static final String GlobalScopeKey                          ="GS";
   public static final String GlobalViewScopeKey                      ="GVS$";
   public static final String NamespaceContainerTypesScopeKey         ="NCTS$";
   public static final String NamespaceLeafTypesScopeKey              ="NLTS$";
   public static final String NamespaceMultiSelectPopupMenuScopeKey   ="$NMSPMS";
   public static final String NamespaceTypeScopeKey                   ="$";
   public static final String NamespaceViewScopeKey                   ="#";
   public static final String NamespaceScopeKey                       ="";
   public static final String NamespaceTreeObjectsScopeKey            ="NTOS$";
   public static final String PlaceholderScopeKey                     ="%";
   public static final String MultiSelectNamespaceScopeKey            ="@MS@";
   public static final String MultiSelectNamespaceBaseTypeScopeKey    ="$MS$";

   //*********************************************************************
   // Tokens
   //*********************************************************************
   public static final String MenuInsertionPointTokenKey              ="%";
   public static final String MenuLocationSeparatorTokenKey           ="%";
   public static final String SnapinResourceProtocolKey               ="snapinresource";


   // These should all be lower case, since we toLowerCase() the file name before comparing.
   public static final String CoreDirectoryKey                        ="core";
   public static final String CoreResDirectoryKey                     ="resources";
   public static final String CoreSnapinsDirectoryKey                 ="snapins";

   public static final String ConsoleJarKey                           ="console.jar";
   public static final String ConsoleOneResJarKey                     ="consoleoneresources";
   public static final String ConsoleResJarKey                        ="consoleresources";

   public static final String[] SnapinFileExtensionsKey = new String[]
                                                               {
                                                                  "jar",
                                                                  "zip",
                                                                  "class"
                                                               };
   public static final String[] JarFileExtensionsKey = new String[]
                                                               {
                                                                  "jar",
                                                                  "zip"
                                                               };



   public static final String[] LibDirectoriesKey = new String[]
                                                               {
                                                                  "lib",
                                                                  CoreResDirectoryKey
                                                               };

   public static final String[] NonGuiSnapinDirectoriesKey = new String[]
                                                               {
                                                                  CoreSnapinsDirectoryKey
                                                               };

   public static final String[] SnapinDirectoriesKey = new String[]
                                                               {
                                                                  CoreSnapinsDirectoryKey
                                                               };

   public static final String ManifestNameKey                         ="META-INF/MANIFEST.MF";

   public static final String SnapinPathCommandLineTokenKey           ="-snapinpath";
   public static final String LibPathCommandLineTokenKey              ="-libpath";

   public static final String DumpScreenToFileCommandLineTokenKey     ="-fileout";
   public static final String DumpScreenCommandLineTokenKey           ="-verbose";
   public static final String BetterDumpScreenCommandLineTokenKey     ="-systemout";
   public static final String DumpScreenToWindowCommandLineTokenKey   ="-windowout";
   public static final String ForceSnapinLoadCommandLineTokenKey      ="-forceSnapinLoad";
   public static final String VisualCafeDebug                         ="-visualCafeDebug";
   public static final String ShowHiddenObjectsCommandLineKey         ="-showHiddenObjects";
   public static final String NoClassLoaderCommandLineKey             ="-noclassloader";

   public static final String DumpDebugCommandLineTokenKey            ="-debug";
   public static final String DumpDebugWidgetsCommandLineTokenKey     ="-debugwidgets";


   public static final String PreferencesDirCommandLineKey            ="-prefdir";

   public static final String ShowListenerWindow                      ="-debuglisteners";

   public static final String PreferencesDirKey                       ="consoleone.preferences.dir";

   public static final String MainExceptionMsg                        ="An error occurred during ConsoleOne startup.\n(Run ConsoleOne with the -debug and -windowout options\nand review the debug information for more details.)";

   public static final String ConsoleOneJarName                       ="ConsoleOne.jar";

   public static final String DefaultPathSeparatorKey                =";";

   public static final String MacroStart                             ="$(";
   public static final String MacroEnd                               =")";

   // Tree keyboard traversal delay
   public static final int KeyboardTraversalInTreeDelayKey           = 300;
   public static final int MPECTabChangeDelayKey                     = 300;

   //*********************************************************************
   // SimpleToolBarMenuSnapin
   //*********************************************************************
   public static final Dimension SimpleToolBarMenuSnapinButtonSizeKey = new Dimension(28, 28);
   public static final String SimpleToolBarMenuSnapinDefaultMenuKey  = "Tools";

   //*********************************************************************
   // Files
   //*********************************************************************
   //REMIND: Need to use file separator here?  Check other resources in this file.
   public static final String ConsoleOneImageDirectoryKey            = "/com/novell/application/console/shell/resources/images/";
   public static final String SplashScreenImageKey                   = "SplashScreenImage.gif";
   public static final String SpecialNullObjectTypeImage             = "UnknownObjectTypeIcon.gif";
   public static final String UnknownImageNameKey                    = "UnknownObjectIcon.gif";
   public static final String ShellFrameIconKey                      = "ConsoleOneIcon.gif";
   public static final String TopObjectEntryIconNameKey              = "MyWorldIcon.gif";
   public static final String HoistTreeNodeIconKey                   = "HoistTreeNode.gif";

   //REMIND: Will this work, or is the best?
   public static final String DefaultShellDirectoryKey               = "./";
   public static final String RelativeHelpDirectoryKey               = "help";

   //*********************************************************************
   // Values
   //*********************************************************************

   // Snapin class loader
   public static final int SnapinClassLoaderNounsCacheInitialSize    = 4000;

   // Splash screen
   public static final int SnapinIconHeight                          = 30;
   public static final int SnapinIconWidth                           = 30;
   public static final int SplashTextTop                             = 60;	 // Defect 314759
   public static final int SplashTextLeft                            = 350; // Defect 314759

   // ToolBar
   public static final int ToolBarLeftExternalPadKey                 = 4;
   public static final int ToolBarRightExternalPadKey                = 4;
   public static final int ToolBarTopExternalPadKey                  = 4;
   public static final int ToolBarBottomExternalPadKey               = 4;

   // StatusBar
   public static final int StatusBarLeftExternalPadKey               = 0;
   public static final int StatusBarRightExternalPadKey              = 0;
   public static final int StatusBarTopExternalPadKey                = 1;
   public static final int StatusBarBottomExternalPadKey             = 0;
   public static final int StatusBarDefaultGapBetweenItemsKey        = 2;
   //REMIND: Does this have to be hardcoded?  Could we base off of font height?  What about other values?
   public static final int StatusBarDefaultHeightKey                 = 25;

   // Console Window Defaults
   public static final float WindowSizeToScreenRatioKey              = 0.75f;
   public static final int StartingSplitterPercentageKey             = 25;

   // Popup Menus
   public static final int PopupMenuXOffsetKey                       = 2;
   public static final int PopupMenuYOffsetKey                       = 0;

   // ObjectEntrySelector Dimensions
   public static final int OESHeight                                 = 324;
   public static final int OESWidth                                  = 529;
   public static final int OESBorderKey                              = 2;

   // Tree and view minimums, without setting these, splitPane will not resize properly.
   public static final int TreePaneMinimumWidthKey                   = 30;
   public static final int TreePaneMinimumHeightKey                  = 30;
   public static final int ViewPaneMinimumWidthKey                   = 30;
   public static final int ViewPaneMinimumHeightKey                  = 30;

   // Tree node spacing
   public static final int TreeNodeBorderLeftKey                     = 1;
   public static final int TreeNodeBorderRightKey                    = 1;
   public static final int TreeNodeBorderTopKey                      = 0;
   public static final int TreeNodeBorderBottomKey                   = 1;

   //*********************************************************************
   // SimpleStatusBarSnapin
   //*********************************************************************
   public static final int AbstractStatusBarSnapinHeightKey          = 21;
   public static final int AbstractStatusBarSnapinGapKey             = 2;
   public static final String AbstractStatusBarWidthPlaceHolderCharKey  = "W";
   public static final Color AbstractStatusBarTextColorKey              = Color.black;


   //*********************************************************************
   // Serialization Filenames
   //*********************************************************************
   public static final String SerializationFilename                  = "Registrars.ser";
   public static final String ShellPrefsFilename                     = "ShellPrefs.ser";
   public static final String SnapinPrefsFilename                    = "SnapinPrefs.ser";
   // Preferences are stored in this directory under user.home (on NT /winnt/users/profiles/<name>)
   public static final String PrefsDirectory                         = ".consoleone";

   //*********************************************************************
   // Snapin class loader
   //*********************************************************************
   public static final int FileBufferSize                            = 4096;
   public static final char SnapinClassLoaderFileSeparator           = '/';

   //****************
   // MPEC max number
   //***************
   public static final int MaxMPECInstances                          = 7;
}

/*
$Log: Constants.java,v $
Revision 1.1.1.1  2001/05/09 12:43:12  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.65  2000/06/29 22:23:29  mharris
Added -debugwidgets command line option
Revision 1.64  2000/06/13 21:56:35  mharris
BQ237813  Fixed output message to be more clear.
Revision 1.63  2000/05/12 18:04:52  DChamberlain
Changed preferences, added NDS keys.
Revision 1.62  2000/05/01 16:31:43Z  DChamberlain
Added UpdateMaster.
Revision 1.61  2000/04/18 23:16:55Z  DChamberlain
Added a dot to front of preference file names for Linux.
Revision 1.60  2000/04/11 21:28:57Z  pmackay
Fix for SPD 300073065.
Revision 1.59  2000/04/05 17:03:16Z  DChamberlain
Increased tree minimum size because of scrollbar.
Revision 1.58  2000/02/22 22:49:55Z  DChamberlain
Removed c1web constant until we checkin the web stuff.
Revision 1.57  2000/02/18 21:16:16Z  DChamberlain
Added web code.
Revision 1.56  2000/01/12 17:13:39  DChamberlain
Cleaned up startup error messages.
Revision 1.55  2000/01/08 00:36:27  mharris
Fixed mini-dredge to look for local resources as well as english.  Added "Last" key in ConsoleOneResources to avoid bug in fake language build tool where last entry isn't localized.
Revision 1.54  1999/11/19 23:27:34  mharris
Split Preferences into ShellPreferences and SnapinPreferences
Revision 1.53  1999/11/18 22:47:41  mharris
Make View Titles be selectable by user
Revision 1.52  1999/10/27 17:51:02  mharris
Removed Console snapin from startup display and about snapins.
Revision 1.51  1999/10/25 22:59:58  mharris
ConsoleOne now registers console snapin, brings up console window, and then registers remaining snapins.
Revision 1.50  1999/10/19 20:11:28  DChamberlain
Moved image names from resource bundles to constants.
Revision 1.49  1999/09/23 17:14:25  mharris
Constants to support -laf parameter.
Revision 1.48  1999/09/02 23:32:50  DChamberlain
Added showHiddenObjects startup flag.
Revision 1.47  1999/08/18 18:56:59  DChamberlain
Added shell.displayURL()
Revision 1.46  1999/07/22 23:04:55  DChamberlain
Put snapin class loader's initial noun cache size in Constants.
Revision 1.45  1999/06/28 14:42:49  DChamberlain
Added actions menu.
Revision 1.44  1999/06/17 19:47:14  DChamberlain
Added code for a Null ObjectType.
Revision 1.43  1999/06/17 17:18:35  DChamberlain
Added my world placeholder.
Revision 1.42  1999/06/14 18:35:10  DChamberlain
Added visualCafeDebug startup flag and placholder key.
Revision 1.41  1999/05/07 16:56:11  DChamberlain
Removed InstanceofScope.
Revision 1.40  1999/05/05 14:42:50  arlandes
Remove snapin persistence constant
Revision 1.39  1999/04/20 23:21:32  mharris
Removed -desktop option and supporting code.
Revision 1.38  1999/04/08 21:40:19  dwilson
Changed to 300 milliseconds for tabchange wait
Revision 1.37  1999/04/08 00:12:13  mharris
Changed -FastStart to -ForceSnapinLoad.
Revision 1.36  1999/04/07 20:25:01  mharris
Display verion on splash screen.
Revision 1.35  1999/04/06 23:53:58  mharris
Moved Splash Screen display earlier in startup process.
Revision 1.34  1999/04/06 15:56:28  DChamberlain
Changed non gui snapin directory back to snapins.
Revision 1.33  1999/03/16 23:59:14  DChamberlain
Added NonGuiSnapinsDir.
Revision 1.32  1999/03/10 18:16:34  dwilson
Added tabdelay key
Revision 1.31  1999/02/25 23:40:05  DChamberlain
Wait to initialize font.  This is to allow NonGuiShell to work.  SPD# 211543.
Revision 1.30  1999/02/22 23:13:40  dwilson
Revision 1.29  1999/01/27 16:43:14  DChamberlain
Added a listener window to track shell listeners.
Revision 1.28  1999/01/07 19:27:29  DChamberlain
Updated copyright to include 1999.
Revision 1.27  1998/12/03 00:43:18  dwilson
Max of 7 mpecs
Revision 1.26  1998/11/10 16:34:18  DChamberlain
Changed MultiNamespaceTypeScope to MultiNamespaceBaseTypeScope,
since we just use the base type.
Revision 1.25  1998/11/05 23:14:05  dwilson
Changer forceSnapinParce to fastStart flag
Revision 1.24  1998/11/05 18:51:09  DChamberlain
Added look and feel and multi scope keys.
Revision 1.23  1998/10/27 21:42:33  dwilson
Added ForceSnapinParseCommandLineTokenKey
Revision 1.22  1998/10/23 15:27:13  DChamberlain
Added namespace instanceof scope key.
Revision 1.21  1998/10/13 21:40:28  DChamberlain
Removed GlobalType, GlobalContainer, GlobalLeaf and GlobalTreeObject
Scopes.
Revision 1.20  1998/09/29 17:29:58  DChamberlain
Bug fix, left out ;.
Revision 1.19  1998/09/29 16:57:31  DChamberlain
Moving constants from headers into code for simplicity.
Revision 1.18  1998/09/29 15:44:37  DChamberlain
Moved items that will not be translated from resources to constants.
Revision 1.17  1998/09/25 15:15:32  DChamberlain
Added main exception message 2.
Revision 1.16  1998/09/24 18:20:04  DChamberlain
Add items specified in manifest to SnapinClassloader's search path.
Revision 1.15  1998/09/21 17:59:08  DChamberlain
Name fix.
Revision 1.14  1998/09/18 15:02:01  DChamberlain
Added comments about not using Resources until they are loaded at
top of classes.
Revision 1.13  1998/09/17 22:25:07  DChamberlain
Revision 1.12  1998/09/17 21:39:50  DChamberlain
Moved items from resources that shouldn't be translated.
Revision 1.11  1998/09/11 19:39:20  DChamberlain
Added ConsoleOne jar name.
Revision 1.10  1998/09/05 01:04:32  dwilson
Added stuff for preferences skads
Revision 1.9  1998/07/30 18:14:13  dwilson
added SnapinFileExtensionKey for Serialized checksum work
Revision 1.8  1998/06/29 15:48:40  mharris
Revision 1.7  1998/05/28 14:56:40  DChamberlain
Added -windowout
Revision 1.6  1998/05/13 15:31:48  DChamberlain
Changed -output to -systemout.
Revision 1.5  1998/05/07 15:36:02  DChamberlain
Changed -verbose to -output.
Revision 1.4  1998/05/05 21:48:14  DChamberlain
Added command line argument to allow ConsolePreferences to
redirect shell.properties file.  (SPD# 191387)
Revision 1.3  1998/05/05 20:17:41  ksondere
Added PlaceHolderScopeKey Constant.
Revision 1.2  1998/05/04 22:21:27  SJENSEN
Changed TopObjectEntryID from "@12345" to "@My World!" so that if a user ever sees the root object name, it will be "prettier." (SPD# 191077)
Revision 1.1  1998/04/27 15:10:39  DChamberlain
Initial revision
*/
