/*
   $RCSfile: ConsoleOneSnapinType.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:21 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
   AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO THIS WORK IS
   RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A NEED TO KNOW HOW
   TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS AND (II)
   ENTITIES OTHER THAN NOVELL, INC. WHO HAVE ENTERED INTO APPROPRIATE
   LICENSE AGREEMENTS. NO PART OF THIS WORK MAY BE USED, PRACTICED,
   PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
   CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, TRANSFORMED
   OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE
   OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
   PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
*/
package com.novell.application.console.snapin;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import java.lang.Integer;
import javax.swing.*;
import com.novell.application.console.snapin.scope.*;
import com.novell.application.console.snapin.context.*;
import com.novell.application.console.shell.Resources;

/**
 * @internal
 * This class wraps the ConsoleOne snap-in types and also provides
 * a meaningful string description for the snap-in type.
 */
public class ConsoleOneSnapinType implements java.io.Serializable
{
   private Integer integer = null;

   ConsoleOneSnapinType( int snapinID )
   {
      integer = new Integer(snapinID);
   }

   public String toString()
   {
      String rv=null;

      switch( integer.intValue() )
      {
      case 1:
         rv = Resources.getString( "SnapinPage" );
         break;
      case 2:
         rv = Resources.getString( "SnapinView" );
         break;
      case 3:
         rv = Resources.getString( "SnapinMenu" );
         break;
      case 4:
         rv = Resources.getString( "SnapinToolbarItem" );
         break;
      case 5:
         rv = Resources.getString( "SnapinStatusbarItem" );
         break;
      case 6:
         rv = Resources.getString( "SnapinService" );
         break;
      case 7:
         rv = Resources.getString( "SnapinNamespace" );
         break;
      case 8:
         rv = Resources.getString( "SnapinExtendChildren" );
         break;
      case 9:
         rv = Resources.getString( "SnapinDisplayName" );
         break;
      case 10:
         rv = Resources.getString( "SnapinDisplayIcon" );
         break;
      case 11:
         rv = Resources.getString( "SnapinPopupMenu" );
         break;
      case 12:
         rv = Resources.getString( "SnapinPersistence" );
         break;
      case 13:
         rv = Resources.getString( "SnapinDynamic" );
         break;
      case 14:
         rv = Resources.getString( "SnapinMapObjectEntry" );
         break;
      case 15:
         rv = Resources.getString( "SnapinResultModifier" );
         break;
      default:
         rv = Resources.getString( "SnapinUnknown" );
         break;
      }

      return rv;
   }

   public int hashCode()
   {
      return integer.hashCode();
   }

   public boolean equals(Object obj)
   {
      //REMIND: Is this slow, do we have to do instanceof
      if(obj instanceof ConsoleOneSnapinType)
      {
         return integer.equals(((ConsoleOneSnapinType)obj).integer);
      }
      return false;
   }
}

/*
$Log: ConsoleOneSnapinType.java,v $
Revision 1.1.1.1  2001/05/09 12:43:21  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.1  1999/06/17 21:43:00  DChamberlain
Initial revision
*/