/*
   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL, 
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO 
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A 
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR 
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE 
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK 
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED, 
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED, 
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR 
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK 
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND 
   CIVIL LIABILITY. 
*/

package com.novell.application.console.snapin;

/**
* Provides a common help interface for snapins which
* need to provide a help system
*/
public interface Help 
{
   /**
    * Determines the state of the Help button.
    *
    * <p>You should override this method and return <i>true</i> if
    * you wish to provide Help for your snap-in, and have the Help
    * button enabled. 
    *
    * @return Boolean set to <i>true</i> if you want the 
    *         Help] button to be enabled, otherwise return
    *         <i>false</i> to disable the Help button.
    *        
    * @see #showHelp()
    */
    public boolean hasHelp();

   /**
    * Displays Help information when the hasHelp() method has returned <i>true</i>.
    *
    * <p>The showHelp() method is called when the user presses the 
    * Help button. To provide help for your snap-in, you must return <i>true</i>, 
    * then implement the showHelp() method.
    *
    * @see #hasHelp()
    */
    public void showHelp();     // called when user presses Help Button
	
}
