/**********************************************************
Created & Designed by:

Company 			: Cygsoft Inc.
Author		 		: <Deepak Dutia>
					: <Deepak Surwade>
Peer Reviewer 		: <Bhavesh Shah >
Code change date 	: <10 May 2001>
Comments 			:This class defines methods for making GUI 
		 			 components accessible
**********************************************************/



package com.novell.application.console.snapin;



import java.awt.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.table.*;
import javax.swing.JMenuItem.*;
import javax.accessibility.*;

import com.novell.utility.localization.*;		//Loc
import com.novell.application.console.widgets.*;	//widgets

//deepak 24 june
import com.novell.application.console.shell.Resources; 


public class NConeFactory 
{
	static AccessibleContext context;

	//This method will basically provide the implementation of making JButton 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JButton.    
	public static JButton novellJButton(JButton jb, String labelstring, String descstring)
	{										   		
		context = jb.getAccessibleContext();   //get Accessible context for the button
		context.setAccessibleName(labelstring);	  // this is what is read out by JAWS.
		context.setAccessibleDescription("");

/*		AccessibleIcon icon[] = context.getAccessibleIcon();
		icon[0].setAccessibleIconDescription("icon1");
*/
		return jb;
	}

	//This method will basically provide the implementation of making
	//JRadioButton (rb here)totally accessible in all possible ways. And it will 		
	//return a handle to accessible JRadioButton.
	public static JRadioButton novellJRadioButton(JRadioButton rb, String labelstring, String descstring)
	{										   											   		
		context = rb.getAccessibleContext();
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");		
		return rb;
	}

	//This method will basically provide the implementation of making
	//JComponent totally accessible in all possible ways. And it will 		
	//return a handle to accessible JComponent.
	public static JComponent novellJComponent(JComponent jcomp, String labelstring, String descstring)
	{										   											   		
		context = jcomp.getAccessibleContext();
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");		
		return jcomp;
	}

	/*
	//This method will basically provide the implementation of making
	//PopupMenu totally accessible in all possible ways. And it will 		
	//return a handle to accessible PopupMenu.
	public static PopupMenu novellPopupMenu(PopupMenu pm, String labelstring, String descstring)
	{										   											   		
		context = pm.getAccessibleContext();
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");		
		return pm;
	}
	*/

	//This method will basically provide the implementation of making JCheckBox 		
	//(cb here)totally accessible in all possible ways. And it will return a handle to 		
	//accessible JCheckBox.
	public static JCheckBox novellJCheckBox(JCheckBox cb, String labelstring, String descstring)
	{										   		
		context = cb.getAccessibleContext();
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");		
		return cb;
	}

	/*
	//This method will basically provide the implementation of making CheckboxMenuItem 		
	//(cb here)totally accessible in all possible ways. And it will return a handle to 		
	//accessible CheckboxMenuItem.
	public static CheckboxMenuItem novellCheckboxMenuItem(CheckboxMenuItem cbm, String labelstring, String descstring)
	{										   		
		context = cbm.getAccessibleContext();
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");		
		return cbm;
	}
	*/

	//This method will basically provide the implementation of making JMenuItem
	//(mi here)totally accessible in all possible ways. And it will return a handle to 		
	//accessible JMenuItem.
	public static JMenuItem novellJMenuItem(JMenuItem mi, String labelstring, String descstring)
	{										   
		context = mi.getAccessibleContext();
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");		
		return mi;
	}

	//This method will basically provide the implementation of making JTree 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JTree.
	public static JTree novellJTree(JTree jt, String labelstring, String descstring)
	{										   
		context = jt.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jt;
	}

	//This method will basically provide the implementation of making JTextField 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JTextField.
	public static JTextField novellJTextField(JTextField tf, String labelstring, String descstring)
	{								
		if(tf instanceof NJTextField)
		{
			((NJTextField)tf).beforeLabel = labelstring;
			return tf;
		}
	   
		context = tf.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return tf;
	}

	//This method will basically provide the implementation of making JTextArea 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JTextArea.
	public static JTextArea novellJTextArea(JTextArea ta, String labelstring, String descstring)
	{										   
		context = ta.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return ta;
	}

	//This method will basically provide the implementation of making JPasswordField 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JPasswordField.
	public static JPasswordField novellJPasswordField(JPasswordField pf, String labelstring, String descstring)
	{										   
		context = pf.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return pf;
	}

	//This method will basically provide the implementation of making JViewport 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JViewport.
	public static JViewport novellJViewport(JViewport vp, String labelstring, String descstring)
	{										   
		context = vp.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return vp;
	}

	//This method will basically provide the implementation of making JTabbedPane 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JTabbedPane.
	public static JTabbedPane novellJTabbedPane(JTabbedPane tp, String labelstring, String descstring)
	{										   
		context = tp.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return tp;
	}

	//This method will basically provide the implementation of making JOptionPane 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JOptionPane.
	public static JOptionPane novellJOptionPane(JOptionPane op, String labelstring, String descstring)
	{										   
		context = op.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return op;
	}
	
	//This method will basically provide the implementation of making JMenu 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JMenu.
	public static JMenu novellJMenu(JMenu jm, String labelstring, String descstring)
	{										   		
		context = jm.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jm;
	}

	//This method will basically provide the implementation of making JCheckBoxMenuItem 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JCheckBoxMenuItem.
	public static JCheckBoxMenuItem novellJCheckBoxMenuItem(JCheckBoxMenuItem cbmi, String labelstring, String descstring)
	{					
		context = cbmi.getAccessibleContext();  				      	    
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return cbmi;
	}

	//This method will basically provide the implementation of making JLayeredPane 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JLayeredPane. 
	public static JLayeredPane novellJLayered(JLayeredPane lp, String labelstring, String descstring)
	{										   
		context = lp.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return lp;
	}

	//This method will basically provide the implementation of making JToggleButton 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JToggleButton. 
	public static JToggleButton novellJToggleButton(JToggleButton tb, String labelstring, String descstring)
	{
		context = tb.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return tb;
	}

	//This method will basically provide the implementation of making JColorChooser 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JColorChooser.  
	public static JColorChooser novellJColorChooser(JColorChooser cc, String labelstring, String descstring)
	{   
		context = cc.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return cc;
	}

	//This method will basically provide the implementation of making JPopupMenu 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JPopupMenu.  
	public static JPopupMenu novellJPopupMenu(JPopupMenu pm, String labelstring, String descstring)
	{   
		context = pm.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return pm;
	}

	//This method will basically provide the implementation of making JSeparator 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JSeparator.  
	public static JSeparator novellJSeparator(JSeparator js, String labelstring, String descstring)
	{   
		context = js.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return js;
	}

	//This method will basically provide the implementation of making JWindow 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JWindow.  
	public static JWindow novellJWindow(JWindow jw, String labelstring, String descstring)
	{   
		context = jw.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jw;
	}

	//This method will basically provide the implementation of making JApplet 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JApplet.  
	public static JApplet novellJApplet(JApplet ja, String labelstring, String descstring)
	{	 		 		
		context = ja.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return ja;
	}

	//This method will basically provide the implementation of making JComboBox 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JComboBox.  
	public static JComboBox novellJComboBox(JComboBox cb, String labelstring, String descstring)
	{	 
		context = cb.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return cb;
	}

	//This method will basically provide the implementation of making JList 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JList.  
	public static JList novellJList(JList jl, String labelstring, String descstring)
	{	 
		context = jl.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jl;
	}

	//This method will basically provide the implementation of making JToolTip 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JToolTip.  
	public static JToolTip novellJToolTip(JToolTip tt, String labelstring, String descstring)
	{	 
		context = tt.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return tt;
	}

	//This method will basically provide the implementation of making JInternalFrame 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JInternalFrame.  
	public static JInternalFrame novellJInternalFrame(JInternalFrame jif, String labelstring, String descstring)
	{	 
		context = jif.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jif;
	}

	//This method will basically provide the implementation of making JPanel 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JPanel.  
	public static JPanel novellJPanel(JPanel jp, String labelstring, String descstring)
	{	 
		context = jp.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jp;
	}

	//This method will basically provide the implementation of making JFrame 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JFrame.  
	public static JFrame novellJFrame(JFrame jf, String labelstring, String descstring)
	{
		context = jf.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jf;
	}

	//This method will basically provide the implementation of making JSplitPane 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JSplitPane.  
	public static JSplitPane novellJSplitPane(JSplitPane sp, String labelstring, String descstring)
	{
		context = sp.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return sp;
	}

	//This method will basically provide the implementation of making JTable 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JTable.  
	public static JTable novellJTable(JTable jt, String labelstring, String descstring)
	{	    
		context = jt.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jt;
	}

	//This method will basically provide the implementation of making JLabel 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JLabel.  
	public static JLabel novellJLabel(JLabel jl, String labelstring, String descstring)
	{	    
		context = jl.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jl;
	}

	//This method will basically provide the implementation of making JFileChooser 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JFileChooser.  
	public static JFileChooser novellJFileChooser(JFileChooser fc, String labelstring, String descstring)
	{	    
		context = fc.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return fc;
	}

	//This method will basically provide the implementation of making JDesktopPane 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JDesktopPane.  
	public static JDesktopPane novellJDesktopPane(JDesktopPane dp, String labelstring, String descstring)
	{	    
		context = dp.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return dp;
	}

	//This method will basically provide the implementation of making JToolBar 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JToolBar.  
	public static JToolBar novellJToolBar(JToolBar tb, String labelstring, String descstring)
	{	    
		context = tb.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return tb;
	}

	//This method will basically provide the implementation of making JMenuBar 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JMenuBar.  
	public static JMenuBar novellJMenuBar(JMenuBar mb, String labelstring, String descstring)
	{	    
		context = mb.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return mb;
	}

	//This method will basically provide the implementation of making JRadioButtonMenuItem 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JRadioButtonMenuItem.  
	public static JRadioButtonMenuItem novellJRadioButtonMenuItem(JRadioButtonMenuItem rbmi, String labelstring, String descstring)
	{	    
		context = rbmi.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return rbmi;
	}

	//This method will basically provide the implementation of making JScrollPane 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JScrollPane.  
	public static JScrollPane novellJScrollPane(JScrollPane sp, String labelstring, String descstring)
	{	    
		context = sp.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return sp;
	}

	//This method will basically provide the implementation of making JScrollBar 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JScrollBar.  
	public static JScrollBar novellJScrollBar(JScrollBar sb, String labelstring, String descstring)
	{	    
		context = sb.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return sb;
	}

	//This method will basically provide the implementation of making JProgressBar 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JProgressBar.  
	public static JProgressBar novellJProgressBar(JProgressBar pb, String labelstring, String descstring)
	{	    
		context = pb.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return pb;
	}

	//This method will basically provide the implementation of making JRootPane 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JRootPane.  
	public static JRootPane novellJRootPane(JRootPane rp, String labelstring, String descstring)
	{	    
		context = rp.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return rp;
	}

	//This method will basically provide the implementation of making JDialog 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JDialog.  
	public static JDialog novellJDialog(JDialog jd, String labelstring, String descstring)
	{	    
		context = jd.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return jd;
	}

	//This method will basically provide the implementation of making JSlider 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JSlider.  
	public static JSlider novellJSlider(JSlider js, String labelstring, String descstring)
	{	    
		context = js.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return js;
	}


	//This method will basically provide the implementation of making JTableHeader 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JTableHeader.  
	public static JTableHeader novellJTableHeader(JTableHeader th, String labelstring, String descstring)
	{	    
		context = th.getAccessibleContext();   
		context.setAccessibleName(labelstring);	
		context.setAccessibleDescription("");
		return th;
	}
	
	
	//This method will basically provide the implementation of making JEditorPane 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible JEditorPane.  
	public static JEditorPane novellJEditorPane(JEditorPane ep, String labelstring, String descstring)
	{
			context = ep.getAccessibleContext();
			context.setAccessibleName(labelstring);
			context.setAccessibleDescription("");
			return ep;
	}

	//This method is used to set the focus accelerator for NList. It takes two parameters JLabel
	//and NList. Note that the text for the JLabel contains a '&' before the letter which is the 
	//accelerator for the NList.		
	public static void makeRelation(JLabel jl, NList nj)
	{
		novellJList(nj.getList(),Loc.removeHotChar(jl.getText()),"This is a List");   //making JList accessible
		
		char ch  = Loc.getHotChar(jl.getText());		//To get the Hot Char. The letter after the '&'
		if(ch!=-1)  //if not hot Char set.
			jl.setDisplayedMnemonic(ch); //Setting Mnemonic for Label.
		
		jl.setText(Loc.removeHotChar(jl.getText()));	
		jl.setLabelFor(nj.getList()); //creates association between label and list.		
		//Deepak Surwade 22 june
		novellJLabel(jl, "" , "");   //set accessible name ""
	}

	//added by deepak on 10 june
	// for NDateTimeControl
	//This method is used to set the focus accelerator for textField of NDateTimeControl. It takes two parameters JLabel
	//and NDateTimeControl. Note that the text for the JLabel contains a '&' before the letter which is the 
	//accelerator for the NDateTimeControl.		
	public static void makeRelation(JLabel jl, NDateTimeControl nj)
	{
		makeRelation(jl, nj.getTextField());//making JTextField accessible
	}

	//end

	//This method is used to set the focus accelerator for JList. It takes two parameters JLabel
	//and JList. Note that the text for the JLabel contains a '&' before the letter which is the 
	//accelerator for the JList.		
	public static void makeRelation(JLabel jl, JList jlist)
	{
		novellJList(jlist,Loc.removeHotChar(jl.getText()),"This is a List");   //making JList accessible

		char ch  = Loc.getHotChar(jl.getText());		//To get the Hot Char. The letter after the '&'
		if(ch!=-1)  //if not hot Char set.
			jl.setDisplayedMnemonic(ch); //Setting Mnemonic for Label.
		
		jl.setText(Loc.removeHotChar(jl.getText()));			

		jl.setLabelFor(jlist); //creates association between label and list.
		//Deepak Surwade 22 june		
		novellJLabel(jl, "" , "");   //set accessible name ""
	}

	//This method is used to set the focus accelerator for JTextArea. It takes two parameters JLabel
	//and JTextArea. Note that the text for the JLabel maycontain '&' before the letter which is the 
	//accelerator for the JTextArea.		
	public static void makeRelation(JLabel lbl , JTextArea area) {
		novellJTextArea(area , Loc.removeHotChar(lbl.getText()),"This is a TextArea");//making text area accessible.
		
		char ch = Loc.getHotChar(lbl.getText());		
		if(ch!=-1)
			lbl.setDisplayedMnemonic(ch);
		
		lbl.setText(Loc.removeHotChar(lbl.getText()));	
		
		//Deepak Surwade 22 june
		//area.setFocusAccelerator(ch);   //Making an association between label and text area.		
		lbl.setLabelFor(area); //creates association between label and list.
		novellJLabel(lbl, "" , "");   //set accessible name ""
	}

	//This method is used to set the focus accelerator for JPasswordField. It takes two parameters JLabel
	//and JPasswordField. Note that the text for the JLabel maycontain '&' before the letter which is the 
	//accelerator for the JPasswordField.		
	public static void makeRelation(JLabel lbl , JPasswordField pf) 
	{
		novellJPasswordField(pf , Loc.removeHotChar(lbl.getText()),"This is a password field");//making text area accessible.

		char ch = Loc.getHotChar(lbl.getText());		
		if(ch!=-1)
			lbl.setDisplayedMnemonic(ch);
		
		lbl.setText(Loc.removeHotChar(lbl.getText()));
		
		//Deepak Surwade 22 june
		//pf.setFocusAccelerator(ch);   //Making an association between label and text area.		
		lbl.setLabelFor(pf); //creates association between label and list.
		novellJLabel(lbl, "" , "");   //set accessible name ""
	}



	//This method is used to set the focus accelerator for JTextField. It takes two parameters JLabel
	//and JTextField. Note that the text for the JLabel may contain '&' before the letter which is the 
	//accelerator for the JTextField.		
	public static void makeRelation(JLabel lbl , JTextField field) 
	{
		//deepak 3 july
		if(field instanceof NJTextField)
		{
			makeRelation(lbl, (NJTextField)field); 
			return ;
		}

		novellJTextField(field , Loc.removeHotChar(lbl.getText()),"This is a TextField");   //making textfield accessible.
		
		char ch = Loc.getHotChar(lbl.getText());
		if(ch!=-1)
			lbl.setDisplayedMnemonic(ch);
		
		lbl.setText(Loc.removeHotChar(lbl.getText()));
			
		//Deepak Surwade 22 june
		//field.setFocusAccelerator(ch);   //Making an association between label and text field.		
		lbl.setLabelFor(field); //creates association between label and list.
		novellJLabel(lbl, "" , "");   //set accessible name ""
	}

	//This method is used to set the focus accelerator for NMved. It takes two parameters JLabel
	//and NMved. Note that the text for the JLabel may contain '&' before the letter which is the 
	//accelerator for the NMved.		
	public static void makeRelation(JLabel lbl , NMved nm) 
	{
		makeRelation(lbl, nm.getTextField());//making text field accessible.
		//24 june
		novellJButton(nm.getButton(), Loc.removeHotChar(lbl.getText()) +"		"+ Resources.getString("Browse"), "");
	}

	//This method is used to set the focus accelerator for JSlider. It takes two parameters JLabel
	//and JSlider. Note that the text for the JLabel maycontain '&' before the letter which is the 
	//accelerator for the JSlider.		
	public static void makeRelation(JLabel lbl, JSlider js) 
	{
		novellJSlider(js , Loc.removeHotChar(lbl.getText()),"This is a JSlider");
		
		char ch = Loc.getHotChar(lbl.getText());		
		if(ch!=-1)
			lbl.setDisplayedMnemonic(ch);	
		
		lbl.setText(Loc.removeHotChar(lbl.getText()));
		
		lbl.setLabelFor(js);		
		//Deepak Surwade 22 june
		novellJLabel(lbl, "" , "");   //set accessible name ""
	}

	//This method is used to set the focus accelerator for JComboBox. It takes two parameters JLabel
	//and JComboBox. Note that the text for the JLabel maycontain '&' before the letter which is the 
	//accelerator for the JComboBox.		
	public static void makeRelation(JLabel lbl, JComboBox jc) {
		novellJComboBox(jc , Loc.removeHotChar(lbl.getText()),"This is a JComboBox");
		
		char ch = Loc.getHotChar(lbl.getText());		
		if(ch!=-1)
			lbl.setDisplayedMnemonic(ch);
			
		lbl.setText(Loc.removeHotChar(lbl.getText()));

		lbl.setLabelFor(jc);	
		//Deepak Surwade 22 june
		novellJLabel(lbl, "" , "");   //set accessible name ""
	}

	//This method is used to set the focus accelerator for NDualScroller. It takes two parameters JLabel
	//and NDualScroller. Note that the text for the JLabel may contain '&' before the letter which is the 
	//accelerator for the NDualScroller.		
	public static void makeRelation(JLabel left ,JLabel right, NDualScroller ds) 
	{
		makeRelation( left , ds.getTextArealeft() );//making text area accessible.
		makeRelation( right , ds.getTextArearight() );//making text area accessible.
	}

	//This method is used to set the focus accelerator for NDualListScroller. It takes two parameters 
	//JLabel and NDualListScroller. Note that the text for the JLabel may contain a '&' before the letter 
	//which is the accelerator for the NDualListScroller.		
	public static void makeRelation(JLabel left ,JLabel right, NDualListScroller ds) 
	{
		makeRelation(left, ds.getNListleft());
		makeRelation(right, ds.getNListright());
	}

	//This method is used to set the focus accelerator for NMVComplex. It takes two parameters 
	//JLabel and NMVComplex. Note that the text for the JLabel contains a '&' before the letter 
	//which is the accelerator for the NMVComplex.		
	public static void makeRelation(JLabel label, NMvComplex mc) {
		makeRelation(label, mc.getNList());
	}

	//This method will basically provide the implementation of making MWrapLabel 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible MWrapLabel.
	public static NWrapLabel novellNWrapLabel(JLabel label, NWrapLabel wl){
		context = wl.getAccessibleContext();
		context.setAccessibleName(label.getText());
		context.setAccessibleDescription("");
		return wl;
	}


	//This method will basically provide the implementation of making MMultiLineLabel 
	//totally accessible in all possible ways. And it will return a handle to 		
	//accessible MMultiLineLabel.
	public static NMultiLineLabel novellNMultiLineLabel(JLabel label, NMultiLineLabel ml){
		context = ml.getAccessibleContext();
		context.setAccessibleName(label.getText());
		context.setAccessibleDescription("");
		return ml;
	}	


	//deepak s 3 july

	//This method calls makeRelation(JLabel , JLabel, NJTextField) 		
	public static void makeRelation(JLabel beforeLbl , NJTextField field) 
	{
		makeRelation(beforeLbl, new JLabel(""), field); 		
	}
	// This takes three parameters two JLabels and NJTextField. This set the accessibility for NJTextField.
	// Note : The text for the JLabel may contain '&' before the letter which is the 
	//	accelerator for the NJTextField.	
	public static void makeRelation(JLabel beforeLbl, JLabel afterLbl, NJTextField field) 
	{	  
		field.beforeLabel = beforeLbl.getText();
		field.afterLabel  = afterLbl.getText();	    

		//novellJTextField(field , Loc.removeHotChar(beforeLbl.getText()),"This is a TextField");   //making textfield accessible.
		char ch = Loc.getHotChar(beforeLbl.getText());
		if(ch!=-1)
			beforeLbl.setDisplayedMnemonic(ch);
		
		beforeLbl.setText(Loc.removeHotChar(beforeLbl.getText()));
			
		//Deepak Surwade 22 june
		//field.setFocusAccelerator(ch);   //Making an association between label and text field.		
		beforeLbl.setLabelFor(field); //creates association between label and list.
		novellJLabel(beforeLbl, "" , "");   //set accessible name ""
	}

	//end


}//end of class NConeFactory{}