/*
   $RCSfile: PageSnapin.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:24 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1989-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
   AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO THIS WORK IS
   RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A NEED TO KNOW HOW
   TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS AND (II)
   ENTITIES OTHER THAN NOVELL, INC. WHO HAVE ENTERED INTO APPROPRIATE
   LICENSE AGREEMENTS. NO PART OF THIS WORK MAY BE USED, PRACTICED,
   PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
   CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, TRANSFORMED
   OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE
   OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
   PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
*/

package com.novell.application.console.snapin;

import java.awt.Component;
import java.awt.Panel;
import java.awt.Dimension;
import com.novell.utility.mpec.MPEC;

/**
 * Provides the interface that must be implemented by property page snap-in writers.
 *
 * <p><b>Note:</b> The size of property pages is now hardcoded to 640 X 480, and the
 * getPreferredSize() and setPreferredSize() methods have been removed. This has the
 * following implications:
 * 
 * <ul>
 * <li>If ConsoleOne hosts a property page snap-in, the minimum screen resolution 
 * required for ConsoleOne will effectively be 800 X 600.
 * <li>It is up to you to ensure that any controls you put on your property pages
 * actually fit on the page.
 * </ul>
 *
 * <p><b>Note:</b> Currently, there is a possible problem with hosting a JComboBox
 * swing component on a property page.
 * 
 * @see PropertyBook
 *
 * @version 0.0 19 May 1997
 */
public interface PageSnapin extends Snapin, Help
{
   /**
    * Provides a reference to the actual Component for the given page snap-in.
    *
    * <p>The getPage() method is called when the PropertyBook is initiated,
    * allowing you to provide a reference to the property page Component. Only
    * an AWT Panel should be used with property pages.</p>
    *
    * @return The visual Component of the given property page that is wrapped
    *         in a java.AWT.Component.
    */
    public Component getPage();

   /**
    * Returns the language dependent, translated display name for the tab
    * where the page is to be placed.
    *
    * <p>This string should be read from a resource file for the purposes
    * of internationalization. This name will only be used when a new tab
    * is being created, not when an existing tab is being extended. If this
    * tab does not exist, the Property Book will use the string name for
    * the tab name, otherwise it is ignored. The following code snippet
    * shows how the getTabName() call is made.
    * <pre><code>
    *    public String getTabName()
    *    {
    *        return "FileInfo";
    *    }
    * </pre></code>
    *
    *
    * @return The translated display name for the tab.
    *
    * @see #getTabID()
    */ 
    public String getTabName();

   /**
    * Returns the globally unique, language independent identifier (TabID)
    * for the tab folder where the current page is to be placed.
    *
    * <p>This TabID can be any globally unique string. If a Tab with the
    * specified TabID exists, the page will extend the Tab, if necessary,
    * by converting it to a Multi-Page Tab, and then adding the menu name
    * to the tab's dropdown menu. If no tab with the specified TabID exists,
    * the PropertyBook will create a new tab folder and assign it the 
    * display name obtained from the getTabName() method call. The tab
    * page is then added to this new folder.</p>
    *
    * <p>Any Tab may be extended by third-party developers if its TabID is 
    * published to the development community and someone writes a Page
    * snap-in that returns the same TabID from its getTabID() method.
    * The following code snippet shows how the getTabID() call is made.
    * <pre><code>
    *    public String getTabID()
    *    {
    *        return "com.novell.sample.snapins.filesystem.fileinfo";
    *    }
    * </pre></code>
    *
    * @return The tab indentification name.
    *
    * @see #getTabName()
    */
    public String getTabID();

    /**
    * Returns the language dependent, unique menu item name for the menu
    * on Multi-Page Tabs.
    *
    * <p>The PropertyBook calls the getMenuName() method to determine the
    * the menu item name for this page if the Tab is a Multi-Page Tab. The
    * menu item name is displayed in a pop-up menu whenever a user selects
    * a Multi-Page Tab. You can return NULL if the Tab is not a Multi-Page
    * Tab and you are sure it will never be extended. That is, its TabID
    * will never be published to the third-party snap-in development
    * community. The following code snippet shows how the getMenuName() call
    * is made.
    * <pre><code>
    *    public String getMenuName()
    *    {
    *        return "Rename";
    *    }
    * </pre></code>
    *
    * @return The displayable menu name or null if the tab ID cannot be extended.
    *
    * @see #getTabID()
    */ 
    public String getMenuName();

   /**
    * Indicates that your page is receiving focus next.
    *
    * <p>The setActive() method is called when your page is about get the focus (to
    * be shown).
    * <pre><code>
    *       public void setActive( boolean firstTimeShown )
    *       {
    *          if( firstTimeShown )
    *          {
    *             // read data from source and populate page
    *          }
    *       }
    * </code></pre>
    *
    * @param firstTimeShown Boolean set to <i>true</i> the first time your page gets
    *                       focus, then set to <i>false</i> to indicate the page has
    *                       previously been given focus.
    *
    * @see #killActive()
    */
    public void setActive( boolean firstTimeShown );

   /**
    * Determines if the page can lose focus.
    *
    * <p>The killActive() method is called when your snap-in page is about
    * to lose focus. To give the current focus holder an opportunity to veto
    * the change, the PropertyBook calls the page's killActive() method. If the
    * owning PageSnapin determines that its data is valid, it should return
    * <i>true</i>, indicating its willingness to proceed with the focus change.
    * If the PageSnapin checks its data and finds it invalid, it should display
    * an error dialog and then return false, effectively vetoing the change in
    * focus. Thus, you should implement this method to validate snap-in data
    * before losing focus, as shown below.
    *
    * <pre><code>
    *       public boolean killActive()
    *       {
    *          // Check page data validity
    *          // Return true if data is valid
    *          // else display error dialog, then return false
    *       }
    * </code></pre>
    *
    * @return A boolean set to <i>true</i> if it is OK to lose focus, otherwise
    *         display an error dialog and return <i>false</i> to stop the page
    *         from losing focus.
    *
    * @see #setActive(boolean)
    */
    boolean killActive();

   /**
    * Determines the state of the Property Book Help button.
    *
    * <p>You should override this method and return <i>true</i> if
    * you wish to provide Help for your snap-in, and have the Help
    * button enabled for your page. You should also override the
    * showHelp() method.
    *
    * @return Boolean set to <i>true</i> if you want the Property Book
    *         Help] button to be enabled for this page, otherwise return
    *         <i>false</i> to disable the Help button.
    *        
    * @see #showHelp()
    */
    public boolean hasHelp();

   /**
    * Displays Help information when the hasHelp() method has returned <i>true</i>.
    *
    * <p>The showHelp() method is called when the user presses the Property Book
    * Help button. To provide help for your snap-in, you must override the 
    * hasHelp() method to return <i>true</i>, then implement the showHelp()
    * method.
    *
    * @see #hasHelp()
    */
    public void showHelp();     // called when user presses Help Button

   /**
    * Determines whether the page data is ready to be saved.
    *
    * <p>The canSave() method is called in each of its page snap-ins to validate
    * dialog fields,when the user selects either the OK button, or the Apply Now
    * button. You should implement this method to to give each page snap-in a
    * chance to validate page data before saving data to storage. The only difference
    * between this method and the killActive method is that this method is called
    * when the user is trying to close the PropertyBook and the killActive() method
    * is called when the user is trying to change the focus to a different page.
    * This method can also be implemented by simply calling the killActive() method
    * as shown below.
    *
    * <pre><code>
    *       public boolean canSave()
    *       {
    *          // Check page data validity
    *          // Return true if data is valid
    *          // Else display error dialog, then return false
    *          return true; // or
    *          return killActive();
    *       }
    * </code></pre>
    *
    * @return A boolean set to <i>true</i> if your snap-in data is ready to
    *         be saved, otherwise display a dialog informing the user of why the
    *         operation was stopped and return <i>false</i>.
    *
    * @see #saveData()
    */
    public boolean canSave();

   /**
    * Saves page data to a persistent store.
    *
    * <p>The saveData() method is called when the user selects either the OK
    * button or the Apply Now button, and the canSave() method has returned
    * <i>true</i>. If all the page snap-ins return <i>true</i> in their canSave()
    * methods, this indicates to the PropertyBook that the save sequence may continue.
    * The PropertyBook then calls each of its page snap-in's saveData() methods. If
    * during the process of saving its data the page snap-in has a problem, it can 
    * display a dialog informing the user of why the operation was stopped and then
    * return <i>false</i>, thereby stopping the operation for the remaining pages.
    *
    * @return A boolean set to <i>true</i> if the page data has been saved to
    *         a persistant store, otherwise display a dialog informing the user
    *         of why the operation was stopped and return <i>false</i>.
    *
    * @see #canSave()
    */
    public boolean saveData();
}

/*

$Log: PageSnapin.java,v $
Revision 1.1.1.1  2001/05/09 12:43:24  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.36  1999/01/08 15:32:45  DChamberlain
Updated copyright to include 1999.
Revision 1.35  1999/01/07 19:28:13  DChamberlain
Updated copyright to include 1999.
Revision 1.34  1998/12/16 17:04:54  dwilson
Seperated the Help methods into a new interface called Help
Revision 1.33  1998/08/11 20:15:34  mcarmack
More Javadoc revisions per SPD 182294.
Revision 1.32  1998/08/11 18:59:17  mcarmack
Added Javadoc comments per SPDs 198988 and 200590.
Revision 1.31  1998/08/06 19:44:36  mcarmack
Fixed typo per SPD 205821
Revision 1.30  1998/05/14 16:19:18  SHerrin
Added comment and code snippets from Mike Harris in Javadoc for getTabID(), getTabName() and getMenuName().
Revision 1.29  1998/05/06 16:44:54  SHerrin
Corrected Javadoc comments for killActive(), canSave() and saveData().
Revision 1.28  1998/04/07 16:55:28  dwilson
Doc changes
Revision 1.27  1998/04/07 03:03:29  SHerrin
Added and corrected Javadoc comments.
Revision 1.26  1998/04/03 22:17:35  SHerrin
Corrected Javadoc comments.
Revision 1.25  1998/03/19 21:38:55  dwilson
Took out setPropertyBook moved into PageSnapinContext
Revision 1.24  1998/03/11 23:26:54  dwilson
Changed setPageHost to setPropertyBook
Revision 1.23  1998/03/10 21:49:56  dwilson
Took out setPageHost
Revision 1.22  1998/03/04 18:05:21  SHerrin
Edited Javadoc comments.
Revision 1.21  1998/02/26 01:13:54  DChamberlain
Changed Simple to Abstract.
Revision 1.20  1998/02/07 00:49:09  dwilson
Update to new MPEC interfaces
Revision 1.19  1998/01/29 16:21:39  dwilson
Revision 1.18  1998/01/23 18:52:42  SHerrin
Corrected Javadoc comments.
Revision 1.17  1998/01/22 22:49:31  dwilson
Added setPageHost()
Revision 1.16  1998/01/12 23:50:40  dwilson
Added canChange() to interface
Revision 1.15  1998/01/12 18:34:55  DChamberlain
Moved from ncc package to console.
Revision 1.14  1997/11/25 23:20:56  SHerrin
Made changes to Javadoc comments following technical review.
Revision 1.13  1997/11/13 22:08:40  dwilson
Updated to Gallup interfaces
Revision 1.12  1997/11/07 16:32:46  DChamberlain
Massive package name changes.
Revision 1.11  1997/10/24 20:48:57  SHerrin
Made corrections to Javadoc comments following technical review.
Revision 1.10  1997/09/26 21:07:25  SHerrin
Made Javadoc editorial corrections.
Revision 1.9  1997/09/25 22:26:02  DChamberlain
Bug fix.
Revision 1.8  1997/09/25 22:10:50  dwilson
Changed interface names getTabIDString to getTabID again, and getPanel to getMPECPage again
Revision 1.7  1997/09/18 22:50:40  DChamberlain
Uppercase COM to lowercase com for novell packages.
Revision 1.6  1997/09/18 22:04:46  dwilson
Changed getTabID to getTabIDString
Revision 1.5  1997/09/16 22:51:44  dwilson
Made changes to correct comments, changed order of methods
Revision 1.4  1997/09/12 20:31:08  Paul_MacKay
Added Selby's documentation changes
Revision 1.3  1997/09/05 23:04:18  dwilson
Updated interfaces
Revision 1.2  1997/09/04 15:21:52  jeThatcher
Changed superinsterface to Snapin, changed initPage to setMPEC, removed close.
Revision 1.1  1997/08/29 00:32:32  DChamberlain
Initial revision
Revision 1.1  1997/08/28 23:45:20  DChamberlain
Initial revision
Revision 2.2  1997/08/13 21:30:46  DChamberlain
Put back extends ConfigurableSnapin.
Revision 2.1  1997/08/12 21:35:50  dwilson
Added getTabID()
Revision 1.2  1997/07/28 21:58:18  jeThatcher
Removed proxyID parameters.
Revision 1.1  1997/07/28 21:46:26  dwilson
Initial revision
Revision 1.2  1997/06/26 15:56:22  DChamberlain
Added MKS keywords and copyright.

*/
