/*
   $RCSfile: Registration.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:25 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL, 
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO 
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A 
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR 
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE 
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK 
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED, 
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED, 
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR 
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK 
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND 
   CIVIL LIABILITY. 
*/

package com.novell.application.console.snapin;

/**
 * Provides for the registration of snap-ins to ConsoleOne.
 *
 * <p>You can register your snap-in in three ways:
 * <ul>
 * <li>Within each individual snap-in class
 * <li>In a separate registration class
 * <li>By auto-registration using a manifest file
 * </ul>
 * <p>Registering your snap-ins within each individual snap-in class makes
 * the code easier to read, however registering snap-ins in a separate
 * registration class is more efficient at startup time. For a more 
 * complete description of snap-in registration, go the the "Registering
 * Your Snap-ins" tasks topic in the ConsoleOne Developer's Guide.
 */
public interface Registration
{
  /**
   * Returns a RegistrationItem array, which the shell uses to categorize
   * the snap-ins based on the content of the Scope and to instantiate the
   * snap-ins.
   *
   * <p>Following is an example of the getRegistration() implementation.
   * <pre>
   * <code>    public RegistrationItem[] getRegistration()</code>
   * <code>    {</code>
   * <code>        return new RegistrationItem[]</code>
   * <code>        {</code>
   * <code>            new RegistrationItem(new NamespaceContainerTypesScope(Shell.SNAPIN_VIEW,</code>
   * <code>                "com.novell.sample.snapins.filesystem"), getClass().getName())</code>
   * <code>        };</code>
   * <code>    }</code>
   * </pre>
   * @return The array of items to be registered.
   *
   * @see RegistrationItem
   */

   RegistrationItem[] getRegistration();
}
