/*
   $RCSfile: ShellFocusListener.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:25 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
   CIVIL LIABILITY.
*/
package com.novell.application.console.snapin;

import java.util.*;


//REMIND: John, review entire class
 /**
  * Listens for shell focus changed events.
  *
  * <p>The ShellFocusListener interface can be implemented for the purpose of
  * listening for shell focus changed events.  This can be useful for view 
  * snapins that want to know when focus changes to the tree.
  *
  * @see ShellFocusEvent
  */

public interface ShellFocusListener extends EventListener
{
  /**
   * Allows a participating snap-in to perform an action associated with 
   * a shell focus changed event.
   *
   * <p>The participating snap-in is notified that the shell focus status
   * has changed.  Either the focus has moved from the tree to the view or
   * vice-versa.
   *
   * @param event The shell focus event containing the new status.
  */
	public abstract void focusChanged(ShellFocusEvent event);
}

/*
$Log: ShellFocusListener.java,v $
Revision 1.1.1.1  2001/05/09 12:43:25  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.2  2000/01/25 19:49:39  DChamberlain
Updated javadoc.
Revision 1.1  1999/08/12 20:15:51  DChamberlain
Initial revision
*/
