/*
   $RCSfile: ShellLifecycleEvent.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:26 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
   CIVIL LIABILITY.
*/
package com.novell.application.console.snapin;

//REMIND: John, review entire class
/**
 * Defines a shell lifecycle event.
 *
 * <p>A shell lifecycle event may consist of several shell status states.
 *
 * @see ShellLifecycleListener
 * @see ShellLifecycleAdapter
 *
 * @copyright (c) 1997-1999 Novell, Inc.
*/

public class ShellLifecycleEvent extends java.util.EventObject
{
   static Integer dummy = new Integer(0);    // a dummy object for the super() call in the constructor
   
   /**
    * Starting snapin registration.
    *
    * <p>(BEGIN_SNAPIN_REGISTRATION = 1)
    * </p>
    */
   public static final int BEGIN_SNAPIN_REGISTRATION = 1;
   
   /**
    * Snapin registration complete.
    *
    * <p>(END_SNAPIN_REGISTRATION = 2)
    * </p>
    */
   public static final int END_SNAPIN_REGISTRATION = 2;
   
   /**
    * Initing service snapins.
    *
    * <p>(BEGIN_SERVICE_SNAPIN_INIT = 3)
    * </p>
    */
   public static final int BEGIN_SERVICE_SNAPIN_INIT = 3;
   
   /**
    * Service snapin init complete.
    *
    * <p>(END_SERVICE_SNAPIN_INIT = 4)
    * </p>
    */
   public static final int END_SERVICE_SNAPIN_INIT = 4;
   
   /**
    * Initing namespace snapins.
    *
    * <p>(BEGIN_NAMESPACE_SNAPIN_INIT = 5)
    * </p>
    */
   public static final int BEGIN_NAMESPACE_SNAPIN_INIT = 5;
   
   /**
    * Namespace snapin init complete.
    *
    * <p>(END_NAMESPACE_SNAPIN_INIT = 6)
    * </p>
    */
   public static final int END_NAMESPACE_SNAPIN_INIT = 6;
   
   /**
    * Beginning snapin shutdown.
    *
    * <p>(BEGIN_SNAPIN_SHUTDOWN = 7)
    * </p>
    */
   public static final int BEGIN_SNAPIN_SHUTDOWN = 7;
   
   /**
    * Snapin shutdown complete.
    *
    * <p>(END_SNAPIN_SHUTDOWN = 8)
    * </p>
    */
   public static final int END_SNAPIN_SHUTDOWN = 8;
   
   /**
    * Beginning shell construction.
    *
    * <p>(BEGIN_SHELL_CONSTRUCTION = 9)
    * </p>
    */
   public static final int BEGIN_SHELL_CONSTRUCTION = 9;
   
   /**
    * Shell construction complete.
    *
    * <p>(END_SHELL_CONSTRUCTION = 10)
    * </p>
    */
   public static final int END_SHELL_CONSTRUCTION = 10;
   
   /**
    * Beginning ConsoleOne startup.
    *
    * <p>(BEGIN_CONSOLEONE_STARTUP = 11)
    * </p>
    */
   public static final int BEGIN_CONSOLEONE_STARTUP = 11;
   
   /**
    * ConsoleOne startup complete.
    *
    * <p>(END_CONSOLEONE_STARTUP = 12)
    * </p>
    */
   public static final int END_CONSOLEONE_STARTUP = 12;
   
   /**
    * Beginning ConsoleOne shutdown.
    *
    * <p>(BEGIN_CONSOLEONE_SHUTDOWN = 13)
    * </p>
    */
   public static final int BEGIN_CONSOLEONE_SHUTDOWN = 13;
   
   /**
    * ConsoleOne shutdown complete.
    *
    * <p>(END_CONSOLEONE_SHUTDOWN = 14)
    * </p>
    */
   public static final int END_CONSOLEONE_SHUTDOWN = 14;
   
   /**
    * ConsoleOne shutdown aborted.
    *
    * <p>(ABORT_CONSOLEONE_SHUTDOWN = 15)
    * </p>
    */
   public static final int ABORT_CONSOLEONE_SHUTDOWN = 15;
   
   // private variables
   private int m_id;

   /**
   * Creates a shell lifecycle event object.
   *
   * @param object The object this event is associated with.
   * @param id An integer specifying the action that occurred on the event.
   */
  	public ShellLifecycleEvent(int id)
	{
      super(dummy);
      m_id = id;
	}

  /**
   * Returns the action performed.
   *
   * @return An integer representing the action performed.
   */
	public int getID()
	{
		return m_id;
   }
   
   public String toString()
   {
      switch (getID())
      {
      case ShellLifecycleEvent.BEGIN_SNAPIN_REGISTRATION:
         return("BEGIN_SNAPIN_REGISTRATION");
         
      case ShellLifecycleEvent.END_SNAPIN_REGISTRATION:
         return("END_SNAPIN_REGISTRATION");

      case ShellLifecycleEvent.BEGIN_SERVICE_SNAPIN_INIT:
         return("BEGIN_SERVICE_SNAPIN_INIT");

      case ShellLifecycleEvent.END_SERVICE_SNAPIN_INIT:
         return("END_SERVICE_SNAPIN_INIT");

      case ShellLifecycleEvent.BEGIN_NAMESPACE_SNAPIN_INIT:
         return("BEGIN_NAMESPACE_SNAPIN_INIT");

      case ShellLifecycleEvent.END_NAMESPACE_SNAPIN_INIT:
         return("END_NAMESPACE_SNAPIN_INIT");

      case ShellLifecycleEvent.BEGIN_SNAPIN_SHUTDOWN:
         return("BEGIN_SNAPIN_SHUTDOWN");

      case ShellLifecycleEvent.END_SNAPIN_SHUTDOWN:
         return("END_SNAPIN_SHUTDOWN");

      case ShellLifecycleEvent.BEGIN_SHELL_CONSTRUCTION:
         return("BEGIN_SHELL_CONSTRUCTION");

      case ShellLifecycleEvent.END_SHELL_CONSTRUCTION:
         return("END_SHELL_CONSTRUCTION");
         
      case ShellLifecycleEvent.BEGIN_CONSOLEONE_STARTUP:
         return("BEGIN_CONSOLEONE_STARTUP");
  
      case ShellLifecycleEvent.END_CONSOLEONE_STARTUP:
         return("END_CONSOLEONE_STARTUP");

      case ShellLifecycleEvent.BEGIN_CONSOLEONE_SHUTDOWN:
         return("BEGIN_CONSOLEONE_SHUTDOWN");
  
      case ShellLifecycleEvent.END_CONSOLEONE_SHUTDOWN:
         return("END_CONSOLEONE_SHUTDOWN");

      case ShellLifecycleEvent.ABORT_CONSOLEONE_SHUTDOWN:
         return("ABORT_CONSOLEONE_SHUTDOWN");
         
      default:
         return("UNKNOWN");
      }
   }
   
}

/*
$Log: ShellLifecycleEvent.java,v $
Revision 1.1.1.1  2001/05/09 12:43:26  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.4  1999/12/02 23:11:40  DChamberlain
Added abort shutdown.
Revision 1.3  1999/05/24 23:09:04  mharris
SPD 230672 (BQ73770)  Implemented ShellLifecycleEvents to provide various lifecycle events (including snapin shutdown)
Revision 1.2  1999/05/19 21:03:14  mharris
Added additional event IDs
Revision 1.1  1999/05/19 20:24:57  mharris
Initial revision

*/
