/*
   $RCSfile: ViewSnapin.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:26 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1989-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
   AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO THIS WORK IS
   RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A NEED TO KNOW HOW
   TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS AND (II)
   ENTITIES OTHER THAN NOVELL, INC. WHO HAVE ENTERED INTO APPROPRIATE
   LICENSE AGREEMENTS. NO PART OF THIS WORK MAY BE USED, PRACTICED,
   PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
   CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, TRANSFORMED
   OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE
   OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
   PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
*/

package com.novell.application.console.snapin;

import java.awt.*;
import java.awt.event.*;
import com.novell.application.console.snapin.context.*;
/**
 * Provides view snap-ins for the ConsoleOne shell.
 *
 * <p>Snap-ins must implement this interface to provide views for
 * the associated ObjectType. New view snapins should implement 
 * ViewSnapinRev2 as well.
 * 
 * @see ViewSnapinRev2
 * @version 0.1 19 May 1997
 */

public interface ViewSnapin extends Snapin
{
  /**
   * Returns the object derived from Component that will be used
   * as the view in the shell.
   *
   * <p>The Component object returned is associated with the ObjectEntry
   * in the view context passed to the snap-in in the context parameter.
   * The view snap-in developer should construct the return Component in
   * the initSnapin() method, then in getView() the new tree selection
   * should be cleared so that new data can be put in. That is, all
   * Components in the view should be removed and a new set of Components set.
   * The following code snippet provides an example.
   * <pre>
   * <code>    // Global variables set up in the initSnapin() method</code>
   * <code>    //   p -- The panel where the children will be displayed</code>
   * <code>    //   shell -- A ConsoleOne shell instance</code>
   *
   * <code>    public Component getView(ViewSnapinContext viewContext)</code>
   * <code>    {</code>
   * <code>        // remove any existing components from the pane</code>
   * <code>        p.removeAll();</code>
   *
   * <code>        // get enumeration of the selected ObjectEntry's children</code>
   * <code>        ObjectEntryEnumeration children = shell.getChildren(viewContext.getObjectEntry());</code>
   *
   * <code>        // for each child, add it to the pane and set up a mouse listener</code>
   * <code>        while(children.hasMoreElements())</code>
   * <code>        {</code>
   * <code>            ObjectEntry child = children.next();</code>
   * <code>            MyLabel node = new MyLabel(child);</code>
   * <code>            node.addMouseListener(new MyMouseListener());</code>
   * <code>            p.add(node);</code>
   * <code>        };</code>
   *
   * <code>        // return the reformatted pane</code>
   * <code>        return p;</code>
   * <code>    }</code>
   * </pre>
   *
   * @param context The context information passed to the snap-in.
   *
   * @return The Component to be shown in the shell as a view.
   *
   * @see com.novell.application.console.snapin.context.ViewSnapinContext
   */
   public Component getView(ViewSnapinContext context);

  /** Returns the unique name of the view.
   *
   * <p>In a view snap-in the getUniqueID() method is called before the
   * initSnapin() method. Also, if a view is changed by ConsoleOne, the
   * getViewMenuName() method is called before the initSnapin() method.
   * Following is an implementation example.
   * <pre>
   * <code>    public String getUniqueID()</code>
   * <code>    {</code>
   * <code>        return "com.novell.sample.snapins.filesystem.FilesystemListView";</code>
   * <code>    }</code>
   * </pre>
   * @return The unique, non-localized name of the view.
   *
   */
   public String getUniqueID();

  /**
   * Provides a shell notification that the current view has become inactive.
   *
   * <p>An example implementation of setInactive() is as follows.
   * <pre>
   * <code>    public void setInactive(Component c){};</code>
   * </pre>
   *
   * @param c The instance of the view passed by the shell.
   *
   */
   public void setInactive(Component c);

   //REMIND: John, review mnemonic stuff.
  /**
   * Returns the localized name for the view.
   *
   * <p>The getViewMenuName() method returns the language-dependent translated
   * (localized) name that will be used as the text in the view menu.  Use 
   * the ampersand '&' character to specify a mnemonic character.
   * Following is an implementation example.  
   * <pre>
   * <code>    public String getViewMenuName()</code>
   * <code>    {</code>
   * <code>        return "S&ample Filesystem List View";</code>
   * <code>    };</code>
   * </pre>
   * @return The localized name for the view.
   */
   public String getViewMenuName();
}

/*

$Log: ViewSnapin.java,v $
Revision 1.1.1.1  2001/05/09 12:43:26  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.39  2000/01/25 21:51:21  DChamberlain
Cleaned up some javadoc.
Revision 1.38  1999/05/11 21:08:20  DChamberlain
Removed refresh() since it went to ViewSnapinRev13.
Revision 1.37  1999/05/06 21:08:19  DChamberlain
Removed isBusy(), it was not used.
Revision 1.36  1999/03/02 18:08:54  SJENSEN
Updated to the new ViewSnapin interfaces. For refresh and stoppable.
Added refresh() and isBusy().
Revision 1.35  1999/02/08 20:13:14  SJENSEN
Removed getSelectedObjects(). It is now part of MutableSelectionSet.
Revision 1.34  1999/01/08 15:32:49  DChamberlain
Updated copyright to include 1999.
Revision 1.33  1999/01/07 19:28:22  DChamberlain
Updated copyright to include 1999.
Revision 1.32  1998/12/21 18:42:55  JWilliams
Reviewed getviewmenuname mnemonic doc.
Revision 1.31  1998/12/18 01:04:38  DChamberlain
Cleaned up docs.
Revision 1.30  1998/12/12 00:24:15  DChamberlain
Removed getViewComponent().
Revision 1.29  1998/12/03 16:58:32  DChamberlain
Added getViewComponent().
Revision 1.28  1998/11/11 18:36:43  DChamberlain
Documented mnemonic.
Revision 1.27  1998/05/18 21:47:20  SHerrin
Corrected Javadoc comments for getUniqueID().
Revision 1.25  1998/05/05 22:09:32  SHerrin
Corrected spelling in Javadoc, and added code snippet from Mike Harris to getView().
Revision 1.24  1998/04/07 16:34:29  SHerrin
Corrected Javadoc comment for setInactive().
Revision 1.23  1998/04/07 03:25:12  SHerrin
Corrected Javadoc comments.
Revision 1.22  1998/04/04 22:55:57  SHerrin
Corrected some Javadoc comments.
Revision 1.21  1998/03/23 22:19:30  SHerrin
Corrected Javadoc comments.
Revision 1.20  1998/03/20 00:24:24  Paul_MacKay
Since we are not doing printing in this release and because it is already 
a part of AWT/JFC Component it is redundant.
Revision 1.19  1998/03/18 23:49:45  DChamberlain
Took out ASN1 id in comments.
Revision 1.18  1998/03/13 21:20:47  ksondere
Revision 1.17  1998/03/13 17:12:19  ksondere
Added ViewContext parameter to getView.
Revision 1.16  1998/03/13 00:11:55  ksondere
Changed getView call to pass a ViewContext.
Revision 1.15  1998/03/10 21:05:11  ksondere
Removed getMenuLoc call.
Revision 1.14  1998/03/09 22:08:41  ksondere
Added getViewMenuName, getViewMenuLoc, and modified setInactive method.
Revision 1.13  1998/02/12 18:04:18  ksondere
Added setInactive call to the interface necessary to let the view do clean-up work.
Revision 1.12  1998/01/27 18:51:18  SHerrin
Edited Javadoc comments.
Revision 1.11  1998/01/12 18:35:44  DChamberlain
Moved from ncc package to console.
Revision 1.10  1997/12/04 19:44:11  SHerrin
Made changes in Javadoc comments following technical review.
Revision 1.9  1997/11/18 23:13:12  jeThatcher
Fixed minor doc problem on getSelectedObjects.
Revision 1.8  1997/11/07 16:32:46  DChamberlain
Massive package name changes.
Revision 1.7  1997/10/16 16:10:10  SHerrin
Made changes in Javadoc comments following technical review.
Revision 1.6  1997/09/26 21:57:53  SHerrin
Made Javadoc editorial corrections.
Revision 1.5  1997/09/25 21:12:52  DChamberlain
Method name changes in NamespaceSnapin, ObjectType, ToolbarSnapin, StatusbarSnapin and ViewSnapin to bring closer to beans model.
Revision 1.4  1997/09/18 22:50:42  DChamberlain
Uppercase COM to lowercase com for novell packages.
Revision 1.3  1997/09/18 04:02:33  jeThatcher
Changed getName to getIDString.
Revision 1.2  1997/09/04 15:14:42  jeThatcher
Changed superinterface to Snapin, added getName, removed getMenuItems.
Revision 1.1  1997/08/29 00:32:32  DChamberlain
Initial revision
Revision 1.1  1997/08/28 23:45:20  DChamberlain
Initial revision
Revision 2.1  1997/08/12 20:20:48  DChamberlain
Added getMenuItems() to get a view menu.
Revision 2.0  1997/07/28 18:20:50  DChamberlain
Revision 1.4  1997/07/28 18:20:50  DChamberlain
Added snapin and console to package name.
Revision 1.3  1997/06/26 15:55:46  DChamberlain
Added MKS keywords and copyright.

*/
