/*
   $RCSfile: PageSnapinContext.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:26 $

   $ProjectName: V:/PROJECT/houston/context.pj $
   $ProjectRevision: 1.169 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
   CIVIL LIABILITY.
*/

package com.novell.application.console.snapin.context;

import com.novell.application.console.snapin.*;
import java.awt.Window;

/**
 * Contains an ObjectEntryCollection from one or more namespaces, and a
 * reference to a PropertyBook.
 *
 * <p>The ObjectEntryCollection may represent objects selected by the user
 * from a Browser or View window when a PropertyBook was invoked, or it
 * may have been generated programmatically by another snap-in.</p>
 *
 * <p>A PageSnapinContext object is used by a PageSnapin to determine
 * which ObjectEntries are to have their properties edited. This object
 * is passed to the PageSnapin on initialization through the InitSnapinInfo
 * parameter to the initSnapin() method. The PageSnapinContext can be
 * retrieved from the InitSnapinInfo parameter with a  call to the
 * getSnapinContext() method.</p>
 *
 * <p>The PropertyBook manages a set of registered PageSnapins, which
 * control property values for the specified ObjectEntries.</p>
 *
 * @see SnapinContext
 * @see PageSnapin
 * @see PropertyBook
 */

public class PageSnapinContext extends SnapinContext
{
   /**
   * @internal
   */
   protected ObjectEntryCollection    theObjectCollection=null;

   /**
   * @internal
   */
   protected PropertyBook     thePropertyBook=null;
	
   /**
   * @internal
   */
	protected Window parentWindow = null;

   /**
   * @internal
   */
   public PageSnapinContext( PropertyBook thePB, ObjectEntryCollection theObjectCollection,
									  Window parentWindow )
   {
      this.thePropertyBook = thePB;
      this.theObjectCollection = theObjectCollection;
      this.parentWindow = parentWindow;		
   }

   /**
   * @internal
   */
   public PageSnapinContext( PropertyBook thePB, ObjectEntryCollection theObjectCollection )
   {
      this.thePropertyBook = thePB;
      this.theObjectCollection = theObjectCollection;
   }

   /**
   * @internal
   */
   public void setPropertyBook( PropertyBook thePB )
   {
      this.thePropertyBook = thePB;
   }

  /**
   * Retrieves the reference to the PropertyBook from the context.
   *
   * <p>Using this reference, the set of registered PageSnapin(s) can tell
   * the PropertyBook when attribute values have changed so the appropriate
   * PropertyBook buttons (OK, CANCEL, APPLY, CLOSE) can be enabled or disabled.
   *
   * @return The PropertyBook, associated with the PageSnapinContext, in which
   *         the property pages will be displayed.
   *
   */
   public PropertyBook getPropertyBook()
   {
      return thePropertyBook;
   }

  /**
   * Retrieves the ObjectEntryCollection from the context.  This collection
   * provides enumerations of ObjectEntrys associated with the page snapin.
   *
   * @return The ObjectEntryCollection associated with the PageSnapinContext.
   *
   */
   public ObjectEntryCollection getObjectCollection()
   {
      return theObjectCollection;
   }

   /**
   * Retrieves the parent window on which the gui component will be placed from the context.
   *
   * @return The parent window associated with the PageSnapinContext.
   *
   */
   public Window getParentWindow()
   {
       return(parentWindow);
   }
}

/*
$Log: PageSnapinContext.java,v $
Revision 1.1.1.1  2001/05/09 12:43:26  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.22  2000/03/07 18:21:51  dwilson
Restore original constructor for ZEN stuff
Revision 1.21  2000/03/06 22:07:58Z  dwilson
Added Window parameter to constructor
Revision 1.20  1999/01/14 22:40:06Z  SJENSEN
Removed all deprecated methods. (The ones that do not support
ObjectEntryCollections.)
Revision 1.19  1999/01/09 00:21:22  dwilson
Took out deprecated constructor
Revision 1.18  1999/01/08 23:30:16  SJENSEN
Set up the old ObjectEntry[] for now in the constructor that takes
ObjectEntryCollection.
Revision 1.17  1999/01/07 19:22:00  DChamberlain
Updated copyright to include 1999.
Revision 1.16  1999/01/04 19:08:06  SJENSEN
Added @@deprecated javadoc comments.
Revision 1.15  1998/12/24 17:56:16  SJENSEN
Added ObjectEntryCollections.
Revision 1.14  1998/10/14 22:38:43  dwilson
Took out getPages() method and moved it to the PropertyBook interface
Revision 1.13  1998/09/15 18:13:28  dwilson
Added support for getPageSnapins().
Revision 1.12  1998/06/08 19:35:59  SHerrin
Corrected Javadoc comments.
Revision 1.11  1998/05/12 22:38:47  SHerrin
Added information from Mike Harris to Javadoc comments.
Revision 1.10  1998/04/07 17:22:15  DChamberlain
Cleaned up docs.
Revision 1.9  1998/04/06 17:55:39  SHerrin
Added Javadoc comments.
Revision 1.8  1998/04/01 17:35:17  SHerrin
Edited Javadoc comments.
Revision 1.7  1998/03/19 21:58:39  dwilson
Fix a bug
Revision 1.6  1998/03/19 19:06:36  dwilson
Added get and setPropertyBook
Revision 1.5  1998/03/16 22:09:04  Paul_MacKay
Copyright and version cleanup. SPD # 175930, 175929
Revision 1.4  1998/03/13 01:04:59  DChamberlain
Clean up for compile.
Revision 1.3  1998/03/12 23:42:49  DChamberlain
Clean up.
*/
