/*
   $RCSfile: NamespaceScope.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:27 $

   $ProjectName: V:/PROJECT/houston/scopes.pj $
   $ProjectRevision: 1.164 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
   CIVIL LIABILITY.
*/
package com.novell.application.console.snapin.scope;

//REMIND: Remember to comment out these lines when building non-checked version in all scopes.
import com.novell.application.console.shell.*;
import com.novell.application.console.snapin.*;

/**
 * Defines a scope that is restricted to the namespace specified at
 * registration.
 *
 * <p>Snap-ins of all types except Namespace and Service
 * snap-ins may be registered with the NamespaceScope scope. When registered,
 * the functionality provided by these snap-ins becomes active when the
 * namespace specified at registration is selected (activated) by the user.
 * </p>
 * <p>The following code snippet is an example of registering a view snap-in
 * with to specified namespace with the NamespaceScope scope.
 * <pre><code>
 *      public RegistrationItem[] getRegistration()
 *      {
 *          NamespaceScope scope;
 *          scope = new NamespaceScope(Shell.SNAPIN_VIEW, "Namespace UniqueID");
 *          return new RegistrationItem[]
 *          {
 *              new RegistrationItem(scope, getClass().getName())
 *          };
 *      }
 * </code></pre>
 *
 * @see Scope
 */
public class NamespaceScope implements Scope
{
   private static final String SCOPE_KEY = Constants.NamespaceScopeKey;
   private String namespace;
   private Object snapinType;
   private String key;

   /**
   * Returns the snap-in type object that was passed in the constructor.
   *
   * @return The snap-in type object.
   *
   * @see Scope
   */
   public Object getSnapinType()
   {
      return snapinType;
   }

  /**
   * Builds a NamespaceScope for the specified snapinType, but restricted
   * to the namespace specified at registration.
   *
   * <p>The snap-in types that can be used for the NamespaceScope scope
   * include all snap-in types except Namespace and Service,
   * which are:
   * <ul>
   * <li>Shell.SNAPIN_DISPLAYICON
   * <li>Shell.SNAPIN_DISPLAYNAME
   * <li>Shell.SNAPIN_DYNAMIC
   * <li>Shell.SNAPIN_MAP_OBJECTENTRY
   * <li>Shell.SNAPIN_MENU
   * <li>Shell.SNAPIN_PAGE
   * <li>Shell.SNAPIN_POPUP_MENU
   * <li>Shell.SNAPIN_RESULTMODIFIER
   * <li>Shell.SNAPIN_STATUSBARITEM
   * <li>Shell.SNAPIN_TOOLBARITEM
   * <li>Shell.SNAPIN_VIEW
   * </ul>
   *
   * @param snapinType The type of the snap-in as defined above.
   * @param namespace  The uniqueID string for which the namespace applies.
   */
   public NamespaceScope( Object snapinType, String namespace )
   {
      Debug.n_assert(
               snapinType != Shell.SNAPIN_SERVICE,
               "Cannot use given snapin type with this scope.");
      this.snapinType = snapinType;
      this.namespace = namespace;
      key = namespace + SCOPE_KEY;
   }

   /**
   * @internal
   * Returns the scopeKey string for this registration point.
   *
   * <p>The getScopeKey() method is called by the RegistrationItem class.
   *
   * @return The scopeKey string.
   */
   public String getScopeKey()
   {
      return key;
   }

   /**
   * @internal
   * Returns the scope description string for this registration point.
   *
   * <p>The getScopeDescription() method is called by the ConsoleOne Configurator.
   *
   * @return The scope description string.
   */
   public String getScopeDescription()
   {
      return namespace;
   }

   /**
   * Returns the namespace unique ID for this scope instance.
   *
   * @return The unique ID of the specified namespace.
   */
   public String getNamespaceUniqueID()
   {
      return namespace;
   }
}

/*
$Log: NamespaceScope.java,v $
Revision 1.1.1.1  2001/05/09 12:43:27  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.29  1999/06/02 17:01:17  DChamberlain
Allow namespaces to be registered to this scope.
Revision 1.28  1999/05/05 15:03:56  arlandes
Update to remove persistence snap in constants, update javadoc.
Revision 1.27  1999/04/01 21:53:37  DChamberlain
Use Debug instead of D.
Revision 1.26  1999/01/07 19:26:51  DChamberlain
Updated copyright to include 1999.
Revision 1.25  1998/12/15 21:40:41  mharris
Revised javadoc comments to refect Snapin types allowed with scope.
Revision 1.24  1998/10/26 17:02:57  DChamberlain
Fixed asserts to exclude 3rd party snapin types.
Revision 1.23  1998/10/21 20:20:57  dwilson
Commented out the assert
Revision 1.22  1998/10/08 19:27:25  ksondere
Removed references to ExtendChildrenSnapin.
Revision 1.21  1998/09/25 15:12:00  DChamberlain
Cache key for optimization, found during optimizing that it took too
long to compute everytime getScopeKey() is called.
Revision 1.20  1998/06/05 19:59:39  DChamberlain
Added SNAPIN_DYNAMIC to all asserts, removed assert from GlobalScope.
Revision 1.19  1998/06/04 22:20:08  SHerrin
Corrected and enhanced Javadoc comments.
Revision 1.18  1998/05/27 20:10:04  SHerrin
Flagged Map ObjectEntry snap-in type as not yet available.
Revision 1.17  1998/05/27 19:51:06  SHerrin
Added  Shell.SNAPIN_MAP_OBJECTENTRY to Javadoc comments.
Revision 1.16  1998/05/21 17:18:32  DChamberlain
Added map object entry snapin to scope.
Revision 1.15  1998/05/12 16:32:04  SHerrin
Corrected code snippet in Javadoc comments.
Revision 1.14  1998/05/12 15:41:18  SHerrin
Corrected code snippet in Javadoc comments.
Revision 1.13  1998/05/11 20:03:53  SHerrin
Added code snippet to Javadoc comments.
Revision 1.12  1998/05/11 20:03:28  SHerrin
Revision 1.11  1998/04/27 16:40:36  DChamberlain
Moved non-translated strings out of resource bundle.  (SPD# 188198)
Revision 1.10  1998/04/08 16:54:42  DChamberlain
Added accessor methods.
Revision 1.9  1998/04/07 16:12:13  DChamberlain
Marked internal methods for javadoc.
Revision 1.8  1998/03/26 16:19:44  SHerrin
Corrections to Javadoc comments.
Revision 1.7  1998/03/20 16:06:11  DChamberlain
Use shorter scope keys defined in resources.
Revision 1.6  1998/03/11 21:10:51  DChamberlain
Use icons instead of images.
Revision 1.5  1998/03/07 02:56:40  DChamberlain
Removed name map snapin.
Revision 1.4  1998/03/05 23:49:36  dwilson
Added getScopeDescription()
Revision 1.3  1998/03/05 03:49:02  SHerrin
Added Javadoc comments.
Revision 1.2  1998/02/24 01:36:52  DChamberlain
import snapin.
Revision 1.1  1998/02/24 01:04:42  DChamberlain
Initial revision
Revision 1.4  1998/02/23 17:42:01  DChamberlain
New registration.
Revision 1.3  1998/02/17 17:20:46  dwilson
Revision 1.2  1998/02/17 17:05:41  dwilson
Revision 1.1  1998/02/16 22:24:49  DChamberlain
Initial revision
*/
