/*
   $RCSfile: Loc.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:30 $

   $ProjectName: V:/PROJECT/houston/localization.pj $
   $ProjectRevision: 1.141 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
   CIVIL LIABILITY.
*/
package com.novell.utility.localization;

import java.awt.*;
import javax.swing.*;
import javax.swing.text.*;

public class Loc
{
   /**
    * Returns the string with the hot char key '&' removed.
    */
   public static String removeHotChar(String str)
   {
      if (str == null)
      {
         return "";
      }

      int pos = str.indexOf("&");

      String newStr = null;

      // Is there a mnemonic?
      if (pos == -1)
      {
         // No. Just return the string;
         newStr = str;
      }
      else if (pos == 0)
      {
         // Yes. It's at the beginning; chop it off.
         newStr = str.substring(1, str.length());
      }
      else
      {
         // Yes. It's in the middle; splice it out.
         String firstPart = str.substring(0, pos);
         String secondPart = str.substring(pos+1, str.length());
         newStr = firstPart + secondPart;
      }

      return newStr;
   }
   
   /**
    * Returns the hot char specified in the string using the '&' character.
    * If there is not hot char, -1 is returned.
    */
   public static char getHotChar(String str)
   {
      if (str == null)
      {
         return (char)-1;
      }

      int pos = str.indexOf("&");
      char ret = (char)-1;  // No mnemonic

      // Is there a mnemonic?
      if (pos > -1)
      {
         // Yes.
         if (str.length()-1 > pos)
         {
            ret = str.charAt(pos+1);
         }
      }

      return ret;
   }
   
/*
   public static void setHotChar(AbstractButton button, String str)
   {
      if (str == null)
      {
         return;
      }

      int pos = str.indexOf("&");

      // Is there a mnemonic?
      if (pos > -1)
      {
         // Yes.
         if (str.length() - 1 > pos)
         {
            char c = str.charAt(pos+1);
            //REMIND: Any error checking on char before setting?
            button.setMnemonic(c);
         }
      }
   }
*/
   
   /**
    * Sets the text and mnemonic for an AbstractButton using the passed in string.
    * Use the '&' char to specify the mnemonic.  Note that this
    * works with AbstractButtons, JButtons, JMenuItems, JCheckBoxMenuItems, JMenus,
    * JRadioButtonMenuItems, JToggleButtons, JCheckBoxes and JRadioButtons since they
    * all are derived from AbstractButton.
    */
   public static void setText(AbstractButton item, String str)
   {
      if(str == null)
      {
         return;
      }
      
      int pos = str.indexOf("&");

      // Is there a mnemonic?
      if (pos > -1)
      {
         // Yes.
         String newStr = null;
   
         if (pos == 0)
         {
            // Yes. It's at the beginning; chop it off.
            newStr = str.substring(1, str.length());
         }
         else
         {
            // Yes. It's in the middle; splice it out.
            String firstPart = str.substring(0, pos);
            String secondPart = str.substring(pos+1, str.length());
            newStr = firstPart + secondPart;
         }
         
         item.setText(newStr);
         
         if (str.length() - 1 > pos)
         {
            char c = str.charAt(pos+1);
            //REMIND: Any error checking on char before setting?
            item.setMnemonic(c);
         }
      }
      else
      {
         item.setText(str);
      }
   }

   /**
    * Sets the text and mnemonic for a label and sets the component to receive focus
    * when the mnemonic for the label is pressed.
    */
   public static void setText(JLabel label, Component comp, String str)
   {
      if(str == null)
      {
         return;
      }
      
      // Make sure that if comp is a JScrollPane that we set the accelerator to its child and
      // not the actual JScrollPane!
      if (comp instanceof JScrollPane)
      {
         comp = ((JScrollPane)comp).getViewport().getView();
      }
      
      int pos = str.indexOf("&");

      label.setLabelFor(comp);
      
      // Is there a mnemonic?
      if (pos > -1)
      {
         // Yes.
         String newStr = null;
   
         if (pos == 0)
         {
            // Yes. It's at the beginning; chop it off.
            newStr = str.substring(1, str.length());
         }
         else
         {
            // Yes. It's in the middle; splice it out.
            String firstPart = str.substring(0, pos);
            String secondPart = str.substring(pos+1, str.length());
            newStr = firstPart + secondPart;
         }
         
         label.setText(newStr);
         
         if (str.length() - 1 > pos)
         {
            char c = str.charAt(pos+1);
            //REMIND: Any error checking on char before setting?
            label.setDisplayedMnemonic(c);
         }
      }
      else
      {
         label.setText(str);
      }
   }

   /**
    * Sets the focus accelerator for a text component from the mnemonic specified
    * in a string.  The string is only used to get the mnemonic char from.
    */
   public static void setText(JTextComponent textComponent, String str)
   {
      if(str == null)
      {
         return;
      }
      
      int pos = str.indexOf("&");

      // Is there a mnemonic?
      if (pos > -1)
      {
         if (str.length() - 1 > pos)
         {
            char c = str.charAt(pos+1);
            //REMIND: Any error checking on char before setting?
            textComponent.setFocusAccelerator(c);
         }
      }
   }
}

/*
$Log: Loc.java,v $
Revision 1.1.1.1  2001/05/09 12:43:30  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.7  1999/06/02 17:40:04  kmuir
Made sure that if a JScrollPane is passed, then the actual view
in the scrollPane gets the focus with the accelerators.
Revision 1.6  1999/01/07 19:29:31  DChamberlain
Updated copyright to include 1999.
Revision 1.5  1998/11/30 18:36:20  DChamberlain
Added methods to set mnemics for labels and text components.
Revision 1.4  1998/10/29 23:31:33  DChamberlain
Changed setHotCharAndText to setText.
Revision 1.3  1998/10/29 16:17:28  DChamberlain
Fixed bug in setting button text.
Revision 1.2  1998/10/23 15:37:00  DChamberlain
Added new methods to make simpler, cleaned up.
*/