/*
   $RCSfile: NMsgBox.java,v $
	$Revision: 1.11 $ $Name:  $
	$Date: 2001/06/03 14:48:01 $ 

	$ProjectName: V:/PROJECT/houston/nmsgbox.pj $
	$ProjectRevision: 1.173 $

	For revision information, see the history log at the end of this file.

	Copyright (c) 1998-1999 Novell, Inc.  All Rights Reserved.

	THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
	PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
	THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
	NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
	ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
	ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
	MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
	MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
	COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
	WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
	WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
	CIVIL LIABILITY.
*/
package com.novell.utility.nmsgbox;

// Sun
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.awt.image.*;
import java.net.URL;
import javax.swing.*;
import com.novell.utility.localization.*;

// Novell
import com.novell.application.console.shell.*;
import com.novell.application.console.widgets.*;

import com.novell.application.console.snapin.*; //ADDED BY VINOD V FOR ACCESSIBILITY

/**
 * Provides a common message box for displaying messages.
 *
 * <p>This message box consists of the following four types:
 * <ul>
 * <li>Confirmation</li>
 * <li>Information</li>
 * <li>Warnings</li>
 * <li>Error</li>
 * </ul>
 */
public class NMsgBox extends NDialog
   implements ActionListener, KeyListener, ImageObserver,
   com.novell.application.console.testing.C1Automation
{
   //************************************************************************
   // Class Static Definitions
   //************************************************************************
   
   private static ResourceBundle res = null;
   static
   {
      try
      {
         res = ResourceBundle.getBundle(getBundleName());
      }
      catch(Exception e)
      {
         // Silently ignore.
      }
   }

   /**
    * @internal
    */
   public static String getBundleName()
   {
      return "com.novell.utility.nmsgbox.resources.NMsgBoxResourceBundle";
   }

   /**
    * @internal
    */
   public static void setBundle(ResourceBundle resourceBundle)
   {
      NMsgBox.res = resourceBundle;
   }

   
   //************************************************************************
   // Public Definitions
   //************************************************************************
   /**
    * Confirmation message box type.
    *
    * <p>(CONFIRM = 0)</p>
    */
   public static final int CONFIRM = 0;

   /**
    * Information message box type.
    *
    * <p>(INFO = 1)</p>
    */
   public static final int INFO = 1;

   /**
    * Warning message box type.
    *
    * <p>(WARN = 2)</p>
    */
   public static final int WARN = 2;

   /**
    * Error message box type.
    *
    * <p>(ERROR = 3)</p>
    */
   public static final int ERROR = 3;

   /**
    * Warning all message box type.
    *
    * <p>(WARN_ALL = 4)</p>
    */
   public static final int WARN_ALL = 4;

   /**
    * Warning message box type with cancel.
    *
    * <p>(WARN_WITH_CANCEL = 5)</p>
    */
   public static final int WARN_WITH_CANCEL = 5;

   /**
    * Warning all message box type with cancel.
    *
    * <p>(WARN_ALL_WITH_CANCEL = 6)</p>
    */
   public static final int WARN_ALL_WITH_CANCEL = 6;

   /**
    * Warn with prompt option and cancel.
    *
    * <p>(WARN_PROMPT_WITH_CANCEL = 7)</p>
    */
   public static final int WARN_PROMPT_WITH_CANCEL = 7;

   /**
    * Error allowing the user to ignore, ignore all, or cancel.
    *
    * <p>(ERROR_IGNORE = 8)</p>
    */
   public static final int ERROR_IGNORE = 8;


   /**
    * [OK] button identifier.
    *
    * <p>(OK = 0x0001)</p>
    */
   public final static int OK = 0x0001;

   /**
    * [Cancel] button identifier.
    *
    * <p>(CANCEL = 0x0002)</p>
    */
   public final static int CANCEL = 0x0002;

   /**
    * [Close] button identifier.
    *
    * <p>(CLOSE = 0x0004)</p>
    */
   public final static int CLOSE = 0x0004;

   /**
    * [Yes] button identifier.
    *
    * <p>(YES = 0x0008)</p>
    */
   public final static int YES = 0x0008;

   /**
    * [No] button identifier.
    *
    * <p>(NO = 0x0010)</p>
    */
   public final static int NO = 0x0010;

   /**
    * [Details] button identifier.
    *
    * <p>(DETAILS = 0x00020)</p>
    */
   public final static int DETAILS = 0x0020;

   /**
    * [Yes All] button identifier.
    *
    * <p>(YES_ALL = 0x0040)</p>
    */
   public final static int YES_ALL = 0x0040;

   /**
    * [No All] button identifier.
    *
    * <p>(NO_ALL = 0x0080)</p>
    */
   public final static int NO_ALL = 0x0080;

   /**
    * [Prompt] button identifier.
    *
    * <p>(PROMPT = 0x0100)</p>
    */
   public final static int PROMPT = 0x0100;

   /**
    * [IGNORE] button identifier.
    *
    * <p>(IGNORE = 0x0102</p>
    */
   public final static int IGNORE = 0x0200;

   /**
    * [IGNORE_ALL] button identifier.
    *
    * <p>(IGNORE_ALL = 0x0104</p>
    */
   public final static int IGNORE_ALL = 0x0400;

   
   
   //************************************************************************
   // Private Data
   //************************************************************************
   private static final String errorImageKey     = "ErrorAnim.gif";
   private static final String warnImageKey      = "WarnAnim.gif";
   private static final String warnAllImageKey   = "WarnAnim.gif";
   private static final String infoImageKey      = "InfoAnim.gif";
   private static final String confirmImageKey   = "ConfirmAnim.gif";
   private static final String imageLocationKey  = "/com/novell/utility/nmsgbox/images/";

   
   //************************************************************************
   // Private Variables
   //************************************************************************
   private Frame        parentFrame;
   private String       helpSetName;
   private String       helpID;
   private String       msg;
   private JButton      okButton;
   private JButton      cancelButton;
   private JButton      closeButton;
   private JButton      yesButton;
   private JButton      noButton;
   private JButton      yesAllButton;
   private JButton      noAllButton;
   private JButton      detailsButton;
   private JButton      ignoreButton;
   private JButton      ignoreAllButton;
   private JButton      promptButton;
   private JButton      defaultButton = null;
   	//******************Cygsoft modification starts*********************
	// Company 			: Cygsoft Inc.
	// Author			: <Deepak Surwade>
	// Peer Reviewer	: <>
	// Code change date	: <May 27, 2001>
	// Comments			: stores the current button instance (To make accessible)
	//********************************************************************
	private JButton      currentButton = null;
	//******************Cygsoft modification ends*********************
   private JPanel       buttonsPanel;
   private Image        image;
   private JLabel       imageLabel = new JLabel("@");
   private boolean      requestedFocus = false;
   private boolean      internalSetVisibleCachedState;
   private int          setupCachedType;

   // If the user closes the dialog any other way than the buttons (ie. the
   // "x" in the upper right-hand corner of the frame) then the value the
   // default will return its default, which is CANCEL.
   private int          pressedButton = CANCEL;


   // TESTING HOOKS
   private String sTitle;
   // END TESTING HOOKS
   
   
   //************************************************************************
   // Constructors
   //************************************************************************
   /**
    * Creates a pre-defined modal message box with help system support.
    *
    * @param  parent        The parent Component.
    * @param  title         The title to be put in the title bar.
    * @param  msg           The message to be displayed in the message area.
    * @param  type          The type of the pre-built message box.
    * @param  helpSetName   The help set file name (pass in 'null' for no help).
    * @param  helpID 	   The help set ID.
    */
   public NMsgBox(Component parent, String title, String msg, int type,
                  String helpSetName, String helpID)
   {
      super(parent, title, true);
      this.helpSetName = helpSetName;
      this.helpID = helpID;
      setup(parent, title, msg, type);
   }

   /**
    * Creates a pre-defined modal message box with help system support.
    *
    * @param  parent The parent component.
    * @param  title  The title to be put in the title bar.
    * @param  msg    The message to be displayed in the message area.
    * @param  type   The type of the pre-built message box.
    * @param  helpSetName   The help set file name (pass in 'null' for no help).
    */
   public NMsgBox(Component parent, String title, String msg, int type, String helpSetName)
   {
      super(parent, title, true);
      this.helpSetName = helpSetName;
      this.helpID = null;
      setup(parent, title, msg, type);
   }

   /**
    * Creates a pre-defined modal message box without help system support.
    *
    * @param  parent The parent component.
    * @param  title  The title to be put in the title bar.
    * @param  msg    The message to be displayed in the message area.
    * @param  type   The type of the pre-built message box.
    */
   public NMsgBox(Component parent, String title, String msg, int type)
   {
      super(parent, title, true);
      this.helpSetName = null;
      this.helpID = null;
      setup(parent, title, msg, type);
   }
   
   
   /**
    * @internal
    * Sets up the dialog
    */
   private void setup(Component parent, String title, String inMsg, int type)
   { 
      // The call to this setup was causing a hang because of threading on JRE 1.3 on Linux
      // Push it to the event dispatch loop and wait for it to finish before returning if needed

      setupCachedType = type; // needed in the internal Runnable

      // remember the parent frame
      if (parent instanceof Frame)
      {
         parentFrame = (Frame)parent;
      }  

      // remember the message to display
      if (inMsg == null)
      {
         inMsg = "";
      }
      msg = inMsg;

      // TESTING HOOKS 
      com.novell.application.console.testing.C1Hooks.registerWindow( this );
      this.setName( "NMsgBox" );
      
      this.sTitle = title;
      // END TESTING HOOKS

	   Runnable doTheSetup = new Runnable() 
	   {
         public void run() 
         {

            // Build up the panels
            Container contentPane = getContentPane();
            contentPane.setLayout(new BorderLayout());
      
            NWrapLabel lab = new NWrapLabel(msg, false);
            contentPane.add(BorderLayout.CENTER, lab);

            int btnFlags = getButtonFlags(setupCachedType);
            imageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 
                                                                 getInt("MsgBoxSpaceBelowImageKey"),
                                                                 getInt("MsgBoxSpaceBetweenImageAndTextKey")));
            contentPane.add(BorderLayout.WEST, imageLabel);

            contentPane.add(BorderLayout.SOUTH, getButtonPanel(btnFlags));

            // Put an empty border around the content pane
            if (contentPane instanceof JComponent)
            {
               int gap = getInt("MsgBoxInsetGapKey");
               ((JComponent)contentPane).setBorder(BorderFactory.createEmptyBorder(gap, gap, gap, gap));
            }
      
            pack();

            // A bug in the Solaris JVM (Bug Parade # 4100382) causes any non-resizable
            // Dialog to display to size of the entire screen. To get around this bug, set
            // resizable to false after doing the pack. The Dialog will still be resizable,
            // but at least it will be the correct size.
            setResizable(false);
      
//            // TESTING HOOKS 
//            com.novell.application.console.testing.C1Hooks.registerWindow( this );
//            this.setName( "NMsgBox" );
//      
//            this.sTitle = title;
//            // END TESTING HOOKS
         }
      };

      if (SwingUtilities.isEventDispatchThread())
      {
         // we are on the event dispatch thread so it is safe for gui - do it the old way
         doTheSetup.run();
      }
      else
      {
         try
         {
            SwingUtilities.invokeAndWait(doTheSetup);
         }
         catch(Exception e)
         {
            //REMIND: What to really do here?
            D.out("+++NMsgBox: Error -- Couldn't invokeAndWait the setup");
         }
      }
   }


   /**
    * @internal
    * Get the flags for the type of dialog.
    *
    * @param type Type of dialog.
    *
    * @return The button flags.
    */
   private int getButtonFlags(int type)
   {
      int btnFlags = 0;

      switch(type)
      {
      case WARN:
         createImageLabel(this, warnImageKey);
         btnFlags = YES | NO;
         break;

      case WARN_ALL:
         createImageLabel(this, warnAllImageKey);
         btnFlags = YES | YES_ALL| NO | NO_ALL;
         break;

      case WARN_WITH_CANCEL:
         createImageLabel(this, warnImageKey);
         btnFlags = YES | NO | CANCEL;
         break;

      case WARN_ALL_WITH_CANCEL:
         createImageLabel(this, warnAllImageKey);
         btnFlags = YES | YES_ALL | NO | NO_ALL | CANCEL;
         break;

      case WARN_PROMPT_WITH_CANCEL:
         createImageLabel(this, warnAllImageKey);
         btnFlags = YES | NO | PROMPT | CANCEL;
         break;

      case ERROR_IGNORE:
         createImageLabel(this, errorImageKey);
         btnFlags = IGNORE | IGNORE_ALL | CANCEL;
         break;

      case CONFIRM:
         createImageLabel(this, confirmImageKey);
         btnFlags = YES | NO;
         break;

      case ERROR:
         createImageLabel(this, errorImageKey);
         btnFlags = CLOSE;
         break;

      case INFO:
      default:
         createImageLabel(this, infoImageKey);
         btnFlags = OK;
         break;
      }

      if (helpSetName != null)
      {
         btnFlags |= DETAILS;
      }

      return btnFlags;
   }

   
   /**
    * Adds a component to the button panel.
    *
    * @param comp The Component to add to the button panel.
    *
    * @return The Component added to the button panel.
    */
   public Component add(Component comp)
   {
      return buttonsPanel.add(comp);
   }

   
   /* 
   public void setBounds(int x, int y, int width, int height)
   {
   super.setBounds(x, y, width, height);
   Dw.out("NMsgBox.setBounds: size = "+width+","+height); 
   }
   */ 

   
   /**
    * Return the preferred size of the message box dialog.
    *
    * <p>You can override the Dimension returned from getPreferredSize()
    * to make sure your page is shown properly, otherwise the page will be
    * displayed at the default standard size.
    *
    * @return The preferred size as a Dimension type.
    */
   public Dimension getPreferredSize()
   {
      Dimension dim = super.getPreferredSize();
      
      // The rest of this code is used to adjust the preferred size of the
      // dialog if the title is longer than the message.  The width is adjusted wider
      // to accomodate the long title text to insure the title doesn't get truncated.
      FontMetrics titleMetrics = null;
      Font dlgFont = null;
      Font titleFont = null;
      int titleWidth = 0;
      int maxTitleWideChars = getInt("MsgBoxMaxWidestCharsPerTitleKey");
      

      // Calculate the display width of the title string, if not null
      if (getTitle() != null)
      {
         dlgFont      = getFont();
         
         // since we can't get the font used in the titlebar,
         // assume its bold, italic +2pt from the dialog font.
         titleFont    = new Font(dlgFont.getName(),
                                 Font.ITALIC | Font.BOLD,
                                 dlgFont.getSize()+2);

         titleMetrics = getFontMetrics(titleFont);
         titleWidth   = (int) (titleMetrics.stringWidth(getTitle()));

         // Get the maximum allowed title display width
         int titleWidestCharWidth = titleMetrics.stringWidth(getString("WidestCharacterKey"));
         int maxTitleWidth = titleWidestCharWidth*maxTitleWideChars;
         titleWidth = Math.min(maxTitleWidth, titleWidth);
      }
      
      // Get the width of a titleless, contentless dialog
       /**********************************************************
		START OF CODE CHANGE
	
		Company : Cygsoft Inc.
		Author : <Vinod Venugopal>
		Peer Reviewer : <Deepak Surwade>
		Code change date : <12 May 2001>
		Comments : replaced 'null' with 'this' to solve ambiguity errors
		
		**********************************************************/
	     
	    //JDialog tmp = new JDialog(null," ");
	    JDialog tmp = new JDialog(this," ");
	      
	    /**********************************************************
		END OF CODE CHANGE
		**********************************************************/
      tmp.getContentPane().setLayout(new BorderLayout());
      tmp.getContentPane().add(BorderLayout.CENTER, new JLabel(""));
      tmp.setResizable(false);
      tmp.pack();
      
      int tmpWidth = tmp.getPreferredSize().width;
      tmp.dispose();
      
      // see if width of our dialog should be adjusted bigger
      if (titleWidth + tmpWidth > dim.width)
      {
         dim.width = titleWidth + tmpWidth;
      }
      
      //D.out("NMsgBox::getPreferredSize:  preferred size = "+dim);
      return dim;
   }
   

   /**
    * @internal 
    * Creates a JLabel with the specified icon to be placed on the
    * West side of the dialog.
    *
    * @param   Object     An object loaded with the class desired class loader
    * @param   imageName  The file name of the .gif to be loaded
    */
   private void createImageLabel(Object obj, String imageName)
   {
      image = null;
      String imageLocationString = imageLocationKey;

      // Replace bogus characters
      imageName = imageName.replace(':', '_');
      String fullImageName = new String(imageLocationString + imageName);
      URL url = obj.getClass().getResource(fullImageName);

      try
      {
         image = Toolkit.getDefaultToolkit().createImage((ImageProducer)url.getContent());
         imageLabel = new JLabel(new ImageIcon(image));
      }
      catch (Exception ex)
      {
         D.out("+++NMsgBox: Error -- Couldn't create image "+imageName+"...");
      }  
   }

   
   /**
    * @internal
    * Returns the matching string from the resourceBundle given a key-pair.
    *
    * @param key The key-pair match from the resourceBundle.
    *
    * @return The string that corresponds to the key-pair.
    */
   static String getString(String key)
   {
      return res.getString(key);
   }

   
   /**
    * @internal
    * Returns the integer value associated with a given key from the
    * resourceBundle.
    *
    * @param key The key-pair match from the resourceBundle.
    *
    * @return The color that corresponds to the key-pair.
    */
   static int getInt(String key)
   {
      Integer integer = (Integer)res.getObject(key);
      return integer.intValue();
   }

   
   /**
    * @internal
    * Returns the font associated with a given key from the resourceBundle.
    *
    * @param key The key-pair match from the resourceBundle.
    *
    * @return The font that corresponds to the key-pair.
    */
   static Font getFont(String key)
   {
      return (Font)res.getObject(key);
   }

   
   //************************************************************************
   // Methods
   //************************************************************************
   /**
    * Launches the message box, calls setVisible(true), and calls getPressedButton()
    * to return the button that the user pressed.
    *
    * @return The integer ID of the button that the user pressed to dismiss the message box.
    *
    * @see #setVisible
    * @see #getPressedButton
    */
   public int launch()
   {
      setVisible(true);
      return getPressedButton();
   }
   

   /**
    * Override the setVisible() and try to work out a more thread safe war of doing nMsgBox.
    * This may not be on the main event loop thread and it causes problems some places
    * like JRE 1.3 on Linux
    *
    * @see #setVisible
    * 
    */
   public void setVisible(boolean state)
   {
      // If this is the event thread, just call it from here
      // If it is not the event thread then call it based upon whether it is modal
      // or not modal. I am doing it this way because I assume that invokeLater()
      // is safer than invokeAndWait()
      if (SwingUtilities.isEventDispatchThread())
      {
         super.setVisible(state);
      }
      else
      {
         internalSetVisibleCachedState = state;    // must do this so Runnable can get to it.
         Runnable doVisible = new Runnable() 
         {
            public void run()
            {
               //super.setVisible(state);
               internalSetVisible(internalSetVisibleCachedState);
            }
         };
         // modal means that it will not return from the setVisible call until the dialog
         // is dismissed. - I cannot return until something is typed by the user so invokeAndWait()
         //
         // non-modal means that control must go on - just put it on the event queue and return
         // so it can be displayed when it can from the event loop.
         if (isModal())
         {
            try
            {
               SwingUtilities.invokeAndWait(doVisible);
            }
            catch (Exception e)
            {
               // at least we tried
               D.out("+++NMsgBox: Error -- Couldn't invokeAndWait with setVisible method");
            }
         }
         else
         {
            SwingUtilities.invokeLater(doVisible);
         }
      }
   }
   /**
    * internal way to get the the super classes setVisible call
    * ONLY to be used in Overridden setVisible call above - Threading issues.
    */
   private void internalSetVisible(boolean state)
   {
      super.setVisible(state);
   }

   
   /**
    * @internal
    */
   public void paint(Graphics g)
   {
      if(!requestedFocus)
      {
         if(defaultButton != null)
         {  		 	
			//******************Cygsoft modification starts*********************
			// Company 		: Cygsoft Inc.
			// Author		: <Deepak Surwade>
			// Peer Reviewer	: <>
			// Code change date	: <May 27, 2001>
			// Comments		:  To make accessible
			//********************************************************************
 			NConeFactory.novellJButton(defaultButton, msg +"	"+ defaultButton.getName(),"");
			//******************Cygsoft modification ends*********************

            defaultButton.requestFocus();
         }
         requestedFocus = true;
      }

      super.paint(g);
   }

   
   /**
    * Returns the button that was pressed.
    *
    * <p>This method is intended to be called after the message box
    * is launched and then dismissed.
    *
    * @return Integer ID of the button that was pressed.
    *
    * @see #launch
    */
   public int getPressedButton()
   {
      return pressedButton;
   }

   
   /**
    * @internal
    * Returns a button panel that is created based on a bitwise flag passed
    * in identifying the buttons to be created.
    *
    * @param btnFlags Bitwise flag indicating what buttons need
    *                 to be shown.
    *
    * @return The button Panel.
    */
   private JPanel getButtonPanel(int btnFlags)
   {
      NUniformFlowLayout layout = new NUniformFlowLayout();
      
      buttonsPanel = new JPanel(layout);
	  	  
      layout.setExternalPadTop(getInt("MsgBoxSpaceAboveButtonsKey"));
      layout.setExternalPadBottom(0);
      layout.setInternalPadY(0);

      if ((btnFlags & YES) == YES)
      {
         yesButton = new JButton();
         yesButton.setName("Yes");
         Loc.setText(yesButton, getString("yesKey"));
         buttonsPanel.add(yesButton);
         yesButton.addActionListener(this);
         yesButton.addKeyListener(this);
         defaultButton = yesButton;

		 
		//******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 yesButton.addFocusListener(new buttonFocusListener());
		 NConeFactory.novellJButton(yesButton,yesButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }

      if ((btnFlags & YES_ALL) == YES_ALL)
      {
         yesAllButton = new JButton();
                  
         yesAllButton.setName("YesToAll");
         Loc.setText(yesAllButton, getString("yesAllKey"));
         buttonsPanel.add(yesAllButton);
         yesAllButton.addActionListener(this);
         yesAllButton.addKeyListener(this);

		 
		//******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 yesAllButton.addFocusListener(new buttonFocusListener());
		 NConeFactory.novellJButton( yesAllButton,yesAllButton.getName(),"");
		//******************Cygsoft modification ends*********************
      }

      if ((btnFlags & NO) == NO)
      {
         noButton = new JButton();
	     noButton.setName("No");
         Loc.setText(noButton, getString("noKey"));
         buttonsPanel.add(noButton);
         noButton.addActionListener(this);
         noButton.addKeyListener(this);

		 
		//******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 noButton.addFocusListener(new buttonFocusListener());
		 NConeFactory.novellJButton( noButton,noButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }

      if ((btnFlags & NO_ALL) == NO_ALL)
      {
         noAllButton = new JButton();
                  
         noAllButton.setName("NoToAll");
         Loc.setText(noAllButton, getString("noAllKey"));
         buttonsPanel.add(noAllButton);
         noAllButton.addActionListener(this);
         noAllButton.addKeyListener(this);

		 //******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 noAllButton.addFocusListener(new buttonFocusListener());
		 NConeFactory.novellJButton(noAllButton,noAllButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }

      if ((btnFlags & OK) == OK)
      {
         okButton = new JButton();
         
         okButton.setName("OK");
         Loc.setText(okButton, getString("okKey"));//COMMENTED BY VINOD V
         buttonsPanel.add(okButton);
         okButton.addActionListener(this);
         okButton.addKeyListener(this);
         defaultButton = okButton;

		 
		//******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 okButton.addFocusListener(new buttonFocusListener());
         NConeFactory.novellJButton(okButton,okButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }

      if ((btnFlags & CLOSE) == CLOSE)
      {
         closeButton = new JButton();
         
         closeButton.setName("Close");
         Loc.setText(closeButton, getString("closeKey"));//COMMENTED BY VINOD V
         buttonsPanel.add(closeButton);
         closeButton.addActionListener(this);
         closeButton.addKeyListener(this);
         defaultButton = closeButton;

		 //******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 closeButton.addFocusListener(new buttonFocusListener());
		 NConeFactory.novellJButton( closeButton,closeButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }

      if ((btnFlags & PROMPT) == PROMPT)
      {
         promptButton = new JButton();
         
         promptButton.setName("Prompt");
         Loc.setText(promptButton, getString("promptKey"));//COMMENTED BY VINOD V
         buttonsPanel.add(promptButton);
         promptButton.addActionListener(this);
         promptButton.addKeyListener(this);

		 
		//******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 promptButton.addFocusListener(new buttonFocusListener());
         NConeFactory.novellJButton(promptButton,promptButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }

      if ((btnFlags & IGNORE) == IGNORE)
      {
         ignoreButton = new JButton();
                  
         ignoreButton.setName("Ignore");
         Loc.setText(ignoreButton, getString("ignoreKey"));
         Loc.setText(ignoreButton, getString("ignoreKey"));//COMMENTED BY VINOD V
         buttonsPanel.add(ignoreButton);
         ignoreButton.addActionListener(this);
         ignoreButton.addKeyListener(this);
         defaultButton = ignoreButton;

		 
		//******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 ignoreButton.addFocusListener(new buttonFocusListener());
		 NConeFactory.novellJButton( ignoreButton,ignoreButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }

      if ((btnFlags & IGNORE_ALL) == IGNORE_ALL)
      {
         ignoreAllButton = new JButton();
         
         ignoreAllButton.setName("IgnoreAll");
         Loc.setText(ignoreAllButton, getString("ignoreAllKey"));//COMMENTED BY VINOD V
         buttonsPanel.add(ignoreAllButton);
         ignoreAllButton.addActionListener(this);
         ignoreAllButton.addKeyListener(this);

		 
		//******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 ignoreAllButton.addFocusListener(new buttonFocusListener());
         NConeFactory.novellJButton( ignoreAllButton,ignoreAllButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }

      if ((btnFlags & CANCEL) == CANCEL)
      {
         cancelButton = new JButton();
         
         cancelButton.setName("Cancel");
         Loc.setText(cancelButton, getString("cancelKey"));//COMMENTED BY VINOD V
         buttonsPanel.add(cancelButton);
         cancelButton.addActionListener(this);
         cancelButton.addKeyListener(this);

		 
		//******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 cancelButton.addFocusListener(new buttonFocusListener());
		 NConeFactory.novellJButton( cancelButton,cancelButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }

      if ((btnFlags & DETAILS) == DETAILS)
      {
         detailsButton = new JButton();
                  
         detailsButton.setName("Details");
         Loc.setText(detailsButton, getString("detailsKey"));
         Loc.setText(detailsButton, getString("detailsKey"));//COMMENTED BY VINOD V
         buttonsPanel.add(detailsButton);
         detailsButton.addActionListener(this);
         detailsButton.addKeyListener(this);

				 
		//******************Cygsoft modification starts*********************
		// Company 		: Cygsoft Inc.
		// Author		: <Deepak Surwade>
		// Peer Reviewer	: <>
		// Code change date	: <May 27, 2001>
		// Comments		:  To make accessible
		//********************************************************************
		 detailsButton.addFocusListener(new buttonFocusListener());
		 NConeFactory.novellJButton( detailsButton,detailsButton.getName(),"");
		 //******************Cygsoft modification ends*********************
      }
      
      if (defaultButton == null)
      {
         // iterate through all components on buttonsPanel
         // and select the first button as default
         Component[] ca = buttonsPanel.getComponents();
         if (ca != null)
         {
            for (int i=0; i<ca.length; i++)
            {
               if (ca[i] instanceof JButton)
               {
                  defaultButton = (JButton) ca[i];
                  break;
               }
            }
         }
      }
	 
      return buttonsPanel;
   }

   
	//******************Cygsoft modification starts*********************
	// Company 		: Cygsoft Inc.
	// Author		: <Deepak Surwade>
	// Peer Reviewer	: <>
	// Code change date	: <May 27, 2001>
	// Comments		:  To make accessible
	//********************************************************************

	/*
	*	This is inner class for focus listener of button
	*
	*
	*/
   class buttonFocusListener implements FocusListener
   {	
   		public void focusGained(FocusEvent e)
		{
			Object obj = e.getSource();
   			if(!(obj instanceof JButton) || currentButton==null)
				return;

			if(currentButton.equals(obj))
				NConeFactory.novellJButton( currentButton, msg +"	"+ currentButton.getName(),"");
			else
				NConeFactory.novellJButton( currentButton, currentButton.getName(),"");
		}
		public void focusLost(FocusEvent e)
		{
			Object obj = e.getSource();
   			if(!(obj instanceof JButton))
				return;	

			currentButton = (JButton)obj  ;
		}
   }
   //******************Cygsoft modification ends*********************

   /**
    * @internal
    * Processes action events.
    *
    * @param event The action event to process.
    */
   public void actionPerformed(ActionEvent event)
   {
      Object src = event.getSource();

      if (src instanceof JButton)
      {
         buttonPressed((JButton)src);
      }
      super.actionPerformed(event);
   }

   
   /**
    * @internal
    * Override dispose method of Window class.
    */
   public void dispose()
   {
      super.dispose();
      
      if(image != null)
      {
         image.flush();
         image = null;
      }
   }


   /**
    * @internal
    * Processes a button pressed.
    *
    * @param button The button that was pressed.
    */
   private void buttonPressed(JButton button)
   {
      if (button == okButton)
      {
         pressedButton = OK;
         dispose();
	  }
      else if (button == yesButton)
      {
         pressedButton = YES;
         dispose();
 	  }
      else if (button == noButton)
      {
         pressedButton = NO;
         dispose();
	  }
      else if (button == yesAllButton)
      {
         pressedButton = YES_ALL;
         dispose();
	  }
      else if (button == noAllButton)
      {
         pressedButton = NO_ALL;
         dispose();
	  }
      else if (button == closeButton)
      {
         pressedButton = CLOSE;
         dispose();
	  }
      else if (button == cancelButton)
      {
         pressedButton = CANCEL;
         dispose();
	  }
      else if (button == ignoreButton)
      {
         pressedButton = IGNORE;
         dispose();
	  }
      else if (button == ignoreAllButton)
      {
         pressedButton = IGNORE_ALL;
         dispose();
	  }
      else if (button == detailsButton)
      {
         help();
	  }
      else if (button == promptButton)
      {
         pressedButton = PROMPT;
         dispose();
	  }
   }


   /**
    * Override superclass help method.
    */
   protected void help()
   {
      // Need to check if helpSetName and helpId are = NULL, if they are, then return
      // without launching the NMsgBox.
      if(helpSetName != null && helpID != null)
      {
       
      	// Need to catch NullPointer exceptions here because detailed help
      	// now links to the corporate web page which could be down.
      	try
      	{
             ShellStubs.launchHelp(helpSetName, helpID, this);
      	}
      	catch(Exception e)
      	{
             NMsgBox box = new NMsgBox(parentFrame,
                                   getString("helpErrorKey"),
                                   getString("helpConnectionKey"),
                                   NMsgBox.ERROR);
             box.setVisible(true);
      	}
      }
   }

   
   // KeyListener Interface
   public void keyReleased(KeyEvent event){}
   public void keyPressed(KeyEvent event) {}
   public void keyTyped(KeyEvent event)
   {
      // See if user hit "Enter" key
      if ((event.getKeyCode() == KeyEvent.VK_ENTER) ||
          (event.getKeyCode() == KeyEvent.VK_SPACE))
      {
         Object src = event.getSource();

         if (src instanceof JButton)
         {
            buttonPressed((JButton)src);
         }
      }
   }
   
   
   // TESTING HOOKS
   public Vector c1AutomationInvoke(Vector vTokens)
   {
      
      String sMethod = (String)vTokens.elementAt(0);
      Vector retVector = new Vector();
      
      // getTitle API
      if ( sMethod.equalsIgnoreCase("getTitle") )
      {
         retVector.addElement(this.sTitle);		   
      }
      
      // getText API
      else if ( sMethod.equalsIgnoreCase("getText") )
      {
         retVector.addElement(this.msg);		   
      }
      
      // Unsupported API
      else
      {
         retVector.addElement(new Integer(-1));
         retVector.addElement
            ("NMSgBox::c1AutomationInvoke: Unsupported API: " + sMethod);		   
      }
      
      return retVector;	   
      
   } // end c1AutomationInvoke method  
   // END TESTING HOOKS

}//class NMsgBox


