//   Name:  ConfigurationStoreExampleTask.java
//
//   Copyright (c) 1997-2004 Novell, Inc.  All Rights Reserved.
//
//   THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
//   USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
//   ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
//   PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
//   ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
//   PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
//   DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
//   PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
//   CUSTOMERS WITH RESPECT TO THIS CODE.

package com.company.plugins;

import com.novell.emframe.dev.*;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.config.ConfigException;

import javax.servlet.http.HttpServletRequest;
import java.util.Properties;

public class ConfigurationStoreExampleTask extends Task
{
   public boolean execute(TaskContext context, Properties resultStrings)
   {
      HttpServletRequest req = context.getRequest();
      String nextState = req.getParameter("nextState");

      SystemConfig systemConfig = SystemConfig.getSystemConfig(context);

      if(nextState==null || nextState.equals("initialState"))
      {
         resultStrings.put("ConfigurationExample_Name", systemConfig.getSetting("ConfigurationExample_Name","Joe"));
         resultStrings.put("ConfigurationExample_Color", systemConfig.getSetting("ConfigurationExample_Color","Blue"));

         setUIPage("sdk/ConfigurationStoreExampleTemplate.jsp");
      }
      else if(nextState.equals("save"))
      {
         try
         {
            systemConfig.setSetting("ConfigurationExample_Name", req.getParameter("ConfigurationExample_Name"));
            systemConfig.setSetting("ConfigurationExample_Color", req.getParameter("ConfigurationExample_Color"));

            systemConfig.writeSettings();
         }
         catch (ConfigException e)
         {
            eMFrameUtils.setMessage("error","Configuration Store Example","Your settings could not be saved.",context);
         }

         eMFrameUtils.setMessage("success","Configuration Store Example","Your settings have been saved.",context);
      }

      return true;
   }
}