//   Name:  FileUploadExampleTask.java
//
//   Copyright (c) 1997-2004 Novell, Inc.  All Rights Reserved.
//
//   THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
//   USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
//   ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
//   PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
//   ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
//   PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
//   DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
//   PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
//   CUSTOMERS WITH RESPECT TO THIS CODE.

package com.company.plugins;

import com.novell.emframe.dev.*;

import javax.servlet.http.HttpServletRequest;
import java.util.Properties;
import java.io.File;

public class FileUploadExampleTask extends Task
{
   private HttpServletRequest req = null;

   public boolean execute(TaskContext context, Properties resultStrings)
   {
      req = context.getRequest();
      String nextState = req.getParameter(eMFrameConsts.NEXTSTATE);

      if (nextState.equalsIgnoreCase(eMFrameConsts.INITIALSTATE))
      {
         setUIPage("sdk/FileUploadExampleEntryTemplate.jsp");
      }
      else if(nextState.equalsIgnoreCase("doUpload"))
      {
         //get the path to the temporary file
         String filePath = req.getParameter("fileToUpload.tempFile");

         //also, get the file size
         Integer fileSize = new Integer(req.getParameter("fileToUpload.size"));

         //create new file based on the temp path
         File f = new File(filePath);

         //Now that we have a File object, we can do whatever we want with the file.
         //In this example, we'll just print the file name, path, and size.
         resultStrings.put("fileName",f.getName());
         resultStrings.put("filePath",f.getAbsolutePath());
         resultStrings.put("fileSize",fileSize.toString());

         setUIPage("sdk/FileUploadExampleResultsTemplate.jsp");
      }

      return true;
   }
}