/* **************************************************************************
 * %derived_by:    msorensen %
 * %date_modified: Thu Oct 07 17:35:20 2004 %
 *
 * Copyright (c) 2001 Novell, Inc.  All Rights Reserved.
 *
 * THIS WORK IS  SUBJECT  TO  U.S.  AND  INTERNATIONAL  COPYRIGHT  LAWS  AND
 * TREATIES.   NO  PART  OF  THIS  WORK MAY BE  USED,  PRACTICED,  PERFORMED
 * COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED,  ABRIDGED, CONDENSED,
 * EXPANDED,  COLLECTED,  COMPILED,  LINKED,  RECAST, TRANSFORMED OR ADAPTED
 * WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION
 * OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO
 * CRIMINAL AND CIVIL LIABILITY.
 ***************************************************************************/
package com.company.plugins;

import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.Properties;

public class MVStringEditorExample extends Task
{
   public boolean execute(TaskContext context, Properties resultStrings)
   {
      HttpServletRequest request=context.getRequest();
      String nextState = request.getParameter("nextState");

      if(nextState==null || nextState.equalsIgnoreCase("initialState"))
      {
         String[] myData = {"orange", "blue", "yellow"};
         request.setAttribute("myData", myData);                           // pass data from Java task to JSP; JSP will pass to MVStringEditor
         setUIPage("sdk/MVStringEditorExample.jsp");
      }
      else if (nextState.equalsIgnoreCase("postedData"))
      {
         String[] myData = eMFrameUtils.getMvedValues("myData", context);

         String msg = "Here is the data sent: \n";
         for(int i=0; i<myData.length; i++)
         {
            msg += myData[i] + "\n";
         }

         eMFrameUtils.setMessage("success", "Success", msg, context);
         setUIPage("dev/GenConf.jsp");
      }

      return true;
   }
}
