//   Name:  TargetChooserOverrideExampleTask.java
//
//   Copyright (c) 1997-2004 Novell, Inc.  All Rights Reserved.
//
//   THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
//   USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
//   ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
//   PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
//   ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
//   PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
//   DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
//   PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
//   CUSTOMERS WITH RESPECT TO THIS CODE.

package com.company.plugins;

import com.novell.emframe.dev.*;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.FilterResultModifier;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;

import java.util.Properties;
import java.util.ArrayList;

public class TargetChooserOverrideExampleTask extends Task
{
   public boolean execute(TaskContext context, Properties resultStrings)
   {
      //we need to get a namespace through which we can get our tree's child objects.
      //to do so, we use the current auth broker to get a namespace.
      AuthenticationBroker broker = context.getAuthenticationBroker();
      ObjectEntry treeOE = (ObjectEntry) broker.getAPIObject("NDSNamespace");
      NDSNamespace ns = (NDSNamespace) treeOE.getNamespace();

      try
      {
         //we use a filter to sort by specific attributes.
         //set up the filter objects.
         FilterResultModifier.Filter filter = new FilterResultModifier.Filter();
         FilterResultModifier.FilterItemGroup group = new FilterResultModifier.FilterItemGroup();

         //this filter specifies all objects whose CN starts with "a"
         group.addFilterItem("CN", FilterResultModifier.EQUAL, "a*", null);

         //add the filter group to filter
         filter.addFilterItemGroupPair(group, null);

         //now create the result modifier with the filter and get all the children based on the filter.
         FilterResultModifier rm = new FilterResultModifier("", ResultModifier.SORTBY_KEY_NAME, filter, true);
         ObjectEntryEnumeration children = ns.getChildren(treeOE, rm);

         //create an arraylist object to hold our values.
         ArrayList items = new ArrayList();

         //now loop through the children and add them to the users arraylist.
         //the users is the arraylist that will be returned to the JSP.
         //in this example, let's limit our list to only 10 users.
         int count = 0;
         while (children.hasMoreElements() && count < 10)
         {
            count++;
            ObjectEntry childOE = (ObjectEntry) children.nextElement();
            items.add(ns.getUnrootedName(childOE));
            //note the line right above this. The arraylist passed to the JSP will have
            //10 items, for example:
            //   Bob
            //   Dave
            //   Hans
            //   ...
            //we can then parse through the arraylist to find our users.
         }

         //now put our temporary properties object into the main properties being sent to the JSP
         resultStrings.put("Items", items);

         //that is all we need to do to do a simple query of the directory.
         //set the JSP page.
         setUIPage("sdk/TargetChooserOverrideExampleTemplate.jsp");

      }
      catch (SPIException e)
      {
         //throw an error if this is somehow invalid.
         eMFrameUtils.setErrorMessage(e, context);
         return false;
      }

      return true;
   }
}