<!-- ************************************************************************
 |
 |	(C) Copyright 2007 Novell, Inc.
 |	All Rights Reserved.
 |
 |	This program is an unpublished copyrighted work which is proprietary
 |	to Novell, Inc. and contains confidential information that is not
 |	to be reproduced or disclosed to any other person or entity without
 |	prior written consent from Novell, Inc. in each and every instance.
 |
 |	WARNING:  Unauthorized reproduction of this program as well as
 |	unauthorized preparation of derivative works based upon the
 |	program or distribution of copies by sale, rental, lease or
 |	lending are violations of federal copyright laws and state trade
 |	secret laws, punishable by civil and criminal penalties.
 |
 |***************************************************************************
 |
 |	 Novell iManager Base Plugin
 |
 |***************************************************************************
 |
 |
 | $Author: $
 | $Modtime: $
 |
 | $Workfile:$
 | $Revision: $
 |
 |***************************************************************************
 |
 |	This page will display the info required for creting Volume
 |
 |************************************************************************ -->

<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/fmt.tld" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>
<iman:stringtable bundle="DevResources" />
<iman:stringtable bundle="FwResources" />
<%
   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("FwResources");
   c.stringTable("BaseResources");
%>


<%-- Empty xml, since we don't have an object to read --%>
<x:parse xml="<edas></edas>" var="edasXml"/>

<HTML>
<HEAD>
   <TITLE><%= c.string("CreateVolumeTaskDisplayName") %></TITLE>
   <iman:stylesheet/>
   <iman:uihandlerTools/>


   <iman:eMFrameScripts/>
   <iman:validateNumberScripts/>
   <iman:osScripts/>

   <SCRIPT>
      function onInit()
      {
         var form = document.forms[0];
         form._CN.focus();
         returnFromOS();
      }

	  function getFSVolumes(error, FSVolumes)
	  {
           document.form._Host_Resource_Name.options.length = 0;
           
	  	   if(error != '')
      	   {
      	     alert(error);
             return;
           }

           var vols = unpack(FSVolumes);
           for(i = 0; i < vols.length; i++)
           {
             document.form._Host_Resource_Name.options[i] = new Option(vols[i],vols[i]);
             if(i == 0) document.form._Host_Resource_Name.options[i].selected = true;
           }
	  }
	  
	  function HostServerCallBack(controlName, selObj)
	  {
		 document.form._Host_Server.value = toScript(selObj[0]);
		 window.upExchanger = new exchanger("exchangerFrame");
         upExchanger.sendData("webacc?taskId=fw.GetFSVolumes&merge=base.GetFSVolumesExchanger&error=base.GetFSVolumesExchanger&HostServerObject=" + urlEncode(selObj[0]));
	  }
	  
	  function goGetFSVolumes()
	  {
	       selObj = new Array(1);
	       if(document.form._Host_Server.value == '')
	         return;
      	   selObj[0] = document.form._Host_Server.value;
           HostServerCallBack("document.form._Host_Server", selObj);
	  }
	  
      function onExit()
      {
         var form=document.forms[0];

         var success = notifyAllOfExit();
         if(!success)
         {
            return false;
         }

		 form.eDir$target.value = getValueFromXml(form.eDir$target$CN.value);
	     if ((null == form.eDir$target.value) || (form.eDir$target.value.length == 0))
	     {
	        alert("<%= c.toScript(c.string("Creator.InvalidObjectName")) %>");
	        return false;
	     }
	     
         if(form.eDir$target$CN.value.indexOf('<value')<0)
         {
            alert("<%= c.string("CreateVolume.InvalidVolumeName") %>");
            return false;
         }
         if(form.eDir$target$Host_Server.value.indexOf('<value')<0)
         {
			alert("<%= c.string("CreateVolume.InvalidSrvName") %>");            
            return false;
         }
		 if(document.form._Host_Resource_Name.options.length == 0)
		 {
		 	alert("<%= c.string("Common.NoVolumes") %>");
		 	return false;
		 }

         var containerInput = document.form.eDir$target$createContext.value;
         var radioButton = (form.eDir$target$createContext[0] && form.eDir$target$createContext[0].type == "radio");
         if(!radioButton)
         {
            if ((containerInput==null) || (containerInput.length==0))
            {
               alert("<iman:string key="Creator.InvalidContainerName"/>");
               return false;
            }
         }

         return true;
      }

      var ENABLED_COLOR = "white";
      var DISABLED_COLOR = "#EFEEE9";

      function enableTemplate(control)
      {
         with(document.forms[0])
         {
            var tf = eDir$target$createSourceObjectForClone;
            if (control.checked == true)
            {
               tf.disabled = false;
               tf.style.backgroundColor = ENABLED_COLOR;
            }
            else
            {
               tf.disabled = true;
               tf.value = "";
               tf.style.backgroundColor = DISABLED_COLOR;
            }
         }
      }

	   function checkDefaultKey(evt)
      {
         var form = document.forms[0];
         var keyCode = evt.which ? evt.which : evt.keyCode;
         // 13 is the Enter key code
         if (keyCode == 13)
         {
            if(onExit() != false)
            {
               document.forms[0].submit();
               return false;
            }
         }
         return true;
      }
   </SCRIPT>
</HEAD>


<body onLoad="onInit();">
<FORM name="form" method="post" action="webacc" onSubmit="onExit();">

   <!---- EDAS and System Variables ---->
   <INPUT type=hidden name="taskId" value="<c:out value="${taskId}"/>">
   <INPUT type=hidden name="eDirCommand" value="create">
   <INPUT type=hidden name="merge" value="dev.GenConf">
   <INPUT type=hidden name="error" value="dev.GenErr">
   <INPUT type=hidden name="nextState" value="doCreateVolume">
   <INPUT type=hidden name="SelectedClass" value="<%= c.var("SelectedClass") %>">   
   <INPUT type=hidden name="TranslatedClass" value="<%= c.var("TranslatedClass") %>">
   <INPUT type=hidden name="GifName" value="<%= c.var("GifName") %>">
   <INPUT type=hidden name="targetNames" value="<%= c.var("targetNames") %>">
   <INPUT type=hidden name="eDir$target" value="">
   <INPUT type=hidden name="eDir$target$createClassName"  value="<%= c.var("SelectedClass") %>">   
   
   <c:set var="eDirCommandString" value="create" />

   <!---- Shared Form Code ---->

   <%
      c.set("TaskHeader.title", c.string("CreateVolumeTaskDisplayName"));
      c.set("TaskHeader.iconUrl", c.plus("dir/", c.var("GifName")));
      c.set("TaskHeader.iconAlt", c.var("TranslatedClass"));
      c.set("TaskHeader.helpFile", "base/createvolume.html");
   %>
   <jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" />

   <% if (c.var("createClassName").equals("Country")) { %>
      <p class="instructions"><iman:string key="Creator.CountrySelectPrompt" /></p>
   <% } else { %>
      <p class="instructions"><iman:string key="Creator.GenericSelectPrompt"/></p>
   <% } %>

  <TABLE class="mediumtext" border="0" bgcolor="#FFFFFF" cellpadding="0" cellspacing="0">

   <%-- CN --%>
   <TR>
      <TD align="left" colspan="2">
         <%= eMFrameUtils.toScript(c.formatMessage(c.string("Creator.NamePrompt"), new String[]{c.var("TranslatedClass")} ) )%>:&nbsp;
      </TD>
   </TR>
   <TR>
      <TD>
         <c:if test="${edasRights.target.CN.writeable}">
            <INPUT type="hidden" name="eDir$target$CN" value="<c:out value="${eDir$target$CN}" escapeXml="false"/>">
         </c:if>
         <INPUT type="text" name="_CN" id="spinner_CN" value="" size=<iman:string key="UI.textboxSize"/> style="width:<iman:string key="UI.textboxPixel"/>"  maxlength=64 onChange='return validateLengthField(this, 1, 64); postUiHandlerEvent("CN", "change")'<c:if test="${!edasRights.target.CN.writeable}">DISABLED</c:if>  >
      </TD>
      <TD valign="top">
         <c:set var="mode"><x:out select="$edasXml/edas/CN/@mode"/></c:set>
         <iman:mooMode name="_CN_mode" value="${mode}" multi="true" />
      </TD>
   </TR>
   <SCRIPT>
      window.uiObject_CN = new UiObject();
      <c:if test="${edasRights.target.CN.writeable}">
         addToNotificationList('CN', 'uih_textfield');
         addActionHandler('CN', 'uiah_textfield');
      </c:if>
   </SCRIPT>
   <SCRIPT>
      window.uiObject_CN.m_lowerBound = 1;
      window.uiObject_CN.m_upperBound = 64;
      window.uiObject_CN.m_type = "string";
   </SCRIPT>
   <TR><TD height="9"></TD></TR>

   <%-- Host_Server --%>
   <TR>
      <TD align="left" colspan="2">
         <%= c.string("Attribute.Host_Server") %>:&nbsp;&nbsp;
      </TD>
   </TR>
   <TR>
      <TD>
         <c:if test="${edasRights.target.Host_Server.writeable}">
            <INPUT type="hidden" name="eDir$target$Host_Server" value="<c:out value="${eDir$target$Host_Server}" escapeXml="false"/>">
         </c:if>
         <INPUT type="text" name="_Host_Server" id="spinner_Host_Server" value="<x:out select="$edasXml/edas/Host_Server/value"/>" onchange="goGetFSVolumes()" size=<iman:string key="UI.textboxSize"/> style="width:<iman:string key="UI.textboxPixel"/>"  <c:if test="${!edasRights.target.Host_Server.writeable}">DISABLED</c:if> >      
         <c:if test="${edasRights.target.Host_Server.writeable}">
            <iman:os typeFilter="NCP Server" control="_Host_Server" showSubClasses="false" callBack="HostServerCallBack" />
         </c:if>
      </TD>
      <TD valign="top">
         <c:set var="mode"><x:out select="$edasXml/edas/Host_Server/@mode"/></c:set>
         <iman:mooMode name="_Host_Server_mode" value="${mode}" multi="true" />
      </TD>
   </TR>
   <SCRIPT>
      window.uiObject_Host_Server = new UiObject();
      <c:if test="${edasRights.target.Host_Server.writeable}">
         addToNotificationList('Host_Server', 'uih_textfield');
         addActionHandler('Host_Server', 'uiah_textfield');
      </c:if>
   </SCRIPT>
   <SCRIPT>
      window.uiObject_Host_Server.m_lowerBound = null;
      window.uiObject_Host_Server.m_upperBound = null;
      window.uiObject_Host_Server.m_type = "string";
   </SCRIPT>
   <TR><TD height="9"></TD></TR>

   <%-- context --%>
   <TR>
      <TD><iman:string key="Creator.Context"/><font color="red">*</font></TD>
   </TR>
   <TR>
      <TD>
         <INPUT type=text name="eDir$target$createContext" value="<%= eMFrameUtils.getSingleTarget(request) %>"size="<iman:string key="UI.textboxSize"/>" style="width:<iman:string key="UI.textboxPixel"/>" onkeypress="return checkDefaultKey(event)">
          <% c.set("OS.Control", "eDir$target$createContext");
			            c.set("OS.TypeFilter", "Organization,Organizational Unit,domain");
			            c.set("OS.History", "true");
			            c.set("OS.Windowed", "true"); %>
		  <jsp:include page='<%= c.getPath("dev/OS_inc.jsp") %>' flush="true" />
      </TD>
   </TR>
   <SCRIPT>
      window.uiObject_context = new UiObject();
      <c:if test="${true}">
      </c:if>
   </SCRIPT>
   <TR><TD height="9"></TD></TR>
  
   <%-- Host_Resource_Name --%>
   <TR>
      <TD align="left" colspan="2">
         <%= c.string("Attribute.Host_Resource_Name") %>:&nbsp;&nbsp;
      </TD>
   </TR>
   <TR>
      <TD>
         <c:if test="${edasRights.target.Host_Resource_Name.writeable}">
            <INPUT type="hidden" name="eDir$target$Host_Resource_Name" value="<c:out value="${eDir$target$Host_Resource_Name}" escapeXml="false"/>">
         </c:if>
        
        <SELECT name="_Host_Resource_Name" id="spinner_Host_Resource_Name" style="width:<iman:string key="UI.textboxPixel"/>" >
        </SELECT>
      </TD>
      <TD valign="top">
         <c:set var="mode"><x:out select="$edasXml/edas/Host_Resource_Name/@mode"/></c:set>
         <iman:mooMode name="_Host_Resource_Name_mode" value="${mode}" multi="true" />
      </TD>
   </TR>
   <SCRIPT>
      window.uiObject_Host_Resource_Name = new UiObject();
      <c:if test="${edasRights.target.Host_Resource_Name.writeable}">
         addToNotificationList('Host_Resource_Name', 'uih_textfield');
         addActionHandler('Host_Resource_Name', 'uiah_textfield');
      </c:if>
   </SCRIPT>
   <SCRIPT>
      window.uiObject_Host_Resource_Name.m_lowerBound = null;
      window.uiObject_Host_Resource_Name.m_upperBound = null;
      window.uiObject_Host_Resource_Name.m_type = "string";
   </SCRIPT>
   <TR><TD height="9"></TD></TR>
   </TABLE><BR>

   <iman:bar/>
   <iman:button key="OK" onClick="if(onExit() != false) document.forms[0].submit()" />
   <iman:cancelBtn/>

</FORM>
<iman:osFooter/>
<IFRAME src="/nps/Empty.html" style="visibility: hidden" name="exchangerFrame" id="exchangerFrame" width="0" height="0" marginwidth="0" marginheight="0"></IFRAME>
</BODY>
</HTML>


