<!--
   Name: NGGroupMembershipPage.jsp

   Copyright (c) 2007-2013 Novell, Inc.  All Rights Reserved.

   THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
   USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
   ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
   PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
   ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
   PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
   DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
   PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
   CUSTOMERS WITH RESPECT TO THIS CODE.

-->
<%@ page pageEncoding="utf-8" contentType="text/html;charset=utf-8" %>
<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>

<iman:stringtable bundle="BaseResources"/>

<html>
   <head>
      <title><iman:string key="NestedGroup.GroupMembershipPageTitle"/></title>
      <LINK rel="stylesheet" href="<c:out value="${ContextPath}" />/portal/modules/dev/css/hf_style.css">

      <iman:eMFrameScripts/>
      <iman:osScripts/>
      <iman:mvedScripts mode="mvsel"/>
      <iman:include page="dev/PageScripts_inc.jsp"/>
      <script language="JavaScript">

		function onInit()
       	{
        	<c:if test="${IsNestedSettingParam == 'true'}">
			if ( "<c:out value="${GroupMembershipParam}"/>" != "" )
				mvLoadFromPack("GroupMembershipControl","<c:out value="${GroupMembershipParam}"/>");
			
			if ( "<c:out value="${GroupMembershipNestedParam}"/>" != "" )
			{
	        	var listcontrol=document.getElementById("nesteddisplay");
              		 
              	var values=unpack("<c:out value="${GroupMembershipNestedParam}"/>");
              	for ( var i=0; i < values.length; i++ ) 
				{
					var option=new Option(values[i],i);
					listcontrol.options[i]=option;
				}            	
			}
				
			document.getElementById("staticlist").style.display = ''; 
			document.getElementById("nestedlist").style.display = 'none'; 
            </c:if>
           
		}

		function isPageValid()
        {
			with ( document.NGGroupMembershipPageForm )
			{
				<c:if test="${IsNestedSettingParam == 'true'}">
					GroupMembershipHiddenField.value = mvGetValuesAsPack( "GroupMembershipControl" );
				</c:if>
			}
		}
         
        function shownested(control)
        {
        	document.getElementById("staticlist").style.display='none';
			document.getElementById("nestedlist").style.display='';
		}
		
		function showstatic()
		{
			document.getElementById("staticlist").style.display='';
			document.getElementById("nestedlist").style.display='none';
		}

      </script>
   </head>
   <body TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF" onLoad="returnFromOS();onInit();">
      <form name="NGGroupMembershipPageForm" method=post action="<c:out value= "${ContextPath}"/>/servlet/frameservice">
        <input type=hidden name="taskId" value="<c:out value="${taskId}"/>"/>
       	<input type=hidden name="GroupMembershipHiddenField" value="empty">

		<iman:include page="dev/Messagebar_inc.jsp"/>
        <iman:include page="dev/BookVars_inc.jsp"/>

		<table border=0 class="mediumtext">
			<c:if test="${IsNestedSettingParam == 'true'}">	
			<tr>
				<input type="radio" name="displaymode" onclick="showstatic()" value="static" checked> 
					<label><iman:string key="NestedGroup.StaticGroupMembership"/></label> <br>
				<input type="radio" name="displaymode" onclick="shownested()" value="nested"> 
					<label> <iman:string key="NestedGroup.NestedGroupMembership"/> </label>			
			</tr >		

            <tr id="staticlist">
               <td align=left >
					<c:if test="${IsNestedSettingParam == 'true'}">
						<br><c:out value="${attributeDisplayName}"/>:<br>
 	                 	<iman:mved mode="mvsel" name="GroupMembershipControl" size="15" enforceUnique="true"
		                  	width="450" objectTypeName="nestedGroupAux" history="true" showCount="true"/>
	    			</c:if>  	
			</tr>
			
			<tr id="nestedlist">	
				<td align=left>
					<br><c:out value="${attributeDisplayName}"/>:<br>
					<c:if test="${IsNestedSettingParam == 'true'}">
                    	<SELECT id="nesteddisplay" size="15" style="width:450">
                        </SELECT>
						<br>
	                	<iman:string key="DynamicGroup.CountLabel"/> 
						<INPUT type="text" id="<c:out value="${GroupMembershipNestedParamCount}"/>"
							 value="<c:out value="${GroupMembershipNestedParamCount}"/>" 
							 style="border:none;background:white;color:black;" disabled="true">
                  </c:if>
               </td>
            </tr>
			
			</c:if>

         </table>
        
      </form>
      <iman:osFooter/>
   </body>
</html>
