//===================================================
// BookScripts.js: Device independent
//===================================================

function refresh()
{	
	var refreshConfirm = rc_confirmRefresh;
	var retVal = window.confirm(refreshConfirm);
	if(retVal){
		doAction("refreshAllValues");
	}

}

function apply()
{
   doAction("apply");
}

function ok()
{
   doAction("ok");
}

function showPage(page)
{
   doAction("show", page);
}

function doCancel(taskId)
{
   var wpage = parent.bookBody;
   if( ((typeof wpage.canCancel == "function") && (wpage.canCancel()==false)) || (PIE && !wpage.canCancel()) )
   {
      return;
   }

   parent.location = "webacc?taskId="+taskId+"&taskComplete=true";
}

function doAction(strAction, page)
{
   var wpage = parent.bookBody;
   var fpage = wpage.document.forms[0];

  if(strAction == "refreshAllValues")	{
  	wpage.isRefreshClicked = true;
  	
  }
   // is page loaded
   var pageLoaded = (typeof fpage != "undefined");
   if(pageLoaded && MS55 && wpage.document.readyState!="complete")
   {
      pageLoaded = false;
   }

   if(!pageLoaded || !fpage.activePage)
   {
      if(strAction=="show")
      {
         var doc = wpage.document;
         var tag = " <INPUT type=hidden name=";
         doc.open();
         doc.writeln('<HTML><BODY><FORM action="webacc">');
         doc.writeln(tag + 'taskId value="'+vars_taskId+'">');
         doc.writeln(tag + 'nextPage value="'+page+'">');
         doc.writeln(tag + 'nextState value="show">');
         doc.writeln('</FORM></BODY></HTML>');
         doc.close();
         doc.forms[0].submit();

         selectPage(page);
      }

      // apply ignored if page not loaded
      return;
   }
	
   if( ((typeof wpage.isPageValid == "function") && (wpage.isPageValid(strAction)==false)) || (PIE && !wpage.isPageValid(strAction)) )
   {
      return;
   }

   if(page)
   {
      fpage.nextPage.value=page;
      selectPage(page);
   }

   fpage.nextState.value = strAction;

   showLoadingMessage();

   // Moo only
   if(vars_isMoo && (strAction=="ok" || strAction=="apply"))
   {
      var b = parent.document.body;
      var x = parent.bookBody.screenLeft + (parent.bookBody.document.body.clientWidth-350)/2;
      var y = parent.bookBody.screenTop + (parent.bookBody.document.body.clientHeight-200)/2 - 100;

      var params = "left="+x+",top="+y+",height=200,width=350,resizable,scrollbars";
      window.open("/nps/Empty.html","progress",params);
      var tmp = fpage.target;
      fpage.target = "progress";
      fpage.submit();
      fpage.target = tmp;
   }
   else
   {
      fpage.submit();
   }
}

function refreshAfterProgress()
{
   var fpage = parent.bookBody.document.forms[0];
   fpage.nextState.value = "refresh";
   fpage.activePage.value="-1";

   showLoadingMessage();

   fpage.submit();
}

function showLoadingMessage()
{
	if(MS55)
   {
      var wpage = parent.bookBody;

      var message = null;
      if(parent.bookBody.loadingMessage && parent.bookBody.loadingMessage !=null)
      {
         message = parent.bookBody.loadingMessage;
      }
      else
      {
         message = rc_pageLoading;
      }

      var loadingDlg = window.createPopup();
      var popStyle = loadingDlg.document.body.style;
      popStyle.backgroundColor = "#dfddd5";
      popStyle.border = "1 solid black";
      popStyle.textAlign = "center";
      popStyle.fontFamily = '"Trebuchet MS", Arial, Helvetica';
      loadingDlg.document.body.innerHTML = "<BR>"+message+"<BR><BR>";
      var x = (wpage.document.body.clientWidth / 2) - 100;
      var y = (wpage.document.body.clientHeight * 0.20);
      loadingDlg.show(x, y, 200, 70, wpage.document.body);
   }
}

function showHelpButton(helpfile)
{
   if(helpfile && helpfile.value.length>0)
      isVisible = "visible";
   else
      isVisible = "hidden";


   var helpButton = parent.bookHeader.document.getElementById("helpButton");
   if(helpButton)
      helpButton.style.visibility = isVisible;
}
