//===================================================
// BookScriptsDefault.js
// Device dependent - for complex graphic tabs
//===================================================

function selectPage(pageid)
{
   // set current page to bold
   if(MS4 || NN6)
   {
      var idIndex=0;
      while(document.getElementById("tab_"+idIndex))
      {
         document.getElementById("tab_"+idIndex).className="tab2u";
         idIndex = idIndex+1;
      }
      document.getElementById("tab_"+pageid).className="tab2s";
   }
}

function selectChapter(strId)
{
   var index=0;
   while(document.getElementById("tab"+index))
   {
      document.getElementById("tab" + index).style.display = "none";
      index++;
   }
   document.getElementById("tab" + strId).style.display = "block";
}

function syncTab(pageId)
{
   selectPage(pageId);
   selectChapter(findChapterIndex(pageId));
}

function findChapterIndex(pageId)
{
   for(var row=0; row<tabs.length; row++)
   {
      for(var col=0; col<tabs[row].length; col++)
      {
         if(tabs[row][col][0] == pageId)
         {
            return row;
         }
      }
   }

   return -1;
}



window.buttonWidth = 60;

//We really don't need scrollLeft and scrollRight for default mode
//However, we should implement this one day
function scrollLeft()
{
   var i=0;
   while(myDiv = document.getElementById("tab" + i))
   {
      myDiv.doScroll('left')
      i++;
   }
}

function scrollRight()
{
   var i=0;
   while(myDiv = document.getElementById("tab" + i))
   {
      myDiv.doScroll('right')
      i++;
   }
}

function startDown()
{
   clearInterval(window.movingInterval);
   window.movingInterval = setInterval("scrollLeft()", 30);
}

function stopDown()
{
   clearInterval(window.movingInterval);
}

function startUp()
{
   clearInterval(window.movingInterval);
   window.movingInterval = setInterval("scrollRight()", 30);
}

function stopUp()
{
   clearInterval(window.movingInterval);
}

function reposition()
{
   var totalWidth = document.body.offsetWidth;
   menuWidth = totalWidth - 47;

   var i=0;
   while(myDiv = document.getElementById("tab" + i))
   {
      myDiv.style.width = menuWidth;
      i++;
   }

}

function initMenu()
{
   reposition();
}

window.onresize = reposition;