// NOTE TO DEVELOPERS:
// -Documenation for MVED available in dev/MVStringEditor.inc
// -All methods contained in this file are PRIVATE and not support APIs
//
// Implementation notes
// mvse is object; reference is window.mv{$name}
// members: m_tb, m_list, and m_{property}
//
// Only 6 methods used outside this file:
// -first six methods; wrapped by dev.MVStringEditorScripts.inc
// -event handlers (ex mvieBlur) used by fw.MVStringEditorIE.inc


// Globals
mvPopup = window.createPopup();
var popStyle = mvPopup.document.body.style;
popStyle.cursor = "default";
popStyle.backgroundColor = "white";
popStyle.border = "1 solid black";
popStyle.fontSize = "11px";
popStyle.fontFamily = '"Trebuchet MS", Arial, Helvetica';
mvPopup.document.body.title = window.rc_mvieToolTip;


// should be called by every method that changes the values
// calls mvCallOnChange to notify anyone listening to the event
// packs up the values and puts them in the hidden field
function mvieOnChange(mvse)
{
   var list = getValuesAsArray(mvse);
   document.getElementById(mvse.m_name+"_packedValues").value = pack(list);

   mvCallOnChange(mvse);
}

// enables the control, so users can add items to the list
// called by mvEnable; programatic api
function mvieEnable(name)
{
   var mvse = eval("window.mv" + name);
   mvse.m_tb.disabled=false;
   mvse.m_disabled=false;
   document.getElementById(name+"ImgDown").style.display = "inline"; // show dropdown images
}

// disables the control, so users cannot add items to the list
// called by mvDisable; programatic api
function mvieDisable(name)
{
   var mvse = eval("window.mv" + name);
   mvse.m_tb.disabled=true;
   mvse.m_disabled = true;
   document.getElementById(name+"ImgDown").style.display = "none"; // hide dropdown images
}


// called by mvFocus; programatic api
function mvieFocus(mvse)
{
   if(mvse.m_disabled)
		return;
   mvieShowListUnderneath(mvse);
   mvieShowImage(mvse, "up");
   window.mvIgnoreFocus = false;
}


// called when the focus leaves the textbox
function mvieBlur(mvse)
{
   if(mvse.m_ignoreBlur)
   {
      return;
   }

   if(mvse.m_disabled) return;
   if(mvse.m_tb.value!="")
   {
      mvieSetValue(mvse);
   }

   mvieShowListInBox(mvse);
   mvieShowImage(mvse, 'down');
}

// callback from object selector
function mvieReturnFromOS(controlName, results)
{
   var mvse = eval("window.mv" + controlName);

   //----------------------------------------------
   // -improve the speed of checking for duplicates
   //  when returning from OS
   // -build has table to be used in isDuplicate
   //----------------------------------------------
   mvse.m_hash = new Array();
   for(var i=0; i<mvse.m_list.length; i++)
   {
      var key = (mvse.m_ignoreCase ? mvse.m_list[i].toLowerCase() : mvse.m_list[i]);
      mvse.m_hash[key] = 1;
   }

   for(var i=0;i<results.length;i++)
   {
      var dn = results[i];

      // special case: append treename to dn from Object selector
      if(mvse.m_useRootedName)
      {
         dn = dn + "." + mv_treeName;
      }

      // add if not dup
      if(!mvIsDuplicate(mvse, dn, true))
      {
         mvse.m_list[mvse.m_list.length] = dn;
      }
   }

   //----------------------------------------------
   // set the hash to null, so mvIsDuplicate won't use it.
   // reason: it can become invalid by adding or chaning list manually
   // Didn't wan't to change edit, add, and remove code to update hash
   //----------------------------------------------
   mvse.m_hash = null;
   mvieOnChange(mvse);
   mvieShowListInBox(mvse);
   
   if(mvse.m_tb.visible)
   {
      mvse.m_tb.focus();
   }
}

// Updates the icon of the double up arrow or double down arrow next to the textfield
function mvieShowImage(mvse, shouldDispaly)
{
	var name = mvse.m_name;
   document.getElementById(name+"ImgUp").style.display = (shouldDispaly=="up" ? "inline" : "none");
   document.getElementById(name+"ImgDown").style.display = (shouldDispaly=="up" ? "none" : "inline");
}

// Called when the user clicks on a row; We change the color to show it selected
function mvieSelectRow(name, rowindex)
{
   var mvse = eval("window.mv" + name);
   if(mvse.m_list.length==0) return;

   rowObj = mvPopup.document.getElementById("mved_row_"+rowindex);

   mvse.m_isEditing=false;
   mvse.m_tb.value="";
   mvse.m_selectedRow=rowindex;

   if(mvse.m_lastSelectedRow)
   {
      mvse.m_lastSelectedRow.style.backgroundColor='white';
      mvse.m_lastSelectedRow.style.color='black';
   }
   rowObj.style.backgroundColor='#0A246A';
   rowObj.style.color='white';

   mvse.m_lastSelectedRow=rowObj;
}

// called when user double clicks item
function mvieEditEntry(name, rowObj, rowIndex)
{

   var mvse = eval("window.mv" + name);
    if(mvse.m_disableEdit==true)
 	{
  		return; 
    }
   rowObj.style.backgroundColor='#c82727';
	mvse.m_tb.value = mvse.m_list[rowIndex];
   mvse.m_isEditing=true;
}

// When the textbox receives focus, we show the Popup underneath with the values
function mvieShowListUnderneath(mvse)
{
	if (document.body.readyState=="complete")
	{
      // build html for popup
   	var str = "<DIV style=\"width:100%;height:100%;overflow:auto\">\n<TABLE width=100% border=0 cellspacing=0 cellpadding=0>"
      for(var i=0; i < mvse.m_list.length; i++)
      {
         var rowStyle = (i==mvse.m_selectedRow ? "background-color:#0A246A;color:white" : "");
         str += "<TR id='mved_row_"+i+"' onMouseDown=\"parent.mvieSelectRow('"+mvse.m_name+"', "+i+");\" onDblClick=\"parent.mvieEditEntry('"+mvse.m_tb.name+"', this, "+i+");\" style=\""+rowStyle+"\"><TD nowrap style=\"font-size:11px\">&nbsp;" + toDisplay(mvse.m_list[i]) + "</TD></TR>\n";
      }
      str += "</TABLE></DIV>";
   	mvse.m_tb.value = "";
   	mvPopup.document.body.innerHTML = str;
		mvPopup.show(mvse.m_tb.offsetLeft,mvse.m_tb.offsetTop + 21,mvse.m_tb.offsetWidth-2,80,mvse.m_tb);
      mvse.m_lastSelectedRow = mvPopup.document.getElementById("mved_row_"+mvse.m_selectedRow);
	}
}

// Adds an item to the list form the textbox
// Called when the user hits enter
function mvieAdd(mvse)
{
   var selIndex = (mvse.m_isEditing ? mvse.m_selectedRow : -1);
   if(mvse.m_enforceUnique && mvIsDuplicate(mvse, mvse.m_tb.value, selIndex))
   {
		return false;
   }

   mvieAddValueAtFirst(mvse, mvse.m_tb.value);
   mvieOnChange(mvse);
}

// Moves all of the items down one and adds at top
function mvieAddValueAtFirst(mvse, value)
{
   mvse.m_list[mvse.m_list.length] = mvse.m_list[mvse.m_list.length-1];
   for(var j=mvse.m_list.length-2; j>=0; --j)
      mvse.m_list[j+1] = mvse.m_list[j];
   mvse.m_list[0] = mvedtrim.trim(value);
}

// Called when the user presses a key in the textfield or popup box
function mvieCheckKey(mvse)
{
   if(event.keyCode == 13)			// enter
   {

      if(!mvIsValidValue(mvse, mvse.m_tb.value))
      {
         return false;
      }

      mvieSetValue(mvse);
      mvieShowListUnderneath(mvse);
      return false;
   }
   else if(event.keyCode == 46 && !mvse.m_isEditing && mvse.m_tb.value=="")	// delete
   {
      if(mvse.m_tb.value=="" && mvse.m_list.length>0)
      {
         for(var i=mvse.m_selectedRow; i<mvse.m_list.length-1; i++)
         	mvse.m_list[i] = mvse.m_list[i+1];
         mvse.m_list.length = mvse.m_list.length-1;
         mvieShowListUnderneath(mvse);
         mvieOnChange(mvse);
      }
      return false;
   }
   else if(event.keyCode == 38)	// up arrow
   {
      if(mvse.m_selectedRow>0)
         mvieSelectRow(mvse.m_name, mvse.m_selectedRow-1);
      else
         mvieSelectRow(mvse.m_name, mvse.m_selectedRow);
   }
   else if(event.keyCode == 40)	// down arrow
   {
      if(mvse.m_selectedRow<mvse.m_list.length-1)
         mvieSelectRow(mvse.m_name, mvse.m_selectedRow+1);
      else
         mvieSelectRow(mvse.m_name, mvse.m_selectedRow);
   }
}

// called when editing value and press enter or blur
function mvieSetValue(mvse)
{

   if (mvse.m_isEditing)
   {
	   if(mvse.m_enforceUnique && mvIsDuplicate(mvse, mvse.m_tb.value, mvse.m_selectedRow))
	   {
			alert(window.rc_uniqueMsg);
			return false;
	   }

      if (mvse.m_tb.value!="")
         mvse.m_list[mvse.m_selectedRow] = mvedtrim.trim(mvse.m_tb.value);
      mvse.m_isEditing=false;
   }
   else if(mvse.m_tb.value!="")
   {
      mvieAdd(mvse);
   }
   mvieOnChange(mvse);
}

// sets the values in the list to values in packed string (str)
function mvieLoadFromPack(name, str)
{
   var mvse = eval("window.mv"+name);
   mvse.m_list = unpack(str);
   mvieShowListInBox(mvse);
   mvieOnChange(mvse);
}

// really just set moo mode
function mvieLoadFromXml(name,x,childName)
{
   initMooMode(name, x);
}