// Public Browser OV code -- can be called by the developer's javascript.  Developer must create
// an object which contains the following member variables.  Either the OV.control or OV.callBack
// parameter must be defined.

function doDynamicOV(userContext, OV)
{
   iman.debugOV("doDynamicOV: \nOV.mode="+OV.mode+"\nOV.advancedSelection="+OV.advancedSelection+"\nOV.multiSelect="+OV.multiSelect+"\nOV.typeFilter="+OV.typeFilter+"\nOV.typeFilterCnt="+OV.typeFilterCnt+"\nOV.typeFilterName="+OV.typeFilterName+"\nOV.typeFilterCrit="+OV.typeFilterCrit);
   //make sure we at least have default values for all parameters
   if (OV.advancedSelection==null)           OV.advancedSelection="";
   if (OV.initialContext==null)              OV.initialContext="";
   if (OV.mode==null)                        OV.mode="";
   if (OV.multiSelect==null)                 OV.multiSelect="";
   if (OV.nameFilter==null)                  OV.nameFilter="";
   if (OV.resultsPerPage==null)              OV.resultsPerPage="";
   if (OV.searchSubContainers==null)         OV.searchSubContainers="";
   if (OV.searchOnStartup==null)             OV.searchOnStartup="";
   if (OV.selectedType==null)                OV.selectedType="";
   if (OV.showSubClasses==null)              OV.showSubClasses=="";
   if (OV.typeFilter==null)                  OV.typeFilter="";
   if (OV.typeFilterCnt==null)               OV.typeFilterCnt="0";
   if (OV.typeFilterName==null)              OV.typeFilterName="";
   if (OV.typeFilterCrit==null)              OV.typeFilterCrit="";
   if (OV.typeFilterCallBack==null)          OV.typeFilterCallBack="";
   
   //call the private doOV routine
   doOV(userContext, 
        OV.advancedSelection,
        OV.initialContext,
        OV.mode, 
        OV.multiSelect, 
        OV.nameFilter,
        OV.resultsPerPage,
        OV.searchSubContainers,
        OV.searchOnStartup,
        OV.selectedType,
        OV.showSubClasses,  
        OV.typeFilter,
        OV.typeFilterCnt,
        OV.typeFilterName,
        OV.typeFilterCrit,
        OV.typeFilterCallBack);
}   
  
  
// Private Browser OV code -- not intended for eMFrame developer use.
// These apis are not public and are subject to change without notice. --> 
     
function doOV( userContext,         // user session context info
               advSel,              // opt - false (default) name-search only, true advanced selection criterion
               initialContext,      // opt - initial container to search from ([root] default)
               mode,                // opt - search (default)or browse
               multiSelect,         // opt - false (default) single select, true multi-select
               nameFilter,          // opt - initial name filter (* default)
               resultsPerPage,      // opt - number of objects to display at a time
               searchSubContainers, // opt - true (default) search subcontainers, false find objects in only the specified container
               searchOnStartup,     // opt - false (default) wait for user to click search button,
                                    //       true, search container on startup
               selectedType,        // opt - name of type which will be selected in type list
               showSubClasses,      // opt - true - base and derived classes found, false (default) - only base class found
               typeFilter,          // opt - type filter (all default)
               typeFilterCnt,       // opt - 0 if no advanced crition, 1 if advanced criterion
               typeFilterName,      // opt - name of type which has advance criterion
               typeFilterCrit,      // opt - advanced selection criterion
               typeFilterCallBack)  // opt - routine to return type filter
{
   var controlName="OV";
      
   //retrieve type filter from type filter callback, if a callback is specified
   if (exists(typeFilterCallBack))
   {
      typeFilter=eval(typeFilterCallBack+"('"+toScript(controlName)+"')");
   }
      
   //call the task's preOV function
   if (exists("preOV")) preOV(controlName);
         
   iman.debugOV("doOV: setting form values... \nOV.Mode="+mode+"\nOV.AdvancedSelection="+advSel+"\nOV.MultiSelect="+multiSelect+"\nOV.TypeFilter="+typeFilter+"\nOV.TypeFilter.cnt="+typeFilterCnt+"\nOV.TypeFilter.0.name="+typeFilterName+"\nOV.TypeFilter.0.crit="+typeFilterCrit);
   //set up optional object selector variables
   setOVFooterElementValue("OV.AdvancedSelection",advSel);
   setOVFooterElementValue("OV.InitialContext",initialContext);
   setOVFooterElementValue("OV.Mode",mode);
   setOVFooterElementValue("OV.MultiSelect",multiSelect); 
   setOVFooterElementValue("OV.NameFilter",nameFilter);
   setOVFooterElementValue("OV.ResultsPerPage",resultsPerPage);
   setOVFooterElementValue("OV.SearchSubContainers",searchSubContainers); 
   setOVFooterElementValue("OV.SearchOnStartup",searchOnStartup);
   setOVFooterElementValue("OV.ShowSubClasses",showSubClasses);
   setOVFooterElementValue("OV.TypeFilter",typeFilter);
   setOVFooterElementValue("OV.TypeFilter.cnt",typeFilterCnt);
   setOVFooterElementValue("OV.TypeFilter.0.name",typeFilterName);
   setOVFooterElementValue("OV.TypeFilter.0.crit",typeFilterCrit);
   setOVFooterElementValue("OV.SelectedType",selectedType);
   setOVFooterElementValue("OV.TypeFilter",typeFilter);
      
   //set up webaccess object selector values
   setOVFooterElementValue("User.context",userContext);
   setOVFooterElementValue("taskId","fw.ObjectView");
   setOVFooterElementValue("merge","fw.OV.ObjectViewPanel");
   setOVFooterElementValue("error","dev.GenErr");
      
   //submit
   document.OVFooterPostData.submit();
}

//set the named element in the OVFooterPostData form to the specified value
function setOVFooterElementValue(elementName, elementValue)
{
   iman.debugOV("in "+document.title+"::setOVFooterElementValue("+elementName+", "+elementValue+")");

   if (elementName!=null && elementName.length>0)
   {
      var currentFormElement = document.OVFooterPostData.elements[elementName];
      if(currentFormElement)
      {
      	currentFormElement.value = elementValue;
      }else{
      		iman.debugOV("could not find '"+elementName+"' in OVFooterPostData form in "+document.title+".  Looking with the old code.");
	      for (var j=0; j<document.OVFooterPostData.elements.length; j++)
	      {
	         if (document.OVFooterPostData.elements[j].name == elementName)
	         {
	            iman.debugOV("Found with the old code -- setOVFooterElementValue: "+elementName+" = "+elementValue );
	            document.OVFooterPostData.elements[j].value = elementValue;
	            return;
	         }
	      }
      }
   }
   //alert("setOVFooterElementValue: couldn't find "+elementName);
}

function switchMultiSelectMode(OVWin,userContext,newSelectMode)
{
   //save new multiselect mode
   OVWin.m_multiSelect = newSelectMode;
      		
   var OV=new Object();
   OV.initialContext			=	OVWin.m_container;
   OV.advancedSelection		=	OVWin.m_advSel;
   OV.mode						=	OVWin.m_mode;
   OV.multiSelect				=	OVWin.m_multiSelect;
   OV.nameFilter				=	OVWin.m_nameFilter;
   OV.resultsPerPage			=	OVWin.m_resultsPerPage;
   OV.searchSubContainers	=	OVWin.m_searchSubContainers;
   OV.searchOnStartup		=	OVWin.m_searchOnStartup;
   OV.selectedType         =  OVWin.m_selectedType;
   OV.showSubClasses			=	OVWin.m_showSubClasses;
   OV.typeFilter				=	OVWin.m_initialTypeFilter;
   OV.typeFilterCallBack	=	"";
   OV.typeFilterCnt        =  "0";
   OV.typeFilterName       =  "";
   OV.typeFilterCrit       =  "";
   
   //get advanced typeFilter criterion, if defined
   //alert("switchMultiSelectMode:  \nadvMode = "+OVWin.m_advSel+"("+OVWin.isAdvSelMode()+")\nselectedType = "+OVWin.m_selectedType);
   if (OVWin.isAdvSelMode())
   {
      var i = OVWin.getTypeIdx(OVWin.m_selectedType);
      //alert("switchMultiSelectMode: \ni = "+i+"\ncrit = "+OVWin.m_types[i][2]);
      if (i!=-1 && OVWin.m_types[i][2]!=null && OVWin.m_types[i][2].length>0)
      {
         //advanced criterion
         //alert("switchMultiSelectMode: saving advanced selection criterion...\ni = "+i+"\nname = "+OVWin.m_types[i][1]+"\ncrit = "+OVWin.m_types[i][2]);
         OV.typeFilterCnt="1";
         OV.typeFilterName=OVWin.m_types[i][1];
         OV.typeFilterCrit=OVWin.m_types[i][2];
      }
   }
   /*
   alert("switchMultiSelectMode: "+
            "\nOV.initialContext = "+OV.initialContext+
            "\nOV.advancedSelection = "+OV.advancedSelection+
            "\nOV.mode = "+OV.mode+
            "\nOV.multiSelect = "+OV.multiSelect+
            "\nOV.nameFilter = "+OV.nameFilter+
            "\nOV.resultsPerPage = "+OV.resultsPerPage+
            "\nOV.searchSubContainers = "+OV.searchSubContainers+
            "\nOV.searchOnStartup = "+OV.searchOnStartup+
            "\nOV.selectedType = "+OV.selectedType+
            "\nOV.showSubClasses = "+OV.showSubClasses+
            "\nOV.typeFilter = "+OV.typeFilter+
            "\nOV.typeFilterCallBack = "+OV.typeFilterCallBack+
            "\nOV.typeFilterCnt = "+OV.typeFilterCnt+
            "\nOV.typeFilterName = "+OV.typeFilterName+
            "\nOV.typeFilterCrit = "+OV.typeFilterCrit);
   */
   
   doDynamicOV(userContext,OV);
}