// This function will parse the file system volume Name and path from the file system string
// fileSystemString = <fs>\\OES-SP5-35\SYS:homedir\fred</fs>.OES-SP5-35_SYS.lab
// return = SYS:homedir\fred
function getFileSystemVolumeNameAndPath(fileSystemString)
{
	var retStr = "";
	var subString1 = "<fs>\\\\";
	var subString2 = "</fs>";
	var subString3 = "\\";
	var subStringLength1 = subString1.length;
	var subStringLength3 = subString3.length;
       		
	var index1 = fileSystemString.indexOf(subString1);
	var index2 = fileSystemString.indexOf(subString2);
	if((index1 != -1) && (index2 != -1))
	{
		var serverVolume = fileSystemString.substring(index1+subStringLength1, index2);
		var length = serverVolume.length;
		index1 = serverVolume.indexOf(subString3);
		if(index1 != -1)
		{
			retStr = serverVolume.substring(index1+subStringLength3, length);
		}
	}
 
	return retStr;
}

// This function will parse the file system volume name from the file system string
// fileSystemString = <fs>\\OES-SP5-35\SYS:homedir\fred</fs>.OES-SP5-35_SYS.lab
// return = SYS:
function getFileSystemVolumeName(fileSystemString)
{
	var retStr = "";
	var subString1 = "<fs>\\\\";
	var subString2 = ":";
	var subString3 = "\\";
	var subStringLength1 = subString1.length;
	var subStringLength2 = subString2.length;
	var subStringLength3 = subString3.length;
       		
	var index1 = fileSystemString.indexOf(subString1);
	var index2 = fileSystemString.indexOf(subString2);
	if((index1 != -1) && (index2 != -1))
	{
		var serverVolume = fileSystemString.substring(index1+subStringLength1, index2+subStringLength2);
		var length = serverVolume.length;
		index1 = serverVolume.indexOf(subString3);
		if(index1 != -1)
		{
			retStr = serverVolume.substring(index1+subStringLength3, length);
		}
	}
 
	return retStr;
}

// This function will parse the file system path from the file system string
// fileSystemString = <fs>\\OES-SP5-35\SYS:homedir\fred</fs>.OES-SP5-35_SYS.lab
// return = homedir\fred or empty string if no path
function getFileSystemPath(fileSystemString)
{
	var retStr = "";
	var subString = ":";
	var subString2 = "</fs>.";
	var subStringLength = subString.length;
	var index = fileSystemString.indexOf(subString);
	var index2 = fileSystemString.indexOf(subString2);
	if((index != -1) && (index2 != -1))
	{
		retStr = fileSystemString.substring(index+subStringLength, index2);
	}
      		
	return retStr;
}
 	  
// This function will parse the volume object from the file system string
// fileSystemString = <fs>\\OES-SP5-35\SYS:homedir\fred</fs>.OES-SP5-35_SYS.lab
// return = OES-SP5-35_SYS.lab
function getVolumeObject(fileSystemString)
{
	var retStr = "";
	var length = fileSystemString.length;
	var subString = "</fs>.";
	var subStringLength = subString.length;
	var index = fileSystemString.indexOf(subString);
	if(index == -1)
	{
		// Did not find the file system seperator just return the original string
		retStr = fileSystemString;
	}
	else
	{
		retStr = fileSystemString.substring(index+subStringLength, length);
	}
      		
	return retStr;
}
