<!-- xsl includes to support tasks written for Browser mode devices (IE) -->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

   <!-- includes -->
   <xsl:include href="../default/PageTemplates.xsl"/>          <!-- so it will be include on each request-->
   <xsl:include href="../default/MVStringEditor.xsl"/>         <!-- so it will be include on each request-->
   
   <!-- Object Selector includes -->
   <xsl:include href="OS_inc.xsl" />                <!-- used to put an Object Selector button on the page -->
   <xsl:include href="OSBtn_inc.xsl" />             <!-- used to put an HTML-style Object Selector button on the page -->
   <xsl:include href="OSLink_inc.xsl" />            <!-- used to put an Object Selector HTML link on the page -->
   <xsl:include href="OSScripts_inc.xsl" />         <!-- javascript to support Object Selector -->
   <xsl:include href="OSFooter_inc.xsl" />          <!-- Object Selector HTML form used to return selected object to task -->

   <xsl:template match="OS.ReturnedData"/>
   
   <!-- eMFrameScripts_inc.jsp   -->
   <xsl:template name="eMFrameScripts">
      <!-- browser xml/xsl implementation of eMFrameScripts_inc.jsp -->
      <script>
         BrowserCharset='utf-8';
		   ParentWindowChangedErrorAlertMessage = '<xsl:call-template name="toScript"><xsl:with-param name="theString" select="$dev.ParentWindowChangedErrorAlertMessage"></xsl:with-param></xsl:call-template>';
         fw_modulesPath = "<xsl:value-of select="/PortalData/modulesPath"/>";
         fw_lang = "<xsl:value-of select="/PortalData/SessionInfo/CurrentLocale"/>";
         fw_isDebugEnabled = <xsl:value-of select="/PortalData/isDebugEnabled"/>;
         fw_taskId = "fw_taskIdNotImplementedInInclude.xsl";

         //exists() returns true is object identified by string s
         //exists in the same scope (is a peer of) this routine
         function exists(s)
         {
         <!-- {IF find(Browser.id, "Windows CE") == -1} -->
            var ret=false;
            if (s!=null &amp;&amp; s.length>0)
            {
               try
               {
                  eval(s);
                  ret=true;
               }
               catch(e)
               {
               }
            }
         <!-- {ELSE}
            var ret=false;
            if (s!=null && s.length>0)
            {
               var f = eval(s);
               if (f)
               {
                  ret=true;
               }
            }
         {ENDIF} -->
            return ret;
         }

      </script>

      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/BrowserVersions.js"></script>
      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/eMFrameScripts.js"></script>
   </xsl:template>
   
<!-- bar implementation   -->  
   <xsl:template name="bar">
      <HR color="#6B8899" size="2"></HR>
   </xsl:template>

<!-- cancel implementation   --> 
   <xsl:template name="cancel">
      <xsl:param name="taskId"/>

      <xsl:text> </xsl:text>
      <A href="webacc?NPService=fw.LaunchService&amp;NPAction=Return&amp;returnID={$taskId}&amp;test=test2">
         <IMG name="Cancel" alt="Cancel" src="{$Portal.ResourcePath}/modules/dev/images/en/btncancel_en.gif" border="0"></IMG>
      </A>
   </xsl:template>

<!-- target chooser scripts   --> 
   <xsl:template name="target-chooser-scripts">
      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/TC.js"></script>
   </xsl:template>

<!-- target chooser implementation   --> 
   <xsl:template name="target-chooser">
      <xsl:param name="TC.advancedSelectionEnabled" select="false"/>    <!--allows user to choose filter (instead of selecting specific objects)-->
      <xsl:param name="TC.multipleObjectEnabled" select="false"/>       <!--allows user to select multiple objects-->
      <xsl:param name="TC.initialValue"/>
      <xsl:param name="TC.controlName">eDir$target</xsl:param>          <!--this key in HttpRequest will contain the target; (default=eDir$target)-->
      <xsl:param name="TC.prompt"/>                                     <!--optional; prompt to show to user-->
      <!-- REMIND: update prompt -->

      <!--   {IF TC.prompt==""}-->
      <!--      {SET TC.prompt=TC.defaultPrompt}-->
      <!--   {ENDIF}-->


      <!-- ********************************************** -->
      <!-- tc documentation                               -->
      <!-- ********************************************** -->
      <!--
       Must include TC.js to use this widget
         Consumer Paramaters: See param list above.

         Consumer must call eMFrameUtils.setupTargetChooser(context, resultStrings, String[] objectTypeNames)
         Consumer should call TaskContext.addToHistory() from the Java code after a valid object is chosen
         Consumer template must import DevResources
         Consumer template must call validateTargetChooser() in javascript onExit

         Implementation Notes
           Parameters from setupTargetChooser:
             -TC.defaultPrompt
             -TC.packedObjectTypeNames
             -TC.osTypeFilter
       -->



   <xsl:variable name="tc_gadgetRoot" select="ancestor::Gadget"></xsl:variable>
   <xsl:variable name="tc_systemData" select="$tc_gadgetRoot//system-data"></xsl:variable>


   <!-- vars and strings used in tc.js; need to move to javascript vars -->
   <SCRIPT>
      <!-- save vars to be used in js file -->
      window.tc_packedObjectTypeNames = "<xsl:value-of select="$tc_systemData/TC.packedObjectTypeNames"/>";
      window.tc_controlName = "<xsl:value-of select="$TC.controlName"/>";

      <!--General.validObjectTypes-->
      <!--General.NeedsObjectName-->
      <!--TC.advancedFilterSet-->
      <!--TC.mustHaveContainer-->
      <!--TC.performingPreview-->
      <!--TC.noFilter-->
   </SCRIPT>


   <INPUT type="hidden" name="{$TC.controlName}" value="{$TC.initialValue}"/>
   <INPUT type="hidden" name="TC.packRealObjectClassNames" value="{$tc_systemData/TC.packRealObjectClassNames}"/>  <!-- Just passing along for edas validation -->
   <INPUT type="hidden" name="targetType" value=""/>

   <!-- ********************************************** -->
   <!-- Single Select                                  -->
   <!-- ********************************************** -->
   <DIV id="singleSelect" style="display:block">

      <!-- tab bar -->
      <xsl:if test="$TC.multipleObjectEnabled=true or $TC.advancedSelectionEnabled=true">
         <TABLE border="0" cellpadding="0px" cellspacing="1px" bgcolor="#BBBBBB"><TR><TD style="background-color:#EEEEEE;font-size:0.7em">
            &#xa0;<xsl:value-of select="$dev.General.selectSingle"/>
               <xsl:if test="$TC.multipleObjectEnabled=true">
                  <SPAN style="color:#BBBBBB">&#xa0;|&#xa0;</SPAN><A href="#" onClick="setDisplay('multiSelect');document.forms[0].multipleListTB.focus();"><xsl:value-of select="$dev.General.selectMultiple"/></A>
               </xsl:if>
            <xsl:if test="$TC.advancedSelectionEnabled=true">
               <SPAN style="color:#BBBBBB">&#xa0;|&#xa0;;</SPAN><A href="#" onClick="setDisplay('advancedSelection');" ><xsl:value-of select="$dev.General.advancedSelection"/></A>
            </xsl:if>
            &#xa0;
         </TD></TR></TABLE><BR/>
      </xsl:if>

      <!-- prompt -->
      <xsl:if test="$TC.prompt=true">
         <NOBR>
            <xsl:value-of select="$tc_systemData/TC.defaultPrompt"/>
            <xsl:if test="$tc_systemData/TC.packedObjectTypeNames != ''">(<A href="Javascript: showList();"><xsl:value-of select="$dev.TC.seeList"/></A>)</xsl:if>:
         </NOBR><BR/>
      </xsl:if>

      <!-- textbox, and os -->
      <TABLE cellpadding="0" cellspacing="0">
      <TR>
         <TD><INPUT type="text" name="single" value="{$TC.initialValue}" size="{$dev.UI.textboxSize}" style="width:{$dev.UI.textboxPixel}"/>

            <xsl:call-template name="OS">
               <xsl:with-param name="OS.Control">single</xsl:with-param>
               <xsl:with-param name="OS.Mode">Browse</xsl:with-param>
               <xsl:with-param name="OS.TypeFilter">*</xsl:with-param>    <!-- REMIND: {SET OS.TypeFilter=TC.osTypeFilter} -->
               <xsl:with-param name="OS.History">true</xsl:with-param>
            </xsl:call-template>
         </TD>
      </TR>
      </TABLE>
   </DIV>

   <!-- ********************************************** -->
   <!-- Multi Select                                   -->
   <!-- ********************************************** -->
<!--   <DIV id="multiSelect" style="display:none">
      <TABLE border="0" cellpadding="0px" cellspacing="1px" bgcolor="#BBBBBB"><TR><TD style="background-color:#EEEEEE;font-size:0.7em">
         &nbsp;<A href="#" onClick="setDisplay('singleSelect');document.forms[0].single.focus();">{STRING General.selectSingle}</A>
         &nbsp;|&nbsp;{STRING General.selectMultiple}
         {IF TC.advancedSelectionEnabled=="true"}<SPAN style="color:#BBBBBB">&nbsp;|&nbsp;</SPAN><A href="#" onClick="setDisplay('advancedSelection');">{STRING General.advancedSelection}</A>{ENDIF}&nbsp;
      </TD></TR></TABLE>
      <BR>

      {IF showObjectTypeSelectionInMultiSelect=="true" && TC.baseObjectTypes.count>1}
         {STRING TC.selectObjectClass}<BR>
         <SELECT name="multiTargetType" style="width:{STRING UI.textboxPixel}">
            {SET i=0}
            {WHILE i<TC.baseObjectTypes.count}
            <OPTION value="{VAR TC.baseObjectTypes[i]}" {IF TC.baseObjectTypes[i]=="User"}selected{ENDIF}>{VAR TC.baseObjectTypes[i]}
            {INC i}
            {ENDWHILE}
         </SELECT><BR/><BR/>

         {SET OS.TypeFilterCallBack="myTypeFilerCallBack"}
      {ELSE}
         <INPUT type="hidden" name="multiTargetType" value="{VAR TC.baseObjectTypes[0]}">
      {ENDIF}


      <NOBR>{VAR toDisplay(TC.prompt)}: {IF TC.packedObjectTypeNames != ""}(<A href="Javascript: showList();">{STRING TC.seeList}</A>){ENDIF}</NOBR><BR/>


      {SET MVStringEditor.name = "multipleList"}
      {SET MVStringEditor.fixedHeight = "10"}
      {SET MVStringEditor.dnMode = "true"}
      {SET MVStringEditor.objectTypeName=TC.osTypeFilter}
      {SET MVStringEditor.enforceUnique="true"}
      {SET MVStringEditor.history="true"}
      {SET MVStringEditor.mode = "pocket"}
      {INCLUDE ../dev/MVStringEditor.inc}
   </DIV>-->


   <!-- ********************************************** -->
   <!-- Advanced Selection                             -->
   <!-- ********************************************** -->
<!--
   <DIV id="advancedSelection" style="display:none">
      <TABLE border="0" cellpadding="0px" cellspacing="1px" bgcolor="#BBBBBB"><TR><TD style="background-color:#EEEEEE;font-size:0.7em">
         &nbsp;<A href="#" onClick="setDisplay('singleSelect');document.forms[0].single.focus();">{STRING General.selectSingle}</A>
         {IF TC.multipleObjectEnabled=="true"}<SPAN style="color:#BBBBBB">&nbsp;|&nbsp;</SPAN><A href="#" onClick="setDisplay('multiSelect');document.forms[0].multipleListTB.focus();">{STRING General.selectMultiple}</A>{ENDIF}
         &nbsp;|&nbsp;{STRING General.advancedSelection}&nbsp;
      </TD></TR></TABLE>
      <BR>

      <INPUT type="hidden" name="advancedSelectionXML">

      <TABLE cellpadding="0" cellspacing="0">

      {IF TC.showObjectTypeSelectionInAdvancedSelect=="true" && TC.baseObjectTypes.count>1}
         <TR><TD class="mediumtext">{STRING toDisplay(TC.objectClass)}</TD></TR>
         <TR>
            <TD>
               <SELECT name="asTargetType" style="width:{STRING UI.textboxPixel}" onChange="clearFilter()">
                  {SET i=0}
                  {WHILE i<TC.baseObjectTypes.count}  // remove white space
                  <OPTION value="{VAR TC.baseObjectTypes[i]}" {IF TC.baseObjectTypes[i]=="User"}selected{ENDIF}>{VAR TC.baseObjectTypes[i]}
                  {INC i}
                  {ENDWHILE}
               </SELECT>
            </TD>
         </TR>
         <TR><TD height="8px"></TD></TR>
      {ELSE}
         <INPUT type="hidden" name="asTargetType" value="{VAR TC.baseObjectTypes[0]}">
      {ENDIF}

      <TR><TD class="mediumtext">{STRING toDisplay(TC.container)}</TD></TR>
      <TR>
         <TD>
            <INPUT name="container" type="text" value="" size="{STRING PocketUI.textboxSize}" style="width:{STRING UI.textboxPixel}" onKeyPress="if(event.keyCode==13) return false">
            {SET OS.Control="container"}
            {SET OS.TypeFilter="[containers],[root]"}
            {SET OS.History="true"}
            {INCLUDE ../dev/OS.inc}
         </TD>
      </TR>
      <TR><TD height="2px"></TD></TR>

      <TR><TD class="mediumtext">&nbsp;&nbsp;&nbsp;&nbsp;<INPUT type="checkbox" name="subContainerSearch" checked>{STRING toDisplay(TC.searchSubContainer)}</TD></TR>
      <TR><TD height="8px"></TD></TR>

      <TR><TD class="mediumtext">{STRING toDisplay(TC.filter)}</TD></TR>
      <TR>
         <TD>
            <INPUT name="filterSet" type="text" value="{STRING toTag(TC.noFilter)}" size="{STRING PocketUI.textboxSize}" style="width:{STRING UI.textboxPixel};" readonly>
            {SET AS.Control="advancedSelectionXML"}
            {SET AS.ControlCallBack="saveXML"}
            {SET AS.TypesCallBack="myASTypeFilerCallBack"}
            {INCLUDE ../dev/AS.inc}
         </TD>
      </TR>
      <TR><TD height="8px"></TD></TR>

      <TR><TD class="mediumtext"><A href="#" onClick="preview()">{STRING toDisplay(TC.showPreview)}</A></TD></TR>

      </TABLE><BR>

      <HR noshade size="1"><BR>

      {STRING toDisplay(TC.preview)}<BR>
      <IFRAME src="webacc?taskId=dev.Empty&merge=fw.Empty&User.context={VAR User.context}" name="previewFrame" id="previewFrame" style="width:393px"></IFRAME><BR>

      <IMG id="backButton" onClick="movePreview('previewPrevious', this)" src="{$Portal.ResourcePath}/modules/dev/images/btnback_palm_dis.gif" border="0" alt="{STRING Button.Back.alt}" title="{STRING Button.Back.alt}">
      <IMG id="nextButton" onClick="movePreview( 'previewNext', this)" src="{$Portal.ResourcePath}/modules/dev/images/btnnext_palm_dis.gif" border="0" alt="{STRING Button.Next.alt}" title="{STRING Button.Next.alt}"><BR><BR>
   </DIV>
-->

   </xsl:template>

   
   <xsl:template match="SessionInfo">
      <!-- empty -->
   </xsl:template>
   

   <xsl:template name="task-header">
      <xsl:param name="TaskHeader.title">MyTask</xsl:param> <!-- default value should be Common.ProductName-->
      <xsl:param name="TaskHeader.bgcolor">#ffffff</xsl:param>
      <xsl:param name="TaskHeader.iconUrl"></xsl:param>
      <xsl:param name="TaskHeader.iconAlt"></xsl:param>
      <xsl:param name="TaskHeader.helpFile"></xsl:param>

      <xsl:variable name="TaskHeader.cellpadding">
         <xsl:choose>
            <xsl:when test="data/globals/Browser.name='MVIE'">3</xsl:when>
            <xsl:otherwise>0</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>


      <!--{INCLUDE HelpScripts.inc}-->

      <SCRIPT>
         function showHelpWindow()
         {
            launchHelp('<xsl:value-of select="$TaskHeader.helpFile"></xsl:value-of>');
         }

      </SCRIPT>

      <!-- xsl:choose>
      	<xsl:when test="/data/globals/User.interface='browser'" -->
      <TABLE style="margin-top:0" width="100%" border="0" cellspacing="0" cellpadding="{$TaskHeader.cellpadding}">
         <TR bgcolor="{$TaskHeader.bgcolor}" height="12">
            <TD>
            </TD>
         </TR>
         <TR bgcolor="{$TaskHeader.bgcolor}">
            <TH class="head3b" height="19" align="left">
               <xsl:if test="$TaskHeader.iconUrl!=''">
                  <IMG src="{$TaskHeader.iconUrl}" alt="{$TaskHeader.iconAlt}" border="0"></IMG><xsl:text> </xsl:text>
               </xsl:if>
               <xsl:value-of select="$TaskHeader.title"/>
            </TH>
            <TH class="head3b" height="19" align="right">
               <xsl:choose>
                  <xsl:when test="$TaskHeader.helpFile!=''"><xsl:call-template name="help-icon"><xsl:with-param name="Help.file"><xsl:value-of select="$TaskHeader.helpFile"/></xsl:with-param></xsl:call-template></xsl:when>
                  <xsl:otherwise><!-- &nbsp; --></xsl:otherwise>
               </xsl:choose>
            </TH>
         </TR>
      </TABLE>
      <!-- /xsl:when>
      <xsl:otherwise>
         <TABLE bgcolor="{$TaskHeader.bgcolor}" width="100%" border="0" cellspacing="0" cellpadding="0">
         <TR>
            <TD height="4"></TD>
         </TR>
         <TR>
            <TD>
               <xsl:if test="$TaskHeader.iconUrl!=''">
                  <IMG src="{$TaskHeader.iconUrl}" alt="{$TaskHeader.iconAlt}" border="0"></IMG>
               </xsl:if>
              <FONT size="+1" face="'Trebuchet MS', Arial, Helvetica, Geneva, Swiss, SunSans-Regular"><xsl:value-of select="$TaskHeader.title"></xsl:value-of></FONT>
              <HR noshade="true" size="2" color="#458ab9"></HR>
            </TD>
         </TR>
         </TABLE>
      </xsl:otherwise>
   </xsl:choose -->
   </xsl:template>
   

   <xsl:template name="help-scripts">

      <script>
        function launchHelp(helpFile)
        {
           if(helpFile!="")
           {
               var slashIndex = helpFile.indexOf("/");
               if(slashIndex == -1 || slashIndex == helpFile.length - 1)
               {
                  return;
               }
               var module = helpFile.substring(0, slashIndex);
               var page = helpFile.substring(slashIndex + 1, helpFile.length);
               var w=window.open('<xsl:value-of select="$Portal.ResourcePath"/>/modules/' + module + '/help/<xsl:value-of select="/PortalData/SessionInfo/CurrentLocale"/>/' + page, "<xsl:value-of select="$dev.Help.WindowName"/>", 'toolbar=no,location=no,directories=no,menubar=yes,scrollbars=yes,resizable=yes,width=<xsl:value-of select="$dev.Help.WindowWidth"/>,height=<xsl:value-of select="$dev.Help.WindowHeight"/>');
               if(w != null)
               {
                  w.focus();
               }
           }
        }
      </script>
   </xsl:template>
   

	<xsl:template name="help-icon">
        <xsl:param name="Help.file" />

        <a href="javascript:launchHelp('{$Help.file}');">
            <img name="Help" alt="{$dev.Button.Help.alt}" title="{$dev.Button.Help.alt}" src="{$Portal.ResourcePath}/modules/dev/images/help_16.gif" border="0" />
        </a>
	</xsl:template>
   

	<xsl:template name="Spacer2px">
	   <IMG src="{$Portal.ResourcePath}/modules/fw/images/1px_spacer.gif" width="2" border="0"/>
	</xsl:template>
   

	<xsl:template name="ValidateIntegerScripts">
	   <SCRIPT language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/ValidateInteger.js"></SCRIPT>
	   <SCRIPT language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/ValidateHex.js"></SCRIPT>

	   <SCRIPT>
		   window.rc_invalidNumberMsg  = "<xsl:value-of select="$dev.Widgets.integerOutOfBounds"/>";
		   window.rc_invalidStringLengthMsg  = "<xsl:value-of select="$dev.Widgets.invalidLengthOfString"/>";
		   window.rc_invalidExactStringLengthMsg  = "<xsl:value-of select="$dev.Widgets.invalidExactLengthOfString"/>";
	   </SCRIPT>
	</xsl:template>
   

	<xsl:template name="OctetStringEditorScripts">
		  <script>
			  window.osWidth=<xsl:value-of select="$dev.OS.Browser.WindowWidth"/>;
			  window.osHeight=<xsl:value-of select="$dev.OS.Browser.WindowHeight"/>;
		  </script>

		  <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/OctetStringTextBox.js"></script>
		  <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/MVStringEditor.js"></script>
   </xsl:template>
   

	<xsl:template name="OctetStringEditorLink">
	   <xsl:param name="OctetStringEditor.formName">forms[0]</xsl:param>
	   <xsl:param name="OctetStringEditor.name"/>

      <a href="#" onClick="javascript:OctetStringEdit(document.{$OctetStringEditor.formName}.{$OctetStringEditor.name},'document.{$OctetStringEditor.formName}.{$OctetStringEditor.name}');">
      <img alt="{$dev.Button.OS.alt}" title="{$dev.Button.OS.alt}" src="{$Portal.ResourcePath}/modules/dev/images/iconedit.gif" border="0" align="absmiddle"/></a>
	</xsl:template>
   

	<xsl:template name="MVOctetStringEditor">
		<xsl:param name="MVOctetStringEditor.formName">forms[0]</xsl:param>
	   <xsl:param name="MVOctetStringEditor.width">{$dev.UI.textboxPixel} - 2}</xsl:param>
	   <xsl:param name="MVOctetStringEditor.bgColor">white</xsl:param>
	   <xsl:param name="MVOctetStringEditor.readonly">false</xsl:param>
	   <xsl:param name="MVOctetStringEditor.mode"/>
	   <xsl:param name="MVOctetStringEditor.name"/>

		  <TABLE bgcolor="{$MVOctetStringEditor.bgColor}">
			  <TR>
				  <TD>
					  <SELECT name="{$MVOctetStringEditor.name}" width="{$MVOctetStringEditor.width}" height="200" style="width:{$MVOctetStringEditor.width}"/>
				  </TD>

		  <xsl:if test="$MVOctetStringEditor.readonly!='true'">
				  <TD>
					 <a href="javascript:MVOctetStringAdd('document.{$MVOctetStringEditor.formName}.{$MVOctetStringEditor.name}');"><img src="{$Portal.ResourcePath}/modules/dev/images/iconadd.gif" border="0"/></a>
				  </TD>
				  <TD>
					 <a href="javascript:mvselRemove(document.{$MVOctetStringEditor.formName}.{$MVOctetStringEditor.name});"><img src="{$Portal.ResourcePath}/modules/dev/images/iconremove.gif" border="0"/></a>
				  </TD>
		     <xsl:if test="$MVOctetStringEditor.mode!='DN'">
				  <TD>
					 <a href="javascript:MVOctetStringEdit(document.{$MVOctetStringEditor.formName}.{$MVOctetStringEditor.name},'document.{$MVOctetStringEditor.formName}.{$MVOctetStringEditor.name}');"><img src="{$Portal.ResourcePath}/modules/dev/images/iconedit.gif" border="0"/></a>
				  </TD>
			  </xsl:if>
		  </xsl:if>
			  </TR>
		  </TABLE>
   </xsl:template>
   

	<xsl:template name="form-header">
        <xsl:param name="FormHeader.title"/>
        <xsl:param name="FormHeader.helpFile"/>

        <TABLE width="100%" border="0" cellspacing="0" cellpadding="3">
           <TR>
              <TH bgcolor="#458ab9" colspan="2" height="19"><DIV align="left" class="formhead1"><font color="#FFFFFF"><B><xsl:value-of select="$FormHeader.title"/></B></font></DIV></TH>
              <TD width='4%' class="formhead1" height="26"><DIV align="right" class="formhead1"><xsl:if test="$FormHeader.helpFile!=''"><xsl:call-template name="help-icon"><xsl:with-param name="Help.file"><xsl:value-of select="$FormHeader.helpFile"/></xsl:with-param></xsl:call-template></xsl:if></DIV></TD>
           </TR>
        </TABLE>
    </xsl:template>
   

   <xsl:template name="wizard-header">
        <xsl:param name="WizardHeader.title"/>
        <xsl:param name="WizardHeader.subtitle"/>
        <xsl:param name="WizardHeader.helpFile"/>
        <xsl:param name="WizardHeader.instruction"/>

        <TABLE width="100%" border="0" cellspacing="0" cellpadding="3">
            <TR>
                <TH bgcolor="#458ab9" colspan="2" height="19"><DIV align="left" class="formhead1"><font color="#FFFFFF"><B><xsl:value-of select="$WizardHeader.title"/></B></font></DIV></TH>
                <TD width='4%' class="formhead1" height="26"><DIV align="right" class="formhead1"><xsl:if test="$WizardHeader.helpFile!=''"><xsl:call-template name="help-icon"><xsl:with-param name="Help.file"><xsl:value-of select="$WizardHeader.helpFile"/></xsl:with-param></xsl:call-template></xsl:if></DIV></TD>
            </TR>
            <TR bgcolor="#EFEEE9">
                <TD height="16" align="center" valign="middle"><img src="{$Portal.ResourcePath}/modules/fw/images/wizard_on.gif" width="24" height="23" border="0" align="middle"/></TD>
                <TD height="16" align="left" valign="middle" width="100%" class="mediumtext"><B><xsl:value-of select="$WizardHeader.subtitle"/></B> <xsl:if test="$WizardHeader.instruction!=''"><xsl:value-of select="$WizardHeader.instruction"/></xsl:if></TD>
                <TD height="16" align="left" valign="middle" class="tablesubhead1"></TD>
            </TR>
            <TR>
                <TD height="16" align="center" valign="middle"> </TD>
           </TR>
        </TABLE>
    </xsl:template>
   
	<xsl:template name="toScript">
		<xsl:param name="theString"/>
		<xsl:if test="normalize-space($theString)">
			<xsl:call-template name="processString">
				<xsl:with-param name="theCharater" select="substring($theString, 1, 1)"/>
				<xsl:with-param name="theString" select="substring($theString, 2)"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template name="processString">
		<xsl:param name="theCharater"/>
		<xsl:param name="theString"/>

		<xsl:call-template name="processCharacter">
			<xsl:with-param name="theChar" select="$theCharater"/>
		</xsl:call-template>

		<xsl:choose>
			<xsl:when test="string-length($theString) &gt; 0">
				<xsl:call-template name="processString">
					<xsl:with-param name="theCharater" select="substring($theString, 1, 1)"/>
					<xsl:with-param name="theString" select="substring($theString, 2)"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<!-- all done -->
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="processCharacter">
		<xsl:param name="theChar"/>

		<xsl:variable name="apos">'</xsl:variable>
		<xsl:choose>
			<!-- check for ' -->
			<xsl:when test="contains($theChar, $apos)">\&apos;</xsl:when>
			<!-- check for \ -->
			<xsl:when test="$theChar='\'">\\</xsl:when>
			<!-- check for " -->
			<xsl:when test="$theChar='&quot;'">\&quot;</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$theChar"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet><!-- Stylus Studio meta-information - (c)1998-2002 eXcelon Corp.
<metaInformation>
<scenarios/><MapperInfo srcSchemaPath="" srcSchemaRoot="" srcSchemaPathIsRelative="yes" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes"/>
</metaInformation>
-->