<?xml version='1.0'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">



   <!-- ==============================================================================
                                       MVStringEditor

   // Types of methods
   // 1. Public api
   // 2. Package - only called from html widget (handle events)
   // 3. Private - only called from within this file

   // Variables Naming Convention
   // list = Select control
   // tb = textbox control

   // Member Vars
   // m_list
   // m_tb
   // m_enforceUnique
   // m_numbersOnly
   // m_ignoreCase
   // m_upperBound
   // m_lowerBound
   // m_maxLength
   // m_minLength
   // m_disabled
   //
   // window.mvemail = new MVStringEditorSel(list, tb);

   // TO DO list
   // mvselIsValidValue - task mvse pointer as only param

   // Globals
   // -sIndex
   // -editing
   // -oldIndex;

   // Shared methods (Expanded and collapsed)
   // -mvselRemove
   // -all public methods
   ============================================================================== -->


   <xsl:template name="MVStringEditor">

      <!-- OPTINAL PARAMETERS -->
      <xsl:param name="mode">sel</xsl:param> <!-- REMIND: this should default depending on device -->
      <xsl:param name="size" select="1"/>
      <xsl:param name="width">300</xsl:param>            <!-- width in pixels -->
      <xsl:param name="disabled">false</xsl:param>
      <xsl:param name="formName">forms[0]</xsl:param>
      <xsl:param name="enforceUnique">true</xsl:param>
      <xsl:param name="numbersOnly">false</xsl:param>
      <xsl:param name="ignoreCase">false</xsl:param>
      <xsl:param name="upperBound">NaN</xsl:param>
      <xsl:param name="lowerBound">NaN</xsl:param>
      <xsl:param name="maxLength">NaN</xsl:param>
      <xsl:param name="minLength">256</xsl:param>
      <xsl:param name="name">MVED</xsl:param>
      <xsl:param name="history">true</xsl:param>
      <xsl:param name="objectTypeName"></xsl:param>
      <xsl:param name="items"/>


      <!-- this really shouldn't be passed in as param; local var; but helps for test cases -->
      <xsl:variable name="mvStringEditor_name" select="$name"/>

      <!-- INIT VARIABLES -->
      <xsl:variable name="mvStringEditor_fullname" select="concat('document.', $formName, '.', $mvStringEditor_name)"></xsl:variable>
      <xsl:variable name="mvStringEditor_textfullname" select="concat('document.', $formName, '.', $mvStringEditor_name, 'Textbox')"></xsl:variable>
      <xsl:variable name="mvStringEditor_objectName" select="concat('window.mv', $mvStringEditor_name)"></xsl:variable>
      <xsl:variable name="Portal.ResourcePath" select="/PortalData/SessionInfo/WebAppInfo/ResourcePath"/>



      <xsl:choose>
         <xsl:when test="$mode='sel'">    <!-- ============================= SEL ============================= -->

            <TABLE cellpadding="0" cellspacing="0">

               <xsl:choose>

                  <!-- ***************** -->
                  <!--  Expanded         -->
                  <!-- ***************** -->
                  <xsl:when test="$size>1">
                     <TR>
                        <xsl:if test="$disabled!='true'">

                           <!-- TEXT BOX -->
                           <TD>
                              <INPUT type="text" id="mvid_{$mvStringEditor_name}" name="{$mvStringEditor_name}Textbox" onkeydown="return mvselKeyDown({$mvStringEditor_objectName},event);" style="width:{$width}px" title="{$dev.Widgets.toolTip}" maxlength="{$maxLength}"></INPUT>
                           </TD>

                           <!-- BUTTONS -->
                           <xsl:choose>
                              <xsl:when test="$objectTypeName!=''">
                                 <TD>
                                    <xsl:call-template name="OS">
                                       <xsl:with-param name="OS.MultiSelect">true</xsl:with-param>
                                       <xsl:with-param name="OS.TypeFilter" select="$objectTypeName"/>
                                       <xsl:with-param name="OS.Control" select="$name"/>
                                       <xsl:with-param name="OS.History" select="$history"/>
                                       <xsl:with-param name="OS.CallBack">mvselReturnFromOS</xsl:with-param>
                                    </xsl:call-template>
                                 </TD>
                                 <TD><xsl:call-template name="Spacer2px"/></TD>
                                 <!--<TD><A href="javascript:mvselRemove({$mvStringEditor_objectName})"><IMG alt="{$dev.Widgets.removeItem}" src="{$Portal.ResourcePath}/modules/dev/images/iconremove.gif" border="0"></IMG></A><xsl:call-template name="Spacer2px"/></TD>-->
                              </xsl:when>
                              <xsl:otherwise>
                                 <!-- buttons - add, remove, edit -->
                                 <TD><A href="javascript:mvselAddFromPrompt({$mvStringEditor_objectName})"><IMG alt="{$dev.Widgets.addItem}" src="{$Portal.ResourcePath}/modules/dev/images/iconadd.gif" border="0"></IMG></A><xsl:call-template name="Spacer2px"/></TD>
                                 <TD><A href="javascript:mvselRemove({$mvStringEditor_objectName})"><IMG alt="{$dev.Widgets.removeItem}" src="{$Portal.ResourcePath}/modules/dev/images/iconremove.gif" border="0"></IMG></A><xsl:call-template name="Spacer2px"/></TD>
                                 <TD><A href="javascript:mvselEdit({$mvStringEditor_objectName})"><IMG alt="{$dev.Widgets.editItem}" src="{$Portal.ResourcePath}/modules/dev/images/iconedit.gif" border="0"></IMG></A></TD>
                              </xsl:otherwise>
                           </xsl:choose>

                        </xsl:if>
                     </TR>
                     <TR>
                        <!-- SELECT BOX -->
                        <TD>
                           <xsl:choose>
                              <xsl:when test="$disabled!='true'">

                                 <SELECT name="{$mvStringEditor_name}" size="{$size}" style="width:{$width}px"
                                       onClick="{$mvStringEditor_textfullname}.value=&apos;&apos;;{$mvStringEditor_objectName}.m_editing=false;"
                                       onkeydown="return mvselKeyDown({$mvStringEditor_objectName},event);"
                                       onMouseDown="mvselResetColor({$mvStringEditor_objectName});"
                                 >
                                    <xsl:if test="$items">
                                       <xsl:for-each select="$items/item">
                                          <OPTION value="{.}" onDblClick="mvselEditOnPage({$mvStringEditor_objectName});"><xsl:value-of select="."/></OPTION>
                                       </xsl:for-each>
                                    </xsl:if>

                                 </SELECT>

                              </xsl:when>
                              <xsl:otherwise>
                                 <SELECT name="{$mvStringEditor_name}" size="{$size}" style="width:{$width}px">
                                    <xsl:if test="$items">
                                       <xsl:for-each select="$items/item">
                                          <OPTION value="{.}" onDblClick="mvselEditOnPage({$mvStringEditor_objectName});"><xsl:value-of select="."/></OPTION>
                                       </xsl:for-each>
                                    </xsl:if>
                                 </SELECT>
                              </xsl:otherwise>

                           </xsl:choose>

                        </TD>
                     </TR>
                  </xsl:when>


                  <!-- ***************** -->
                  <!--  One line         -->
                  <!-- ***************** -->
                  <xsl:otherwise>
                     <TR>

                        <!-- SELECT BOX -->
                        <TD>
                           <SELECT name="{$mvStringEditor_name}" id="mvid_{$mvStringEditor_name}" size="{$size}" onkeydown="return mvselKeyDown({$mvStringEditor_objectName},event);" onMouseDown="mvselResetColor(this);" style="width:{$width}px">
                              <xsl:if test="$items">
                                 <xsl:for-each select="$items/item">
                                    <OPTION value="{.}" onDblClick="mvselEditOnPage({$mvStringEditor_objectName});"><xsl:value-of select="."/></OPTION>
                                 </xsl:for-each>
                              </xsl:if>
                           </SELECT>
                        </TD>

                        <xsl:if test="$disabled!='true'">

                           <!-- BUTTONS -->
                           <xsl:choose>
                              <xsl:when test="$objectTypeName!=''">
                                 <TD>
                                    <xsl:call-template name="OS">
                                       <xsl:with-param name="OS.MultiSelect">true</xsl:with-param>
                                       <xsl:with-param name="OS.TypeFilter" select="$objectTypeName"/>
                                       <xsl:with-param name="OS.Control" select="$name"/>
                                       <xsl:with-param name="OS.History" select="$history"/>
                                       <xsl:with-param name="OS.CallBack">mvselReturnFromOS</xsl:with-param>
                                    </xsl:call-template>
                                 </TD>
                                 <TD>&#xa0;</TD>
                                 <TD><A href="javascript:mvselRemove({$mvStringEditor_objectName})"><IMG alt="{$dev.Widgets.removeItem}" src="{$Portal.ResourcePath}/modules/dev/images/iconremove.gif" border="0"></IMG></A><xsl:call-template name="Spacer2px"/></TD>
                              </xsl:when>
                              <xsl:otherwise>
                                 <!-- buttons - add, remove, edit -->
                                 <TD><A href="javascript:mvselAddFromPrompt({$mvStringEditor_objectName})"><IMG alt="{$dev.Widgets.addItem}" src="{$Portal.ResourcePath}/modules/dev/images/iconadd.gif" border="0"></IMG></A><xsl:call-template name="Spacer2px"/></TD>
                                 <TD><A href="javascript:mvselRemove({$mvStringEditor_objectName})"><IMG alt="{$dev.Widgets.removeItem}" src="{$Portal.ResourcePath}/modules/dev/images/iconremove.gif" border="0"></IMG></A><xsl:call-template name="Spacer2px"/></TD>
                                 <TD><A href="javascript:mvselEdit({$mvStringEditor_objectName})"><IMG alt="{$dev.Widgets.editItem}" src="{$Portal.ResourcePath}/modules/dev/images/iconedit.gif" border="0"></IMG></A></TD>
                              </xsl:otherwise>
                           </xsl:choose>

                        </xsl:if>

                     </TR>

                  </xsl:otherwise>
               </xsl:choose>

            </TABLE>

         </xsl:when>
         <xsl:when test="$mode='ie'">  <!-- ============================= IE =============================-->

            <xsl:choose>
               <xsl:when test="$disabled='true'">
                  <INPUT name="{$mvStringEditor_name}" id="mvid_{$mvStringEditor_name}" value="" type="text" style="width:{$width}px" disabled="true"></INPUT> <!-- value="{$mvStringEditor_concat}" -->
               </xsl:when>
               <xsl:otherwise>
                  <TABLE cellpadding="0" cellspacing="1">
                     <TR>
                     <TD>
                        <INPUT name="{$mvStringEditor_name}" value="" type="text" style="width:{$width}px"
                           onBlur="mvieBlur({$mvStringEditor_objectName})"
                           onFocus="mvieFocus({$mvStringEditor_objectName})"
                           onKeydown="return mvieCheckKey({$mvStringEditor_objectName})"></INPUT>
                     </TD>
                     <TD valign="middle">
                        <INPUT tabindex="-1" style="display:none" type="image" onClick="return false;" id="{$mvStringEditor_name}ImgUp" src="{$Portal.ResourcePath}/modules/dev/images/drop_up.gif" border="0"></INPUT>
                        <INPUT style="display:inline" type="image" onClick="{$mvStringEditor_fullname}.focus(); return false;" id="{$mvStringEditor_name}ImgDown" src="{$Portal.ResourcePath}/modules/dev/images/drop_down.gif" border="0"></INPUT>
                     </TD>

                        <xsl:if test="$objectTypeName!=''">
                           <TD>
                              <xsl:call-template name="OS">
                                 <xsl:with-param name="OS.MultiSelect">true</xsl:with-param>
                                 <xsl:with-param name="OS.TypeFilter" select="$objectTypeName"/>
                                 <xsl:with-param name="OS.Control" select="$name"/>
                                 <xsl:with-param name="OS.History" select="$history"/>
                                 <xsl:with-param name="OS.CallBack">mvieReturnFromOS</xsl:with-param>
                              </xsl:call-template>
                           </TD>
                        </xsl:if>

                     </TR>
                  </TABLE>
               </xsl:otherwise>
            </xsl:choose>

         </xsl:when>
         <xsl:when test="$mode='txt'"> <!-- ============================= TXT =============================-->
            TXT (pocket) version NOT IMPLEMENTED!!!
         </xsl:when>
         <xsl:otherwise>
            Invalid mode for MVStringEditor
         </xsl:otherwise>
      </xsl:choose>


      <INPUT name="{$mvStringEditor_name}_packedValues" id="{$mvStringEditor_name}_packedValues" type="hidden"/>

      <script>
         <!-- **************************** -->
         <!--  Init mvse javascript object -->
         <!-- **************************** -->
         <xsl:choose>

            <xsl:when test="$mode='sel'">
               <xsl:value-of select="$mvStringEditor_objectName"/> = new MVStringEditorSel(<xsl:value-of select="$mvStringEditor_fullname"/>,<xsl:value-of select="$mvStringEditor_fullname"/>Textbox);
            </xsl:when>

            <xsl:when test="$mode='ie'">
               <xsl:value-of select="$mvStringEditor_objectName"/> = new MVStringEditorIE(<xsl:value-of select="$mvStringEditor_fullname"/>);

               <xsl:if test="$items">
                  <xsl:value-of select="$mvStringEditor_objectName"/>.m_list =
                  [
                  <xsl:for-each select="$items/item">
                     <xsl:text>"</xsl:text><xsl:value-of select="."/><xsl:text>"</xsl:text>
                     <xsl:if test="position() != last()"><xsl:text>,</xsl:text></xsl:if>
                  </xsl:for-each>
                  ];
               </xsl:if>

               mvieShowListInBox(<xsl:value-of select="$mvStringEditor_objectName"/>);

            </xsl:when>

            <xsl:when test="$mode='txt'">
            </xsl:when>
         </xsl:choose>

         <!-- init mved javascript object -->
         <xsl:value-of select="$mvStringEditor_objectName"/>.m_enforceUnique = <xsl:value-of select="$enforceUnique"/>;
         <xsl:value-of select="$mvStringEditor_objectName"/>.m_numbersOnly = <xsl:value-of select="$numbersOnly"/>;
         <xsl:value-of select="$mvStringEditor_objectName"/>.m_ignoreCase = <xsl:value-of select="$ignoreCase"/>;
         <xsl:value-of select="$mvStringEditor_objectName"/>.m_upperBound = <xsl:value-of select="$upperBound"/>;
         <xsl:value-of select="$mvStringEditor_objectName"/>.m_lowerBound = <xsl:value-of select="$lowerBound"/>;
         <xsl:value-of select="$mvStringEditor_objectName"/>.m_maxLength = <xsl:value-of select="$maxLength"/>;
         <xsl:value-of select="$mvStringEditor_objectName"/>.m_minLength = <xsl:value-of select="$minLength"/>;
         <xsl:value-of select="$mvStringEditor_objectName"/>.m_disabled = <xsl:value-of select="$disabled"/>;
         <xsl:value-of select="$mvStringEditor_objectName"/>.m_name = "<xsl:value-of select="$mvStringEditor_name"/>";
      </script>

   </xsl:template>


   <xsl:template name="MVStringEditorScripts">
      <script>
         function MVStringEditorSel(sel, tb)
         {
            this.m_sel = sel;
            this.m_tb = tb;
            this.m_isEditing = false;
            this.m_mode = "mvsel";
            this.m_selectedRow = -1;
         }

         function MVStringEditorIE(tb)
         {
            this.m_tb = tb;
            this.m_list = new Array();
            this.m_isEditing = false;
            this.m_mode = "mvie";
            this.m_selectedRow = 0;
         }

         function mvieShowListInBox(mvse)
         {
            mvse.m_tb.value = mvse.m_list.join("; ");
         }

         <!-- Localized Resources -->
         rc_addItemMsg  = "<xsl:value-of select="$dev.Widgets.addItem"/>";
         rc_editItemMsg = "<xsl:value-of select="$dev.Widgets.editItem"/>";
         rc_uniqueMsg   = "<xsl:value-of select="$dev.Widgets.valuesMustBeUnique"/>";
         rc_mvieToolTip = "<xsl:value-of select="$dev.Widgets.toolTip"/>";
         rc_noEmptyValues = "<xsl:value-of select="$dev.Widgets.noEmtpyStrings"/>";
         rc_noValuesToEdit = "<xsl:value-of select="$dev.Widgets.noValueToEdit"/>";
         rc_onlyNumbersAllowed = "<xsl:value-of select="$dev.Widgets.onlyNumbersAllowed"/>";
      </script>

      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/MVStringEditor.js"></script>
      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/MVStringEditorIE.js"></script>
      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/MVStringEditorShared.js"></script>
   </xsl:template>

</xsl:stylesheet>