<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   
   <xsl:template name="OSLink">
      <xsl:param name="OS.Control" />
      <xsl:param name="OS.CallBack" />
      <xsl:param name="OS.AdvancedSelection" />
      <xsl:param name="OS.InitialContext" />
      <xsl:param name="OS.IsOSAllowed" />
      <xsl:param name="OS.Mode" />
      <xsl:param name="OS.MultiSelect" />
      <xsl:param name="OS.NameFilter" />
      <xsl:param name="OS.ResultsPerPage" />
      <xsl:param name="OS.SearchSubContainers" />
      <xsl:param name="OS.SearchOnStartup" />
      <xsl:param name="OS.ShowSubClasses" />
      <xsl:param name="OS.TypeFilter" />
      <xsl:param name="OS.TypeFilterCallBack" />
      <xsl:param name="OS.Windowed">false</xsl:param>
      <xsl:param name="OS.AltText"></xsl:param>
      <xsl:param name="OS.Text"></xsl:param>
      <xsl:param name="OS.History">false</xsl:param>
      
   <!-- simple (default) os textlink code (xsl) -->
   <!-- devtask.java has to call saveOSState(HttpServletRequest req, String mode) if not in windowed mode --> 
   <!-- String altTitle = ( (c.var("OS.AltText").length()==0) ? c.toDisplay(c.string("Button.OS.alt")) : c.toDisplay(c.var("OS.AltText")) ); -->
      <xsl:variable name="altTitle">
         <xsl:choose>
            <xsl:when test="string-length(OS.AltText)=0">
               <xsl:value-of select="$dev.Button.OS.alt"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$OS.AltText"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      
      <xsl:variable name="linkText">
         <xsl:choose>
            <xsl:when test="string-length(OS.Text)=0">
               <xsl:value-of select="$dev.Button.OS.alt"/>
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select="$OS.Text"/>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:variable>
      
      
      <!--<a href="#" title="<%= altTitle %>" alt="<%= altTitle %>" onClick="javascript:doOS('','<%= c.toDisplay(c.toScript(c.var("OS.Control"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.CallBack"))) %>','<%= c.var("OS.AdvancedSelection") %>','<%= c.toDisplay(c.toScript(c.var("OS.InitialContext"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.IsOSAllowed"))) %>','<%= c.var("OS.Mode") %>','<%= c.var("OS.MultiSelect") %>','<%= c.toDisplay(c.toScript(c.var("OS.NameFilter"))) %>','<%= c.var("OS.ResultsPerPage") %>','<%= c.var("OS.SearchSubContainers") %>','<%= c.var("OS.SearchOnStartup") %>','<%= c.var("OS.ShowSubClasses") %>','<%= c.toDisplay(c.toScript(c.var("OS.TypeFilter"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.TypeFilterCallBack"))) %>','<%= c.var("OS.Windowed") %>'); return false"> -->
      <xsl:text> </xsl:text>
      <a href="#" title="{$altTitle}" alt="{$altTitle}" onClick="javascript:doOS('simple-xsl', '{$OS.Control}', '{$OS.CallBack}', '{$OS.AdvancedSelection}', '{$OS.InitialContext}', '{$OS.IsOSAllowed}', '{$OS.Mode}', '{$OS.MultiSelect}', '{$OS.NameFilter}', '{$OS.ResultsPerPage}', '{$OS.SearchSubContainers}', '{$OS.SearchOnStartup}', '{$OS.ShowSubClasses}', '{$OS.TypeFilter}', '{$OS.TypeFilterCallBack}', '{$OS.Windowed}'); return false">
      <xsl:value-of select="$linkText"/></a>
      <!-- end simple (default) os textlink code (xsl) -->
      
      <!-- simple (default) history button code (xsl) -->
      <xsl:variable name="hsrc">
         <xsl:value-of select="$Portal.ResourcePath"/>/modules/dev/images/<xsl:value-of select="$dev.Button.Hist.image"/>
      </xsl:variable>
      
      <xsl:if test="$OS.History='true'">
         <!--<a href="#" onClick="javascript:doHist(this,'<%= c.toDisplay(c.toScript(c.var("OS.Control"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.TypeFilter"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.CallBack"))) %>','<%= c.toDisplay(c.toScript(c.var("OS.IsOSAllowed"))) %>'); return false">
         <img alt="<%= c.string("Button.Hist.alt") %>" title="<%= c.string("Button.Hist.alt") %>" src="<%= c.getModulesUrl() %>/dev/images/<%= c.string("Button.Hist.image") %>" border=0 align="absmiddle" ></a>-->
         <xsl:text> </xsl:text>
         <a href="#" onClick="javascript:doHist(this,'{$OS.Control}','{$OS.TypeFilter}','{$OS.CallBack}','{$OS.IsOSAllowed}'); return false">
         <img alt="{$dev.Button.Hist.alt}" title="{$dev.Button.Hist.alt}" src="{$hsrc}" border="0" align="absmiddle" /></a>
      </xsl:if>
      <!-- end simple (default) history button code (xsl) -->
      
   </xsl:template>

</xsl:stylesheet>