<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
   
   <xsl:template name="OSScripts">
      <!-- BEGIN Simple (default) OSScripts_inc.xsl -->
      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/OSSimpleScripts.js"></script>
      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/dev/javascripts/exchanger.js"></script>
      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/fw/javascripts/AnchorPosition.js"></script>
      <script language="JavaScript" src="{$Portal.ResourcePath}/modules/fw/javascripts/HistoryScripts.js"></script>
   
      <script>
         //Remind:  toScripting in BaseGadgetInstance.  need to toScript in the xsl instead
         var isReturningFromOS = ("<xsl:value-of select="//*/Gadget/OS.ReturnedData/OS.ReturningToAnchor"/>"=="true");
      
         window.osWidth=<xsl:value-of select="$dev.OS.Simple.WindowWidth"/>;
         window.osHeight=<xsl:value-of select="$dev.OS.Simple.WindowHeight"/>;
         window.UserContext = 'xxxx';
      
         function returnFromOS(osControl, osResults, osCallBack)
         {
            var isWindowed = (arguments.length>0);
            var docState = null;
      
            if (!isWindowed)
            {
               // being called from the onLoad returnFromOS() call
               //Remind:  toScripting in BaseGadgetInstance.  need to toScript in the xsl instead
               osCallBack = "<xsl:value-of select="//*/Gadget/OS.ReturnedData/OS.CallBack"/>";
               osControl  = "<xsl:value-of select="//*/Gadget/OS.ReturnedData/OS.Control"/>";
               osResults  = "<xsl:value-of select="//*/Gadget/OS.ReturnedData/OS.Results"/>";
               docState   = "<xsl:value-of select="//*/Gadget/OS.ReturnedData/OS.AnchorDocState"/>";
            }
            //alert("returnFromOS:\n   osControl = "+osControl+"\n   osCallBack = "+osCallBack+"\n   osResults = "+osResults+"\n   docState = "+docState+"\n   isWindowed = "+isWindowed+"\n  isReturningFromOS = "+isReturningFromOS);
      
            if (isWindowed || isReturningFromOS)
            {
               try
               {
                  //1.  restore the document to the state it was in before calling the OS
                  if (docState != null &amp;&amp; docState.length != 0)
                  {
                     //extract document state values and set them
                     restoreDocStateInfo(docState);
                  }
      
                  //2.  now process the os results
                  if (osResults!=null &amp;&amp; osResults.length>0)
                  {
                     // turn the one returned value into an array for compatibility with browser mode
                     var osResultsArray = new Array(1);
                     osResultsArray[0] = osResults;
      
                     //process the os results that have been returned
                     if (exists(osCallBack))
                     {
                        //let the callback routine process the os results
                        var command = osCallBack+"('"+toScript(osControl)+"',osResultsArray)";
                        eval( command );
                     }
                     else
                     {
                        //just store the search results in the specified control
                        if (osControl != null)
                        {
                           setElementValue(osControl, osResults);
                        }
                     }
                  }
               }
               finally
               {
                  //3.  call task's post OS function
                  if (exists("postOS")) postOS(osControl);
               }
            }
         }
      </script>
      <!-- END Simple (default) OSScripts_inc.xsl -->
   </xsl:template>
   
</xsl:stylesheet>  
