<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


   <xsl:template name="page-variables">
      <xsl:variable name="gadgetRoot" select="ancestor::Gadget"></xsl:variable>

      <!-- WEBACC VARIABLES -->
      <INPUT type="hidden" name="User.context"   value="xxxx"></INPUT>
      <INPUT type="hidden" name="taskId"         value="{$gadgetRoot/@id}"></INPUT>
      <INPUT type="hidden" name="merge"          value=""></INPUT>
      <INPUT type="hidden" name="error"          value=""></INPUT>

      <!-- BOOK VARIABLES -->
      <INPUT type="hidden" name="nextState"      value="show"></INPUT>
      <INPUT type="hidden" name="nextPage"       value="{$gadgetRoot/book-data/activePage}"></INPUT>
      <INPUT type="hidden" name="activePage"     value="{$gadgetRoot/book-data/activePage}"></INPUT>
      <INPUT type="hidden" name="helpfile"       value="{$gadgetRoot/book-data/Help.file}"></INPUT>

      <SCRIPT>
         syncTab("<xsl:value-of select="$gadgetRoot/book-data/activePage"></xsl:value-of>");
      </SCRIPT>
   </xsl:template>


   <xsl:template name="page-scripts">
      <!-- REMIND: this shouldn't be hard coded; should be in nps area -->
      <xsl:variable name="DevScriptsPath">/nps/javascripts/dev</xsl:variable>
      <SCRIPT language="JavaScript" src="{$DevScriptsPath}/PageScripts.js"></SCRIPT>
   </xsl:template>


   <xsl:template match="book-data">
      <!-- do nothing -->
      <!-- requried so book data isn't rendered -->
   </xsl:template>


   <!-- Note: this implementation only works in IE -->
   <xsl:template name="page-messagebar">
      <xsl:param name="Messagebar.jumpToError.method"></xsl:param>
      <xsl:param name="Messagebar.jumpToError.label"></xsl:param>


      <xsl:variable name="gadgetRoot" select="ancestor::Gadget"></xsl:variable>

<!--
      {IFDEF GeneralMsg.Error.Detail}
          {SET GeneralMsg.Detail.Url = {VAR Templates.Errors.url}{VAR GeneralMsg.Error.Detail}}
      {ENDIF}

      {IFDEF stackTrace}
         <SCRIPT>
            var bDetailsOn = false;
            function showDetails()
            {
               var w = window.open();
               w.document.writeln("<table border=1><tr><td><code>{VAR toScript(stackTrace)}</code></td></tr></table><br>");
            }
         </SCRIPT>
      {ENDIF}
-->


      <xsl:variable name="headerClass">
         <xsl:choose>
            <xsl:when test="$gadgetRoot/book-data/GeneralMsg.Mode='error'">errorHead</xsl:when>
            <xsl:otherwise>head1</xsl:otherwise>
         </xsl:choose>
      </xsl:variable>


      <DIV id="pbMessageBox">
      <TABLE border="0" cellpadding="1px" cellspacing="0px" bgcolor="#000000" width="100%"><TR><TD valign="top">
      <TABLE border="0" cellpadding="0" cellspacing="0" width="100%">
         <TR>
            <TD bgcolor="#dfddd5" class="{$headerClass}">&#xa0;
               <xsl:choose>
                  <xsl:when test="not($gadgetRoot/book-data/GeneralMsg.Detail.Url)">
                     <xsl:value-of select="$gadgetRoot/book-data/GeneralMsg.MsgTitle"/>
                  </xsl:when>
                  <xsl:otherwise>
                     <A href="{$gadgetRoot/book-data/GeneralMsg.Detail.Url}" class="errorlink" target="errDetail"><xsl:value-of select="$gadgetRoot/book-data/GeneralMsg.MsgTitle"/></A>
                  </xsl:otherwise>
               </xsl:choose>
            </TD>
            <TD bgcolor="#dfddd5" align="right" valign="middle" nowrap="true">
               <A href="#" onClick="document.getElementById('pbMessageBox').style.display='none';">
                  <IMG src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Icon.Close.image}" alt="{$dev.Icon.Close.alt}" title="{$dev.Icon.Close.alt}" border="0"></IMG>
               </A>&#xa0;
            </TD>
         </TR>
         <TR>
            <TD bgcolor="#ffffff" colspan="2">
               <TABLE cellpadding="4"><TR valign="middle">
                  <TD>
                     <xsl:if test="$gadgetRoot/book-data/GeneralMsg.Mode='error'">
                        <IMG src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Icon.Error.image}" alt="{$dev.Icon.Error.alt}" title="{$dev.Icon.Error.alt}" border="0"></IMG>
                     </xsl:if>
                  </TD>
                  <TD>

                     <xsl:choose>
                        <xsl:when test="not($gadgetRoot/book-data/GeneralMsg.MsgBodyPlainText)">
                           <xsl:value-of select="$gadgetRoot/book-data/GeneralMsg.MsgBody"></xsl:value-of>
                        </xsl:when>
                        <xsl:otherwise>
                        <!-- REMIND: implement
                           {SET GenMsg.BoldDisplay=(toDisplay(GeneralMsg.MsgBodyBoldText))}
                           {SET GenMsg.BoldMsg="<B>"GenMsg.BoldDisplay"</B>"}
                           {SET GenMsg.PlainMsg=(toDisplay(GeneralMsg.MsgBodyPlainText))}
                           {VAR GenMsg.PlainMsg GenMsg.BoldMsg}
                        -->
                        </xsl:otherwise>
                     </xsl:choose>

                  <!-- REMIND: implement
                  {IFDEF GeneralMsg.MsgBodyPlainText2}
                     <br/>
                     <br/>
                      {SET GenMsg.BoldDisplay=(toDisplay(GeneralMsg.MsgBodyBoldText2))}
                      {SET GenMsg.BoldMsg="<B>"GenMsg.BoldDisplay"</B>"}
                      {SET GenMsg.PlainMsg=(toDisplay(GeneralMsg.MsgBodyPlainText2))}
                      {VAR GenMsg.PlainMsg GenMsg.BoldMsg}
                  {ENDIF}
                  -->

                  <xsl:if test="$gadgetRoot/book-data/stackTrace">
<!--                     <IMG type="image" src="{$Portal.ResourcePath}/modules/dev/images/{VAR User.lang}/btndetails_{VAR User.lang}.gif" id="btnDetails" onClick="showDetails()"></IMG>-->
                  </xsl:if>

                  <!-- REMIND: implement
                  {IFDEF Messagebar.jumpToError.method}
                     {IF Messagebar.jumpToError.label==""}{SET Messagebar.jumpToError.label={STRING Messagebar.jumpToError}}{ENDIF}
                     <BR/><BR/><A href="Javascript:{VAR toScript(Messagebar.jumpToError.method)}();">{VAR toDisplay(Messagebar.jumpToError.label)}</A>
                  {ENDIF}
                  -->
                  </TD>
               </TR></TABLE>
            </TD>
         </TR>
      </TABLE>
      </TD></TR></TABLE><BR/>
      </DIV>
   </xsl:template>

</xsl:stylesheet>