var V_COMPARE_ATTR =     0x00000001;
var V_READ_ATTR =        0x00000002;
var V_WRITE_ATTR =       0x00000004;
var V_DELETE_ATTR =      0x00000008;
var V_SUPER_ATTR =       0x00000010;
var V_SELF_ATTR =        0x00000020;

var V_BROWSE_ENTRY =     0x00000001;
var V_CREATE_ENTRY =     0x00000002;
var V_DELETE_ENTRY =     0x00000004;
var V_RENAME_ENTRY =     0x00000008;
var V_SUPER_ENTRY =      0x00000010;

var entryRightsName = ["Browse","Create","Rename","Delete","Supervisor"];
var entryRightsMask = [V_BROWSE_ENTRY, V_CREATE_ENTRY, V_RENAME_ENTRY, V_DELETE_ENTRY, V_SUPER_ENTRY];

var attrRightsName = ["Supervisor","Compare","Read","Write","Self", "Delete"];
var attrRightsMask = [V_SUPER_ATTR,V_COMPARE_ATTR,V_READ_ATTR,V_WRITE_ATTR,V_SELF_ATTR,V_DELETE_ATTR];

function onInit(priv, attr)
{
   startingPriv = priv;
   if(attr==" " || attr=="")
   {
     showPrivilagesModifier();
   }
   else if(attr)
   {
   	showPrivilages();
   }

   if(priv) updatePrivilages(priv);
}

function onOk()
{
   var attrName = document.form.protectedAttributeName.value;
   var rights = startingPriv;
   var names = attrName == " " ? entryRightsName : attrRightsName;
   var masks = attrName == " " ? entryRightsMask : attrRightsMask;

   for(var i=0; i < names.length; i++)
   {
      if(document.getElementById(names[i]).checked)
      {
         rights |= masks[i];
      }
      else
      {
         rights &= ~masks[i];
      }
   }

   var subjectName = document.form.subjectName.value;
   var scopeName = document.form.scopeName.value;
   var modifier = document.form.modifier.value;
   var classname = document.form.classname.value;
   var filter = document.form.filter.value;
   var list = [rights, attrName, subjectName, scopeName ,modifier, classname, filter];
   var acl = pack(list);
   if(!subjectName)
   {
   		alert("Subject is required");
   }
   else
   {
   	eval("opener." + returnMethodName + "(\"" + acl + "\")");
   	window.close();
   }
}

function updatePrivilages(priv)
{
   var attrName = document.form.protectedAttributeName.value;
   var names = attrName == " " ? entryRightsName : attrRightsName;
   var masks = attrName == " " ? entryRightsMask : attrRightsMask;
   for(var i=0; i < names.length; i++)
   { 
      document.getElementById(names[i]).checked = ((priv & masks[i]) > 0);
   }
}
function addCheckbox(div, label, name)
{
   var cb = document.createElement("INPUT");
   cb.setAttribute("type", "checkbox");
   cb.setAttribute("name", name);
   cb.setAttribute("id", name);
   div.appendChild( cb );

   div.appendChild( document.createTextNode(name) );
   div.appendChild( document.createElement("BR") );
}

function showPrivilages()
{
   var attrName = document.form.protectedAttributeName.value;
   var div = document.getElementById("privilagesDiv");

   while(div.firstChild != null) div.removeChild(div.firstChild);

   var names = attrRightsName;
   var masks = attrRightsMask;

   for(var i=0; i < names.length; i++)
   {
      addCheckbox(div, names[i], names[i]);
   }
}
function showPrivilagesModifier()
{
   var attrName = document.form.modifier.value;
   var div = document.getElementById("privilagesDiv");
   var pdiv = document.getElementById("propertyDiv");
   while(div.firstChild != null) div.removeChild(div.firstChild);

   if(attrName == "1")
   {
    document.form.protectedAttributeName.value = " ";
    var names = entryRightsName;
    var masks = entryRightsMask;
    pdiv.style.visibility = "hidden";
   	for(var i=0; i < names.length; i++)
   	{
      addCheckbox(div, names[i], names[i]);
   	}
   }
   else
   {
     pdiv.style.visibility = "visible";
     document.form.protectedAttributeName.value = "acl";
   }
}
