// This file contains javascript used by the ACL Uihandler

function uih_acl(name, uiControl, xmlControl)
{
   var sel = document.getElementById("ACL_Editor");

   var xml = "<attribute>";

   for(var i=0; i<sel.options.length; i++)
   {
      var list = unpack(sel.options[i].value);
      xml += "<value><nvds-privileges>"+list[0]+"</nvds-privileges><nvds-attributename>"+list[1]+"</nvds-attributename><nvds-trustee>"+list[2]+"</nvds-trustee><nvds-scope>"+list[3]+"</nvds-scope><nvds-modifier>" + list[4] + "</nvds-modifier><nvds-classname>" + list[5] + "</nvds-classname><nvds-filter>" + list[6] + "</nvds-filter></value>";
   }

   xml += "</attribute>";
   xmlControl.value = xml;
   return true;
}

function openAclPopup(mode, returnMethodName, priv, attr, subj, scope, modifier, classname, filter)
{
   var width = 450;
   var height = 550;
   var x = (screen.availWidth-width)/2;
   var y =  (screen.availHeight-height)/3;
   var params = "left="+x+",top="+y+",height="+height+",width="+width+",resizable,scrollbars";
   var url = "webacc?taskId=dev.Empty&merge=fw.KeplerACLEditorPopup&mode="+mode + "&returnMethodName=" + returnMethodName;

   if(mode == "edit")
   {
      url += "&priv=" + priv + "&attr=" + attr + "&subj=" + subj + "&scopeName=" + scope + "&modifier=" + modifier + "&classname=" + classname + "&filter=" + filter;
   }
   var w = window.open(url,"KeplerACLEditor", params);
}

function addAclItem()
{
   openAclPopup("add", "returnFromAdd");
}

function deleteAclItem()
{
   var sel = document.forms[0].ACL_Editor;
   sel.options[sel.selectedIndex] = null;
}

function editAclItem()
{
   var sel = document.forms[0].ACL_Editor;
   editingIndex = sel.selectedIndex;

   var list = unpack(sel.value);
   openAclPopup("edit", "returnFromEdit", list[0], list[1], list[2], list[3], list[4], list[5], list[6]);
}

function returnFromAdd(packedAcl)
{
   if(packedAcl==null || packedAcl.length==0) return;

   var list = unpack(packedAcl);
   var displayAcl = list[6] + " - " + list[5] + " - " + list[4] + " - " + list[3] + " - " + list[2] + " - " + list[1]  + " - " + list[0];
   var sel = document.forms[0].ACL_Editor;
   sel.options[sel.options.length] = new Option(displayAcl, packedAcl);
}

function returnFromEdit(packedAcl)
{
   if(editingIndex<0) return;
   if(packedAcl==null || packedAcl.length==0) return;

   var list = unpack(packedAcl);
   var displayAcl = list[6] + " - " + list[5] + " - " + list[4] + " - " + list[3] + " - " + list[2] + " - " + list[1]  + " - " + list[0];
   var sel = document.forms[0].ACL_Editor;
   sel.options[editingIndex] = new Option(displayAcl, packedAcl);
}