/*******************
* FUNCTION HEADER *
*******************/
// This function will remove all the selected options from
// the fromList and add them to the toList.
// Remove the emptyListBracket from the toList if present.
// Add the emptyListBracket to the fromList if empty.
// Then sort the to list.
//
// fromList         : The list the options are being moved from
// toList           : The list the options are being moved to
//
// return           : True if a change was made else False
function moveListItems(fromList, toList)
{
    var retValue = false;
    var index = -1;
    
    // If neither list has a selected item then just return
    if( (fromList.selectedIndex == -1) &&
        (toList.selectedIndex == -1))
    {
        return;
    }
    
    // If from list doesnot have a selected item then just return
    if(fromList.selectedIndex == -1)
    {
        return;
    }
        
    // If empty list bracket then just return
    if (fromList.options[0].text == emptyListBracket)
    {
        return;
    }
        
    // Move all the selected options in the formList to the toList
    for (var i=(fromList.length-1); i>=0; i--)
    {
        if(fromList.options[i].selected)
        {
            if(index == -1)
            {
                index = i;
            }
            
            newoption = new Option(fromList.options[i].text, fromList.options[i].value, false, false);
            newoption.title = fromList.options[i].title;
            toList.options[toList.length] = newoption;
            fromList.options[i] = null;
            retValue = true;
        }
    }
	    
	// Remove empty list bracket
    for (var i = 0; i < toList.length; i++)
    {
        if (toList.options[i].text == emptyListBracket)
        {
            toList.options[i] = null;
            break;
        }
    }
  
	// Set empty list bracket
    if (fromList.length == 0)
    {
        index = 0;
        newoption = new Option(emptyListBracket, "", false, false);
        fromList.options[0] = newoption;
    }

    // Sort the toList
    sortLists(toList.options);
        
    // Set the focus to the fromList and set the next option as selected
    fromList.focus();
    if((fromList.length-1) < index)
    {
        fromList.options[fromList.length-1].selected = true;
    }
    else
    {
        fromList.options[index].selected = true;
    }
    
    return retValue;
}


/*******************
* FUNCTION HEADER *
*******************/
function sortLists(x)
{
    if (x.length > 1)
    {
        sortedArray = new Array();

        for (var i=0; i<x.length; i++)
        {
            sortedArray[i] = new Array(x[i].text, x[i].value, false, false);
        }

        sortedArray.sort(sortBYtext);

        for (var i=0; i<x.length; i++)
        {
            x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
            x[i].selected = sortedArray[i][3];
        }
    }

    return;
}


/*******************
* FUNCTION HEADER *
*******************/
function sortListsWithAnythingOrNothing(x)
{
    if (x.length > 1)
    {
        xLength = x.length - 2;

        sortedArray = new Array();

        for (var i=0; i<x.length; i++)
        {
            if(x[i].text!="[Anything]" && x[i].text!="[Nothing]")
            {
               sortedArray[i] = new Array(x[i].text, x[i].value, false, false);
            }
        }

        //sortedArray.sort(sortBYtext);
        sortedArray.sort();

        x[0] = new Option("[Anything]", "[Anything]", false, false);
        x[1] = new Option("[Nothing]", "[Nothing]", false, false);

        for (var i=0; i<xLength; i++)
        {
            x[i+2] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
            x[i+2].selected = sortedArray[i][3];
        }
    }

    return;
}


/*******************
* FUNCTION HEADER *
*******************/   
function sortBYtext(a,b) 
{
    if(a[0].toUpperCase() < b[0].toUpperCase())
    {
        return -1;
    }

    if(a[0].toUpperCase() > b[0].toUpperCase())
    {
        return 1;
    }

    return 0;
}
    
    
