   // This file contains PRIVATE functions that implement the dynamic GUI in the Object Selector widget.
   // They are not intended for use by anyone else and are subject to change without notice.
   
   //------------ getType functions -----------------
   function getSelectedTypes(bAdvanced)
   {
      var ret="";
      for (var i=0; i<m_types.length; i++)
      {
         if (m_types[i][0] && m_types[i][1]!=null)
         {
            //type is enabled
            if ( (!bAdvanced) || 
                 (bAdvanced && (m_types[i][2]==null || m_types[i][2].length==0)) )
            {
               //add type to list
               ret = addType(ret,m_types[i][1]);
            }
         }
      }
      for (var i=0; i<m_pseudoTypes.length; i++)
      {
         if (m_pseudoTypes[i][0] && m_pseudoTypes[i][1]!=null)
         {
            ret = addType(ret,m_pseudoTypes[i][1]);
         }
      }
      //alert("getSelectedTypes: ret="+ret);    
      return ret;
   }
   
   function addType(s,type)
   {
      if (s==null) s="";
      if (type!=null)
      {
         if (s.length>0)
         {
            s+=( (type.charAt(0)==",") ? ",," : ",");
         }
         s+=type;
      }
      return s;
   }
   
   //------------ doSearch functions ----------------
   function doSearch()
   {
      if (isAdvSelMode()) 
      {
         top.Query.doAdvancedSearch();
      }
      else 
      {
         top.Query.doGenericSearch();
      }
   }
   
   //------------ process Next/Previous button click -------
   function processDisplayCountKeyPress(keyCode, nextEnabled, prevEnabled)
   {
      if (keyCode==13)   //enter key?
      {
         try
         {
            if (nextEnabled)        top.ResultButtons.document.Next.click();                 //click next button
            else if (prevEnabled)   top.ResultButtons.document.Previous.click();             //click previous button
            else                    top.Query.document.getElementById("doSearch").click();   //click apply/search button
         }
         catch (e)
         {
         }
      }
   }
   
   function processResultsButton(strURL)
   {
      processDisplayCountChange();

      //update Results frame   
      var strHTML = '<input type=hidden name="Search.ContextId" value="'+toTag(top.m_searchContextId)+'">\n';
      var strRPP = '&OS.ResultsPerPage='+m_resultsPerPage;
      //alert("processResultsButton: strURL="+strURL);
      //alert("processResultsButton: strHTML="+strHTML);
      top.ResultButtons.document.PostData.action=strURL+strRPP;
      top.ResultButtons.document.getElementById("FormData").innerHTML = strHTML;
      top.ResultButtons.document.PostData.target="Results";
      top.ResultButtons.document.PostData.submit();
   }
   
   function processDisplayCountChange()
   {
      try
      {
         var adjusted=false;
         var cnt = top.ResultButtons.document.getElementById("ResultsPerPage").value;
         if (cnt==null || cnt.length==0) return;
         else if (cnt<1) { adjusted=true; cnt=1; }
         else if (cnt>500) {adjusted=true; cnt=500;}
         if (adjusted) top.ResultButtons.document.getElementById("ResultsPerPage").value=cnt;
         m_resultsPerPage=cnt;
      }
      catch (e)
      {
      }
   }
   
   //------------ Advanced Selection ----------------
   function doMyAS(types)
   {
      AS=new Object();
      AS.types=types;
      AS.controlCallBack="saveCriterion";
      AS.initialCriterionCallBack="getCriterion";
      doDynamicAS(m_userContext, AS);
   }
  
   function getCriterion(typeName)
   {
      var ret="";
      if (typeName!=null && typeName.length>0)
      {
         var i = getTypeIdx(typeName);
         if (i!=-1)
         {
            ret=m_types[i][2];    //return type criterion
         }
      }
      return ret;
   }
    
   function saveCriterion(controlName, typeNames, xmlCriterion)
   {
      //alert("saveCriterion: \ncontrolName="+controlName+"\ntypeNames="+typeNames+"\ncriterion="+xmlCriterion);
      //convert comma-separated name into array and call saveCriterionArray()
      var types = iman.commaSplit(typeNames);
      saveCriterionArray(types, xmlCriterion);
   }
   
   function saveCriterionArray(types, xmlCriterion)
   {
      //alert("saveCriterionArray: types = "+types+"\nxmlCriterion = ["+xmlCriterion+"]\nxmlCriterion is typeof "+typeof(xmlCriterion));
      if (types!=null && types.length>0)
      {
         for (var i=0; i<types.length; i++)
         {
            var type = types[i]; 
            if (xmlCriterion==null || xmlCriterion.length==0)
            {
               //clear criterion for this type
               clearCriterion(type);
            }
            else
            {
               //remember criterion for this type
               var idx = getTypeIdx(type);
               if (idx!=-1)
               {
                  //save criterion
                  m_types[idx][2] = xmlCriterion;
                  
                  //make '-' visible
                  top.Query.document.getElementById("minus"+idx).style.display="inline";
                  
                  //make clearall '-' visible?
                  if (numCriterion()>1 && top.Query.document.getElementById("minus"+HDR_TAG)!=null)
                  {
                     top.Query.document.getElementById("minus"+HDR_TAG).style.display="inline";
                  } 
               }
            }
         }
      }
   }
   
   //----------------- GUI utility functions ---------------------
   function getTypeIdx(typeName)
   {
      var id=-1;
      for (var i=0; i<m_types.length; i++)
      {
         if (m_types[i][1]==typeName)
         {
            id=i;
            break;
         }
      }
      return id;
   }
   
   function numCriterion()
   {
      var cnt=0;
      for (var i=0; i<m_types.length; i++)
      {
         if (m_types[i][2]!=null && m_types[i][2].length>0)
         {
            cnt++;
         }
      }
      return cnt;
   }
   
   function numSelected()
   {
      var cnt=0;
      for (var i=0; i<m_types.length; i++)
      {
         if (m_types[i][0])
         {
            cnt++;
         }
      }
      for (var i=0; i<m_pseudoTypes.length; i++)
      {
         if (m_pseudoTypes[i][0])
         {
            cnt++;
         }
      }
      return cnt;
   }
   
   function isAdvSelMode()
   {
      return (m_advSel=="true");
   }
   
   
   function setAdvSelMode(sMode)
   {
      if (top.Query.document.getElementById("AdvancedSearchLink")!=null)
      {
         m_advSel=sMode;
         if (isAdvSelMode())
         {
            //switch to advanced search mode
            top.Query.document.getElementById("AdvancedSearchLink").style.display="none";
            top.Query.document.getElementById("SimpleSearchLink").style.display="inline";
            top.Query.document.getElementById("SimpleCriterion").style.display="none";
            top.Query.document.getElementById("AdvancedCriterion").style.display="block";
         }
         else
         {
            //switch to simple search mode
            top.Query.document.getElementById("AdvancedSearchLink").style.display="inline";
            top.Query.document.getElementById("SimpleSearchLink").style.display="none";
            top.Query.document.getElementById("SimpleCriterion").style.display="block";
            top.Query.document.getElementById("AdvancedCriterion").style.display="none";
         }
      }
   }
   
   function setRowAttributes(rowIdx,txtColor,bgColor)
   {
      //alert("setRowAttributes: rowIdx="+rowIdx+" txtColor="+txtColor+" bgColor="+bgColor);
      if (top.Query.document.getElementById(SIMPLE_ROW+rowIdx))
      {
         top.Query.document.getElementById(SIMPLE_ROW+rowIdx).bgColor=bgColor;
         top.Query.document.getElementById(SIMPLE_ROW+rowIdx+"txt").style.color=txtColor;
      }
      if (top.Query.document.getElementById(ADV_ROW+rowIdx))
      {
         top.Query.document.getElementById(ADV_ROW+rowIdx).bgColor=bgColor;
         top.Query.document.getElementById(ADV_ROW+rowIdx+"txt").style.color=txtColor;
      }
    }
    
    function setAllRowAttributes(isSelected,txtColor,bgColor)
   {
      //unselect but active all types
      var rowIdx=0;
      for (var i=0; i<m_types.length; i++)
      {
         setRowAttributes(rowIdx,txtColor,bgColor);
         m_types[i][0]=isSelected;
         rowIdx++;
      }
      for (var i=0; i<m_pseudoTypes.length; i++)
      {
         setRowAttributes(rowIdx,txtColor,bgColor);
         m_pseudoTypes[i][0]=isSelected;
         rowIdx++;
      } 
   }
   
   //------------------Dynamic GUI functions---------------------
  
   function clearCriterion(typeName)
   {
      if (typeName!=null && typeName.length>0)
      {
         var i = getTypeIdx(typeName);
         if (i!=-1)
         {
            //clear criterion for this type
            m_types[i][2]=null;
            
            //make '-' invisible
            top.Query.document.getElementById("minus"+i).style.display="none";
            
            //make clear all '-' invisible
            if (top.Query.document.getElementById("minus"+HDR_TAG)!=null && numCriterion()<2)
            {
               top.Query.document.getElementById("minus"+HDR_TAG).style.display="none";
            }
         }
      }
   }
   
   function clearAllCriterion()
   {
      for (var i=0; i<m_types.length; i++)
      {
         //clear criterion for this type
         m_types[i][2]=null;
         
         //make '-' invisible
         var id = "minus"+i;
         top.Query.document.getElementById(id).style.display="none";
      }
      //make clear all '-' invisible
      if (top.Query.document.getElementById("minus"+HDR_TAG)!=null)
      {
         top.Query.document.getElementById("minus"+HDR_TAG).style.display="none";
      }
   }
   
   function activateHdr()
   {
      m_bHdrEnabled = true;
      
      //select header
      setRowAttributes(HDR_TAG, SELECTED_TEXT_COLOR, SELECTED_BGCOLOR);
      setAllRowAttributes(true, ACTIVE_TEXT_COLOR,UNSELECTED_BGCOLOR);
   }
   
   function deactivateHdr()
   {
      m_bHdrEnabled = false;
      
      //select header
      setRowAttributes(HDR_TAG, UNSELECTED_TEXT_COLOR, UNSELECTED_BGCOLOR);
      setAllRowAttributes(false,UNSELECTED_TEXT_COLOR, UNSELECTED_BGCOLOR);
   }
    
   function selectType(rowIdx)
   {
      if (m_numViewableTypes<2)
      {
         return;
      }
      
      if (rowIdx==HDR_TAG)
      {
         //activate header
         if (!m_bHdrEnabled)
         {
            activateHdr();
         }
      }
      else
      {
         //select type in list
         if (m_bHdrEnabled)
         {
            //header was activated -- deactivate it
            deactivateHdr();
         }
         
         var bSelected = false;
         if (rowIdx<m_types.length)
         {
            m_types[rowIdx][0]=(!(m_types[rowIdx][0]));
            if (m_types[rowIdx][0])
            {
               bSelected=true;
            }
         }
         else
         {
            m_pseudoTypes[rowIdx-m_types.length][0]=(!(m_pseudoTypes[rowIdx-m_types.length][0]));
            if (m_pseudoTypes[rowIdx-m_types.length][0])
            {
               bSelected=true;
            }
         }
         // set row display characteristics
         if (bSelected)
         {
            setRowAttributes(rowIdx, SELECTED_TEXT_COLOR, SELECTED_BGCOLOR);
         }
         else
         {
            setRowAttributes(rowIdx,UNSELECTED_TEXT_COLOR, UNSELECTED_BGCOLOR);
         }
         
         // if no type is selected, select header
         if (numSelected()==0)
         {
            activateHdr();
         }
      }
   }
   
   function showSimpleTypes()
   {
      if (m_numViewableTypes<2)
      {
         //only one type, don't show the selectable table view
         for (var i=0; i<m_displayTypes.length; i++)
         {
            if (m_displayTypes[i]!=null)
            {
               top.Query.document.writeln('<font face="Helvetica,Arial" size=-2><NOBR>&nbsp;&nbsp;'+m_displayTypes[i]+'</NOBR></font><BR>');
            }
         }
         for (var i=0; i<m_pseudoDisplayTypes.length; i++)
         {
            if (m_pseudoDisplayTypes[i]!=null)
            {
               top.Query.document.writeln('<font face="Helvetica,Arial" size=-2><NOBR>&nbsp;&nbsp;'+m_pseudoDisplayTypes[i]+'</NOBR></font><BR>');
            }
         }
      }
      else
      {
         //more than one type, show the selectable table view
         top.Query.document.writeln('<FONT face="Helvetica,Arial" size=-4><NOBR>'+TYPE_HINT+'</NOBR></FONT><BR>');
         top.Query.document.writeln('<table width=100% bgcolor=#EFEEE9 style="margin-top:5; border-style:solid; border-width:1; border-color:#BFBBB2;">');
         top.Query.document.writeln('<tr><td>');
         top.Query.document.writeln('   <table width=100% cellpadding=0 cellspacing=0>');
         
         top.Query.document.writeln('<tr id='+SIMPLE_ROW+HDR_TAG+' bgcolor="'+SELECTED_BGCOLOR+'">');
         top.Query.document.writeln('<td align=left id='+SIMPLE_ROW+HDR_TAG+'txt onClick="javascript:top.selectType(\''+HDR_TAG+'\')" style="cursor:pointer; color:'+SELECTED_TEXT_COLOR+'"><font face="Helvetica,Arial" size=-2><NOBR>&nbsp;&nbsp;'+ALL_TYPES+'</NOBR></font></td>');
         top.Query.document.writeln('</tr>');
         var rowIdx=0;
         for (var i=0; i<m_displayTypes.length; i++)
         {
            if (m_displayTypes[i]!=null && m_displayTypes[i].length>0)
            {
               top.Query.document.writeln('<tr id='+SIMPLE_ROW+rowIdx+' bgcolor="'+UNSELECTED_BGCOLOR+'">');
               top.Query.document.writeln('<td align=left id='+SIMPLE_ROW+rowIdx+'txt onClick="javascript:top.selectType('+rowIdx+')" style="cursor:pointer"><font face="Helvetica,Arial" size=-2><NOBR>&nbsp;&nbsp;'+m_displayTypes[i]+'</NOBR></font></td>');
               top.Query.document.writeln('</tr>');
            }
            rowIdx++;
         }
         for (var i=0; i<m_pseudoDisplayTypes.length; i++)
         {
            if (m_pseudoDisplayTypes[i]!=null && m_pseudoDisplayTypes[i].length>0)
            {
               top.Query.document.writeln('<tr id='+SIMPLE_ROW+rowIdx+' bgcolor="'+UNSELECTED_BGCOLOR+'">');
               top.Query.document.writeln('<td align=left id='+SIMPLE_ROW+rowIdx+'txt onClick="javascript:top.selectType('+rowIdx+')" style="cursor:pointer"><NOBR><font face="Helvetica,Arial" size=-2>&nbsp;&nbsp;'+m_pseudoDisplayTypes[i]+'</font></NOBR></td>');
               top.Query.document.writeln('</tr>');
            }
            rowIdx++;
         }
         top.Query.document.writeln('   </table>');
         top.Query.document.writeln('</td></tr>');
         top.Query.document.writeln('</table>');
         
         updateTypeSelections();
      }
   }
   
   function showAdvancedTypes()
   {
      //show the advanced selectable table view
      var CURSOR = "default";
      if (m_numViewableTypes>1)
      {
         CURSOR="pointer";
         top.Query.document.writeln('<tr id='+ADV_ROW+HDR_TAG+' bgcolor="'+SELECTED_BGCOLOR+'">');
         top.Query.document.writeln('<td width=14 align=center><span id="minus'+HDR_TAG+'" style="display:none"><a href="#" onClick="javascript:top.clearAllCriterion()"><img src="'+NPS_MODULES_URL+'/fw/images/'+MINUS_BUTTON+'" alt="'+CLEAR_ALL_CRITERION+'" border=0></a></span></td>');
         top.Query.document.writeln('<td width=14><font face="Helvetica,Arial" size=-2>&nbsp;</font></td>');
         top.Query.document.writeln('<td align=left id='+ADV_ROW+HDR_TAG+'txt onClick="javascript:top.selectType(\''+HDR_TAG+'\')" style="cursor:'+CURSOR+'; color:'+SELECTED_TEXT_COLOR+'"><font face="Helvetica,Arial" size=-2><NOBR>&nbsp;'+ALL_TYPES+'</NOBR></font></td>');
         top.Query.document.writeln('</tr>');
      }
   
      var rowIdx=0;
      for (var i=0; i<m_displayTypes.length; i++)
      {
         if (m_displayTypes[i]!=null && m_displayTypes[i].length>0)
         {
            top.Query.document.writeln('<tr id='+ADV_ROW+rowIdx+' bgcolor="'+UNSELECTED_BGCOLOR+'">');
            top.Query.document.writeln('<td width=14 align=center><span id="minus'+i+'" style="display:none"><a href="#" onClick="javascript:top.clearCriterion(\''+m_types[i][1]+'\')"><img src="'+NPS_MODULES_URL+'/fw/images/'+MINUS_BUTTON+'" alt="'+CLEAR_CRITERION+'&nbsp;'+m_displayTypes[i]+'" border=0></a></span></td>');
            top.Query.document.writeln('<td width=14 align=center><a href="#" onClick="javascript:top.doMyAS(\''+m_types[i][1]+'\')"><img src="'+NPS_MODULES_URL+'/fw/images/'+PLUS_BUTTON+'" alt="'+ADD_EDIT_CRITERION+'&nbsp;'+m_displayTypes[i]+'" border=0></a></td>');
            top.Query.document.writeln('<td align=left id='+ADV_ROW+rowIdx+'txt onClick="javascript:top.selectType('+rowIdx+')" style="cursor:'+CURSOR+'"><font face="Helvetica,Arial" size=-2><NOBR>&nbsp;'+m_displayTypes[i]+'</NOBR></font></td>');
            top.Query.document.writeln('</tr>');
         }
         rowIdx++;
      }
      for (var i=0; i<m_pseudoDisplayTypes.length; i++)
      {
         if (m_pseudoDisplayTypes[i]!=null && m_pseudoDisplayTypes[i].length>0)
         {
            top.Query.document.writeln('<tr id='+ADV_ROW+rowIdx+' bgcolor="'+UNSELECTED_BGCOLOR+'">');
            top.Query.document.writeln('<td width=14><font face="Helvetica,Arial" size=-2>&nbsp;</font></td>');
            top.Query.document.writeln('<td width=14><font face="Helvetica,Arial" size=-2>&nbsp;</font></td>');
            top.Query.document.writeln('<td align=left id='+ADV_ROW+rowIdx+'txt onClick="javascript:top.selectType('+rowIdx+')" style="cursor:'+CURSOR+'"><font face="Helvetica,Arial" size=-2><NOBR>&nbsp;'+m_pseudoDisplayTypes[i]+'</font></NOBR></td>');
            top.Query.document.writeln('</tr>');
         }
         rowIdx++;
      }

      updateTypeSelections();
      updateClearButtons();
   }
   
   function updateTypeSelections()
   {
      if (m_numViewableTypes>1 && m_bHdrEnabled)
      {
         activateHdr();
      }
      else
      {
         if (m_numViewableTypes>1)
         {
            //display header as active.
            setRowAttributes(HDR_TAG, UNSELECTED_TEXT_COLOR, UNSELECTED_BGCOLOR);
            m_bHdrEnabled=false;
         }
      
         //just set row attributes
         var rowIdx=0;
         for (var i=0; i<m_types.length; i++)
         {
            if (m_types[i][0])
            {
               setRowAttributes(rowIdx, SELECTED_TEXT_COLOR, SELECTED_BGCOLOR);
            }
            else
            {
               setRowAttributes(rowIdx, UNSELECTED_TEXT_COLOR, UNSELECTED_BGCOLOR);
            }
            rowIdx++;
         }
         for (var i=0; i<m_pseudoTypes.length; i++)
         {
            if ( m_pseudoTypes[i][0])
            {
               setRowAttributes(rowIdx, SELECTED_TEXT_COLOR, SELECTED_BGCOLOR);
            }
            else
            {
               setRowAttributes(rowIdx, UNSELECTED_TEXT_COLOR, UNSELECTED_BGCOLOR);
            }
            rowIdx++;
         }
      } 
   }
   
   function updateClearButtons()
   {
      var element=null;
      for (var i=0; i<m_types.length; i++)
      {
         //update i-th clear '-'
         element = top.Query.document.getElementById("minus"+i);
         if (element!=null)
         {
            element.style.display=((m_types[i][2]!=null && m_types[i][2].length>0)?"inline":"none");
         }
      }
      //update clear all '-'
      element = top.Query.document.getElementById("minus"+HDR_TAG);
      if (element!=null)
      {
         element.style.display=((numCriterion()>1)?"inline":"none");
      }
   }
   