// This file duplicates some of the functionality of MoveListItems
// Unfortunatly move list items did some specific things I didn't need
// Example: MoveListItems sorted a list everytime items were added.
// I needed an unsorted list

function moveOptions(selA, selB)
{
   var i=0;
   while(i < selA.options.length)
   {
      if(selA.options[i].selected)
      {
         var length = selB.options.length;
         selB.options[length] = new Option(selA.options[i].text, selA.options[i].value);

         selA.options[i] = null;
      }
      else
      {
         i++;
      }
   }
}

function moveOptionUp(sel)
{
   var index = sel.selectedIndex;
   if(index>=0 && index>0)
   {
      var tempVal = sel.options[index].value;
      var tempTxt = sel.options[index].text;

      sel.options[index].value = sel.options[index-1].value;
      sel.options[index].text = sel.options[index-1].text;

      sel.options[index-1].value = tempVal;
      sel.options[index-1].text = tempTxt;

      sel.selectedIndex = index-1;
   }
}

function moveOptionDown(sel)
{
   var index = sel.selectedIndex;
   if(index>=0 && index < sel.length-1)
   {
      var tempVal = sel.options[index].value;
      var tempTxt = sel.options[index].text;

      sel.options[index].value = sel.options[index+1].value;
      sel.options[index].text = sel.options[index+1].text;

      sel.options[index+1].value = tempVal;
      sel.options[index+1].text = tempTxt;

      sel.selectedIndex = index+1;
   }
}

function sortSelectBox(x)
{
   if (x.length > 1)
   {
      sortedArray = new Array();

      for (var i=0; i < x.length; i++)
      {
         sortedArray[i] = new Array(x[i].text, x[i].value, false, false);
      }

      sortedArray.sort(sortByText);

      for (var i=0; i < x.length; i++)
      {
         x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
         x[i].selected = sortedArray[i][3];
      }
   }
}

// help called by sortSelectBox
function sortByText(a,b)
{
    if(a[0].toUpperCase() < b[0].toUpperCase())
    {
        return -1;
    }
    else if(a[0].toUpperCase() > b[0].toUpperCase())
    {
        return 1;
    }

    return 0;
}

function packSelect(sel)
{
   var list = new Array();
   var options = sel.options;
   for(var i=0; i < options.length; i++)
   {
      list[list.length] = options[i].value;
   }

   return pack(list);
}


