// This file contains javascript used by the Timestamp Uihandler

function uih_timestamp(name, uiControl, xmlControl)
{
   var sel = document.getElementById("Timestamp_Editor");

   var xml = "<attribute>";

   for(var i=0; i<sel.options.length; i++)
   {
      var list = unpack(sel.options[i].value);
      alert ("uih_timestamp seconds is " + list[0]);
      xml += "<value><seconds>"+list[0]+"</seconds><replica>"+list[1]+"</replica><event>"+list[2]+"</event></value>";
   }

   xml += "</attribute>";
   xmlControl.value = xml;
   return true;
}

function openTimestampPopup(mode, returnMethodName, readOnly, singleValued, secs, replica, eventid)
{
   var width = 450;
   var height = 550;
   var x = (screen.availWidth-width)/2;
   var y =  (screen.availHeight-height)/3;
   var params = "left="+x+",top="+y+",height="+height+",width="+width+",resizable,scrollbars";
   var url = "webacc?taskId=dev.Empty&merge=fw.TimestampEditorPopup&mode="+mode + "&returnMethodName=" + returnMethodName;
   url += "&readOnly="+readOnly +"&singleValued="+singleValued;	
   if(mode == "edit")
   {
      url += "&secs=" + secs + "&replica=" + replica + "&eventid=" + eventid;
   }
   var w = window.open(url,"TimestampEditor", params);
}

function addTimestampItem(singleValued)
{
	var sel = document.forms[0].Timestamp_Editor;
   	if (singleValued && sel.options.length > 0)
   	{
   		document.forms[0].addIcon.disabled = true;
   		return;
   	} 
   	  
	openTimestampPopup("add", "returnFromTSAdd", false, singleValued);

}

function deleteTimestampItem()
{
   var sel = document.forms[0].Timestamp_Editor;
   sel.options[sel.selectedIndex] = null;
   if (sel.options.length == 0 && document.forms[0].addIcon.disabled)
   {
   		document.forms[0].addIcon.disabled = false;
   		return;
   }
}

function editTimestampItem(readOnly, singleValued)
{
   var sel = document.forms[0].Timestamp_Editor;
   editingIndex = sel.selectedIndex;

   var list = unpack(sel.value);
   openTimestampPopup("edit", "returnFromTSEdit", readOnly, singleValued, list[0], list[1], list[2]);
}

function returnFromTSAdd(packedTimestamp)
{
   if(packedTimestamp==null || packedTimestamp.length==0) return;

   var list = unpack(packedTimestamp);
   var displayTimestamp = list[0] + " - " + list[1]  + " - " + list[2];
   var sel = document.forms[0].Timestamp_Editor;
   sel.options[sel.options.length] = new Option(displayTimestamp, packedTimestamp);
}

function returnFromTSEdit(packedTimestamp)
{
   if(editingIndex<0) return;
   if(packedTimestamp==null || packedTimestamp.length==0) return;

   var list = unpack(packedTimestamp);
   var displayTimestamp = list[0] + " - " + list[1]  + " - " + list[2];
   var sel = document.forms[0].Timestamp_Editor;
   sel.options[editingIndex] = new Option(displayTimestamp, packedTimestamp);
}