// Glogal Variables
var	g_xmlHttpRequest = null;
var	g_uniqueID 		= 0;

/**
 * 
 */
function TreeView_createXMLHttpRequest()
{
	if(window.ActiveXObject)
	{
		g_xmlHttpRequest = new ActiveXObject("Microsoft.XMLHTTP");
	}
	else if(window.XMLHttpRequest)
	{
		g_xmlHttpRequest = new XMLHttpRequest();
	}
} // end of createXMLHttpRequest()

/**
 * 
 */
function TreeView_onPageLoadCallBack()
{
	if(g_xmlHttpRequest.readyState == 4)
	{
		if(g_xmlHttpRequest.status == 200)
		{
			var xmlDoc = g_xmlHttpRequest.responseXML;
			var error = TreeView_checkForError(xmlDoc);
			if(error == false)
			{
				addBreadCrumbLinks(xmlDoc);
				addNewMenuItems(xmlDoc);
				TreeView_initTable(xmlDoc);
			}
		}
	}
} // end of onPageLoadCallBack()

/**
 * 
 */
function TreeView_checkForError(xmlDoc)
{
	// If an error existed before then remove it.
	hideError();
	
	var rootElement = xmlDoc.documentElement;

	// Get the value of the "error" attribute.
	var errorMsg = rootElement.getAttribute('error-message');
	if(errorMsg != null)
	{
		// Get the error message div
		var errorMessageDiv = document.getElementById("errorMessageDiv");
		
		// remove any previous error message div's
		removeChildrenRecursively(errorMessageDiv);
		
		// Get top message box and append
		var topMessageBox = TreeView_createTopErrorMessageBox();
		errorMessageDiv.appendChild(topMessageBox);
		
		var errorMessageContent = createErrorMessageContent(xmlDoc);
		errorMessageDiv.appendChild(errorMessageContent);
		
		// Get bottom message box and append
		var bottomMessageBox = TreeView_createBottomErrorMessageBox();
		errorMessageDiv.appendChild(bottomMessageBox);

		// Show the error message div		
		errorMessageDiv.style.display = "block";
		
		return true;
	}

	return false;
} // end of checkForError()

/**
 * 
 */
function TreeView_createTopErrorMessageBox()
{
	var mBox = document.createElement('b');
	mBox.className = "messagebox";

	var mBox1 = document.createElement('b');
	mBox1.className = "messagebox1";
	
	var mBox1E = document.createElement('b');
	mBox1.appendChild(mBox1E);
			
	var mBox2 = document.createElement('b');
	mBox2.className = "messagebox2";
	
	var mBox2E = document.createElement('b');
	mBox2.appendChild(mBox2E);
			
	var mBox3 = document.createElement('b');
	mBox3.className = "messagebox3";
		
	var mBox4 = document.createElement('b');
	mBox4.className = "messagebox4";
		
	var mBox5 = document.createElement('b');
	mBox5.className = "messagebox5";
		
	mBox.appendChild(mBox1);
	mBox.appendChild(mBox2);
	mBox.appendChild(mBox3);
	mBox.appendChild(mBox4);
	mBox.appendChild(mBox5);
	
	return mBox;
}

/**
 * 
 */
function TreeView_createBottomErrorMessageBox()
{
	var mBox = document.createElement('b');
	mBox.className = "messagebox";

	var mBox5 = document.createElement('b');
	mBox5.className = "messagebox5";
		
	var mBox4 = document.createElement('b');
	mBox4.className = "messagebox4";
		
	var mBox3 = document.createElement('b');
	mBox3.className = "messagebox3";
		
	var mBox2 = document.createElement('b');
	mBox2.className = "messagebox2";
	
	var mBox2E = document.createElement('b');
	mBox2.appendChild(mBox2E);
			
	var mBox1 = document.createElement('b');
	mBox1.className = "messagebox1";
	
	var mBox1E = document.createElement('b');
	mBox1.appendChild(mBox1E);
			
	mBox.appendChild(mBox5);
	mBox.appendChild(mBox4);
	mBox.appendChild(mBox3);
	mBox.appendChild(mBox2);
	mBox.appendChild(mBox1);
	
	return mBox;
}

/**
 * 
 */
function TreeView_showErrorLink(errorLink)
{
	launchError("fw/" + errorLink);
} // end of showErrorLink()

/**
 * 
 */
function TreeView_getMenuItemTypeNodes(xmlDoc, type)
{
	var menuItems = new Array();
	var menuItemNodes = xmlDoc.getElementsByTagName("menu-item");
	for(var i = 0; i < menuItemNodes.length; i++)
	{
		var menuType = menuItemNodes[i].getAttribute('menu-type');
		if(menuType == type)
		{
			menuItems[menuItems.length] = menuItemNodes[i];
		}
	}

	return menuItems;
} // end of getMenuItemTypeNodes()

/**
 * 
 */
function TreeView_getMenuItemNodes(xmlDoc)
{
	var menuItems = new Array();
	var menuItemNodes = xmlDoc.getElementsByTagName("menu-item");
	for(var i = 0; i < menuItemNodes.length; i++)
	{
		menuItems[menuItems.length] = menuItemNodes[i];
	}

	return menuItems;
} // end of getMenuItemNodes()

/**
 * 
 */
function TreeView_getCurrentContainerDN(xmlDoc)
{
	var containerNode = xmlDoc.getElementsByTagName("container");
	var containerDN = containerNode[0].getAttribute('container-dn'); // Should only be one container node
	
	return containerDN;
} // end of getCurrentContainerDN()

/**
 * 
 */
function TreeView_getNextBlockCallBack()
{
	if(g_xmlHttpRequest.readyState == 4)
	{
		if(g_xmlHttpRequest.status == 200)
		{
			var xmlDoc = g_xmlHttpRequest.responseXML;
			var error = TreeView_checkForError(xmlDoc);
			if(error == false)
			{
				TreeView_initTable(xmlDoc);
			}
		}
	}
} // end of getNextBlockCallBack()
 
/**
 * 
 */
function TreeView_refreshListCallBack()
{
	if(g_xmlHttpRequest.readyState == 4)
	{
		if(g_xmlHttpRequest.status == 200)
		{
			var xmlDoc = g_xmlHttpRequest.responseXML;
			var error = TreeView_checkForError(xmlDoc);
			if(error == false)
			{
				TreeView_initTable(xmlDoc);
			}
		}
	}
} // end of refreshListCallBack()
 
/**
 * 
 */
function TreeView_getPreviousBlockCallBack()
{
	if(g_xmlHttpRequest.readyState == 4)
	{
		if(g_xmlHttpRequest.status == 200)
		{
			var xmlDoc = g_xmlHttpRequest.responseXML;
			var error = TreeView_checkForError(xmlDoc);
			if(error == false)
			{
				TreeView_initTable(xmlDoc);
			}
		}
	}
} // end of getPreviousBlockCallBack()

/**
 * 
 */
function TreeView_initTable(xmlDoc)
{
	// Unselect "Select all" checkbox.
	ckbox = document.getElementById('selectAllCkbox');
	ckbox.checked = false;

	// Remove the existing contents of the object entries table
	TreeView_emptyObjectEntryTable();
	
	if(xmlDoc != null)
	{
		setNameSortImage(xmlDoc);
		setTitleRowInfo(xmlDoc);
		setMenuRowInfo(xmlDoc);
		
		// Update the text that shows 101-200 of 750
		updateCountersText(xmlDoc);
		
		var editTaskID = null;
		var menuItemNodes = xmlDoc.getElementsByTagName("menu-item");
		if(menuItemNodes != null)
		{
			for(var i = 0; i < menuItemNodes.length; i++)
			{
				var menuType = menuItemNodes[i].getAttribute('menu-type');
				if(menuType == "edit")
				{
					editTaskID = menuItemNodes[i].getAttribute('task-id');
					break;
				}
			}
		}
		
		var objectEntryNodes = xmlDoc.getElementsByTagName("object-entry");
		for(var i = 0; i < objectEntryNodes.length; i++)
		{
			addObjectEntryToPage(objectEntryNodes[i], editTaskID);
		}
		
		// Make sure the first object entry is showing.
		var table = TreeView_getObjectEntryTable();
		table.rows[0].scrollIntoView();
		
		// Set a flag to indicate if we are browsing in the file system.  
		// If so, turn off filter status indicators and link to disable filtering.
 		var span = document.getElementById('FilterStatusIndicators');
 		if ( xmlDoc.documentElement.getAttribute('is-file-system') == "true")
 			span.style.display = 'none';
 		else
 			span.style.display = '';		
		
	}
} // end of initTable()

/**
 * Remove all the rows in the table that contain object entries.
 */
function TreeView_emptyObjectEntryTable()
{
	var table;
	var i;
	
	// Get the <table> that holds the list of object entries.
	table = TreeView_getObjectEntryTable();
	
	// Spin through the rows in the table.  If we find a row that has a n_objectEntryElement property we
	// will remove that row from the table.
	for(i = 0; i < table.rows.length; ++i)
	{
		var	tr;
		
		// Get the next tr from the table.
		tr = table.rows.item(i);
		
		// Does this row contain a object entry?
		if(TreeView_isDefined(tr.n_objectEntryElement))
		{
			// Yes, Delete the row.
			table.deleteRow(i);
			--i;
		}
	}// end for()
}// end of emptyObjectEntryTable()

/**
 * This function will return the table that holds the list of object entries.
 */
function TreeView_getObjectEntryTable()
{
	return document.getElementById('objectEntryTable');
}// end getObjectEntryTable()

/**
 * 
 */
function TreeView_isDefined(o)// Is this object defined? 
{ 
	var	r; 

	// We're we given an object to check? 
	r = (null != o); 
	if(r) 
	{ 
		var	s; 
		// Yes!  Is the object defined? 
		s = typeof o; 
		r = (("undefined" != s) && ("unknown" != s)); 
	} // if 

// If we get here, r contains true if the object is defined and 
// false otherwise.  Return it. 

	return(r); 
} // end of isDefined()

/**
 * 
 */
function TreeView_createTR( 
		eTABLE,// The TABLE Element to create the TR in. 
		sID,// The ID               of the TR Element. 
		sClass,// The class            of the TR Element. 
		sAlign,// The align  attribute of the TR Element. 
	sVAlign)// The valign attribute of the TR Element. 
{ 
	var eTR; 

	// Create a TR Element in the TABLE Element... 
	eTR = eTABLE.insertRow(eTABLE.rows.length); 

	// ...and store the other attributes that we were given for it. 
	if (sID)     eTR.id        = sID; 
	if (sClass)  eTR.className = sClass; 
	if (sAlign)  eTR.align     = sAlign; 
	if (sVAlign) eTR.vAlign    = sVAlign; 

	// If we get here, eTR refers to the TR Element created. 
	// Return it. 
	return(eTR); 
} // end of createTR()

/**
 * 
 */
function TreeView_createTD( 
		eTR,// The TR Element to create the TD in. 
		sID,// The ID                of the TD Element. 
		sClass,// The class             of the TD Element. 
		sAlign,// The align   attribute of the TD Element. 
		sVAlign,// The valign  attribute of the TD Element. 
		iColspan)// The colspan attribute of the TD Element. 
{ 
	var eTD; 

	// Create a TD Element in the TABLE Element... 
	eTD = eTR.insertCell(eTR.cells.length); 

	// ...and store the other attributes that we were given for it. 
	if (sID)      eTD.id        = sID; 
	if (sClass)   eTD.className = sClass; 
	if (sAlign)   eTD.align     = sAlign; 
	if (sVAlign)  eTD.vAlign    = sVAlign; 
	if (iColspan) eTD.colSpan   = iColspan; 

	// If we get here, eTD refers to the TD Element created. 
	// Return it. 
	return(eTD); 
} // end of createTD() 

/** 
 * This function will return a unique id. 
 */ 
function TreeView_getUniqueId() 
{ 
	++g_uniqueID; 
	return g_uniqueID; 
}// end of getUniqueId() 

/**
 * 
 */
function TreeView_hasString( 
		sValue)// Does this string contain a value? 
{
	return((null != sValue) && (0 < sValue.length) ); 
} // end of hasString()

/** 
 *  
 */ 
function TreeView_updateElementsTextNode( 
		element,// The Element whose text Node is to be updated. 
		newText)// The text to update the Node with. 
{ 
	var	found; 
	var	i; 
	var kids; 
	var	numKids; 

	if (null == element) 
	{ 
		return; 
	} // if 

// Find the text node for this element. 
	kids = element.childNodes; 
	numKids = kids.length; 
	found = false; 
	for (i = 0; ((i < numKids) && (!found)); i += 1) 
	{ 
		// Is this child a text node? 
		if (3 == kids[i].nodeType) 
		{ 
			// Yes!  Replace its text with the new text. 
			kids[i].data = newText; 
			found        = true; 
		} // if 
	} // for 

	// Did we find a text node? 
	if (!found) 
	{ 
		var textNode; 
		// No!  Create one and add it to the element. 
		textNode = element.ownerDocument.createTextNode(newText); 

		element.appendChild(textNode); 
	} // if 
} // end of updateElementsTextNode()

/** 
 * Set the background and foreground color for a menu item when the mouse is moved off of 
 * the menu item. 
 */ 
function TreeView_setMenuItemMouseOutColor(item) 
{ 
	item.style.backgroundColor = ''; 
	item.style.color = ''; 
}// end setMenuItemMouseOutColor() 

/** 
 * Set the background and forground color for a menu item when the mouse is moved over 
 * the menu item. 
 */ 
function TreeView_setMenuItemMouseOverColor(item) 
{ 
	item.style.backgroundColor = '#458AB9'; 
	item.style.color = '#ffffff'; 
}// end setMenuItemMouseOverColor() 

/** 
 *  
 */ 
function TreeView_getActionsMenuTaskListCallBack()
{
	if(g_xmlHttpRequest.readyState == 4)
	{
		if(g_xmlHttpRequest.status == 200)
		{
			var xmlDoc = g_xmlHttpRequest.responseXML;
			var error = TreeView_checkForError(xmlDoc);
			if(error == false)
			{
				addActionsMenuItems(xmlDoc);
			}
		}
	}
} // end of getActionsMenuTaskListCallBack()

/** 
 *  
 */ 
function TreeView_getDeleteMenuTaskListCallBack()
{
	if(g_xmlHttpRequest.readyState == 4)
	{
		if(g_xmlHttpRequest.status == 200)
		{
			var xmlDoc = g_xmlHttpRequest.responseXML;
			var error = TreeView_checkForError(xmlDoc);
			if(error == false)
			{
				addDeleteMenuItems(xmlDoc);
			}
		}
	}
} // end of getDeleteMenuTaskListCallBack()

/** 
 *  
 */ 
function TreeView_getEditMenuTaskListCallBack()
{
	if(g_xmlHttpRequest.readyState == 4)
	{
		if(g_xmlHttpRequest.status == 200)
		{
			var xmlDoc = g_xmlHttpRequest.responseXML;
			var error = TreeView_checkForError(xmlDoc);
			if(error == false)
			{
				addEditMenuItems(xmlDoc);
			}
		}
	}
} // end of getEditMenuTaskListCallBack()

/**
 * 
 */
function TreeView_handleClickOnNewMenu(span)
{
	showhide(span);
} // end of handleClickOnNewMenu()

/**
 * This function gets called when the user clicks on the "Select All" checkbox.  We will
 * select or unselect every checkbox in the table according to the state of the "select all"
 * checkbox.
 */
function TreeView_onClickSelectAll()
{
	var	table;
	var	ckbox;
	var	i;
	
	// Get the <table> that holds the list of object entries.
	table = TreeView_getObjectEntryTable();
	
	// Get the "Select all" checkbox.
	ckbox = document.getElementById('selectAllCkbox');

	for (i = 0; i < table.rows.length; ++i)
	{
		var	tr;
		var	nextCkbox;
		
		// Get the next row.
		tr = table.rows.item(i);
		
		var objectEntryElement = tr.n_objectEntryElement;
		if (TreeView_isDefined( objectEntryElement))
		{
			// See if this is the current node
			var isCurrent = objectEntryElement.getAttribute('is-current');
			if(isCurrent == "true")
			{
				// Don't check the current node
				continue;
			}
		}		
		
		// Get the checkbox in this row.
		nextCkbox = tr.n_ckboxCtrl;
		
		if(TreeView_isDefined(nextCkbox))
		{
			nextCkbox.checked = ckbox.checked;
			
			// Call the onclick event handler so the row gets highlighted/unhighlighted.
			nextCkbox.onclick();
		}
	}// end for()
}// end of onClickSelectAll()

/**
 * We always want the buttons on this page to be visible so we will figure out how much room to give them and then give
 * the rest of the room to the <div> that holds the page content.
 */
function TreeView_resizePage()
{
	var	windowHeight;
	var	buttonDivHeight;
	var	breadCrumbDivHeight;
	var	contentDivHeight	= 0;
	var	menuDivHeight;
	var	selectDriverDivHeight;
	var	div;
	
	// See how much room we have.
	windowHeight = TreeView_getWindowHeight() - 70;
	
	// Get the height of the <div> that holds the buttons.
	buttonDivHeight = TreeView_getElementHeight( 'buttonDiv' );
	
	// Get the height of the <div> that holds the header.
	breadCrumbDivHeight = TreeView_getElementHeight( 'breadCrumbDiv' );
	
	// Get the height of the <div> that holds the menu.
	menuDivHeight = TreeView_getElementHeight( 'menuDiv' );
		
	// Get the height of the <div> that holds the driver dn
	selectDriverDivHeight = TreeView_getElementHeight( 'selectDriverDiv' );
		
	// Give the rest of the space to the <div> that holds the content of the page
	if ( windowHeight > buttonDivHeight )
//		contentDivHeight = windowHeight - selectDriverDivHeight - menuDivHeight - buttonDivHeight;
		contentDivHeight = windowHeight - breadCrumbDivHeight - selectDriverDivHeight - menuDivHeight - buttonDivHeight;
	div = document.getElementById( 'listOfObjectEntrysDiv' );
	div.style.height = contentDivHeight + 'px';
}// end of resizePage()

/**
 * Get the current height of the browser window.
 */
function TreeView_getWindowHeight() 
{ 
	var wndHeight; 
	if(document.all)
	{ 
		wndHeight = document.body.clientHeight;
	}
	else
	{
		wndHeight = window.innerHeight;
	}

	return wndHeight; 
} // end of getWindowHeight()

/**
 * Get the current width of the browser window.
 */
function TreeView_getWindowWidth() 

{
	var wndWidth; 

	if(document.all)
	{
		wndWidth = document.body.clientWidth;
	}
	else
	{
		wndWidth = window.innerWidth;
	}

	return wndWidth; 
} // end of getWindowWidth()

/**
 * 
 */
function TreeView_getElementHeight(
	elementId)	//
{
	var	height;
	var	element;

	height  = 0;
	element = document.getElementById(elementId);
	if (null != element)
	{
		height = element.offsetHeight;
	} // if

	return height;
} // end of getElementHeight()

/**
 * This function is the onresize event handler.  It will get called when the user resizes the browser.  We always want
 * the buttons on this page to be visible so we will figure out how much room to give them and then give the rest of
 * the room to the <div> that holds the main content.
 */
function TreeView_handleOnResize()
{
	TreeView_resizePage();
}// end of handleOnResize()

/**
 * Return an array that holds <tr> elements that are selected in the given table.
 */
function TreeView_getSelectedRows(table)
{
	var	selectedRows;
	var	i;
	
	selectedRows = new Array();
	
	for(i = 0; i < table.rows.length; ++i)
	{
		var	tr;
		var	ckbox;
		
		// Get the next row.
		tr = table.rows.item( i );
		
		// Get the checkbox in this row.
		ckbox = tr.n_ckboxCtrl;
		
		// Is this row selected?
		if(TreeView_isDefined(ckbox) && ckbox.checked)
		{
			// Yes
			selectedRows[selectedRows.length] = tr;
		}
	}// end for()
	
	return selectedRows;	
}// end of getSelectedRows()
