


// Support for event/action system
function sendAction(fieldName, actionName)
{
   var methodName = actionHandlerTable[fieldName];
   if(methodName==null) return;

   var methodPtr = eval(methodName);
   var xmlControl = eval("document.forms[0]."+fieldPrefix+"$" + fieldName);
   var uiControl = eval("document.forms[0]._"+fieldName);
   var success = methodPtr(fieldName, uiControl, xmlControl, actionName);
}


// Notifies all controls that registered a listener for the page exit
// event by calling addToNotificationList(...)
function notifyAllOfExit()
{
   var size=exitNotificationControlNames.length;
   for(var i=0; size>i; i++)
   {
      var name = exitNotificationControlNames[i];
      var methodPtr = eval(exitNotificationMethodNames[i]);
      var xmlControl = eval("document.forms[0]."+fieldPrefix+"$" + name);
      var uiControl = eval("document.forms[0]._"+name);


      var uiObject = null;
      try
      {
         uiObject = eval("window.uiObject_"+name);
      }
      catch(e)
      {
         // ignore; in older code uiObject_... will not be defined; that is ok
      }


      var success = methodPtr(name, uiControl, xmlControl, uiObject);

      if(!success)
      {
         return false;
      }
   }

   return true;
}

function getValueFromXml(str)
{
   s = str.indexOf("<value>");
   e = str.indexOf("</value>");
   if((s!=-1) && (e!=-1))
   {
      return xmlDecode(str.substring(s+7, e));
   }
   return "";
}

// helps build XML for Multiple Object Opperations
function getMooMode(name)
{
   var modeControl = eval("document.forms[0]._" + name + "_mode");
   return (modeControl ? "mode='" + modeControl[modeControl.selectedIndex].value + "'" : "");
}

// only works on control that support uiControl.value
function matchesRegularExpression(uiControl, uiObject)
{
   if(uiObject && uiObject.m_regExpression && uiObject.m_regExpression!="")
   {
      var matches = uiControl.value.match(uiObject.m_regExpression);
      if(matches==null || matches.length==0)
      {
         alert(uiObject.m_regExpressionErrorMsg);
         uiControl.focus();
         return false;
      }
   }

   return true;
}

function uih_textfield(name, uiControl, xmlControl, uiObject)
{

   var success = validateTextfield(name);
   if(!success)
   {
      uiControl.focus();
      return false;
   }

   if(uiControl.value!="")
   {
      // validate value; older custom tasks will not have a uiObject
      if(uiObject && !matchesRegularExpression(uiControl, uiObject))
      {
         return false;
      }
      xmlControl.value = "<attribute "+getMooMode(name)+"><value>" + xmlEncode(uiControl.value) + "</value></attribute>";
   }
   else
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"></attribute>";
   }
   return true;
}


function uih_textarea(name, uiControl, xmlControl, uiObject)
{
	
   // Don't allow more than 5mb;  it can crash the iManager server
   var maxlength = 5000000;
   if(uiControl.value.length > maxlength)
   {
      var msg = formatMessage(window.rc_invalidStringLengthMsg, ["0", ""+maxlength]);
      alert(msg);
      return false;
   }

   if(uiControl.value!="")
   {
   		
      // validate value; older custom tasks will not have a uiObject
      if(uiObject && !matchesRegularExpression(uiControl, uiObject))
      {
         return false;
      }
      
      // This Change is regarding a Bug 357511 - modifying a Syntax stream attribute by XML values is giving exception.
      // It is strange that the Edit of stream value retrieve the data in a format,
      // xmlControl.value = "<attribute-name "+getMooMode(name)+"><value>" + xmlEncode(uiControl.value) + "</value></attribute-name>";
      // where attribute-name is any attribute name like stream_attr for a Stream attribute.
      // But while saving the Data we send the value is a format,
      // xmlControl.value = "<attribute "+getMooMode(name)+"><value>" + xmlEncode(uiControl.value) + "</value></attribute>";
      // Hence this two different format mismatch and throws an Jsp exception as,
      // -----javax.servlet.jsp.JspException: The processing instruction target matching
      // -----"[xX][mM][lL]" is not allowed.
      
      // I am commenting out the following line and writing a new line of code that take the real attribute name 
      // instead of a string "attribute".
      
      //--Code Change for Bug 357511
      // -- Start Here
      
       //xmlControl.value = "<attribute "+getMooMode(name)+"><value>" + xmlEncode(uiControl.value) + "</value></attribute>";
         xmlControl.value = "<"+name+" "+getMooMode(name)+"><value>" + xmlEncode(uiControl.value) + "</value></"+name+">";
	  
	  // -- End Here
   }
   else
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"></attribute>";
   }
   return true;
}



function uih_octetstring(name, uiControl, xmlControl)
{
   if(uiControl.value!="")
   {
      if(uiControl.value.length%2==1) //pad a 0 at the front if there's a stray nibble at the end.
      {
         if(uiControl.value.charAt(0)=="0")
         {
            uiControl.value = uiControl.value.substring(1);
         }
         else
         {
           uiControl.value="0" +uiControl.value;
         }
      }
      xmlControl.value = "<attribute "+getMooMode(name)+"><value>" + uiControl.value + "</value></attribute>"; // was asciiToHex
   }
   else
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"></attribute>";
   }
   return true;
}

function uih_checkbox(name, uiControl, xmlControl)
{
   xmlControl.value = "<attribute "+getMooMode(name)+"><value>" + uiControl.checked + "</value></attribute>";
   return true;
}

function uih_radioButton(name, uiControl, xmlControl)
{
   xmlControl.value = "<attribute "+getMooMode(name)+"><value>" + uiControl[0].checked + "</value></attribute>";
   return true;
}

function uih_boolSelect(name, uiControl, xmlControl)
{
   var val = (uiControl.selectedIndex==0 ? "true" : "false");
   xmlControl.value = "<attribute "+getMooMode(name)+"><value>" + val + "</value></attribute>";
   return true;
}

function uih_getControl(name)
{
   return eval("document.forms[0]."+name);
}

function uih_interval(name, uiControl, xmlControl)
{
   var minutesControl = uih_getControl("_" + name+"Minutes");
   var hoursControl = uih_getControl("_" + name+"Hours");
   var daysControl = uih_getControl("_" + name+"Days");

   if(minutesControl.value=="" && hoursControl.value=="" && daysControl.value=="")
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"></attribute>";
   }
   else
   {
      var mins = (minutesControl.value=="" ? 0 : Number(minutesControl.value));
      var hrs = (hoursControl.value=="" ? 0 : Number(hoursControl.value));
      var days = (daysControl.value=="" ? 0 : Number(daysControl.value));

      if(isNaN(mins) || isNaN(hrs) || isNaN(days))
      {
         alert(window.rc_invalidInterval);
         return false;
      }
      var val = mins*60 + hrs*3600 + days*86400;
      xmlControl.value = "<attribute "+getMooMode(name)+"><value>" + val + "</value></attribute>";
   }
   return true;
}

function uih_path(name, uiControl, xmlControl)
{
   var volume = uih_getControl("_"+name+"Volume.value");
   var path = uih_getControl("_"+name+"Path.value");
   var type = null;
   try
   {
   	     type = uih_getControl("_"+name+"Type.value");
   }catch(e)
   {
   }		   
   if(type == null || type == "") type = "0";
   if(path!=null && path.length>0 && volume!=null && volume.length>0)
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"><value><type>" + type + "</type><volume>"+ volume + "</volume><path>" + path + "</path></value></attribute>";
   }
   else
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"></attribute>";
   }
   return true;
}

function uih_pathAdvanced(name, uiControl, xmlControl)
{
   var volume = uih_getControl("_"+name+"Volume.value");
   var path = uih_getControl("_"+name+"Path.value");
   var type = uih_getControl("_"+name+"namespaceType.value");
   if(!validateInteger(type))
   {
   	alert("Not a valid value for type.");
   	return false;
   }
   if(path!=null && path.length>0 && volume!=null && volume.length>0)
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"><value><type>" + type + "</type><volume>"+ volume + "</volume><path>" + path + "</path></value></attribute>";
   }
   else
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"></attribute>";
   }
   return true;
}

function uih_dirMapPath(name, uiControl, xmlControl)
{
   var volume = uih_getControl("_"+name+"Volume.value");
   var path = uih_getControl("_"+name+"Path.value");
   
   volume = iman.trim(volume);
   path = iman.trim(path);
   
   if((volume==null || volume.length == 0) && (path==null || path.length == 0))
   {
   		xmlControl.value = "<attribute "+getMooMode(name)+"></attribute>";
   }
   else
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"><value><type>0</type><volume>"+ volume + "</volume><path>" + path + "</path></value></attribute>";
   }
   return true;
}

function uih_postalAddress(name, uiControl, xmlControl)
{
   var xml = "<attribute "+getMooMode(name)+"><value>";
   for(var i=0; i<6; i++)
   {
      xml += "<item>" + uih_getControl("_"+name+"Item"+i+".value") + "</item>";
   }
   xmlControl.value = xml + "</value></attribute>";
   return true;
}

function uih_typedName(name, uiControl, xmlControl)
{
   var distinguishedName = uih_getControl("_"+name+"DistinguishedName.value");
   if(distinguishedName!=null && distinguishedName.length>0)
   {
      var level = Number(uih_getControl("_"+name+"Level.value"));
      var interval = Number(uih_getControl("_"+name+"Interval.value"));

      if(isNaN(level))
      {
         level = 0;
      }

      if(isNaN(interval))
      {
         interval = 0;
      }

      xmlControl.value = "<attribute "+getMooMode(name)+"><value><distinguished-name>"+distinguishedName+"</distinguished-name><level>"+ level + "</level><interval>" + interval + "</interval></value></attribute>";
   }
   else
   {
      xmlControl.value = "<attribute></attribute>";
   }
   return true;
}

function uih_mvStringEditor(name, uiControl, xmlControl)
{
   xmlControl.value = mvGetValuesAsXml("_" + name);
   return true;
}

// NOTE: People didn't like how uih_mvCheckbox behavied
// giving them what they want, but without changing
// existing plug-ins.
function uih_mvCheckbox2(name, uiControl, xmlControl)
{
   var mooMode = getMooMode(name);
   if(mooMode == "")
   {
      var xml = "<attribute removeExistingValues='false'>";
      var i=0;
      var cb = uih_getControl("_" + name + i);

      while(cb)
      {
         var action = cb.checked ? "add" : "remove";
         xml += "<value action='"+action+"'>" + xmlEncode(cb.value) + "</value>";

         i++;
         cb = uih_getControl("_" + name + i);
      }

      xmlControl.value = xml + "</attribute>";
   }
   else
   {
      var xml = "<attribute "+mooMode+">";
      var i=0;
      var cb = uih_getControl("_" + name + i);

      while(cb)
      {
         if(cb.checked)
         {
            xml += "<value>" + xmlEncode(cb.value) + "</value>";
         }

         i++;
         cb = uih_getControl("_" + name + i);
      }

      xmlControl.value = xml + "</attribute>";
   }

   return true;
}

function uih_mvCheckbox(name, uiControl, xmlControl)
{
   return uih_mvHelper(name, uiControl, xmlControl, "checkbox");
}

function uih_mvRadio(name, uiControl, xmlControl)
{
   return uih_mvHelper(name, uiControl, xmlControl, "radio");
}

function uih_mvHelper(name, uiControl, xmlControl, mode)
{
   var xml = "<attribute "+getMooMode(name)+">";
   var i=0;
   while(true)
   {
      var postfix = (mode=="radio" ? "[" + i + "]" : "" + i);
      var cb = uih_getControl("_" + name+postfix);
      if(cb)
      {
         if(cb.checked)
         {
            xml += "<value>" + xmlEncode(cb.value) + "</value>";
         }
      }
      else
      {
         break;
      }

      i++;
   }

   xmlControl.value = xml + "</attribute>";
   return true;
}

function uih_mvSelect(name, uiControl, xmlControl)
{
   return uih_textfield(name, uiControl, xmlControl);
}

function returnFromCalendar(date, name)
{
   document.forms[0].elements[name].value = date.toLocaleString();
   document.forms[0].elements[name+"_ms"].value = date.valueOf();
}

function onLoadCalendar(name)
{
   var value = document.forms[0].elements[name+"_ms"].value;

   if(value != null && value.length>0)
   {
      return new Date(Number(value));
   }
   else
   {
      return new Date();
   }
}

function uih_time(name, uiControl, xmlControl)
{
   if(uiControl.value!="")
   {
      var ms = Number(document.forms[0].elements["_"+name+"_ms"].value);
      xmlControl.value = "<attribute "+getMooMode(name)+"><value>" + ms + "</value></attribute>";
   }
   else
   {
      xmlControl.value = "<attribute "+getMooMode(name)+"></attribute>";
   }
   return true;
}

function uih_phone(name, uiControl, xmlControl)
{
   var success = checkPhoneNumber(uiControl, name);
   if(!success)
      return false;

   xmlControl.value = "<attribute "+getMooMode(name)+"><value>"+xmlEncode(uiControl.value)+"</value></attribute>";
   return true;
}

function checkPhoneNumber(field, name)
{
   var digits = "0123456789";
   var val = field.value;
   var result = "";
   var numDigitsRequired = eval("window.phone_"+name+"Digits");
   var format = eval("window.phone_"+name+"Format");

   // strip spaces
   for(var i=0; i<val.length; i++)
   {
      if(digits.indexOf(val.charAt(i)) != -1)
      {
         result += val.charAt(i);
      }
   }

   if(result.length != numDigitsRequired)
   {
      var msg = iman.formatMessageSingle(window.rc_invalidPhoneNumber, numDigitsRequired);
      alert(msg);
      return false;
   }


   var resultIndex = 0;
   var pretty = "";
   for(var i=0; i<format.length; i++)
   {
      if(format.charAt(i) == '#')
      {
         pretty += result.charAt(resultIndex++);
      }
      else
      {
         pretty += format.charAt(i);
      }
   }

   field.value = pretty;
   return true;
}

// jpegPhoto attr
function uploadChanged(checkbox, safeAttrName)
{
   document.getElementById(safeAttrName + '_uploadBox').style.display = (checkbox.checked ? 'block' : 'none');

   if(checkbox.checked)
   {
      var cb = document.getElementById(safeAttrName + "_remove");
      if(cb) cb.checked = false;
      document.form[fieldPrefix + "$" + safeAttrName].value = "<attribute><value src='file-upload' fileParam='"+ safeAttrName +"myfile'></value></attribute>";
   }
   else
   {
      document.form[fieldPrefix + "$" + safeAttrName].value='<attribute><value></value></attribute>'
   }
}

// jpegPhoto attr
function removeChanged(checkbox, safeAttrName)
{
   if(checkbox.checked)
   {
      document.form[fieldPrefix + "$" + safeAttrName].value='<attribute><value>DELETE</value></attribute>';
      document.getElementById(safeAttrName + "_upload").checked = false;
      document.getElementById(safeAttrName + '_uploadBox').style.display = 'none';
   }
   else
   {
      document.form[fieldPrefix + "$" + safeAttrName].value='<attribute><value></value></attribute>'
   }
}

function uiah_textfield(name, uiControl, xmlControl, actionName)
{
   if(actionName=="disable")
      uiControl.disabled = true;
   else if(actionName=="enable")
      uiControl.disabled = false;
   else
      alert("Invalid action for uiah_textfield: " + actionName);
}


function uiah_mvSelect(name, uiControl, xmlControl, actionName)
{
   if(actionName=="disable")
      uiControl.disabled = true;
   else if(actionName=="enable")
      uiControl.disabled = false;
   else
      alert("Invalid action for uiah_textfield: " + actionName);
}



function uiah_mvcheckbox(name, uiControl, xmlControl, actionName)
{
   var mode = "checkbox";

   var i=0;
   while(true)
   {
      var postfix = (mode=="radio" ? "[" + i + "]" : "" + i);
      var cb = uih_getControl("_" + name+postfix);
      if(cb)
      {
         if(actionName=="disable")
            cb.disabled = true;
         else if(actionName=="enable")
            cb.disabled = false;
         else
            alert("Invalid action for uiah_textfield: " + actionName);
      }
      else
      {
         break;
      }

      i++;
   }
}

function mvcheckbox_onclick(name, index)
{
   var cb = uih_getControl("_" + name+index);

   if(cb.checked)
   {
      postUiHandlerEvent(name, "onItemSelectEvent#" + index);
   }
   else
   {
      postUiHandlerEvent(name, "onItemDeselectEvent#" + index);
   }
}

function uiah_container(name, uiControl, xmlControl, actionName)
{
   var childFields = eval("window.container_" + name);
   if(childFields != null)
   {
      for(var i=0; i<childFields.length; i++)
      {
         sendAction(childFields[i], actionName);
      }
   }
}

function onMVSelectChange(name, select)
{
   var uiObject = eval("window.uiObject_"+name);

   postUiHandlerEvent(name, 'onItemSelectEvent#'+select.selectedIndex);

   if(uiObject && uiObject.m_lastIndex != null)
   {
      postUiHandlerEvent(name, 'onItemDeselectEvent#'+uiObject.m_lastIndex);
   }

   uiObject.m_lastIndex = select.selectedIndex;
}

function validateTextfield(name)
{
   var uiObject = eval("window.uiObject_"+name);
   var textfield = document.form.elements["_"+name];
   if(textfield.value=="")
   {
      return true;
   }


   // uiObject will not exist on older
   if(!uiObject)
   {
      return true;
   }

   if(uiObject.m_type == "integer")
   {
      var ok = validateIntegerField(textfield, uiObject.m_lowerBound, uiObject.m_upperBound);
      if(!ok) return false;
   }
   else if(uiObject.m_type == "number")
   {
      var ok = validateNumericString(textfield, window.rc_numbersOnly);
      if(!ok) return false;
   }
   else if(uiObject.m_type == "string")
   {
      var ok = validateLengthField(textfield, uiObject.m_lowerBound, uiObject.m_upperBound);
      if(!ok) return false;
   }

   if(uiObject.m_regExpression != null)
   {
      var matches = textfield.value.match(uiObject.m_regExpression);
      if(matches == null || matches.length==0)
      {
         alert(uiObject.m_regExpressionErrorMsg);
         return false;
      }
   }

   return true;
}


