//
// Launch Menu Tree code
// 

// Portions Copyright (c) 2001, Morten Wang & contributors
// All rights reserved.

// global member variables
var m_itemCnt = 1;      //number for next item entered in menu tree
var m_lastRole = 0;     //number of last active role
var m_lastTask = "";    //number of last active task

//iManageMenu class
function iManageMenu()
{
   this.items   = new Array();
   this.addItem = addItem;
   
   function addItem(item)
   {
      this.items[this.items.length] = item;
   }
}

//menuItem class
function menuItem(text, url, target)
{
   this.text = text;
   this.url = url ? url : "";
   this.target = target ? target : "";
   this.number = m_itemCnt++;
   this.submenu = null;
   this.expanded = false;
   this.addSubMenu = addSubMenu;
   
   function addSubMenu(menu, exp)
   {
      this.submenu = menu;
      this.expanded = exp;
   }
}

function doSubMenu(subMenu)
{
   if (subMenu)
   {
      subMenu.expanded = !subMenu.expanded;     //invert subMenu flag
      m_lastRole = subMenu.number;                //remember m_lastRole
      displayMenu();                            //redisplay entire menu
   }
}

// generates the html to display the menu in the 'menu' FRAME
function displayMenu()
{
   //create dynamic HTML to display menu
   var strHTML="";
   strHTML += '<html>\n';
   strHTML += '<head>\n';
   strHTML += '   <title>Launcher</title>\n';
   strHTML += '   <link rel="stylesheet" href="/nps/portal/modules/fw/css/HF_style1.css">\n';
   strHTML += '   <style type="text/css">\n';
   strHTML += '      a {color:#000000}\n';
   strHTML += '      .highlight {color: #000000; background-color: white; font-family: "Trebuchet MS", Arial, Helvetica, Geneva, Swiss, SunSans-Regular; text-decoration: none; font-weight: bold; background: url(/nps/portal/modules/fw/images/header_clear3.gif) repeat-x}\n';
   strHTML += '      .backlight {color: #000000; background-color: #d8dad6; font-family: "Trebuchet MS", Arial, Helvetica, Geneva, Swiss, SunSans-Regular; text-decoration: none; font-weight: bold; background: url(/nps/portal/modules/fw/images/header_pattern4c.gif) repeat-x}\n';
   strHTML += '   </style>\n';
   strHTML += '\n';
   strHTML += '   <script>\n';
   strHTML += '   function doBold(id)\n';
   strHTML += '   {\n';
   strHTML += '      //unbold previously active task, if there was one\n';
   strHTML += '      a = document.getElementById("mDiv" + parent.code.m_lastTask);\n';
   strHTML += '      if (a) a.className="";\n';
   strHTML += '\n';
   strHTML += '      //bold current task\n';
   strHTML += '      a = document.getElementById("mDiv" + id);\n';
   strHTML += '      if (a) a.className="highlight";\n';
   strHTML += '\n';
   strHTML += '      //remember this as m_lastTask\n';
   strHTML += '      parent.code.m_lastTask = id;\n';
   strHTML += '   }\n';
   strHTML += '\n';
   strHTML += '   function doBacklight(id)\n';
   strHTML += '   {\n';
   strHTML += '      //bold current task\n';
   strHTML += '      a = document.getElementById("mDiv" + id);\n';
   strHTML += '      if (a && id != parent.code.m_lastTask) a.className="backlight";\n';
   strHTML += '   }\n';
   strHTML += '\n';
   strHTML += '   function unBacklight(id)\n';
   strHTML += '   {\n';
   strHTML += '      //bold current task\n';
   strHTML += '      a = document.getElementById("mDiv" + id);\n';
   strHTML += '      if (a && id != parent.code.m_lastTask) a.className="";\n';
   strHTML += '   }\n';
   strHTML += '\n';
   strHTML += '   //set focus to the specified role\n';
   strHTML += '   function doRoleFocus(curRole)\n';
   strHTML += '   {\n';
   strHTML += '      if (document.getElementById("mItem" + curRole))\n';
   strHTML += '      {\n';
   strHTML += '         document.getElementById("mItem" + curRole).focus();\n';
   strHTML += '      }\n';
   strHTML += '   }\n';
   strHTML += '\n';
   strHTML += '   //expand or collapse submenu\n';
   strHTML += '   function doClick(iNum)\n';
   strHTML += '   {\n';
   strHTML += '      var subMenu = parent.code.menu.items[iNum];\n';
   strHTML += '      if (subMenu)\n';
   strHTML += '      {\n';
   strHTML += '         return parent.code.doSubMenu(subMenu);\n';
   strHTML += '      }\n';
   strHTML += '      else\n';
   strHTML += '      {\n';
   strHTML += '         return;\n';
   strHTML += '      }\n';
   strHTML += '   }\n';
   strHTML += '\n';
   strHTML += '   //make <return> expand or collapse submenu\n';
   strHTML += '   function doEnter(iNum)\n';
   strHTML += '   {\n';
   strHTML += '      //was <return> key pressed?\n';
   strHTML += '      if (event.keyCode==13)\n';
   strHTML += '      {\n';
   strHTML += '         doClick(iNum);\n';
   strHTML += '         event.returnValue=false;   //stop event propagation\n';
   strHTML += '      }\n';
   strHTML += '   }\n';
   strHTML += '   </script>\n';
   strHTML += '</head>\n';
   strHTML += '<body bgcolor="' + window.LookAndFeel_MenuColor + '" marginwidth="0" marginheight="0" leftmargin="0" topmargin="0" onLoad="doBold('+m_lastTask+'); doRoleFocus('+m_lastRole+');">\n';
   strHTML += '\n';
   
   if(menu.items.length == 0)
   {
      //no menu display; display empty menu message
      strHTML += '   <table style="margin-top:8px" align="center" border="0" cellpadding="5">\n';
      strHTML += '      <tr>\n';
      strHTML += '         <td align="center">\n';
      strHTML += '            <b>';
      strHTML += noRolesText;
      strHTML += '            </b>\n';
      strHTML += '         </td>\n';
      strHTML += '      </tr>\n';
      strHTML += '   </table>\n\n';
   }
   else
   {
      //display menu
      strHTML += pad(3)+'<table border="0" cellpadding="0" cellspacing="0" style="width=100%; margin-top:2px">\n';
      strHTML += listItems(menu,0);
      strHTML += pad(3)+'</table>\n\n';
   }
   
   strHTML += '</body>\n';
   strHTML += '</html>\n';
   
   //get original position
   var scrollY = 0;
   if (m_lastRole)
   {
      var item = "mItem" + m_lastRole;
	  if (exists("parent.menu.document.getElementById(\"" + item + "\").offsetParent.scrollTop"))
	  {
	     scrollY = parent.menu.document.getElementById(item).offsetParent.scrollTop;
      }
      if (scrollY == 0)
         scrollY = parent.menu.document.body.scrollTop;
   }
   
   //write out the new menu data to the innerHTML span
   //alert("strHTML =\n"+strHTML);
   var d = parent.menu.document;
   d.open("text/html", "replace");
   d.writeln(strHTML);
   d.close();

   //scroll the menu to the original position
   if (m_lastRole)
   {
      var item = "mItem" + m_lastRole;
	  if (exists("parent.menu.document.getElementById(\"" + item + "\").offsetParent.offsetTop"))
	  {
//	     var yVal = parent.menu.document.getElementById(item).offsetParent.offsetTop;
//	     var winSize = parent.menu.document.body.clientHeight;
//		 if(yVal > (winSize - 60))
//		 {
//		    parent.menu.scrollBy(0, parseInt(yVal - (winSize * 1/3)));
		    parent.menu.scrollTo(0, scrollY);
//		 }
      }
	   m_lastRole=0;
   }
} //displayMenu

//generate HTML to display menu items (recursive)
function listItems(menu, level)
{
   var str = "";
   var i;
   for (i=0; i<menu.items.length; i++)
   {
      var item = menu.items[i];
      if (item)
      {
         str += displayItem(item, i, level);
         if (item.submenu && item.expanded)
         {
            str += listItems(item.submenu, level+1);  //recursively display submenu
         }
   
         if (level==0)
         {
            str += pad(6)+'<tr><td style="font-size:.4em">&nbsp;<\/td><\/tr>\n';
         }
      }
   }
   return (str);
}//listItems

//display a menu item and any submenu items
function displayItem(item, mIndex, level)
{
   var str = "";
   if (item)
   {
//      str = pad(6)+'<tr>\n'+pad(9)+'<td align="middle" width="20">';
      if (item.submenu)
      {
         //item is a submenu; make link for +- icon
//         str += '<a style="text-decoration=none" href="#" onClick="doClick('+mIndex+');return false" onkeydown="doEnter('+mIndex+');" tabIndex=-1>';
//         str += '<img src="'+((item.expanded)?minusGifUrl:plusGifUrl)+'" border="0"><\/a>';
//         str += '<\/td>\n'+pad(9)+'<td>';
         str = pad(6)+'<div style="margin-left: 5px; margin-right: 0px; margin-top: 2px; margin-bottom: 0px; background: url(/nps/portal/modules/fw/images/dotline_bg.gif) repeat-x">&nbsp; <\/div>\n';

         str += pad(6)+'<a id="mItem'+item.number+'" style="text-decoration: none" href="#" onClick="doClick('+mIndex+');return false" onkeydown="doEnter('+mIndex+');">';
         str += '<div style="margin-top: -6px; margin-bottom: 2px">\n'+pad(9);
         //make link for submenu name
         str += "&nbsp;";
         str += '<b><font style="font-size:.9em" color="#212A59">' + item.text + '<\/font><\/b>';
      }
      else
      {
         //display leaf (task)
//         str += '<\/td>\n'+pad(9)+'<td>';
         str += pad(6)+'<a id="mItem'+item.number+'" style="text-decoration: none" href="'+item.url+'" onClick="doBold('+item.number+');" onmouseover="doBacklight('+item.number+');" onmouseout="unBacklight('+item.number+');" target="'+item.target+'">';
         str += '<div id="mDiv'+item.number+'" style="padding-top: 2px; padding-bottom: 2px">\n'+pad(9);
         str += "&nbsp;&nbsp;&nbsp;&nbsp;";
         //make link for task name
         str += '<font style="font-size:.85em" color="#003399">' + item.text + '<\/font>';
      }
      str += '</div>\n'+pad(6)+'</a>\n';
   }
   return (str);
}//displayItem

//===================== utility routines ========================
//create a string of p spaces to help indent generated HTML for readability
function pad(p)
{
   var ret = "";
   for (i=0; i<p; i++)
   {
      ret += " ";
   }
   return ret;
}

//output a string in an html window
function htmlAlert(msg)
{
   var w = window.open("","htmlAlert");
   var d = w.document;
   d.open();
   d.writeln("<html><body>\n"+toDisplay(msg)+"\n</body></html>");
   d.close();
}