<%@ page pageEncoding="utf-8" contentType="text/html;charset=utf-8" %>
<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>

<iman:stringtable bundle="FwResources" />
<iman:stringtable bundle="DevResources" />

<html>
  <head>
    <title>'Progress.jsp'</title>
    
    <meta http-equiv="pragma" content="no-cache">
    <meta http-equiv="cache-control" content="no-cache">
    <meta http-equiv="expires" content="0">
    <meta http-equiv="description" content="This is my page">
    
	<iman:stylesheet/>
	<iman:eMFrameScripts/>
   <SCRIPT language="JavaScript" src="<c:out value='${ModulesPath}' />/dev/javascripts/exchanger.js"></SCRIPT>
  	<SCRIPT>
         	ProgressFormat_numberOfObjectsUpdated="<iman:string key='${ProgressFormat.numberOfObjectsUpdatedKey}' />";
         	ProgressFormat_errorHeader="<iman:string key='${ProgressFormat.errorHeaderMsgKey}' />";
         	ProgressFormat_estimatedTime="<iman:string key='${ProgressFormat.estimatedTimeMsgKey}' />";
         	ProgressFormat_calculatingTime="<iman:string key='${ProgressFormat.calculatingTimeMsgKey}' />";
         	ProgressFormat_complete="<iman:string key='${ProgressFormat.completeMsgKey}' />";
         	Button_Close_image="<iman:string key='Button.Close.image' />";
         	Button_Close_alt="<iman:string key='Button.Close.alt' />";
         	Progress_onComplete="<c:out value='${ProgressFormat.onComplete}' />";

//
// Manage asyncronous progess dialog
// 

// Portions Copyright (c) 2001, Morten Wang & contributors
// All rights reserved.

// global member variables

      timeToRefresh = 1000;

      oldCount = 1;
      count = 1;

      d = new Date();
      startTime = d.getTime();
      finished = "false";
		stopping = false;
		stop=false;
      sentMessage = false;
      hasErrors = false;
      Progress_autoClose = "<c:out value='${Progress_autoClose}' />";
      showTimeEstimate = true;

      function updateProgress()
      {
         var hasRead = progress.hasRead();
         finished = progress.retrieveData("progressFinished");
         var numTotal = Number(progress.retrieveData("progressTotalNumber"));
	     	showTimeEstimate = numTotal >0;
         var numComplete = Number(progress.retrieveData("progressNumberCompleted"));
         if(typeof numComplete != "number" || isNaN(numComplete) || hasRead)
         {
            setTimeout("updateProgress();", 500);
            return;
         }


         // updateStatusMessages
         status = progress.retrieveData("progressStatus");;
         if(status!="null")
         {
            var messageDiv = document.getElementById("statusMessage");

            messageDiv.style.display = "block";

            messageDiv.innerHTML = "<img class='margin5r' id='activityImage' height='32' width='32' src='"+fw_modulesPath+"/dev/images/In-progress_framed32.gif' align='absmiddle'><label>"+status+"</label>";
         }
         // updateErrorMessages
         errors = progress.retrieveData("errors");
         window.progressErrors = errors;
         if(errors.length >0)
         {
            hasErrors = true;
            var errorDiv = document.getElementById("errorMessages");
            var errorHeaderDiv = document.getElementById("errorHeader");

            var errorHeader = formatMessage(ProgressFormat_errorHeader, [errors.length]);
            errorHeaderDiv.innerHTML = errorHeader;
            errorHeaderDiv.style.display = "block";
            errorDiv.style.display = "block";

            var str = "<TABLE cellpadding=4 cellspacing=0>";
            for(var i=0; i < errors.length; i++)
            {
               str += "<TR><TD valign=top class=error1>" + errors[i] + "</TD></TR>"
            }
            str += "</TABLE>";

            errorDiv.innerHTML = str;
         }

         if(numTotal > 0 )
         {
	         // update progress bar messages
	         count = 0;
	         var progressDiv = document.getElementById("progressDiv");
	         progressDiv.style.display = "block";
	         var progressMsgDiv = document.getElementById("progressMessage");
   	      var estDiv = document.getElementById("estimatedTime");
      	   progressMsgDiv.innerHTML = "<label>"+formatMessage(ProgressFormat_numberOfObjectsUpdated, [numComplete, numTotal])+"</label>";
         	count = Math.round(numComplete/numTotal * 20);

	         // update progress bar
	         if(count>0)
	         {
	            for(var i=oldCount; i<=count; i++)
	            {
	               if(i%2==0){
	               	document.getElementById("progress"+i).src = fw_modulesPath+"/fw/images/graph_green.gif";
	               }else{
	               	document.getElementById("progress"+i).src = fw_modulesPath+"/fw/images/graph_green_light.gif";
	               }
	            }
	            oldCount = count;
	         }

	         // update time estimation
	          if(showTimeEstimate)
	         {
	         	if(numComplete > 0)
	         	{
		            d = new Date();
		            var currentTime = d.getTime();
		            var estimatedTime = (1.0 - numTotal/numComplete) * (currentTime - startTime) * -0.001;
		
		            var minutes = Math.floor(estimatedTime/60.0);
		            var seconds = Math.floor(estimatedTime%60.0);
		            if(minutes>0 || seconds>0)
		            {
		               estDiv.innerHTML = "<label>"+formatMessage(ProgressFormat_estimatedTime, [minutes, seconds])+"</label>";
		            }
	            }
		         else
		         {
		            estDiv.innerHTML = "<label>"+ProgressFormat_calculatingTime+"</label>";
		         }
	         }
	      }

         if(finished == "true")
         {
            onFinished();
            return;
         }


         // var scale = 1.0 - Math.abs(numTotal*0.6 - numComplete) / (numTotal/2.0); // 0->1->0
         requestUpdateProgress(timeToRefresh);
      }


      // called by updateProgress
      function onFinished()
      {
         var estDiv = document.getElementById("estimatedTime");
         var activityImg = document.getElementById("activityImage")
         if(stop)
         {
         	activityImg.src=fw_modulesPath+"/dev/images/cancelled32.gif";
         	estDiv.innerHTML = "<label><c:out value='${ProgressFormat.interruptedMsg}' /></label>";
         }else{
         	estDiv.innerHTML = "<label>"+ProgressFormat_complete+"</label>";
         	if(hasErrors)
         	{
         		activityImg.src=fw_modulesPath+"/fw/images/wiz_Error.gif";
         	}else{
         		activityImg.src=fw_modulesPath+"/fw/images/wiz_Completed.gif";
         		if(Progress_autoClose)
         		{
						closeButtonPressed();
					}    		
         	}
         }
         
         

         var buttonAtBottom = document.getElementById("buttonAtBottom");
         buttonAtBottom.src = fw_modulesPath+"/dev/images/"+Button_Close_image;
         buttonAtBottom.alt = fw_modulesPath+"/dev/images/"+Button_Close_alt;
      }

      xButtonPressed=true;

      function onUnloadHandler()
      {
         if(this==top && xButtonPressed)
         {
            closeButtonPressed();
         }
      }

      function closeButtonPressed()
      {
         xButtonPressed=false;

         if(finished=="true")
         {
	         // MOZILLA_HACK: mozilla points to wrong window
	         if(this==top)
	         {
	            var realOpener = opener;
	            if(opener.name == "bookBody")
	            {
	               realOpener = opener.parent.bookHeader;
	            }
	         }

            if(this==top)
            {
               if ("refreshTask"==Progress_onComplete)
               {
                  realOpener.refreshAfterProgress();
               }
               else if ("closeTask"==Progress_onComplete)
               {
                  if(window.progressErrors != null && window.progressErrors.length>0)
                  {
                     realOpener.refreshAfterProgress();
                  }
                  else
                  {
                     realOpener.parent.location = "webacc?taskId="+fw_taskId+"&taskComplete=true";
                  }
               }


               window.close();
            }
            else
            {
               window.location = "webacc?taskId="+fw_taskId+"&taskComplete=true";
            }
         }
         else
         {
            // do a Stop
				stop = true;
         }
      }

      function requestUpdateProgress(millsecs)
      {
         progress = new exchanger("exchangerFrame");
         query = "webacc?taskId="+fw_taskId+"&merge=fw.AsyncProgressExchanger";
         if(!stopping && stop)
         {
         	query+="&nextState=interupt";
         	stopping=true;
         }
         progress.sendData(query);
         setTimeout("updateProgress();", millsecs);
      }
  	
  	</SCRIPT>
  </head>
  
  <body onLoad="requestUpdateProgress(0);" onunload="onUnloadHandler();">
     <IFRAME src="/nps/Empty.html" style="visibility: hidden;" name="exchangerFrame" id="exchangerFrame" width="0" height="0" marginwidth="0" marginheight="0"></IFRAME>
	<DIV><iman:taskHeader title="${ProgressFormat.title}" iconUrl="${ProgressFormat.iconUrl}" iconAlt="${ProgressFormat.iconAlt}" helpFile="${ProgressFormat.helpFile}" /></DIV>
   <DIV id=statusMessage style="width:95%; display:none"></DIV>
	<DIV id=progressDiv class="marginleft1 margintop3" style="width:95%; display:none">
   <DIV id=progressMessage class="marginleft1"><c:out value="${ProgressFormat.initialStatusMsgKey}" /></DIV>
	<div class="marginleft1" style="width: 95%; display: block;">
				<img src="<c:out value='${ModulesPath}' />/fw/images/graph_start.gif" id="progressstart" width="5" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress1" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress2" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress3" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress4" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress5" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress6" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress7" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress8" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress9" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress10" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress11" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress12" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress13" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress14" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress15" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress16" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress17" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress18" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress19" width="10" height="20" align="absmiddle"><img src="<c:out value='${ModulesPath}' />/fw/images/graph_clear.gif" id="progress20" width="10" height="20" align="absmiddle"><img class="margin5r" src="<c:out value='${ModulesPath}' />/fw/images/graph_end3.gif" id="progressend" width="5" height="20" align="absmiddle">
	</div>	

   <div class="marginleft1" id=estimatedTime></div>
</DIV>
   <DIV id=errorHeader class="margintop3 errorhead" style="display:none"><BR><BR><iman:string key="Progress.errors" /></DIV>
   <DIV id=errorMessages style="width:95%; display:none"></DIV>
   <div class="ruleabove margintop3"><A href="#" onClick="closeButtonPressed();"><IMG id="buttonAtBottom" alt="<iman:string key='Button.Stop.alt' />" title="<iman:string key='Button.Stop.alt' />" src="<c:out value='${ModulesPath}' />/dev/images/<iman:string key='Button.Stop.image' />" border=0></A></div>

  </body>
</html>
