<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources"); %>
<HTML>
<HEAD>
<TITLE><%= c.toHTML(c.string("RBSManagement.BookObjectTypeTitle")) %></TITLE>
<LINK   href="<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>"
        rel="styleSheet"
        type="text/css">

<jsp:include page='<%= c.getPath("dev/MoveListItems_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />

<SCRIPT language="JavaScript">


   /*******************
    * FUNCTION HEADER *
    *******************/

    function detectBrowser()
    {
        var appVer = navigator.appVersion;
        var iePos = appVer.indexOf('MSIE');
        if (iePos != -1)
        {
            document.BookObjectTypeForm.AvailableObjectTypes.attachEvent('ondblclick',addSelectedItems);
            document.BookObjectTypeForm.AssignedObjectTypes.attachEvent('ondblclick',removeSelectedItems);
        }

        var availAttrOpt = document.BookObjectTypeForm.AvailableObjectTypes.options;
        var optAttrOpt = document.BookObjectTypeForm.AssignedObjectTypes.options;

        sortAvailList(availAttrOpt);
        sortAssignedList(optAttrOpt);
    }

    function onPageLoad()
    {
        var form = document.BookObjectTypeForm;

        if (form.AvailableObjectTypes.length > 0)
        {
            form.AvailableObjectTypes.focus();
            form.AvailableObjectTypes[0].selected = true;
        }

        return;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function setListFocus(list)
    {
        if (list.name == "AssignedObjectTypes")
        {
            document.BookObjectTypeForm.AvailableObjectTypes.selectedIndex=-1;
        }
        else
        {
            document.BookObjectTypeForm.AssignedObjectTypes.selectedIndex=-1;
        }

        return;
    }

   /*******************
    * FUNCTION HEADER *
    *******************/
    function addSelectedItems(event)
    {
	   var availOpt      = document.BookObjectTypeForm.AvailableObjectTypes.options;
	   var optOpt        = document.BookObjectTypeForm.AssignedObjectTypes.options;
	   var selectedNum   = 0;

      if (document.BookObjectTypeForm.AvailableObjectTypes.selectedIndex == -1)
      {
         // Nothing is selected in the Available Object Types list when the user clicked on the add button. Just return.
         return;
      }

	   for (var i=(availOpt.length-1); i>=0; i--)
	   {
		  if(availOpt[i].selected)
		  {
			 optOpt[optOpt.length] = new Option(availOpt[i].text, availOpt[i].value, false, availOpt[i].selected);
			 availOpt[i] = null;
          selectedNum = i;
		  }
	   }

      document.BookObjectTypeForm.elements["BookObjectTypeFormChanged"].value = "true";
      sortAssignedList(optOpt);
      setAvailableListFocus(availOpt,selectedNum);
    }

   /*******************
    * FUNCTION HEADER *
    *******************/
    function removeSelectedItems(event)
    {
       var availAttrOpt = document.BookObjectTypeForm.AvailableObjectTypes.options;
       var optAttrOpt   = document.BookObjectTypeForm.AssignedObjectTypes.options;
       var selectedNum  = 0;

       if (document.BookObjectTypeForm.AssignedObjectTypes.selectedIndex == -1)
      {
        // Nothing is selected in the Assigned Object Types list when the user clicked on the remove button. Just return.
        return;
      }

      for (var i=(optAttrOpt.length-1); i>=0; i--)
      {
         if(optAttrOpt[i].selected)
         {
            availAttrOpt[availAttrOpt.length] = new Option(optAttrOpt[i].text, optAttrOpt[i].value, false, false);
            optAttrOpt[i] = null;
            selectedNum = i;
         }
      }

      document.BookObjectTypeForm.elements["BookObjectTypeFormChanged"].value = "true";
      sortAvailList(availAttrOpt);
      setAssignedListFocus(optAttrOpt,selectedNum);
   }

   /*******************
    * FUNCTION HEADER *
    *******************/
   function setAssignedListFocus(list,num)
   {
      if(list.length > 0)
      {
         if(list[num] == null)
         {
           document.BookObjectTypeForm.AssignedObjectTypes.selectedIndex = num - 1;
         }
         else
         {
           document.BookObjectTypeForm.AssignedObjectTypes.selectedIndex = num;
         }
      }
      else
      {
         document.BookObjectTypeForm.AvailableObjectTypes.selectedIndex = 0;
      }
   }

   /*******************
    * FUNCTION HEADER *
    *******************/
   function setAvailableListFocus(list,num)
   {
      if(list.length > 0)
      {
         if(list[num] == null)
         {
           document.BookObjectTypeForm.AvailableObjectTypes.selectedIndex = num - 1;
         }
         else
         {
           document.BookObjectTypeForm.AvailableObjectTypes.selectedIndex = num;
         }
      }
      else
      {
        document.BookObjectTypeForm.AssignedObjectTypes.selectedIndex = 0;
      }
   }

    function sortAssignedList(x)
    {
        var iePos = navigator.appVersion.indexOf('MSIE');
        sortedArray = new Array();

        for (var i=0; i < x.length; i++) {
            sortedArray[i] = new Array(x[i].text, x[i].value, false, false);
        }

        sortedArray.sort(sortBYtext);

        for (var i=0; i < x.length; i++) {
            x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
            if (iePos == -1)
                x[i].addEventListener("dblclick",removeSelectedItems, false);
            x[i].selected = sortedArray[i][3];
        }

        return;
    }


   function sortAvailList(x)
   {
       var iePos = navigator.appVersion.indexOf('MSIE');
       sortedArray = new Array();

      for (var i=0; i < x.length; i++)
      {
          sortedArray[i] = new Array(x[i].text, x[i].value, false, x[i].selected);
      }

      sortedArray.sort(sortBYtext);

      for (var i=0; i < x.length; i++)
      {
         x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
         if (iePos == -1)
         {
            x[i].addEventListener("dblclick",addSelectedItems, false);
         }

         x[i].selected = sortedArray[i][3];

         if (iePos == -1)
         {
            if (x[i].selected == true)
            {
               x.selectedIndex = i;
            }
         }
      }

      return;
   }


    function sortBYtext(a,b)
    {
        if(a[0].toLowerCase() < b[0].toLowerCase())
        {
            return -1;
        }

        if(a[0].toLowerCase() > b[0].toLowerCase())
        {
            return 1;
        }

        return 0;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function onPageSubmit()
    {
        var assignedBoxLength = document.BookObjectTypeForm.AssignedObjectTypes.length;
        if(assignedBoxLength == 1)
        {
            if (document.BookObjectTypeForm.AssignedObjectTypes.options[0].text == emptyListBracket)
            {
                alert("<%= c.toScript(c.string("BookObjectType.NoAssignedTypes")) %>");
                return false;
            }
        }
        formatAssignedObjectTypeData();
        formatAvailableObjectTypeData();

        return;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function formatAssignedObjectTypeData()
    {
        var boxLength = document.BookObjectTypeForm.AssignedObjectTypes.length;

        // Get everything in the AssignedObjectTypes list
        AssignedObjectTypes = new Array(boxLength);

        for (i = 0; i < boxLength; i++)
        {
            if (document.BookObjectTypeForm.AssignedObjectTypes.options[i].text != emptyListBracket)
            {
                // This needs to be the full name
                AssignedObjectTypes[i] = urlEncode(document.BookObjectTypeForm.AssignedObjectTypes.options[i].value);
            }
        }

        // Convert array into delimited string to be passed into the java file
        var strAssignedObjectTypes = AssignedObjectTypes.join(";");
        document.BookObjectTypeForm.elements["AssignedObjectTypesString"].value = strAssignedObjectTypes;

        return;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function formatAvailableObjectTypeData()
    {
        var boxLength = document.BookObjectTypeForm.AvailableObjectTypes.length;

        // Get everything in the AssignedObjectTypes list
        AvailableObjectTypes = new Array(boxLength);

        for (i = 0; i < boxLength; i++)
        {
            AvailableObjectTypes[i] = urlEncode(document.BookObjectTypeForm.AvailableObjectTypes.options[i].value);
        }

        // Convert array into delimited string to be passed into the java file
        var strAvailableObjectTypes = AvailableObjectTypes.join(";");
        document.BookObjectTypeForm.elements["AvailableObjectTypesString"].value = strAvailableObjectTypes;

        return;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function backButtonSelected()
    {
        formatAssignedObjectTypeData();
        formatAvailableObjectTypeData();
        document.BookObjectTypeForm.elements["merge"].value="fw.CreateBook";
        document.BookObjectTypeForm.elements["nextState"].value="backBookInfoPage";
        document.BookObjectTypeForm.submit();
    }


</SCRIPT>
</HEAD>
<BODY   TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF"
        onload="detectBrowser(),onPageLoad();">

<FORM   name="BookObjectTypeForm"
        method=post
        action="webacc"
        onSubmit="return(onPageSubmit())">

    <input  type=hidden
            name="taskId"
            value="<%= c.var("taskId") %>">

    <input  type=hidden
            name="merge"
            value="fw.BookPage">

    <input  type=hidden
            name="error"
            value="dev.GenErr">

    <input  type=hidden
            name="User.context"
            value="<%= c.var("User.context") %>">

    <input  type=hidden
            name="nextState"
            value="nextBookPages">

    <input  type=hidden
            name="AssignedObjectTypesString"
            value="">

    <input  type=hidden
            name="AvailableObjectTypesString"
            value="">

    <input  type=hidden
            name="BookObjectTypeFormChanged"
            value="false">

   <input   type=hidden
            name="RBSAdmin_TaskDelegate"
            value="<%= c.var("RBSAdmin_TaskDelegate") %>">

    <!-- End of hidden tags -->

    <% c.set("WizardHeader.title", c.toHTML(c.string("CreateBook.WizardTitle")));
       c.set("WizardHeader.subtitle", c.toHTML(c.string("General.Step2")));
       c.set("WizardHeader.instruction", c.toHTML(c.string("BookObjectType.ObjectTypes")));
       c.set("WizardHeader.helpFile", "base/createpropertybook_objecttypes.html"); %>
    <jsp:include page='<%= c.getPath("dev/WizardHeader_inc.jsp") %>' flush="true" />

    <TABLE width="100%" border="0" cellspacing="0" cellpadding="3">
        <TR>
            <TD class="mediumtext">
                <B><%= c.toHTML(c.string("BookObjectType.BookName")) %></B>&nbsp;<%= c.toHTML(c.var("BookName_Value")) %>
            </td>
        </tr>
        <TR>
            <TD class="mediumtext">
                &nbsp;
            </td>
        </TR>
        <TR>
            <TD class="formdescriptext">
                <%= c.toHTML(c.string("BookObjectType.Instruction")) %>
            </td>
        </tr>
            <TD class="mediumtext">
                &nbsp;
            </td>
    </table>
    <TABLE name="Taskstable" >
        <TR>
            <TD align="left" class="mediumtext" valign="bottom">
                <%= c.toHTML(c.string("BookObjectType.AvailableTypes")) %>
            </TD>
            <TD align="left"></TD>
            <TD align="left" class="mediumtext" valign="bottom">
                <%= c.toHTML(c.string("BookObjectType.AssignedTypes")) %>
            </TD>
        </TR>
        <TR>
            <TD>
                <SELECT name="AvailableObjectTypes" size=10 WIDTH="250" style="WIDTH: 250px"
                        multiple
                        onchange="setListFocus(this)">
                    <% c.set("j", "0");
                        while (c.lt(c.var("j"), c.var("AvailableObjectType.Count"))) { %>
                        <OPTION value="<%= c.var("AvailableObjectType.Element."+c.var("j")) %>"><%= c.var("AvailableObjectType.Element."+c.var("j")) %>
                        <% c.inc("j");
                       } %>
                </SELECT>
            </TD>
            <TD>
                <a href="#" onClick="javascript:addSelectedItems();return false">
                            <IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.ArrowRight.image") %>"
                            alt="<%= c.toHTML(c.string("Button.ArrowRight.alt")) %>"
                            title="<%= c.toHTML(c.string("Button.ArrowRight.alt")) %>"
                            border=0></a>
                <BR>
                <a href="#" onClick="javascript:removeSelectedItems();return false">
                            <IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.ArrowLeft.image") %>"
                            alt="<%= c.toHTML(c.string("Button.ArrowLeft.alt")) %>"
                            title="<%= c.toHTML(c.string("Button.ArrowLeft.alt")) %>"
                            border=0></a>
                <BR>
            </TD>
            <TD>
                <SELECT name="AssignedObjectTypes" size=10 WIDTH="250" style="WIDTH: 250px"
                        multiple
                        onchange="setListFocus(this)">
                    <% c.set("i", "0");
                       while (c.lt(c.var("i"), c.var("AssignedObjectType.Count"))) { %>
                        <OPTION value="<%= c.var("AssignedObjectType.Element."+c.var("i")) %>"><%= c.var("AssignedObjectType.Element."+c.var("i")) %>
                        <% c.inc("i");
                       } %>
                </SELECT>
            </TD>
        </TR>
        <TR>
            <TD>&nbsp;</TD>
        </TR>
    </TABLE>
    <jsp:include page='<%= c.getPath("dev/Bar_inc.jsp") %>' flush="true" />
    <a href="#" onClick="javascript:backButtonSelected();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Back.image") %>" alt="<%= c.toHTML(c.string("Button.Back.alt")) %>" title="<%= c.toHTML(c.string("Button.Back.alt")) %>" border=0></a>
    <INPUT type=image name="Next" alt="<%= c.toHTML(c.string("Button.Next.alt")) %>" title="<%= c.toHTML(c.string("Button.Next.alt")) %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Next.image") %>" border=0>
    <jsp:include page='<%= c.getPath("dev/Cancel_inc.jsp") %>' flush="true" />
</FORM>
</BODY></HTML>
