<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="com.novell.emframe.fw.CreateServerAdminTask">
		<html>
			<head>
				<LINK rel="stylesheet" href="{$Portal.ResourcePath}/modules/dev/css/hf_style.css"/>
            <xsl:call-template name="eMFrameScripts"/>
            <xsl:call-template name="OSScripts"/>
				<script>
					function isPageValid()
					      {
					         if(document.servicesForm.taskCollection.value=='' || document.servicesForm.taskName.value=='')
					         {
					            alert('<xsl:value-of select="$fw.TaskBuilder.MustEnterTaskName"/>');
					            return false;
					         }
					
					         var roleName = document.servicesForm.taskRole.value.toUpperCase();
					         var collectionName = document.servicesForm.taskCollection.value.toUpperCase();
					         if(roleName!='' &amp;&amp; roleName.indexOf(collectionName)==-1)
					         {
					            alert('<xsl:value-of select="$fw.TemplateBuilder.roleMustbeInCollection"/>');
					            return false;
					         }
					         else
					         {
					            return true;
					         }
					      }
				</script>
				<script>
					   BrowserCharset='utf-8';
					   
					   //exists() returns true is object identified by string s
					   //exists in the same scope (is a peer of) this routine
					   function exists(s)
					   {
					   
					      var ret=false;
					      if (s!=null &amp;&amp; s.length>0)
					      {
					         try
					         {
					            eval(s);
					            ret=true;
					         }
					         catch(e)
					         {
					         }
					      }
					      return ret;
					   }

					function callDynamicOS(theInputControlName,theTypeFilter,theInitialContext)
					{
					      var OV=new Object();
					      OV.control =		   theInputControlName;
					      OV.mode =            "search";
					      OV.multiSelect =    "false";
					      OV.initialContext = theInitialContext;
					      OV.typeFilter =       theTypeFilter;
					      doDynamicOS("",OV);

					      // doOS('','taskCollection','','','','','search','','','','','','','rbsCollection2','');
					      // doOS('','taskRole','','','','','search','','','','','','','rbsRole2','');
					}
				</script>
				<script>
					function launchHelp(helpFile)
					{
					   var slashIndex = helpFile.indexOf("/");
					   if(slashIndex == -1 || slashIndex == helpFile.length - 1)
					   {
					      return;
					   }
					   var module = helpFile.substring(0, slashIndex);
					   var page = helpFile.substring(slashIndex + 1, helpFile.length);
					   var w=window.open('<xsl:value-of select="$Portal.ResourcePath"/>/modules/' + module + '/help/<xsl:value-of select="/PortalData/SessionInfo/CurrentLocale"/>/' + page, "Help", 'toolbar=no,location=no,directories=no,menubar=yes,scrollbars=yes,resizable=yes,width=500,height=500');
					   if(w != null)
					   {
					      w.focus();
					   }
					}
				</script>
			</head>
			<title>Novell iManager</title>
			<body bgcolor="#FFFFFF" TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" topmargin="5">
				<xsl:if test="NetWareService">
					<xsl:call-template name="pickService"/>
				</xsl:if>
				<xsl:if test="FindServerLocation">
					<xsl:call-template name="FindServerLocation"/>
				</xsl:if>
				<xsl:if test="getTaskName">
					<xsl:call-template name="getTaskName"/>
				</xsl:if>
				<xsl:if test="createSummary">
					<xsl:call-template name="createSummary"/>
				</xsl:if>
				<xsl:if test="FindServiceUrl">
					<xsl:call-template name="FindServiceUrl"/>
				</xsl:if>
				<xsl:if test="CustomSettingsSummary">
					<xsl:call-template name="CustomSettingsSummary"/>
				</xsl:if>
				<xsl:if test="wizardURLData">
					<xsl:call-template name="wizardURLData"/>
				</xsl:if>
			</body>
		</html>
	</xsl:template>
	<xsl:template name="pickService">
		<xsl:call-template name="showHeader">
			<xsl:with-param name="HeaderTitle"><xsl:value-of select="$fw.NetWareService.HeaderTitle"/></xsl:with-param>
			<xsl:with-param name="SubTitle">
				<xsl:value-of select="$fw.General.Step1"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$fw.NetWareService.Step1Text"/></xsl:with-param>
		</xsl:call-template>
		<form action="{$Portal.Servlet.Normal}" name="servicesForm" method="post">
			<input name="GI_ID" type="hidden" value="{../@id}"/>
			<input name="nextState" type="hidden" value="findServer"/>
			<div class="smalltext2C" style="margin-left: 10px; margin-top: 5px;">
						<xsl:value-of select="$fw.NetWareService.Step1Description"/></div>
			<div>
				<xsl:choose>
					<xsl:when test="count(NetWareService)> 8">
						<xsl:attribute name="style">margin-left: 10px; margin-top: 5px; margin-right: 12px; overflow: auto; height: 300px;</xsl:attribute>
					</xsl:when>
					<xsl:otherwise>
						<xsl:attribute name="style">margin-left: 10px; margin-top: 5px; margin-right: 12px; overflow: auto;</xsl:attribute>
					</xsl:otherwise>
				</xsl:choose>
				<table border="0" cellpadding="3" cellspacing="0">
					<xsl:for-each select="NetWareService[@type!='other']">
						<xsl:sort order="ascending" select="NWServiceProductName"/>
						<xsl:sort order="ascending" select="WebLinkDesc"/>
						<tr>
							<xsl:if test="not (position() mod 2)">
								<xsl:attribute name="bgcolor">#efeee9</xsl:attribute>
							</xsl:if>
							<td>&#160;</td>
							<td>
								<a href="/welcome/{NWServiceInfoLink}" target="_blank">
									<img src="/welcome/{NWServiceIcon}" alt="{$fw.NetWareService.about} {NWServiceProductName}" width="16" height="16" align="middle" border="0"/>
								</a>
							</td>
							<td>
								<input type="radio" name="serviceKey" value="{NWServiceIndex}" align="middle">
									<xsl:if test="position()=1">
										<xsl:attribute name="checked">checked</xsl:attribute>
									</xsl:if>
									<a href="/welcome/{NWServiceInfoLink}" target="_blank">
										<xsl:value-of select="NWServiceProductName"/>
									</a>
								</input>
										&#160;
									</td>
							<td>
								<xsl:value-of select="WebLinkDesc"/>
							</td>
						</tr>
					</xsl:for-each>
					<xsl:if test="NetWareService[@type='other']">
						<tr>
							<xsl:if test="(count(NetWareService[@type!='other']) mod 2)">
								<xsl:attribute name="bgcolor">#efeee9</xsl:attribute>
							</xsl:if>
							<td>&#160;</td>
							<td>
								<img src="{$Portal.ResourcePath}/modules/fw/images/iManager_Logo16.gif" alt="{$fw.NetWareService.CustomService}" width="16" height="16" align="middle" border="0"/>
							</td>
							<td>
								<input type="radio" name="serviceKey" value="123456" align="middle">									
									<xsl:if test="count(NetWareService)=1">
										<xsl:attribute name="checked">checked</xsl:attribute>
									</xsl:if>
									<xsl:value-of select="$fw.NetWareService.Other"/>
								</input>
								&#160;
							</td>
							<td>
								<xsl:value-of select="$fw.NetWareService.CreateACustomService"/>
							</td>
						</tr>
					</xsl:if>
				</table>
			</div>
			<xsl:call-template name="wizardFooter">
				<xsl:with-param name="nextButton">true</xsl:with-param>
				<xsl:with-param name="backDisabledButton">true</xsl:with-param>
			</xsl:call-template>
		</form>
	</xsl:template>
	<xsl:template name="FindServerLocation">
		<xsl:call-template name="showHeader">
			<xsl:with-param name="HeaderTitle"><xsl:value-of select="$fw.NetWareService.HeaderTitle"/></xsl:with-param>
			<xsl:with-param name="SubTitle">
				<xsl:value-of select="$fw.General.Step2"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$fw.NetWareService.Step2Text"/></xsl:with-param>
		</xsl:call-template>
		<form action="{$Portal.Servlet.Normal}" name="servicesForm" method="post">
			<input name="GI_ID" type="hidden" value="{../@id}"/>
			<input name="nextState" type="hidden" value="getTaskName"/>
			<div class="smalltext2C" style="margin-left: 10px; margin-top: 5px;">
						<xsl:value-of select="$fw.NetWareService.Step2Description"/></div>
			<div style="margin-left: 10px; margin-top: 25px;" nowrap="nowrap">
				<xsl:value-of select="$fw.NetWareService.Step2ServerAddress"/>&#160;
				<input maxlength="255" name="serviceLoc" size="25" type="text"/>
				<span class="smalltext2C">&#160;<xsl:value-of select="$fw.NetWareService.Step2ServerAddressHint"/></span>
				<script language="JavaScript"><![CDATA[
						document.servicesForm.serviceLoc.focus();									
					]]></script>
			</div>
			<xsl:call-template name="wizardFooter">
				<xsl:with-param name="nextButton">true</xsl:with-param>
				<xsl:with-param name="backButton">true</xsl:with-param>
			</xsl:call-template>
		</form>
	</xsl:template>
	<xsl:template name="getTaskName">
		<xsl:call-template name="showHeader">
			<xsl:with-param name="HeaderTitle"><xsl:value-of select="$fw.NetWareService.HeaderTitle"/></xsl:with-param>
			<xsl:with-param name="SubTitle">
				<xsl:value-of select="$fw.General.Step3"/>
				<xsl:text> </xsl:text>
				<xsl:value-of select="$fw.TaskBuilder.InstallText"/>
			</xsl:with-param>
		</xsl:call-template>
		<form action="{$Portal.Servlet.Normal}" name="servicesForm" method="post" onSubmit="return isPageValid();">
			<input name="GI_ID" type="hidden" value="{../@id}"/>
			<input name="nextState" type="hidden" value="createSummary"/>
			<input name="createServiceTask" type="hidden" value="true"/>
			<div class="smalltext2C" style="margin-left: 10px; margin-top: 5px;">
						<xsl:value-of select="fw.TaskBuilder.installInstructions"/></div>
         <xsl:if test="taskCreateError">
             <div style="color: #c82727; font-style: normal; font-weight: 800; font-size: 1.2em; line-height: 1.5em; margin-left: 15px; margin-bottom: 1.5em">
                <xsl:value-of select="taskCreateError"/>
             </div>
         </xsl:if>
			<div style="margin-left: 15px; margin-top: 25px;">
				<table border="0" cellpadding="0" cellspacing="3">
					<tr>
						<td><xsl:value-of select="$fw.TaskBuilder.TaskName"/>&#160;</td>
						<td>
							<input maxlength="255" name="taskName" size="35" type="text" value="{taskName}"/>
						</td>
					</tr>
					<tr>
						<td><xsl:value-of select="$fw.TaskBuilder.RbsCollection"/>&#160;</td>
						<td>
							<input maxlength="255" name="taskCollection" size="35" type="text" value="{taskCollection}"/>
                     <xsl:call-template name="OS">
                        <xsl:with-param name="OS.Control">taskCollection</xsl:with-param>
                        <xsl:with-param name="OS.Mode">search</xsl:with-param>
                        <xsl:with-param name="OS.TypeFilter">rbsCollection2</xsl:with-param>
                        <xsl:with-param name="OS.Windowed">true</xsl:with-param>
                        <xsl:with-param name="OS.History">true</xsl:with-param>
                     </xsl:call-template>
						</td>
					</tr>
					<tr>
						<td><xsl:value-of select="$fw.TaskBuilder.Role"/>&#160;</td>
						<td>
							<input maxlength="255" name="taskRole" size="35" type="text" value="{taskRole}"/>
                     <xsl:call-template name="OS">
                        <xsl:with-param name="OS.Control">taskRole</xsl:with-param>
                        <xsl:with-param name="OS.Mode">search</xsl:with-param>
                        <xsl:with-param name="OS.TypeFilter">rbsRole2</xsl:with-param>
                        <xsl:with-param name="OS.Windowed">true</xsl:with-param>
                        <xsl:with-param name="OS.History">true</xsl:with-param>
                     </xsl:call-template>
							<xsl:text> </xsl:text>
							<SPAN class="smalltext2d"><xsl:value-of select="$fw.TaskBuilder.RoleIsOptional"/></SPAN>
						</td>
					</tr>
				</table>
				<script language="JavaScript"><![CDATA[
						document.servicesForm.taskName.focus();									
					]]></script>
			</div>
			<xsl:call-template name="wizardFooter">
				<xsl:with-param name="finishButton">true</xsl:with-param>
				<xsl:with-param name="backButton">true</xsl:with-param>
			</xsl:call-template>
		</form>
      <xsl:call-template name="OSFooter"/>
	</xsl:template>
	<xsl:template name="createSummary">
		<div class="head4">
			<img height="32" width="32" src="{$Portal.ResourcePath}/modules/dev/images/success32.gif" alt="{$dev.Icon.Success.alt}" title="Success" align="absmiddle"/>
			<FONT class="head4">
				<span class="typegold1"><xsl:value-of select="$fw.NetWareService.SummaryComplete"/>&#160;</span>
				<xsl:value-of select="createSummary/ResultHeader"/>
			</FONT>
		</div>
		<div style="margin-left: 10px;">
			<p class="marginleft3"><xsl:value-of select="createSummary/ResultBody"/>
			<div id="bar" style="position:absolute;">
					<BR/>
					<HR noshade="noshade" color="#458ab9" size="2" width="100%" align="left"/>
					<a id="okbutton" href="webacc?NPService=fw.LaunchService&amp;NPAction=Return&amp;returnID=fw%2eCreate+Server+Admin+Task">
						<IMG alt="{$dev.Button.OK.alt}" title="OK" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.OK.image}" border="0"/>
					</a>&#160;
               <a href="webacc?realTaskId=fw%2eCreate+Server+Admin+Task&amp;taskId=fw.HandleRepeatTask">
                  <IMG alt="{$dev.Button.RepeatTask.alt}" title="Repeat" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.RepeatTask.image}" border="0"/>
               </a>
					<BR/>
				</div>
			</p>	
		</div>
	</xsl:template>
	<xsl:template name="FindServiceUrl">
		<xsl:call-template name="showHeader">
			<xsl:with-param name="HeaderTitle"><xsl:value-of select="$fw.NetWareService.HeaderTitle"/></xsl:with-param>
			<xsl:with-param name="SubTitle"><xsl:value-of select="$fw.NetWareService.WizardUrl"/></xsl:with-param>
		</xsl:call-template>
		<form action="{$Portal.Servlet.Normal}" name="servicesForm" method="post">
			<input name="GI_ID" type="hidden" value="{../@id}"/>
			<input name="nextState" type="hidden" value="customGetParams"/>
			<div class="smalltext2C" style="margin-left: 10px; margin-top: 5px;">
						<xsl:value-of select="$fw.NetWareService.WizardUrlDescription"/></div>
			<div style="margin-left: 10px; margin-top: 25px;" nowrap="nowrap">
				<xsl:value-of select="$fw.NetWareService.WizardUrlInput"/>
			</div>
			<div style="margin-left: 10px;">
            <input maxlength="255" name="URL" size="50" type="text">
                <xsl:choose>
                    <xsl:when test="string-length(URL)!=0">
                        <xsl:attribute name="value">
                            <xsl:value-of select="URL"/>
                        </xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:attribute name="value">http://</xsl:attribute>
                    </xsl:otherwise>
                </xsl:choose>
            </input>

				<script language="JavaScript"><![CDATA[
						document.servicesForm.URL.focus();									
					]]></script>
			</div>
			<xsl:call-template name="wizardFooter">
				<xsl:with-param name="nextButton">true</xsl:with-param>
				<xsl:with-param name="backButton">true</xsl:with-param>
			</xsl:call-template>
		</form>
	</xsl:template>
	<xsl:template name="CustomSettingsSummary">
		<xsl:call-template name="showHeader">
			<xsl:with-param name="HeaderTitle"><xsl:value-of select="$fw.NetWareService.HeaderTitle"/></xsl:with-param>
			<xsl:with-param name="SubTitle"><xsl:value-of select="$fw.NetWareService.CustomSettingsSummary"/></xsl:with-param>
		</xsl:call-template>
		<form action="{$Portal.Servlet.Normal}" name="servicesForm" method="post">
			<input name="GI_ID" type="hidden" value="{../@id}"/>
			<input name="nextState" type="hidden" value="getTaskName"/>
			<div class="smalltext2C" style="margin-left: 10px; margin-top: 5px; width=500px;">
						<xsl:value-of select="$fw.NetWareService.CustomSettingsSummaryDesc"/></div>
			<div style="margin-left: 10px; margin-top: 25px;" nowrap="nowrap">
				<table border="0" cellpadding="0" cellspacing="0">
					<tr>
						<td><xsl:value-of select="$fw.NetWareService.WizardUrlInput"/>&#160;</td>
						<td>&#160;</td>
					</tr>
					<tr>
						<td><input maxlength="255" name="URL" size="50" type="text" value="{CustomSettingsSummary/URL}"/></td>					
						<td>&#160;</td>
					</tr>
					<tr>
						<td><xsl:value-of select="$fw.NetWareService.CustomSettingsSummaryParameters"/>&#160;</td>
						<td>&#160;</td>
					</tr>
					<tr>
						<td><input maxlength="255" name="PARAMS" size="50" type="text" value="{CustomSettingsSummary/PARAMS}"/></td>					
						<td>&#160;</td>
					</tr>
					<tr>
						<td class="smalltext">
							<input type="checkbox" name="IsBasicAuthentication">
								<xsl:if test="CustomSettingsSummary/IsBasicAuthentication = 'true'">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
							</input>
							&#160;<xsl:value-of select="$fw.NetWareService.CustomSettingsSummaryIsBasic"/>
						</td> 
						<td>&#160;</td>						
					</tr>
               <tr>
                  <td class="smalltext"><xsl:value-of select="$fw.NetWareService.CustomSettingsSummaryIsBasicDescription"/></td>
                  <td>&#160;</td>
               </tr>
				</table>
				<script language="JavaScript"><![CDATA[
						document.servicesForm.URL.focus();									
					]]></script>
			</div>
			<xsl:call-template name="wizardFooter">
				<xsl:with-param name="nextButton">true</xsl:with-param>
				<xsl:with-param name="backButton">true</xsl:with-param>
			</xsl:call-template>
		</form>
	</xsl:template>
	<xsl:template name="wizardURLData">
		<xsl:call-template name="showHeader">
			<xsl:with-param name="HeaderTitle"><xsl:value-of select="$fw.NetWareService.HeaderTitle"/></xsl:with-param>
			<xsl:with-param name="SubTitle"><xsl:value-of select="$fw.NetWareService.CaptureFormAuth"/></xsl:with-param>
		</xsl:call-template>
		<div class="smalltext2C" style="margin-left: 10px; margin-top: 5px; width: 450px;">
						<xsl:value-of select="$fw.NetWareService.CaptureFormAuthDesc"/></div>
		<div style="margin-left: 10px; margin-top: 25px;" nowrap="nowrap">
			<xsl:value-of disable-output-escaping="yes" select="wizardURLData"/>
		</div>
	</xsl:template>
	<xsl:template name="showHeader">
		<xsl:param name="HeaderTitle"/>
		<xsl:param name="SubTitle"/>
      <table border="0" cellspacing="0" cellpadding="3" width="100%">
         <TR>
            <td bgcolor="#458ab9" colspan="2" height="19" nowrap="nowrap">
               <DIV align="left" class="formhead1">
                  <font color="#FFFFFF">
                     <B>
                        <span id="title">
                           <xsl:value-of select="$HeaderTitle"/>
                        </span>
                     </B>
                  </font>
               </DIV>
            </td>
            <TD class="formhead1" height="26" align="right" width="36">
               <a href="javascript:launchHelp('base/createserveradmintask.html');">
                  <IMG id="helpimage" src="{$Portal.ResourcePath}/modules/dev/images/help_16.gif" width="16" height="16" title="" alt="" border="0"/>
               </a>
            </TD>
         </TR>
      </table>
      <table border="0" cellspacing="0" cellpadding="3" width="100%">
         <TR bgcolor="#EFEEE9">
            <TD height="16" align="center" valign="middle" width="40"><IMG src="{$Portal.ResourcePath}/modules/fw/images/wizard_on.gif" width="24" height="23" align="middle"/>
            </TD>
            <TD height="16" align="left" valign="middle" class="tablesubhead1" nowrap="nowrap" colspan="2">
               <B>
                  <SPAN id="subtitle">
                     <xsl:value-of select="$SubTitle"/>
                  </SPAN>
               </B>
            </TD>
         </TR>
      </table>
	</xsl:template>
	<xsl:template name="wizardFooter">
		<xsl:param name="backButton"/>
		<xsl:param name="backDisabledButton"/>
		<xsl:param name="nextButton"/>
		<xsl:param name="nextDisabledButton"/>
		<xsl:param name="finishButton"/>
		<xsl:param name="finishDisabledButton"/>
		<xsl:param name="closeButton"/>
		<xsl:param name="closeDisabledButton"/>
		<xsl:param name="cancelButton"/>
		<xsl:param name="cancelDisabledButton"/>
		<div>
			<xsl:choose>
				<xsl:when test="count(NetWareService)> 8">
					<xsl:attribute name="style">margin-left: 10px; position: absolute; margin-bottom: 5px;</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:attribute name="style">margin-left: 10px; position: absolute; bottom: 0px; margin-bottom: 5px;</xsl:attribute>
				</xsl:otherwise>
			</xsl:choose>
			<HR noshade="noshade" size="2" color="#458ab9"/>
			<NOWRAP>
				<xsl:if test="$backButton !=''">
					<SPAN id="backButton" style="display:inline">
						<!--<input type="image" alt="{$dev.Button.Back.alt}" title="{$dev.Button.Back.alt}" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.Back.image}" border="0" name="backState"/> -->
                  <IMG name="" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.Back.image}" alt="{$dev.Button.Back.alt}" title="{$dev.Button.Back.alt}" border="0" onclick="window.history.go(-1);"/>
						&#160;</SPAN>
				</xsl:if>
				<xsl:if test="$backDisabledButton !=''">
					<SPAN id="backDisabledButton" style="display:inline">
						<IMG name="" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.BackDisabled.image}" alt="{$dev.Button.BackDisabled.alt}" title="{$dev.Button.BackDisabled.alt}" border="0"/>&#160;</SPAN>
				</xsl:if>
				<xsl:if test="$nextButton !=''">
					<SPAN id="nextButton" style="display:inline">
						<input type="image" alt="{$dev.Button.Next.alt}" title="{$dev.Button.Next.alt}" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.Next.image}" border="0" name="nextState"/>
						&#160;</SPAN>
				</xsl:if>
				<xsl:if test="$nextDisabledButton!=''">
					<SPAN id="nextDisabledButton" style="display:inline">
						<IMG name="" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.NextDisabled.image}" alt="{$dev.Button.NextDisabled.alt}" title="{$dev.Button.NextDisabled.alt}" border="0"/>&#160;</SPAN>
				</xsl:if>
				<xsl:if test="$finishButton!=''">
					<SPAN id="finishButton" style="display:inline">
						<input type="image" alt="{$dev.Button.Finish.alt}" title="{$dev.Button.Finish.alt}" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.Finish.image}" border="0" name="finishState"/>
						&#160;</SPAN>
				</xsl:if>
				<xsl:if test="$finishDisabledButton!=''">
					<SPAN id="finishDisabledButton" style="display:inline">
						<IMG name="" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.FinishDisabled.image}" alt="{$dev.Button.FinishDisabled.alt}" title="{$dev.Button.FinishDisabled.alt}" border="0"/>&#160;</SPAN>
				</xsl:if>
				<xsl:if test="$closeButton!=''">
					<SPAN id="closeButton" style="display:inline">
						<input type="image" alt="{$dev.Button.Close.alt}" title="{$dev.Button.Close.alt}" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.Close.image}" border="0" name="closeState"/>
						&#160;</SPAN>
				</xsl:if>
				<xsl:if test="$closeDisabledButton!=''">
					<SPAN id="closeDisabledButton" style="display:inline">
						<IMG name="" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.CloseDisabled.image}" alt="{$dev.Button.CloseDisabled.alt}" title="{$dev.Button.CloseDisabled.alt}" border="0"/>&#160;</SPAN>
				</xsl:if>
				<xsl:if test="$cancelButton!=''">
					<SPAN id="cancelButton" style="display:inline">
						<input type="image" alt="{$dev.Button.Cancel.alt}" title="{$dev.Button.Cancel.alt}" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.Cancel.image}" border="0" name="cancelState"/>
						&#160;</SPAN>
				</xsl:if>
				<xsl:if test="$cancelDisabledButton!=''">
					<SPAN id="cancelDisabledButton" style="display:inline">
						<IMG name="" src="{$Portal.ResourcePath}/modules/dev/images/{$dev.Button.CancelDisabled.image}" alt="{$dev.Button.CancelDisabled.alt}" title="{$dev.Button.CancelDisabled.alt}" border="0"/>&#160;</SPAN>
				</xsl:if>
			</NOWRAP>
		</div>
	</xsl:template>
</xsl:stylesheet>
